/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.text;

import java.io.Closeable;
import java.io.IOException;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import xyz.cofe.collection.Func0;

public class DocumentAdapter
implements DocumentListener {
    @Override
    public void insertUpdate(DocumentEvent e) {
        this.onTextChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.onTextChanged();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.onTextChanged();
    }

    protected void onTextChanged() {
    }

    public static Closeable listenChanged(JTextComponent cmpt, Func0<Object> fun) {
        if (cmpt == null) {
            throw new IllegalArgumentException("cmpt==null");
        }
        if (fun == null) {
            throw new IllegalArgumentException("fun==null");
        }
        return DocumentAdapter.listenChanged(cmpt.getDocument(), fun);
    }

    public static Closeable listenChanged(JTextComponent cmpt, final Runnable fun) {
        if (cmpt == null) {
            throw new IllegalArgumentException("cmpt==null");
        }
        if (fun == null) {
            throw new IllegalArgumentException("fun==null");
        }
        return DocumentAdapter.listenChanged(cmpt.getDocument(), new Func0<Object>(){

            public Object apply() {
                fun.run();
                return null;
            }
        });
    }

    public static Closeable listenChanged(final Document doc, final Func0<Object> fun) {
        if (doc == null) {
            throw new IllegalArgumentException("doc==null");
        }
        if (fun == null) {
            throw new IllegalArgumentException("fun==null");
        }
        final DocumentAdapter da = new DocumentAdapter(){

            @Override
            protected void onTextChanged() {
                fun.apply();
            }
        };
        doc.addDocumentListener(da);
        Closeable cl = new Closeable(){
            private DocumentAdapter listener;
            private Document document;
            {
                this.listener = da;
                this.document = doc;
            }

            @Override
            public void close() throws IOException {
                if (this.document == null) {
                    return;
                }
                if (this.listener == null) {
                    return;
                }
                this.document.removeDocumentListener(this.listener);
                this.document = null;
                this.listener = null;
            }
        };
        return cl;
    }
}

