/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.text;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;

public class DocumentChangeEvent {
    private static final Logger logger = Logger.getLogger(DocumentChangeEvent.class.getName());
    protected Document doc;
    protected String previous;
    protected String current;

    private static Level logLevel() {
        return logger.getLevel();
    }

    private static boolean isLogSevere() {
        Level level = DocumentChangeEvent.logLevel();
        return level == null ? true : level.intValue() <= Level.SEVERE.intValue();
    }

    private static boolean isLogWarning() {
        Level level = DocumentChangeEvent.logLevel();
        return level == null ? true : level.intValue() <= Level.WARNING.intValue();
    }

    private static boolean isLogInfo() {
        Level level = DocumentChangeEvent.logLevel();
        return level == null ? true : level.intValue() <= Level.INFO.intValue();
    }

    private static boolean isLogFine() {
        Level level = DocumentChangeEvent.logLevel();
        return level == null ? true : level.intValue() <= Level.FINE.intValue();
    }

    private static boolean isLogFiner() {
        Level level = DocumentChangeEvent.logLevel();
        return level == null ? false : level.intValue() <= Level.FINER.intValue();
    }

    private static boolean isLogFinest() {
        Level level = DocumentChangeEvent.logLevel();
        return level == null ? false : level.intValue() <= Level.FINEST.intValue();
    }

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(DocumentChangeEvent.class.getName(), method, params);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(DocumentChangeEvent.class.getName(), method, result);
    }

    private static void logExiting(String method) {
        logger.exiting(DocumentChangeEvent.class.getName(), method);
    }

    public DocumentChangeEvent() {
    }

    public DocumentChangeEvent(Document doc, String prev, String curr) {
        this.doc = doc;
        this.previous = prev;
        this.current = curr;
    }

    public Document getDocument() {
        return this.doc;
    }

    public void setDocument(Document doc) {
        this.doc = doc;
    }

    public String getPrevious() {
        return this.previous;
    }

    public void setPrevious(String previous) {
        this.previous = previous;
    }

    public String getCurrent() {
        return this.current;
    }

    public void setCurrent(String current) {
        this.current = current;
    }

    public static class DeleteEvent
    extends DocumentChangeEvent {
        protected int offset;
        protected String deleted;

        public int getOffset() {
            return this.offset;
        }

        public void setOffset(int offset) {
            this.offset = offset;
        }

        public String getDeleted() {
            return this.deleted;
        }

        public void setDeleted(String deleted) {
            this.deleted = deleted;
        }
    }

    public static class UpdateEvent
    extends DocumentChangeEvent {
        protected int offset;
        protected String from;
        protected String to;

        public int getOffset() {
            return this.offset;
        }

        public void setOffset(int offset) {
            this.offset = offset;
        }

        public String getFrom() {
            return this.from;
        }

        public void setFrom(String from) {
            this.from = from;
        }

        public String getTo() {
            return this.to;
        }

        public void setTo(String to) {
            this.to = to;
        }
    }

    public static class InsertEvent
    extends DocumentChangeEvent {
        protected int offset;
        protected String inserted;

        public int getOffset() {
            return this.offset;
        }

        public void setOffset(int offset) {
            this.offset = offset;
        }

        public String getInserted() {
            return this.inserted;
        }

        public void setInserted(String inserted) {
            this.inserted = inserted;
        }
    }
}

