/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.text;

import java.io.Closeable;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import xyz.cofe.collection.BasicPair;
import xyz.cofe.collection.Func2;
import xyz.cofe.collection.Pair;
import xyz.cofe.common.CloseableSet;
import xyz.cofe.common.ListenersHelper;
import xyz.cofe.common.Reciver;
import xyz.cofe.gui.swing.text.DocumentChangeEvent;
import xyz.cofe.gui.swing.text.DocumentChangeListener;

public class DocumentChangeTracker
implements Closeable {
    private static final Logger logger = Logger.getLogger(DocumentChangeTracker.class.getName());
    protected boolean weak = false;
    protected volatile Closeable listenCloser;
    protected String text;
    protected Document doc;
    protected WeakReference<Document> docRef;
    protected final DocumentListener documentListener = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent e) {
            if (e == null) {
                return;
            }
            String oldtxt = DocumentChangeTracker.this.text;
            Document d = e.getDocument();
            if (d != null) {
                int off = e.getOffset();
                int len = e.getLength();
                String txt = DocumentChangeTracker.this.readText(d);
                DocumentChangeTracker.this.fixChanged(txt);
                if (len > 0 && txt != null) {
                    String insTxt;
                    try {
                        insTxt = txt.substring(off, off + len);
                    }
                    catch (Throwable err) {
                        DocumentChangeTracker.logException(err);
                        return;
                    }
                    DocumentChangeTracker.this.textInsertedEvent(d, oldtxt, txt, off, insTxt);
                }
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            if (e == null) {
                return;
            }
            String oldtxt = DocumentChangeTracker.this.text;
            Document d = e.getDocument();
            if (d != null) {
                int off = e.getOffset();
                int len = e.getLength();
                String txt = DocumentChangeTracker.this.readText(d);
                DocumentChangeTracker.this.fixChanged(txt);
                if (len > 0 && txt != null && oldtxt != null) {
                    String prvTxt;
                    try {
                        prvTxt = oldtxt.substring(off, off + len);
                    }
                    catch (Throwable err) {
                        DocumentChangeTracker.logException(err);
                        return;
                    }
                    DocumentChangeTracker.this.textDeletedEvent(d, oldtxt, txt, off, prvTxt);
                }
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            if (e == null) {
                return;
            }
            String oldtxt = DocumentChangeTracker.this.text;
            Document d = e.getDocument();
            if (d != null) {
                int off = e.getOffset();
                int len = e.getLength();
                String txt = DocumentChangeTracker.this.readText(d);
                DocumentChangeTracker.this.fixChanged(txt);
                if (len > 0 && txt != null && oldtxt != null) {
                    String prvTxt;
                    String insTxt;
                    try {
                        insTxt = txt.substring(off, off + len);
                        prvTxt = oldtxt.substring(off, off + len);
                    }
                    catch (Throwable err) {
                        DocumentChangeTracker.logException(err);
                        return;
                    }
                    DocumentChangeTracker.this.textUpdatedEvent(d, oldtxt, txt, off, prvTxt, insTxt);
                }
            }
        }
    };
    protected final CloseableSet listenersCloser = new CloseableSet();
    protected final ListenersHelper<DocumentChangeListener, DocumentChangeEvent> listeners = new ListenersHelper((Func2)new Func2<Object, DocumentChangeListener, DocumentChangeEvent>(){

        public Object apply(DocumentChangeListener listnr, DocumentChangeEvent ev) {
            listnr.documentChangeEvent(ev);
            return null;
        }
    });

    private static Level logLevel() {
        return logger.getLevel();
    }

    private static boolean isLogSevere() {
        Level level = DocumentChangeTracker.logLevel();
        return level == null ? true : level.intValue() <= Level.SEVERE.intValue();
    }

    private static boolean isLogWarning() {
        Level level = DocumentChangeTracker.logLevel();
        return level == null ? true : level.intValue() <= Level.WARNING.intValue();
    }

    private static boolean isLogInfo() {
        Level level = DocumentChangeTracker.logLevel();
        return level == null ? true : level.intValue() <= Level.INFO.intValue();
    }

    private static boolean isLogFine() {
        Level level = DocumentChangeTracker.logLevel();
        return level == null ? true : level.intValue() <= Level.FINE.intValue();
    }

    private static boolean isLogFiner() {
        Level level = DocumentChangeTracker.logLevel();
        return level == null ? false : level.intValue() <= Level.FINER.intValue();
    }

    private static boolean isLogFinest() {
        Level level = DocumentChangeTracker.logLevel();
        return level == null ? false : level.intValue() <= Level.FINEST.intValue();
    }

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(DocumentChangeTracker.class.getName(), method, params);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(DocumentChangeTracker.class.getName(), method, result);
    }

    private static void logExiting(String method) {
        logger.exiting(DocumentChangeTracker.class.getName(), method);
    }

    protected DocumentChangeTracker(Document doc, boolean weak) {
        if (doc == null) {
            throw new IllegalArgumentException("doc==null");
        }
        this.text = this.readText(doc);
        this.doc = weak ? null : doc;
        this.docRef = weak ? new WeakReference<Document>(doc) : null;
        this.weak = weak;
    }

    public static DocumentChangeTracker tracking(JTextComponent doc, boolean weak) {
        if (doc == null) {
            throw new IllegalArgumentException("doc==null");
        }
        return DocumentChangeTracker.tracking(doc.getDocument(), weak);
    }

    public static DocumentChangeTracker tracking(JTextComponent doc) {
        if (doc == null) {
            throw new IllegalArgumentException("doc==null");
        }
        return DocumentChangeTracker.tracking(doc.getDocument(), false);
    }

    public static DocumentChangeTracker tracking(Document doc, boolean weak) {
        if (doc == null) {
            throw new IllegalArgumentException("doc==null");
        }
        return new DocumentChangeTracker(doc, weak);
    }

    public static DocumentChangeTracker tracking(Document doc) {
        if (doc == null) {
            throw new IllegalArgumentException("doc==null");
        }
        return new DocumentChangeTracker(doc, false);
    }

    public DocumentChangeTracker onChanges(final Runnable run, boolean weak) {
        if (run == null) {
            throw new IllegalArgumentException("run==null");
        }
        this.addListener(new DocumentChangeListener(){

            @Override
            public void documentChangeEvent(DocumentChangeEvent e) {
                run.run();
            }
        }, weak);
        return this;
    }

    public DocumentChangeTracker onChanges(final Runnable run) {
        if (run == null) {
            throw new IllegalArgumentException("run==null");
        }
        this.addListener(new DocumentChangeListener(){

            @Override
            public void documentChangeEvent(DocumentChangeEvent e) {
                run.run();
            }
        }, this.weak);
        return this;
    }

    public DocumentChangeTracker onChanges(final Reciver<String> reciver) {
        if (reciver == null) {
            throw new IllegalArgumentException("reciver==null");
        }
        this.addListener(new DocumentChangeListener(){

            @Override
            public void documentChangeEvent(DocumentChangeEvent e) {
                reciver.recive((Object)e.getCurrent());
            }
        }, this.weak);
        return this;
    }

    public DocumentChangeTracker onChangesPair(final Reciver<Pair<String, String>> reciver) {
        if (reciver == null) {
            throw new IllegalArgumentException("reciver==null");
        }
        this.addListener(new DocumentChangeListener(){

            @Override
            public void documentChangeEvent(DocumentChangeEvent e) {
                reciver.recive((Object)new BasicPair((Object)e.getPrevious(), (Object)e.getCurrent()));
            }
        }, this.weak);
        return this;
    }

    public DocumentChangeTracker onChangesEvent(final Reciver<DocumentChangeEvent> reciver) {
        if (reciver == null) {
            throw new IllegalArgumentException("reciver==null");
        }
        this.addListener(new DocumentChangeListener(){

            @Override
            public void documentChangeEvent(DocumentChangeEvent e) {
                reciver.recive((Object)e);
            }
        }, this.weak);
        return this;
    }

    public DocumentChangeTracker onInsertEvent(final Reciver<DocumentChangeEvent.InsertEvent> reciver) {
        if (reciver == null) {
            throw new IllegalArgumentException("reciver==null");
        }
        this.addListener(new DocumentChangeListener(){

            @Override
            public void documentChangeEvent(DocumentChangeEvent e) {
                if (e instanceof DocumentChangeEvent.InsertEvent) {
                    reciver.recive((Object)((DocumentChangeEvent.InsertEvent)e));
                }
            }
        }, this.weak);
        return this;
    }

    public DocumentChangeTracker onUpdateEvent(final Reciver<DocumentChangeEvent.UpdateEvent> reciver) {
        if (reciver == null) {
            throw new IllegalArgumentException("reciver==null");
        }
        this.addListener(new DocumentChangeListener(){

            @Override
            public void documentChangeEvent(DocumentChangeEvent e) {
                if (e instanceof DocumentChangeEvent.UpdateEvent) {
                    reciver.recive((Object)((DocumentChangeEvent.UpdateEvent)e));
                }
            }
        }, this.weak);
        return this;
    }

    public DocumentChangeTracker onDeleteEvent(final Reciver<DocumentChangeEvent.DeleteEvent> reciver) {
        if (reciver == null) {
            throw new IllegalArgumentException("reciver==null");
        }
        this.addListener(new DocumentChangeListener(){

            @Override
            public void documentChangeEvent(DocumentChangeEvent e) {
                if (e instanceof DocumentChangeEvent.DeleteEvent) {
                    reciver.recive((Object)((DocumentChangeEvent.DeleteEvent)e));
                }
            }
        }, this.weak);
        return this;
    }

    public synchronized boolean isWeakDocRef() {
        return this.weak;
    }

    public synchronized void setWeakDocRef(boolean weak) {
        this.weak = weak;
    }

    public synchronized DocumentChangeTracker start() {
        if (this.listenCloser != null) {
            return this;
        }
        Document d = this.getDocument();
        if (d == null) {
            return this;
        }
        this.text = this.readText(d);
        this.listenCloser = this.addDocumentListener(d, this.documentListener, this.weak);
        return this;
    }

    public synchronized DocumentChangeTracker stop() {
        if (this.listenCloser == null) {
            return this;
        }
        try {
            this.listenCloser.close();
            this.listenCloser = null;
        }
        catch (IOException ex) {
            Logger.getLogger(DocumentChangeTracker.class.getName()).log(Level.SEVERE, null, ex);
        }
        return this;
    }

    public synchronized boolean isRunning() {
        return this.listenCloser != null;
    }

    protected String readText(Document doc) {
        if (doc == null) {
            throw new IllegalArgumentException("doc==null");
        }
        try {
            int len = doc.getLength();
            String txt = doc.getText(0, len);
            return txt;
        }
        catch (BadLocationException ex) {
            Logger.getLogger(DocumentChangeTracker.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public synchronized Document getDocument() {
        if (this.doc != null) {
            return this.doc;
        }
        if (this.docRef != null) {
            return (Document)this.docRef.get();
        }
        return null;
    }

    protected synchronized void fixChanged(String currentText) {
        this.text = currentText;
    }

    protected Closeable addDocumentListener(Document doc, final DocumentListener listener, final boolean weak) {
        doc.addDocumentListener(listener);
        final Document fdoc = doc;
        Closeable cl = new Closeable(){
            protected Document doc;
            protected WeakReference<Document> docRef;
            {
                this.doc = weak ? null : fdoc;
                this.docRef = weak ? new WeakReference<Document>(fdoc) : null;
            }

            protected Document getDocument() {
                if (this.doc != null) {
                    return this.doc;
                }
                if (this.docRef != null) {
                    return (Document)this.docRef.get();
                }
                return null;
            }

            @Override
            public void close() throws IOException {
                Document d = this.getDocument();
                if (d != null) {
                    d.removeDocumentListener(listener);
                }
            }
        };
        return cl;
    }

    public boolean hasListener(DocumentChangeListener listener) {
        return this.listeners.hasListener((Object)listener);
    }

    public Set<DocumentChangeListener> getListeners() {
        return this.listeners.getListeners();
    }

    public Closeable addListener(DocumentChangeListener listener) {
        Closeable c = this.listeners.addListener((Object)listener);
        this.listenersCloser.add(c, true);
        return c;
    }

    public Closeable addListener(DocumentChangeListener listener, boolean weakLink) {
        Closeable c = this.listeners.addListener((Object)listener, weakLink);
        this.listenersCloser.add(c, true);
        return c;
    }

    public void removeListener(DocumentChangeListener listener) {
        this.listeners.removeListener((Object)listener);
    }

    public void fireEvent(DocumentChangeEvent event) {
        this.listeners.fireEvent((Object)event);
    }

    protected DocumentChangeEvent createInsertedEvent(Document doc, String preview, String current, int offset, String inserted) {
        DocumentChangeEvent.InsertEvent ev = new DocumentChangeEvent.InsertEvent();
        ev.setDocument(doc);
        ev.setPrevious(preview);
        ev.setCurrent(current);
        ev.setOffset(offset);
        ev.setInserted(inserted);
        return ev;
    }

    protected void textInsertedEvent(Document doc, String preview, String current, int offset, String inserted) {
        this.fireEvent(this.createInsertedEvent(doc, preview, current, offset, inserted));
    }

    protected DocumentChangeEvent createUpdatedEvent(Document doc, String preview, String current, int offset, String from, String to) {
        DocumentChangeEvent.UpdateEvent ev = new DocumentChangeEvent.UpdateEvent();
        ev.setDocument(doc);
        ev.setPrevious(preview);
        ev.setCurrent(current);
        ev.setOffset(offset);
        ev.setFrom(from);
        ev.setTo(to);
        return ev;
    }

    protected void textUpdatedEvent(Document doc, String preview, String current, int offset, String from, String to) {
        this.fireEvent(this.createUpdatedEvent(doc, preview, current, offset, from, to));
    }

    protected DocumentChangeEvent createDeletedEvent(Document doc, String preview, String current, int offset, String deleted) {
        DocumentChangeEvent.DeleteEvent ev = new DocumentChangeEvent.DeleteEvent();
        ev.setDocument(doc);
        ev.setPrevious(preview);
        ev.setCurrent(current);
        ev.setOffset(offset);
        ev.setDeleted(deleted);
        return ev;
    }

    protected void textDeletedEvent(Document doc, String preview, String current, int offset, String deleted) {
        this.fireEvent(this.createDeletedEvent(doc, preview, current, offset, deleted));
    }

    @Override
    public synchronized void close() throws IOException {
        this.stop();
        this.text = null;
        this.doc = null;
        if (this.docRef != null) {
            this.docRef.clear();
            this.docRef = null;
        }
        this.listenersCloser.close();
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }
}

