/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.text;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import xyz.cofe.gui.swing.text.FlatString;
import xyz.cofe.text.Text;

public class FlatBlock {
    private static final Logger logger = Logger.getLogger(FlatBlock.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    private String hash;
    private final ArrayList<FlatString> lines;
    protected Rectangle2D.Double bounds;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(FlatBlock.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(FlatBlock.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(FlatBlock.class.getName(), method, result);
    }

    public FlatBlock(String text, boolean multiLine, double align, Font font, FontRenderContext fctx, String computedHash) {
        String[] strlines;
        String[] stringArray;
        if (text == null) {
            throw new IllegalArgumentException("text == null");
        }
        if (font == null) {
            throw new IllegalArgumentException("font == null");
        }
        if (fctx == null) {
            throw new IllegalArgumentException("fctx == null");
        }
        this.lines = new ArrayList();
        double x = 0.0;
        double y = 0.0;
        if (multiLine) {
            stringArray = Text.splitNewLines((String)text);
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = text;
        }
        for (String strline : strlines = stringArray) {
            FlatString fstr = new FlatString(strline, font, fctx, this);
            fstr.setX(x);
            fstr.setY(y += fstr.getAscent());
            y += fstr.getDescent() + fstr.getLeading();
            this.lines.add(fstr);
        }
        this.align(align);
        this.hash = computedHash != null ? computedHash : FlatBlock.hash(text, multiLine, align, font, null);
    }

    public String getHash() {
        return this.hash;
    }

    public static String hash(String text, boolean multiLine, double align, Font font, Checksum crc) {
        if (text == null) {
            throw new IllegalArgumentException("text==null");
        }
        if (font == null) {
            throw new IllegalArgumentException("font==null");
        }
        if (crc == null) {
            crc = new CRC32();
        }
        if (text.length() < 250) {
            return (multiLine ? "1" : "0") + "|" + align + "|" + font.getName() + "|" + font.getSize() + "|" + font.getStyle() + "|" + text;
        }
        long crcval = -1L;
        crc.reset();
        byte[] bytes = text.getBytes();
        crc.update(bytes, 0, bytes.length);
        crcval = crc.getValue();
        return (multiLine ? "1" : "0") + "|" + align + "|" + font.getName() + "|" + font.getSize() + "|" + font.getStyle() + "|" + crcval;
    }

    public Rectangle2D.Double getBounds() {
        if (this.bounds != null) {
            return this.bounds;
        }
        if (this.lines.isEmpty()) {
            this.bounds = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
            return this.bounds;
        }
        double minx = Double.MAX_VALUE;
        double miny = Double.MAX_VALUE;
        double maxx = Double.MIN_VALUE;
        double maxy = Double.MIN_VALUE;
        for (FlatString fstr : this.lines) {
            minx = Math.min(fstr.getMinX(), minx);
            miny = Math.min(fstr.getMinY(), miny);
            maxx = Math.max(fstr.getMaxX(), maxx);
            maxy = Math.max(fstr.getMaxY(), maxy);
        }
        this.bounds = new Rectangle2D.Double(minx, miny, maxx - minx, maxy - miny);
        return this.bounds;
    }

    private double getMaxLineWidth() {
        double w = 0.0;
        for (FlatString fstr : this.lines) {
            if (fstr == null) continue;
            double w2 = fstr.getWidth();
            w = Math.max(w2, w);
        }
        return w;
    }

    public void render(Graphics2D gs) {
        if (gs == null) {
            throw new IllegalArgumentException("gs == null");
        }
        for (FlatString fstr : this.lines) {
            if (fstr == null) continue;
            fstr.render(gs);
        }
    }

    public void render(Graphics2D gs, double x, double y, Rectangle2D bounds) {
        if (gs == null) {
            throw new IllegalArgumentException("gs == null");
        }
        AffineTransform at = (AffineTransform)gs.getTransform().clone();
        gs.translate(x, y);
        Double yMax = bounds != null ? Double.valueOf(bounds.getMaxY() - y) : null;
        for (FlatString fstr : this.lines) {
            if (fstr == null || yMax != null && fstr.getY() > yMax) continue;
            fstr.render(gs);
        }
        gs.setTransform(at);
    }

    private void align(double xalign) {
        double wmax = this.getMaxLineWidth();
        for (FlatString fstr : this.lines) {
            double wstr = fstr.getWidth();
            double wtot = wmax;
            double wdiff = wtot - wstr;
            fstr.setX(wdiff * xalign);
        }
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

