/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.text;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import xyz.cofe.gui.swing.text.FlatBlock;

public class FlatString {
    protected transient FlatBlock textBlock;
    protected String text;
    protected transient Font font;
    protected double x;
    protected double y;
    protected double width;
    protected double height;
    protected double ascent;
    protected double descent;
    protected double lineHeight;
    protected double leading;

    public FlatString(String text, Font font, FontRenderContext ctx, FlatBlock fblock) {
        if (text == null) {
            throw new IllegalArgumentException("text==null");
        }
        if (font == null) {
            throw new IllegalArgumentException("font==null");
        }
        if (ctx == null) {
            throw new IllegalArgumentException("ctx==null");
        }
        this.textBlock = fblock;
        this.text = text;
        this.font = font;
        this.width = 0.0;
        this.height = 0.0;
        this.ascent = 0.0;
        this.descent = 0.0;
        this.lineHeight = 0.0;
        this.leading = 0.0;
        Rectangle2D rect = font.getStringBounds(text, ctx);
        if (rect == null) {
            return;
        }
        this.width = rect.getWidth();
        this.height = rect.getHeight();
        LineMetrics lm = font.getLineMetrics(text, ctx);
        this.ascent = lm.getAscent();
        this.descent = lm.getDescent();
        this.lineHeight = lm.getHeight();
        this.leading = lm.getLeading();
    }

    public FlatBlock getTextBlock() {
        return this.textBlock;
    }

    private void setTextBlock(FlatBlock textBlock) {
        this.textBlock = textBlock;
    }

    public String getText() {
        return this.text;
    }

    private void setText(String text) {
        this.text = text;
    }

    public Font getFont() {
        return this.font;
    }

    private void setFont(Font font) {
        this.font = font;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getWidth() {
        return this.width;
    }

    private void setWidth(double width) {
        this.width = width;
    }

    public double getHeight() {
        return this.height;
    }

    private void setHeight(double height) {
        this.height = height;
    }

    public double getMinX() {
        return this.x;
    }

    public double getMinY() {
        return this.y;
    }

    public double getMaxX() {
        return this.x + this.width;
    }

    public double getMaxY() {
        return this.y + this.height;
    }

    public double getAscent() {
        return this.ascent;
    }

    private void setAscent(double ascent) {
        this.ascent = ascent;
    }

    public double getDescent() {
        return this.descent;
    }

    private void setDescent(double descent) {
        this.descent = descent;
    }

    public synchronized double getLineHeight() {
        return this.lineHeight;
    }

    private void setLineHeight(double lineHeight) {
        this.lineHeight = lineHeight;
    }

    public double getLeading() {
        return this.leading;
    }

    private void setLeading(double leading) {
        this.leading = leading;
    }

    public void render(Graphics2D gs) {
        Font renderFont;
        if (gs == null) {
            throw new IllegalArgumentException("gs == null");
        }
        Font saveFont = gs.getFont();
        Font font = renderFont = this.font != null ? this.font : saveFont;
        if (renderFont != null) {
            gs.setFont(renderFont);
        }
        gs.drawString(this.text, (float)this.x, (float)this.y);
        if (saveFont != null) {
            gs.setFont(saveFont);
        }
    }

    public void render(Graphics2D gs, double x, double y) {
        Font renderFont;
        if (gs == null) {
            throw new IllegalArgumentException("gs == null");
        }
        Font saveFont = gs.getFont();
        Font font = renderFont = this.font != null ? this.font : saveFont;
        if (renderFont != null) {
            gs.setFont(renderFont);
        }
        gs.drawString(this.text, (float)x, (float)y);
        if (saveFont != null) {
            gs.setFont(saveFont);
        }
    }
}

