/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.text;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.gui.swing.text.AString;
import xyz.cofe.gui.swing.text.RichString;

public class RichBlock
extends ArrayList<RichString> {
    private static final Logger logger = Logger.getLogger(RichBlock.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(RichBlock.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(RichBlock.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(RichBlock.class.getName(), method, result);
    }

    public RichBlock(int initialCapacity) {
        super(initialCapacity);
    }

    public RichBlock() {
    }

    public RichBlock(Collection<? extends RichString> c) {
        super(c);
    }

    public RichBlock(double left, double top, double halign, AString text, boolean splitNewLines, Graphics2D gs, Object textAntialiasingValue) {
        if (text == null) {
            throw new IllegalArgumentException("text==null");
        }
        if (gs == null) {
            throw new IllegalArgumentException("gs==null");
        }
        List<AString> lines = null;
        if (splitNewLines) {
            lines = text.splitNewLines();
        } else {
            lines = new ArrayList<AString>();
            lines.add(text);
        }
        if (textAntialiasingValue != null) {
            gs.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, textAntialiasingValue);
        }
        FontRenderContext frc = gs.getFontRenderContext();
        for (AString astr : lines) {
            RichString rstr = astr.rstring(frc);
            this.add(rstr);
        }
        this.arrange().leftTop(left, top, halign);
    }

    public double getMaxItemWidth() {
        double w = 0.0;
        for (RichString rs : this) {
            double rw = rs.getWidth();
            if (!(w < rw)) continue;
            w = rw;
        }
        return w;
    }

    public void render(Graphics2D gs) {
        if (gs == null) {
            throw new IllegalArgumentException("gs==null");
        }
        for (RichString rs : this) {
            if (rs == null) continue;
            rs.render(gs);
        }
    }

    public Arrange arrange() {
        return new Arrange();
    }

    public Rectangle2D getBounds() {
        Double xmin = null;
        Double ymin = null;
        Double xmax = null;
        Double ymax = null;
        for (RichString it : this) {
            if (it == null) continue;
            xmin = xmin != null ? Math.min(xmin, it.getMinX()) : it.getMinX();
            ymin = ymin != null ? Math.min(ymin, it.getMinY()) : it.getMinY();
            xmax = xmax != null ? Math.max(xmax, it.getMaxX()) : it.getMaxX();
            ymax = ymax != null ? Math.max(ymax, it.getMaxY()) : it.getMaxY();
        }
        if (xmin == null || ymin == null || xmax == null || ymax == null) {
            return new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        }
        return new Rectangle2D.Double(xmin, ymin, xmax - xmin, ymax - ymin);
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }

    public class Arrange {
        public Arrange topBottom(Double top) {
            RichString rs;
            int cnt = RichBlock.this.size();
            if (cnt < 1) {
                return this;
            }
            Double firstY = null;
            if (cnt > 0 && (rs = (RichString)RichBlock.this.get(0)) != null) {
                firstY = rs.getY();
            }
            if (top == null && firstY == null) {
                return this;
            }
            double y = top != null ? top : firstY;
            for (RichString it : RichBlock.this) {
                if (it == null) continue;
                it.setY((float)y);
                y += it.getHeight();
            }
            return this;
        }

        public Arrange halign(double align, Double left) {
            RichString rs;
            int cnt = RichBlock.this.size();
            if (cnt > 0 && left != null && (rs = (RichString)RichBlock.this.get(0)) != null) {
                rs.setX((float)left.doubleValue());
            }
            if (cnt < 2) {
                return this;
            }
            double maxw = RichBlock.this.getMaxItemWidth();
            for (int ri = 1; ri < cnt; ++ri) {
                RichString rs2 = (RichString)RichBlock.this.get(ri);
                if (rs2 == null) continue;
                double w = rs2.getWidth();
                double x = (maxw - w) * align + (left != null ? left.doubleValue() : rs2.getX());
                rs2.setX(x);
            }
            return this;
        }

        public Arrange leftTop(double left, double top, double halign) {
            return this.topBottom(top).halign(halign, left);
        }
    }
}

