/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.text;

import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RichString {
    private static final Logger logger = Logger.getLogger(RichString.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected double x;
    protected double y;
    protected TextLayout layout;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(RichString.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(RichString.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(RichString.class.getName(), method, result);
    }

    public RichString(TextLayout tl, double x, double y) {
        if (tl == null) {
            throw new IllegalArgumentException("tl == null");
        }
        this.layout = tl;
        this.x = x;
        this.y = y;
    }

    public RichString(TextLayout tl) {
        if (tl == null) {
            throw new IllegalArgumentException("tl == null");
        }
        this.layout = tl;
        this.x = 0.0;
        this.y = 0.0;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public TextLayout getLayout() {
        return this.layout;
    }

    private void setLayout(TextLayout layout) {
        this.layout = layout;
    }

    public double getWidth() {
        TextLayout tl = this.layout;
        if (tl == null) {
            return 0.0;
        }
        return tl.getBounds().getWidth();
    }

    public double getHeight() {
        TextLayout tl = this.layout;
        if (tl == null) {
            return 0.0;
        }
        return tl.getAscent() + tl.getDescent() + tl.getLeading();
    }

    public double getMinX() {
        return this.x;
    }

    public double getMinY() {
        return this.y;
    }

    public double getMaxX() {
        return this.x + this.getWidth();
    }

    public double getMaxY() {
        return this.y + this.getHeight();
    }

    public void render(Graphics2D gs) {
        if (gs == null) {
            throw new IllegalArgumentException("gs==null");
        }
        TextLayout tl = this.layout;
        if (tl == null) {
            return;
        }
        double y = this.y;
        tl.draw(gs, (float)this.x, (float)(y += (double)tl.getAscent()));
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

