/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.text;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.font.LineMetrics;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTextField;
import net.java.balloontip.BalloonTip;
import net.java.balloontip.styles.BalloonTipStyle;
import net.java.balloontip.styles.RoundedBalloonStyle;
import xyz.cofe.collection.Predicate;
import xyz.cofe.gui.swing.SwingListener;

public class ValidatedTextField
extends JTextField {
    private static final Logger logger = Logger.getLogger(ValidatedTextField.class.getName());
    protected Color validForeground;
    protected Color invalidForeground;
    protected Predicate<String> filter;
    protected Icon warningIcon = null;
    protected boolean warningIconVisible = false;
    protected Integer warningIconRight = 3;
    protected Integer warningIconTop = 3;
    protected String placeholder;
    protected String balloonText;

    private static Level logLevel() {
        return logger.getLevel();
    }

    private static boolean isLogSevere() {
        Level ll = ValidatedTextField.logLevel();
        return ll == null ? true : ll.intValue() <= Level.SEVERE.intValue();
    }

    private static boolean isLogWarning() {
        Level ll = ValidatedTextField.logLevel();
        return ll == null ? true : ll.intValue() <= Level.WARNING.intValue();
    }

    private static boolean isLogInfo() {
        Level ll = ValidatedTextField.logLevel();
        return ll == null ? true : ll.intValue() <= Level.INFO.intValue();
    }

    private static boolean isLogFine() {
        Level ll = ValidatedTextField.logLevel();
        return ll == null ? true : ll.intValue() <= Level.FINE.intValue();
    }

    private static boolean isLogFiner() {
        Level ll = ValidatedTextField.logLevel();
        return ll == null ? false : ll.intValue() <= Level.FINER.intValue();
    }

    private static boolean isLogFinest() {
        Level ll = ValidatedTextField.logLevel();
        return ll == null ? false : ll.intValue() <= Level.FINEST.intValue();
    }

    private static void logEntering(String method, Object ... args) {
        logger.entering(ValidatedTextField.class.getName(), method, args);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(ValidatedTextField.class.getName(), method, result);
    }

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public ValidatedTextField() {
        Color col = this.getForeground();
        if (col == null) {
            col = Color.black;
        }
        this.validForeground = col;
        this.invalidForeground = Color.red;
        SwingListener.onTextChanged(this, new Runnable(){

            @Override
            public void run() {
                ValidatedTextField.this.validateText();
            }
        });
        URL warnUrl = ValidatedTextField.class.getResource("warning03.png");
        if (warnUrl != null) {
            this.setWarningIcon(new ImageIcon(warnUrl));
        }
    }

    public Color getValidForeground() {
        return this.validForeground;
    }

    public void setValidForeground(Color validForeground) {
        if (validForeground == null) {
            throw new IllegalArgumentException("validForeground==null");
        }
        this.validForeground = validForeground;
    }

    public Color getInvalidForeground() {
        return this.invalidForeground;
    }

    public void setInvalidForeground(Color invalidForeground) {
        if (invalidForeground == null) {
            throw new IllegalArgumentException("invalidForeground==null");
        }
        this.invalidForeground = invalidForeground;
    }

    public Predicate<String> getFilter() {
        return this.filter;
    }

    public void setFilter(Predicate<String> filter) {
        this.filter = filter;
        this.validateText();
    }

    public Icon getWarningIcon() {
        return this.warningIcon;
    }

    public void setWarningIcon(Icon warningIcon) {
        this.warningIcon = warningIcon;
    }

    public boolean isWarningIconVisible() {
        return this.warningIconVisible;
    }

    public void setWarningIconVisible(boolean warningIconVisible) {
        this.warningIconVisible = warningIconVisible;
        this.repaint();
    }

    public Rectangle getWarningIconRect() {
        Icon ico = this.getWarningIcon();
        if (ico == null) {
            return null;
        }
        Insets insets = this.getInsets();
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        float cw = this.getWidth();
        float ch = this.getHeight();
        float aw = cw - (float)insets.left - (float)insets.right;
        float ah = ch - (float)insets.top - (float)insets.bottom;
        int x = (int)(aw - (float)ico.getIconWidth() - (float)this.warningIconRight.intValue());
        int y = 0;
        return new Rectangle(x += insets.left, y += insets.top, ico.getIconWidth(), ico.getIconHeight());
    }

    public boolean isTextValid() {
        Predicate<String> p = this.getFilter();
        if (p == null) {
            return true;
        }
        return p.validate((Object)this.getText());
    }

    protected void seTextValid(boolean valid) {
        boolean bl = this.warningIconVisible = !valid;
        if (valid) {
            this.setForeground(this.validForeground);
        } else {
            this.setForeground(this.invalidForeground);
        }
    }

    public void validateText() {
        Predicate<String> p = this.getFilter();
        if (p != null) {
            this.seTextValid(p.validate((Object)this.getText()));
        } else {
            this.seTextValid(true);
        }
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    public void setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
        this.repaint();
    }

    public String getBalloonText() {
        if (this.balloonText != null) {
            return this.balloonText;
        }
        this.balloonText = "";
        return this.balloonText;
    }

    public void setBalloonText(String balloonText) {
        this.balloonText = balloonText;
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (this.warningIconVisible && e.getID() == 501) {
            Rectangle rect = this.getWarningIconRect();
            String btxt = this.getBalloonText();
            if (rect != null && rect.contains(e.getX(), e.getY()) && btxt != null && btxt.trim().length() > 0) {
                BalloonTip balloon = new BalloonTip((JComponent)this, btxt, (BalloonTipStyle)new RoundedBalloonStyle(7, 7, Color.white, Color.black), true);
                return;
            }
        }
        super.processMouseEvent(e);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        String txt = this.getText();
        String pholder = this.getPlaceholder();
        if (pholder != null && pholder.length() > 0 && (txt == null || txt.length() < 1)) {
            this.paintPlaceholder((Graphics2D)g);
        }
        if (this.warningIconVisible) {
            this.paintWarningIcon((Graphics2D)g);
        }
    }

    protected void paintWarningIcon(Graphics2D gs) {
        Icon ico = this.getWarningIcon();
        Rectangle rect = this.getWarningIconRect();
        if (ico == null || rect == null) {
            return;
        }
        ico.paintIcon(this, gs, rect.x, rect.y);
    }

    protected void paintPlaceholder(Graphics2D gs) {
        String txt = this.getPlaceholder();
        gs.setColor(Color.gray);
        Font fnt = gs.getFont();
        if (fnt == null) {
            return;
        }
        Insets insets = this.getInsets();
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        LineMetrics lm = fnt.getLineMetrics(txt, gs.getFontRenderContext());
        float cw = this.getWidth();
        float ch = this.getHeight();
        float aw = cw - (float)insets.left - (float)insets.right;
        float ah = ch - (float)insets.top - (float)insets.bottom;
        float th = lm.getAscent() + lm.getDescent() + lm.getLeading();
        float x = 0.0f;
        float y = th;
        y += (ah - th) / 2.0f;
        y -= lm.getDescent();
        gs.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        gs.drawString(txt, x += (float)insets.left, y += (float)insets.top);
    }
}

