/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.tree;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTable;
import xyz.cofe.gui.swing.table.Table;

public class ColumnScroll {
    private static final Logger logger = Logger.getLogger(ColumnScroll.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    private Double nodeRenderMinX = null;
    private Double nodeRenderMaxX = null;
    protected double scrollWidth = 0.0;
    private double scrollX = 0.0;
    protected boolean scrollerVisible;
    protected double scrollerHeight = 20.0;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(ColumnScroll.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(ColumnScroll.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(ColumnScroll.class.getName(), method, result);
    }

    public Double getNodeRenderMinX() {
        return this.nodeRenderMinX;
    }

    public void setNodeRenderMinX(Double nodeRenderMinX) {
        this.nodeRenderMinX = nodeRenderMinX;
    }

    public Double getNodeRenderMaxX() {
        return this.nodeRenderMaxX;
    }

    public void setNodeRenderMaxX(Double nodeRenderMaxX) {
        this.nodeRenderMaxX = nodeRenderMaxX;
    }

    public void updateNodeRenderBounds(Rectangle2D rect) {
        double d;
        double d2;
        if (this.nodeRenderMinX == null) {
            this.nodeRenderMinX = rect.getMinX();
            d2 = this.nodeRenderMinX;
        } else {
            d2 = Math.min(this.nodeRenderMinX, rect.getMinX());
        }
        this.nodeRenderMinX = d2;
        if (this.nodeRenderMaxX == null) {
            this.nodeRenderMaxX = rect.getMaxX();
            d = this.nodeRenderMaxX;
        } else {
            d = Math.max(this.nodeRenderMaxX, rect.getMaxX());
        }
        this.nodeRenderMaxX = d;
    }

    public synchronized void resetNodeRenderBounds() {
        this.nodeRenderMaxX = null;
        this.nodeRenderMinX = null;
    }

    public double getScrollWidth() {
        return this.scrollWidth;
    }

    public void setScrollWidth(double scrollWidth) {
        this.scrollWidth = scrollWidth;
    }

    public double getScrollX() {
        return this.scrollX;
    }

    public void setScrollX(double x) {
        this.scrollX = x;
    }

    public boolean isScrollerVisible() {
        return this.scrollerVisible;
    }

    public void setScrollerVisible(boolean scrollerVisible) {
        this.scrollerVisible = scrollerVisible;
    }

    public void recalcScrollWidth(double columnWidth) {
        if (this.nodeRenderMaxX == null || this.nodeRenderMinX == null) {
            return;
        }
        double colWidth = columnWidth;
        double nodesWidthMax = this.nodeRenderMaxX + this.scrollX;
        if (colWidth < nodesWidthMax && colWidth > 0.0) {
            if (this.getScrollWidth() < nodesWidthMax) {
                this.setScrollWidth(nodesWidthMax);
            }
            this.setScrollerVisible(true);
        } else if (this.getScrollX() <= 0.0) {
            this.setScrollWidth(0.0);
            this.setScrollerVisible(false);
        }
    }

    public double getScrollerHeight() {
        return this.scrollerHeight;
    }

    public void setScrollerHeight(double scrollerHeight) {
        this.scrollerHeight = scrollerHeight;
    }

    public static double[] getColumnWidthBounds(JTable table, int column) {
        if (table == null) {
            return null;
        }
        if (column >= table.getColumnCount() || column < 0) {
            return null;
        }
        double x0 = 0.0;
        double x1 = 0.0;
        for (int ci = 0; ci <= column; ++ci) {
            double xx1;
            int mrg;
            int cw;
            if (ci == column) {
                cw = table.getColumnModel().getColumn(ci).getWidth();
                mrg = table.getColumnModel().getColumnMargin();
                if (ci == 0) {
                    x0 = 0.0;
                    x1 = cw;
                    x1 += (double)mrg;
                    continue;
                }
                xx1 = x1;
                x1 += (double)cw;
                x1 += (double)mrg;
                x0 = xx1;
                continue;
            }
            cw = table.getColumnModel().getColumn(ci).getWidth();
            mrg = table.getColumnModel().getColumnMargin();
            if (ci == 0) {
                x0 = 0.0;
                x1 = cw;
                x1 += (double)mrg;
                continue;
            }
            xx1 = x1;
            x1 += (double)cw;
            x1 += (double)mrg;
            x0 = xx1;
        }
        return new double[]{x0, x1};
    }

    public Rectangle2D getScrollerRect(Table table, int column) {
        if (table == null) {
            return null;
        }
        if (column >= table.getColumnCount() || column < 0) {
            return null;
        }
        double[] bounds = ColumnScroll.getColumnWidthBounds(table, column);
        if (bounds == null) {
            return null;
        }
        Rectangle r = table.getVisibleRect();
        return new Rectangle2D.Double(bounds[0], r.getMaxY() - this.scrollerHeight, bounds[1] - bounds[0], this.scrollerHeight);
    }

    public Rectangle2D getScrollerDragRect(Table table, int column) {
        if (!this.scrollerVisible) {
            return null;
        }
        Rectangle2D srect = this.getScrollerRect(table, column);
        if (srect == null) {
            return null;
        }
        if (this.scrollWidth <= 0.0) {
            return null;
        }
        double colw = srect.getWidth();
        double k = colw / this.scrollWidth;
        double x1 = this.scrollX * k;
        return new Rectangle2D.Double(x1, srect.getMinY(), colw * k, srect.getHeight());
    }

    public void paintScroller(Graphics2D gs, Table table, int column) {
        if (gs == null) {
            return;
        }
        if (table == null) {
            return;
        }
        if (this.isScrollerVisible() && this.getScrollWidth() > 0.0) {
            Rectangle2D scrollRect = this.getScrollerRect(table, column);
            if (scrollRect == null) {
                return;
            }
            Rectangle2D dragRect = this.getScrollerDragRect(table, column);
            if (dragRect == null) {
                return;
            }
            AlphaComposite cAlpha = AlphaComposite.getInstance(3, 0.5f);
            gs.setComposite(cAlpha);
            gs.setPaint(Color.lightGray);
            gs.fill(scrollRect);
            gs.setPaint(Color.gray);
            gs.fill(dragRect);
            gs.setComposite(AlphaComposite.Clear);
        }
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

