/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.tree;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import xyz.cofe.common.CloseableSet;
import xyz.cofe.gui.swing.table.Table;
import xyz.cofe.gui.swing.tree.ColumnScroll;

public class ColumnScrollModel {
    private static final Logger logger = Logger.getLogger(ColumnScrollModel.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected final CloseableSet tableListeners = new CloseableSet();
    protected Table table;
    protected TableColumnModelListener columnsListener = new TableColumnModelListener(){

        @Override
        public void columnAdded(TableColumnModelEvent e) {
            int fromIdx = e.getFromIndex();
            int toIdx = e.getToIndex();
            ColumnScrollModel.this.onColumnAdded(fromIdx, toIdx);
        }

        @Override
        public void columnRemoved(TableColumnModelEvent e) {
            int fromIdx = e.getFromIndex();
            int toIdx = e.getToIndex();
            ColumnScrollModel.this.onColumnRemoved(fromIdx, toIdx);
        }

        @Override
        public void columnMoved(TableColumnModelEvent e) {
            int fromIdx = e.getFromIndex();
            int toIdx = e.getToIndex();
            ColumnScrollModel.this.onColumnMoved(fromIdx, toIdx);
        }

        @Override
        public void columnMarginChanged(ChangeEvent e) {
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent e) {
        }
    };
    private List<ColumnScroll> columns;
    private boolean scrollDragged = false;
    private double scrollDragStartX = 0.0;
    private double scrollDragStartY = 0.0;
    private double scrollXStarted = 0.0;
    private double scrollXKofStarted = 0.0;
    private double scrollWidthStarted = 0.0;
    private double scrollColumWidthStarted = 0.0;
    private ColumnScroll scrolledColumn;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(ColumnScrollModel.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(ColumnScrollModel.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(ColumnScrollModel.class.getName(), method, result);
    }

    public synchronized Table getTable() {
        return this.table;
    }

    public synchronized void setTable(Table table) {
        this.tableListeners.closeAll();
        this.columns = null;
        this.table = table;
        if (table != null) {
            this.listen(table);
        }
    }

    protected void listen(Table table) {
        table.getColumnModel().addColumnModelListener(this.columnsListener);
        final WeakReference<Table> wref = new WeakReference<Table>(table);
        this.tableListeners.add(new Runnable(){

            @Override
            public void run() {
                Table table = (Table)wref.get();
                if (table == null) {
                    return;
                }
                table.getColumnModel().removeColumnModelListener(ColumnScrollModel.this.columnsListener);
            }
        });
    }

    protected synchronized void onColumnAdded(int from, int to) {
        for (int ci = Math.max(from, to); ci >= Math.min(from, to); --ci) {
            List<ColumnScroll> l = this.getColumns();
            if (ci >= l.size() || ci < 0) continue;
            ColumnScroll c = this.createColumnScroll();
            l.add(ci, c);
        }
    }

    protected synchronized void onColumnRemoved(int from, int to) {
        for (int ci = Math.max(from, to); ci >= Math.min(from, to); --ci) {
            List<ColumnScroll> l = this.getColumns();
            if (ci >= l.size() || ci < 0) continue;
            l.remove(ci);
        }
    }

    protected synchronized void onColumnMoved(int from, int to) {
        if (this.table == null) {
            return;
        }
        if (from == to) {
            return;
        }
        ColumnScroll c1 = this.getColumnScroll(from);
        ColumnScroll c2 = this.getColumnScroll(to);
        List<ColumnScroll> ls = this.getColumns();
        ls.set(from, c2);
        ls.set(to, c1);
    }

    protected ColumnScroll createColumnScroll() {
        return new ColumnScroll();
    }

    public synchronized List<ColumnScroll> getColumns() {
        if (this.columns != null) {
            return this.columns;
        }
        this.columns = new CopyOnWriteArrayList<ColumnScroll>();
        return this.columns;
    }

    public ColumnScroll getColumnScroll(int column) {
        if (column < 0) {
            return null;
        }
        if (this.table == null) {
            return null;
        }
        if (column >= this.table.getColumnCount()) {
            return null;
        }
        List<ColumnScroll> ls = this.getColumns();
        while (column >= ls.size()) {
            ls.add(this.createColumnScroll());
        }
        return ls.get(column);
    }

    public void resetNodeRenderBounds() {
        for (ColumnScroll cs : this.getColumns()) {
            if (cs == null) continue;
            cs.resetNodeRenderBounds();
        }
    }

    public void recalcScrollWidths() {
        Table tbl = this.getTable();
        if (tbl == null) {
            return;
        }
        for (int ci = 0; ci < tbl.getColumnCount(); ++ci) {
            double colWidth = tbl.getColumnWidth(ci);
            ColumnScroll cscr = this.getColumnScroll(ci);
            if (cscr == null) continue;
            cscr.recalcScrollWidth(colWidth);
        }
    }

    public void paintScrollers(Graphics2D gs, Table table) {
        if (gs == null) {
            return;
        }
        if (table == null) {
            return;
        }
        for (int ci = 0; ci < table.getColumnCount(); ++ci) {
            ColumnScroll cscr = this.getColumnScroll(ci);
            if (cscr == null) continue;
            cscr.paintScroller(gs, table, ci);
        }
    }

    public boolean isScrollDragged() {
        return this.scrollDragged;
    }

    public void setScrollDragged(boolean scrollDragged) {
        this.scrollDragged = scrollDragged;
    }

    public double getScrollDragStartX() {
        return this.scrollDragStartX;
    }

    public void setScrollDragStartX(double scrollDragStartX) {
        this.scrollDragStartX = scrollDragStartX;
    }

    public double getScrollDragStartY() {
        return this.scrollDragStartY;
    }

    public void setScrollDragStartY(double scrollDragStartY) {
        this.scrollDragStartY = scrollDragStartY;
    }

    public double getScrollXStarted() {
        return this.scrollXStarted;
    }

    public void setScrollXStarted(double scrollXStarted) {
        this.scrollXStarted = scrollXStarted;
    }

    public double getScrollXKofStarted() {
        return this.scrollXKofStarted;
    }

    public void setScrollXKofStarted(double scrollXKofStarted) {
        this.scrollXKofStarted = scrollXKofStarted;
    }

    public double getScrollWidthStarted() {
        return this.scrollWidthStarted;
    }

    public void setScrollWidthStarted(double scrollWidthStarted) {
        this.scrollWidthStarted = scrollWidthStarted;
    }

    public double getScrollColumWidthStarted() {
        return this.scrollColumWidthStarted;
    }

    public void setScrollColumWidthStarted(double scrollColumWidthStarted) {
        this.scrollColumWidthStarted = scrollColumWidthStarted;
    }

    public Rectangle2D getScrollerDragRect(int column) {
        if (column < 0) {
            return null;
        }
        if (this.table == null) {
            return null;
        }
        ColumnScroll cs = this.getColumnScroll(column);
        if (cs == null) {
            return null;
        }
        return cs.getScrollerDragRect(this.table, column);
    }

    public Rectangle2D getScrollerRect(int column) {
        if (column < 0) {
            return null;
        }
        if (this.table == null) {
            return null;
        }
        ColumnScroll cs = this.getColumnScroll(column);
        if (cs == null) {
            return null;
        }
        return cs.getScrollerRect(this.table, column);
    }

    public ColumnScroll getScrolledColumn() {
        return this.scrolledColumn;
    }

    public void setScrolledColumn(ColumnScroll scrolledColumn) {
        this.scrolledColumn = scrolledColumn;
    }

    public boolean startDrag(int x, int y) {
        this.setScrollDragged(false);
        if (this.table == null) {
            return false;
        }
        int col = this.table.getColumnModel().getColumnIndexAtX(x);
        if (col < 0) {
            return false;
        }
        ColumnScroll cscrl = this.getColumnScroll(col);
        if (cscrl == null) {
            return false;
        }
        Rectangle2D dragRect = this.getScrollerDragRect(col);
        if (dragRect == null) {
            return false;
        }
        if (!dragRect.contains(x, y)) {
            return false;
        }
        this.setScrolledColumn(cscrl);
        this.setScrollDragStartX(x);
        this.setScrollDragStartY(y);
        this.setScrollXStarted(cscrl.getScrollX());
        this.setScrollWidthStarted(cscrl.getScrollWidth());
        this.setScrollColumWidthStarted(this.table.getColumnWidth(col));
        double scrollWidthStarted = this.getScrollWidthStarted();
        double scrollColumWidthStarted = this.getScrollColumWidthStarted();
        if (scrollWidthStarted > 0.0) {
            this.setScrollXKofStarted(scrollColumWidthStarted / scrollWidthStarted);
            this.setScrollDragged(true);
            return true;
        }
        return false;
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

