/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.tree;

import java.awt.Component;
import java.awt.geom.Rectangle2D;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTable;
import xyz.cofe.gui.swing.cell.CellContext;
import xyz.cofe.gui.swing.cell.TCRenderer;
import xyz.cofe.gui.swing.cell.TableCellContext;
import xyz.cofe.gui.swing.cell.TreeNodeCellRender;
import xyz.cofe.gui.swing.cell.TreeNodeContext;
import xyz.cofe.gui.swing.tree.ColumnScroll;
import xyz.cofe.gui.swing.tree.ColumnScrollModel;
import xyz.cofe.gui.swing.tree.TreeTableNode;

public class TCellNodeRender
extends TCRenderer {
    private static final Logger logger = Logger.getLogger(TCellNodeRender.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected ColumnScrollModel columnScrollModel;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(TCellNodeRender.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(TCellNodeRender.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(TCellNodeRender.class.getName(), method, result);
    }

    public TCellNodeRender() {
        this.cellContext = this.createTreeNodeContext();
        this.labelRender = this.createTreeNodeCellRender();
        this.labelRender.getFormat().setFont(this.getFont());
    }

    public TCellNodeRender(TreeNodeCellRender cellRender, TreeNodeContext ctx) {
        this.cellContext = ctx != null ? ctx : this.createTreeNodeContext();
        this.labelRender = cellRender != null ? cellRender : this.createTreeNodeCellRender();
    }

    public ColumnScrollModel getColumnScrollModel() {
        return this.columnScrollModel;
    }

    public void setColumnScrollModel(ColumnScrollModel columnScrollModel) {
        this.columnScrollModel = columnScrollModel;
    }

    protected TreeNodeCellRender createTreeNodeCellRender() {
        return new TreeNodeCellRender(){

            @Override
            protected void onRenderedContentBounds(Rectangle2D rect, CellContext cctx) {
                ColumnScroll cscrl;
                TableCellContext tctx;
                int col;
                ColumnScrollModel csm = TCellNodeRender.this.getColumnScrollModel();
                if (cctx instanceof TableCellContext && rect != null && csm != null && (col = (tctx = (TableCellContext)cctx).getColumn()) >= 0 && (cscrl = csm.getColumnScroll(col)) != null) {
                    cscrl.updateNodeRenderBounds(rect);
                }
            }
        };
    }

    protected TreeNodeContext createTreeNodeContext() {
        return new TreeNodeContext();
    }

    public synchronized TreeNodeCellRender getTreeNodeCellRender() {
        if (this.labelRender instanceof TreeNodeCellRender) {
            return (TreeNodeCellRender)this.labelRender;
        }
        this.labelRender = this.createTreeNodeCellRender();
        return (TreeNodeCellRender)this.labelRender;
    }

    @Override
    public synchronized TreeNodeContext getCellContext() {
        if (this.cellContext instanceof TreeNodeContext) {
            return (TreeNodeContext)this.cellContext;
        }
        this.cellContext = this.createTreeNodeContext();
        return (TreeNodeContext)this.cellContext;
    }

    @Override
    public synchronized Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        ColumnScrollModel csm = this.getColumnScrollModel();
        if (csm != null) {
            ColumnScroll cs = this.getColumnScrollModel().getColumnScroll(column);
            if (cs != null) {
                double scrl = cs.getScrollX();
                this.getTreeNodeCellRender().setScrollX(scrl);
            } else {
                this.getTreeNodeCellRender().setScrollX(0.0);
            }
        }
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value instanceof TreeTableNode) {
            TreeTableNode node = (TreeTableNode)value;
            this.getCellContext().setNode(node);
            this.getCellContext().setValue(node.getData());
        }
        return this;
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

