/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.tree;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.KeyStroke;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import xyz.cofe.collection.Func2;
import xyz.cofe.collection.tree.TreeNodeEvent;
import xyz.cofe.collection.tree.TreeNodeListener;
import xyz.cofe.common.CloseableSet;
import xyz.cofe.common.ListenersHelper;
import xyz.cofe.common.Reciver;
import xyz.cofe.gui.swing.GuiUtil;
import xyz.cofe.gui.swing.cell.CellContext;
import xyz.cofe.gui.swing.cell.CellFormat;
import xyz.cofe.gui.swing.cell.TCRenderer;
import xyz.cofe.gui.swing.cell.TreeNodeCellRender;
import xyz.cofe.gui.swing.table.Column;
import xyz.cofe.gui.swing.table.Columns;
import xyz.cofe.gui.swing.table.Table;
import xyz.cofe.gui.swing.table.TableEvent;
import xyz.cofe.gui.swing.tree.ColumnScroll;
import xyz.cofe.gui.swing.tree.ColumnScrollModel;
import xyz.cofe.gui.swing.tree.CompareAndSetTreeTable;
import xyz.cofe.gui.swing.tree.SetTreeTable;
import xyz.cofe.gui.swing.tree.TCellNodeRender;
import xyz.cofe.gui.swing.tree.TreeTableModel;
import xyz.cofe.gui.swing.tree.TreeTableNode;
import xyz.cofe.gui.swing.tree.TreeTableNodeBasic;
import xyz.cofe.gui.swing.tree.TreeTableNodeColumn;
import xyz.cofe.gui.swing.tree.TreeTableNodeValue;
import xyz.cofe.gui.swing.tree.TreeTableNodeValueEditor;
import xyz.cofe.gui.swing.tree.TreeTableNodeValueEditorDef;
import xyz.cofe.j2d.RectangleFn;

public class TreeTable
extends Table {
    private static final Logger logger = Logger.getLogger(TreeTable.class.getName());
    private ColumnScrollModel columnScrollModel;
    protected TCellNodeRender nodeRender;
    protected TreeTableNodeValueEditor nodeEditor;
    protected TreeTableNodeBasic root;
    private final CloseableSet rootCloseListeners = new CloseableSet();
    private final TreeNodeListener treeNodeListener = new TreeNodeListener(){

        public void treeNodeEvent(TreeNodeEvent event) {
            if (event == null) {
                return;
            }
            if (event.getSource() instanceof TreeTableNodeBasic || event.getSource() == null) {
                TreeTable.this.rootListeners.fireEvent((Object)event);
            }
        }
    };
    private final ListenersHelper<TreeNodeListener<TreeTableNodeBasic>, TreeNodeEvent<TreeTableNodeBasic>> rootListeners = new ListenersHelper((Func2)new Func2<Object, TreeNodeListener<TreeTableNodeBasic>, TreeNodeEvent<TreeTableNodeBasic>>(){

        public Object apply(TreeNodeListener<TreeTableNodeBasic> ls, TreeNodeEvent<TreeTableNodeBasic> ev) {
            if (ls != null) {
                ls.treeNodeEvent(ev);
            }
            return null;
        }
    });
    protected TreeTableModel treeTableModel;
    protected KeyStroke toggleNodeFolding;

    private static Level logLevel() {
        return logger.getLevel();
    }

    private static boolean isLogSevere() {
        Level ll = TreeTable.logLevel();
        return ll == null ? true : ll.intValue() <= Level.SEVERE.intValue();
    }

    private static boolean isLogWarning() {
        Level ll = TreeTable.logLevel();
        return ll == null ? true : ll.intValue() <= Level.WARNING.intValue();
    }

    private static boolean isLogInfo() {
        Level ll = TreeTable.logLevel();
        return ll == null ? true : ll.intValue() <= Level.INFO.intValue();
    }

    private static boolean isLogFine() {
        Level ll = TreeTable.logLevel();
        return ll == null ? true : ll.intValue() <= Level.FINE.intValue();
    }

    private static boolean isLogFiner() {
        Level ll = TreeTable.logLevel();
        return ll == null ? false : ll.intValue() <= Level.FINER.intValue();
    }

    private static boolean isLogFinest() {
        Level ll = TreeTable.logLevel();
        return ll == null ? false : ll.intValue() <= Level.FINEST.intValue();
    }

    private static void logEntering(String method, Object ... args) {
        logger.entering(TreeTable.class.getName(), method, args);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(TreeTable.class.getName(), method, result);
    }

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public TreeTable() {
        this.setDefaultRenderer(TreeTableNodeBasic.class, this.getNodeRender());
        this.setDefaultRenderer(TreeTableNode.class, this.getNodeRender());
        this.setDefaultEditor(TreeTableNodeValue.class, this.getNodeEditor());
        this.setDefaultRenderer(TreeTableNodeValue.class, new TCRenderer());
        this.setModel(this.getTreeTableModel());
    }

    public ColumnScrollModel getColumnScrollModel() {
        if (this.columnScrollModel != null) {
            return this.columnScrollModel;
        }
        this.columnScrollModel = new ColumnScrollModel();
        this.columnScrollModel.setTable(this);
        return this.columnScrollModel;
    }

    public TCellNodeRender getNodeRender() {
        if (this.nodeRender != null) {
            return this.nodeRender;
        }
        this.nodeRender = new TCellNodeRender(new TreeNodeCellRender(new CellFormat().font(this.getFont()), this.getColumnScrollModel()), null);
        this.nodeRender.setColumnScrollModel(this.getColumnScrollModel());
        return this.nodeRender;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeTableNodeValueEditor getNodeEditor() {
        if (this.nodeEditor != null) {
            return this.nodeEditor;
        }
        TreeTable treeTable = this;
        synchronized (treeTable) {
            if (this.nodeEditor != null) {
                return this.nodeEditor;
            }
            this.nodeEditor = new TreeTableNodeValueEditorDef();
            return this.nodeEditor;
        }
    }

    protected boolean inTreeIconRect(MouseEvent e) {
        Rectangle2D rect;
        if (this.mouseOver && this.mouseAtRow >= 0 && this.mouseAtColumn >= 0 && this.getCellRenderer(this.mouseAtRow, this.mouseAtColumn) instanceof TCellNodeRender && (rect = this.getCellContentLayout(this.mouseAtRow, this.mouseAtColumn)) != null) {
            Rectangle2D irect;
            CellContext cc = this.getNodeRender().getTreeNodeCellRender().getTreeIconContext();
            Rectangle cellRect = this.getCellRect(this.mouseAtRow, this.mouseAtColumn, true);
            Rectangle2D rectangle2D = irect = cc != null ? cc.getBounds() : null;
            if (irect != null && cellRect != null) {
                irect = RectangleFn.move(irect, cellRect.x, cellRect.y);
            }
            boolean treeIcoMatch = irect != null ? irect.contains(e.getX(), e.getY()) : false;
            return treeIcoMatch;
        }
        return false;
    }

    @Override
    protected boolean mousePressed(MouseEvent e) {
        TreeTableNode node;
        boolean captured = super.mousePressed(e);
        TableModel omod = this.getModel();
        TreeTableModel ttmodel = null;
        if (omod instanceof TreeTableModel) {
            ttmodel = (TreeTableModel)omod;
        }
        if (ttmodel != null && !captured && this.inTreeIconRect(e) && e.getButton() == 1 && (node = ttmodel.getNodeOf(this.mouseAtRow)) != null) {
            if (node.isExpanded()) {
                node.collapse();
            } else {
                node.expand();
            }
            this.repaint();
            return true;
        }
        if (this.getColumnScrollModel().startDrag(e.getX(), e.getY())) {
            return true;
        }
        return captured;
    }

    @Override
    protected boolean mouseMove(MouseEvent e) {
        boolean captured = super.mouseMove(e);
        return captured;
    }

    @Override
    protected boolean mouseDragged(MouseEvent e) {
        if (e != null && this.getColumnScrollModel().isScrollDragged()) {
            ColumnScroll cs = this.getColumnScrollModel().getScrolledColumn();
            if (cs == null) {
                return super.mouseDragged(e);
            }
            double xcur = e.getX();
            double xstart = this.getColumnScrollModel().getScrollDragStartX();
            double xdelta = this.getColumnScrollModel().getScrollXKofStarted() != 0.0 ? (xcur - xstart) / this.getColumnScrollModel().getScrollXKofStarted() : 0.0;
            double scrollXNew = this.getColumnScrollModel().getScrollXStarted() + xdelta;
            if (scrollXNew < 0.0) {
                scrollXNew = 0.0;
            }
            double colwidth = this.getColumnScrollModel().getScrollColumWidthStarted();
            double scrollwidth = this.getColumnScrollModel().getScrollWidthStarted();
            double scrollXMax = scrollwidth - colwidth;
            if (scrollXMax > 0.0 && scrollXNew > scrollXMax) {
                scrollXNew = scrollXMax;
            }
            cs.setScrollX(scrollXNew);
            this.repaint();
            return true;
        }
        return super.mouseDragged(e);
    }

    @Override
    protected boolean mouseReleased(MouseEvent e) {
        this.getColumnScrollModel().setScrollDragged(false);
        return super.mouseReleased(e);
    }

    @Override
    protected boolean mouseExit(MouseEvent e) {
        this.getColumnScrollModel().setScrollDragged(false);
        return super.mouseExit(e);
    }

    @Override
    public void paint(Graphics g) {
        this.getColumnScrollModel().resetNodeRenderBounds();
        super.paint(g);
        this.getColumnScrollModel().recalcScrollWidths();
        this.getColumnScrollModel().paintScrollers((Graphics2D)g, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeTableNodeBasic getRoot() {
        TreeTable treeTable = this;
        synchronized (treeTable) {
            if (this.root != null) {
                return this.root;
            }
            TreeTableNodeBasic old = this.root;
            this.rootCloseListeners.closeAll();
            this.root = new TreeTableNodeBasic("root");
            if (this.root != null) {
                Closeable cl = this.root.addTreeNodeListener(this.treeNodeListener, true);
                if (cl != null) {
                    this.rootCloseListeners.add(cl);
                }
                if (this.root instanceof SetTreeTable) {
                    ((SetTreeTable)((Object)this.root)).setTreeTable(this);
                }
            }
            this.root.setExpanded(true);
            TreeTableNodeBasic ttnbA = new TreeTableNodeBasic("default node a");
            ttnbA.setExpanded(true);
            TreeTableNodeBasic ttnbB = new TreeTableNodeBasic("B");
            TreeTableNodeBasic ttnbC = new TreeTableNodeBasic("C");
            TreeTableNodeBasic ttnbD = new TreeTableNodeBasic("D");
            TreeTableNodeBasic ttnbE = new TreeTableNodeBasic("E");
            TreeTableNodeBasic ttnbF = new TreeTableNodeBasic("F");
            TreeTableNodeBasic ttnbG = new TreeTableNodeBasic("G");
            this.root.appendChild(ttnbA);
            this.root.appendChild(ttnbB);
            ttnbA.appendChild(ttnbC);
            ttnbA.appendChild(ttnbD);
            ttnbA.appendChild(ttnbE);
            ttnbE.appendChild(ttnbF);
            ttnbE.appendChild(ttnbG);
            this.firePropertyChange("root", old, this.root);
            return this.root;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRoot(TreeTableNodeBasic newroot) {
        if (newroot == null) {
            throw new IllegalArgumentException("newroot==null");
        }
        TreeTableNodeBasic old = null;
        TreeTable treeTable = this;
        synchronized (treeTable) {
            this.rootCloseListeners.closeAll();
            old = this.root;
            if (this.root instanceof CompareAndSetTreeTable) {
                ((CompareAndSetTreeTable)((Object)this.root)).compareAndSetTreeTable(this, null);
            }
            this.root = newroot;
            if (this.root != null) {
                Closeable cl = this.root.addTreeNodeListener(this.treeNodeListener, true);
                if (cl != null) {
                    this.rootCloseListeners.add(cl);
                }
                if (this.root instanceof SetTreeTable) {
                    ((SetTreeTable)((Object)this.root)).setTreeTable(this);
                }
            }
            if (this.treeTableModel != null) {
                this.treeTableModel.setRoot(this.root);
            }
        }
        this.firePropertyChange("root", old, this.root);
    }

    public boolean hasRootListener(TreeNodeListener<TreeTableNodeBasic> listener) {
        return this.rootListeners.hasListener(listener);
    }

    public Set<TreeNodeListener<TreeTableNodeBasic>> getRootListeners() {
        return this.rootListeners.getListeners();
    }

    public Closeable addRootListener(TreeNodeListener<TreeTableNodeBasic> listener) {
        return this.rootListeners.addListener(listener);
    }

    public Closeable addRootListener(TreeNodeListener<TreeTableNodeBasic> listener, boolean weakLink) {
        return this.rootListeners.addListener(listener, weakLink);
    }

    public void removeRootListener(TreeNodeListener<TreeTableNodeBasic> listener) {
        this.rootListeners.removeListener(listener);
    }

    public void removeRootAllListeners() {
        this.rootListeners.removeAllListeners();
    }

    protected void fireRootEvent(TreeNodeEvent<TreeTableNodeBasic> event) {
        this.rootListeners.fireEvent(event);
    }

    public Queue<TreeNodeEvent<TreeTableNodeBasic>> getRootEventQueue() {
        return this.rootListeners.getEventQueue();
    }

    public void addRootEvent(TreeNodeEvent<TreeTableNodeBasic> ev) {
        this.rootListeners.addEvent(ev);
    }

    public void fireRootEvents() {
        this.rootListeners.fireEvents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeTableModel getTreeTableModel() {
        TreeTable treeTable = this;
        synchronized (treeTable) {
            if (this.treeTableModel != null) {
                return this.treeTableModel;
            }
            this.treeTableModel = new TreeTableModel();
            this.treeTableModel.setRoot(this.getRoot());
            return this.treeTableModel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeTableNode getNodeOf(int row) {
        if (row < 0) {
            return null;
        }
        TreeTable treeTable = this;
        synchronized (treeTable) {
            return this.getTreeTableModel().getNodeOf(row);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowOf(TreeTableNode node) {
        if (node == null) {
            return -1;
        }
        TreeTable treeTable = this;
        synchronized (treeTable) {
            return this.getTreeTableModel().getRowOf(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRootVisible() {
        TreeTable treeTable = this;
        synchronized (treeTable) {
            return this.getTreeTableModel().getDirectModel().isRootVisible();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRootVisible(boolean rootVisible) {
        TreeTable treeTable = this;
        synchronized (treeTable) {
            this.getTreeTableModel().getDirectModel().setRootVisible(rootVisible);
        }
    }

    public int[] getColumnsWidths() {
        TableColumnModel tcm = this.getColumnModel();
        int cc = tcm.getColumnCount();
        int[] w = new int[cc];
        for (int ci = 0; ci < cc; ++ci) {
            TableColumn tc = tcm.getColumn(ci);
            w[ci] = tc.getWidth();
        }
        return w;
    }

    public void setColumnsWidths(boolean pref, int[] w) {
        if (w == null) {
            return;
        }
        TableColumnModel tcm = this.getColumnModel();
        int cc = Math.min(w.length, tcm.getColumnCount());
        for (int ci = 0; ci < cc; ++ci) {
            TableColumn tc = tcm.getColumn(ci);
            if (pref) {
                tc.setPreferredWidth(w[ci]);
                continue;
            }
            tc.setWidth(w[ci]);
        }
    }

    public Columns getDataTreeColumns() {
        return this.getTreeTableModel().getColumns();
    }

    public Column getDataTreeColumnAtX(int x) {
        int ci = this.getColumnModel().getColumnIndexAtX(x);
        if (ci < 0) {
            return null;
        }
        TableColumn tc = this.getColumnModel().getColumn(ci);
        if (tc == null) {
            return null;
        }
        int mi = tc.getModelIndex();
        if (mi < 0) {
            return null;
        }
        int cc = this.getDataTreeColumns().size();
        if (mi >= cc) {
            return null;
        }
        return (Column)this.getDataTreeColumns().get(mi);
    }

    public TreeTableNode getNodeAt(int x, int y) {
        int row = this.rowAtPoint(new Point(x, y));
        if (row < 0) {
            return null;
        }
        TreeTableNode ttn = this.getNodeOf(row);
        return ttn;
    }

    public String getNodeColumnName() {
        Iterator iterator = this.getDataTreeColumns().iterator();
        while (iterator.hasNext()) {
            Column col = (Column)iterator.next();
            if (col == null || !(col instanceof TreeTableNodeColumn)) continue;
            TreeTableNodeColumn ttnc = (TreeTableNodeColumn)col;
            return ttnc.getName();
        }
        return null;
    }

    public void setNodeColumnName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name==null");
        }
        Iterator iterator = this.getDataTreeColumns().iterator();
        while (iterator.hasNext()) {
            Column col = (Column)iterator.next();
            if (col == null || !(col instanceof TreeTableNodeColumn)) continue;
            TreeTableNodeColumn ttnc = (TreeTableNodeColumn)col;
            ttnc.setName(name);
        }
    }

    public Object getNodeColumnHeaderValue() {
        int cc = this.getColumnModel().getColumnCount();
        for (int ci = 0; ci < cc; ++ci) {
            Column dc;
            int mi;
            TableColumn tc = this.getColumnModel().getColumn(ci);
            if (tc == null || (mi = tc.getModelIndex()) < 0 || mi >= this.getDataTreeColumns().size() || !((dc = (Column)this.getDataTreeColumns().get(mi)) instanceof TreeTableNodeColumn)) continue;
            return tc.getHeaderValue();
        }
        return null;
    }

    public void setNodeColumnHeaderValue(Object value) {
        int cc = this.getColumnModel().getColumnCount();
        for (int ci = 0; ci < cc; ++ci) {
            Column dc;
            int mi;
            TableColumn tc = this.getColumnModel().getColumn(ci);
            if (tc == null || (mi = tc.getModelIndex()) < 0 || mi >= this.getDataTreeColumns().size() || !((dc = (Column)this.getDataTreeColumns().get(mi)) instanceof TreeTableNodeColumn)) continue;
            tc.setHeaderValue(value);
        }
    }

    public KeyStroke getToggleNodeFolding() {
        if (this.toggleNodeFolding != null) {
            return this.toggleNodeFolding;
        }
        this.toggleNodeFolding = KeyStroke.getKeyStroke("pressed ADD");
        return this.toggleNodeFolding;
    }

    public void setToggleNodeFolding(KeyStroke toggleNodeFolding) {
        this.toggleNodeFolding = toggleNodeFolding;
    }

    public List<TreeTableNode> getSelectedNodes() {
        ArrayList<TreeTableNode> lnodes = new ArrayList<TreeTableNode>();
        for (int row : this.getSelectedRows()) {
            TreeTableNode ttn = this.getNodeOf(row);
            if (ttn == null) continue;
            lnodes.add(ttn);
        }
        return lnodes;
    }

    public void setSelectedRows(int[] rows) {
        this.getSelectionModel().clearSelection();
        for (int row : rows) {
            if (row < 0 || row >= this.getRowCount()) continue;
            this.getSelectionModel().addSelectionInterval(row, row);
        }
    }

    public List<TreeTableNode> setSelectedNodes(Iterable<TreeTableNode> nodes) {
        ArrayList<TreeTableNode> selected = new ArrayList<TreeTableNode>();
        this.getSelectionModel().clearSelection();
        if (nodes == null) {
            return selected;
        }
        for (TreeTableNode ttnode : nodes) {
            int row;
            if (ttnode == null || (row = this.getRowOf(ttnode)) < 0 || row >= this.getRowCount()) continue;
            this.getSelectionModel().addSelectionInterval(row, row);
            selected.add(ttnode);
        }
        return selected;
    }

    public TreeTableNode getFocusedNode() {
        int row = this.getFocusedRow();
        if (row < 0) {
            return null;
        }
        return this.getNodeOf(row);
    }

    public void setFocusedNode(TreeTableNode node) {
        this.getSelectionModel().clearSelection();
        if (node == null) {
            return;
        }
        int row = this.getRowOf(node);
        if (row >= 0) {
            this.setFocusedCell(row, 0);
        }
    }

    public void setFocusedCell(int row, int col) {
        int[] selcols;
        int[] selrows = this.getSelectedRows();
        boolean addRowSel = true;
        for (int selrow : selrows) {
            if (selrow != row) continue;
            addRowSel = false;
        }
        boolean addColSel = true;
        for (int selcol : selcols = this.getColumnModel().getSelectedColumns()) {
            if (selcol != col) continue;
            addColSel = false;
        }
        if (addRowSel) {
            this.getSelectionModel().addSelectionInterval(row, row);
        }
        if (addColSel) {
            this.getColumnModel().getSelectionModel().addSelectionInterval(col, col);
        }
        this.getSelectionModel().setLeadSelectionIndex(row);
        this.getColumnModel().getSelectionModel().setLeadSelectionIndex(col);
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        TreeTableNode node = this.getFocusedNode();
        if (node != null && GuiUtil.match(e, this.getToggleNodeFolding())) {
            if (node.isExpanded()) {
                node.collapse();
            } else {
                node.expand();
            }
            this.repaint();
            return;
        }
        super.processKeyEvent(e);
    }

    public Closeable onFocusedNodeChanged(final Reciver<TreeTableNode> reciver) {
        if (reciver == null) {
            throw new IllegalArgumentException("reciver == null");
        }
        return this.onFocusedRowChanged(new Reciver<TableEvent.FocusedRowChanged>(){

            public void recive(TableEvent.FocusedRowChanged rowEvent) {
                int row = rowEvent.getCurrentRow();
                TreeTableNode node = TreeTable.this.getNodeOf(row);
                reciver.recive((Object)node);
            }
        });
    }
}

