/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.tree;

import java.io.Closeable;
import java.util.List;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import xyz.cofe.collection.Convertor;
import xyz.cofe.collection.Func3;
import xyz.cofe.collection.tree.TreeNode;
import xyz.cofe.collection.tree.TreeNodeAdded;
import xyz.cofe.collection.tree.TreeNodeBulkInserted;
import xyz.cofe.collection.tree.TreeNodeRemoved;
import xyz.cofe.collection.tree.TreeNodeRemoving;
import xyz.cofe.common.CloseableSet;
import xyz.cofe.common.Reciver;
import xyz.cofe.gui.swing.table.Column;
import xyz.cofe.gui.swing.table.Columns;
import xyz.cofe.gui.swing.table.EventSupport;
import xyz.cofe.gui.swing.table.GetReaderForRow;
import xyz.cofe.gui.swing.table.IsRowEditable;
import xyz.cofe.gui.swing.tree.TreeTableModelInterface;
import xyz.cofe.gui.swing.tree.TreeTableNode;
import xyz.cofe.gui.swing.tree.TreeTableNodeBasic;
import xyz.cofe.gui.swing.tree.TreeTableNodeColumn;

public class TreeTableDirectModel
implements TreeTableModelInterface {
    private static final Logger logger = Logger.getLogger(TreeTableDirectModel.class.getName());
    protected final EventSupport evsupport;
    protected TreeTableNode root;
    protected WeakHashMap<TreeTableNode, RemovingNodeData> removingChild = new WeakHashMap();
    protected final CloseableSet rootListeners = new CloseableSet();
    protected boolean rootVisible = false;
    protected Columns columns;

    private static boolean eq(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null && b != null) {
            return false;
        }
        if (a != null && b == null) {
            return false;
        }
        return a.equals(b);
    }

    private static Level logLevel() {
        return logger.getLevel();
    }

    private static boolean isLogSevere() {
        Level level = TreeTableDirectModel.logLevel();
        return level == null ? true : level.intValue() <= Level.SEVERE.intValue();
    }

    private static boolean isLogWarning() {
        Level level = TreeTableDirectModel.logLevel();
        return level == null ? true : level.intValue() <= Level.WARNING.intValue();
    }

    private static boolean isLogInfo() {
        Level level = TreeTableDirectModel.logLevel();
        return level == null ? true : level.intValue() <= Level.INFO.intValue();
    }

    private static boolean isLogFine() {
        Level level = TreeTableDirectModel.logLevel();
        return level == null ? true : level.intValue() <= Level.FINE.intValue();
    }

    private static boolean isLogFiner() {
        Level level = TreeTableDirectModel.logLevel();
        return level == null ? false : level.intValue() <= Level.FINER.intValue();
    }

    private static boolean isLogFinest() {
        Level level = TreeTableDirectModel.logLevel();
        return level == null ? false : level.intValue() <= Level.FINEST.intValue();
    }

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(TreeTableDirectModel.class.getName(), method, params);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(TreeTableDirectModel.class.getName(), method, result);
    }

    private static void logExiting(String method) {
        logger.exiting(TreeTableDirectModel.class.getName(), method);
    }

    public TreeTableDirectModel() {
        this.evsupport = new EventSupport(this);
    }

    @Override
    public synchronized TreeTableNode getRoot() {
        if (this.root != null) {
            return this.root;
        }
        this.root = new TreeTableNodeBasic();
        this.listenRoot();
        return this.root;
    }

    @Override
    public synchronized void setRoot(TreeTableNode root) {
        this.root = root;
        this.listenRoot();
        this.evsupport.fireAllChanged();
    }

    public void fireAllChanged() {
        this.evsupport.fireAllChanged();
    }

    public void fireColumnsChanged() {
        this.evsupport.fireColumnsChanged();
    }

    public void fireRowUpdated(int row) {
        this.evsupport.fireRowUpdated(row);
    }

    public void fireRowsUpdated(int rowIndexFrom, int toIndexInclude) {
        this.evsupport.fireRowsUpdated(rowIndexFrom, toIndexInclude);
    }

    public void fireCellChanged(int rowIndex, int columnIndex) {
        this.evsupport.fireCellChanged(rowIndex, columnIndex);
    }

    public void fireRowsInserted(int rowIndexFrom, int toIndexInclude) {
        this.evsupport.fireRowsInserted(rowIndexFrom, toIndexInclude);
    }

    public void fireRowsDeleted(int rowIndexFrom, int toIndexInclude) {
        this.evsupport.fireRowsDeleted(rowIndexFrom, toIndexInclude);
    }

    public void fireTableModelEvent(TableModelEvent e) {
        this.evsupport.fireTableModelEvent(e);
    }

    protected synchronized void onTreeNodeBulkInserted(TreeNodeBulkInserted ev, TreeTableNode parent, Integer insertIndex, List insertedItems) {
        if (ev == null) {
            throw new IllegalArgumentException("ev == null");
        }
        if (parent == null) {
            throw new IllegalArgumentException("parent == null");
        }
        if (insertIndex == null) {
            throw new IllegalArgumentException("insertIndex == null");
        }
        if (insertedItems == null) {
            throw new IllegalArgumentException("insertedItems == null");
        }
        if (insertIndex < 0) {
            throw new IllegalArgumentException("insertIndex(" + insertIndex + ") < 0");
        }
        if (insertedItems.isEmpty()) {
            return;
        }
        int insChildNCount = 0;
        int chi = -1;
        TreeTableNode firstInsertChild = null;
        for (Object ch : insertedItems) {
            ++chi;
            if (ch == null) {
                throw new IllegalArgumentException("insert child[" + chi + "] == null");
            }
            if (!(ch instanceof TreeTableNode)) {
                throw new IllegalArgumentException("insert child[" + chi + "] not instanceof TreeTableNode");
            }
            if (firstInsertChild == null) {
                firstInsertChild = (TreeTableNode)ch;
            }
            insChildNCount += ((TreeTableNode)ch).getNodesCount();
        }
        int parentOff = parent.getRootOffset();
        if (!this.isRootVisible()) {
            --parentOff;
        }
        int firstChildOff = firstInsertChild.getRootOffset();
        if (!this.isRootVisible()) {
            --firstChildOff;
        }
        if (parentOff >= 0) {
            TreeTableDirectModel.logFiner("onTreeNodeBulkInserted() fireRowUpdated parentOff={0}", parentOff);
            this.evsupport.fireRowUpdated(parentOff);
        }
        int firstRow = firstChildOff;
        int lastRow = firstChildOff + insChildNCount - 1;
        this.evsupport.fireRowsInserted(firstRow, lastRow);
    }

    protected synchronized void onTreeNodeAdded(TreeNodeAdded evtna, TreeTableNode parent, TreeTableNode child, Integer childIndex) {
        int childNCount = child.getNodesCount();
        int childOff = child.getRootOffset();
        if (!this.isRootVisible()) {
            --childOff;
        }
        int parentOff = parent.getRootOffset();
        if (!this.isRootVisible()) {
            --parentOff;
        }
        if (parentOff >= 0) {
            TreeTableDirectModel.logFiner("onTreeNodeAdded() fireRowUpdated parentOff={0}", parentOff);
            this.evsupport.fireRowUpdated(parentOff);
        }
        TreeTableDirectModel.logFiner("onTreeNodeAdded() fireRowsInserted rootVisible={0},child.ncnt={3}, fire inserted: {4} to {5}", this.isRootVisible(), null, null, childNCount, childOff, childOff + childNCount - 1);
        this.evsupport.fireRowsInserted(childOff, childOff + childNCount - 1);
    }

    protected synchronized void onTreeNodeRemoving(TreeNodeRemoving ev, TreeTableNode parent, TreeTableNode child, Integer childIndex) {
        int childoff;
        int nchild = child.getNodesCount();
        int from = childoff = child.getRootOffset();
        if (!this.isRootVisible()) {
            --from;
        }
        int to = from + nchild - 1;
        RemovingNodeData rndata = new RemovingNodeData();
        rndata.childNodesCount = nchild;
        rndata.childRootOffset = childoff;
        rndata.fromIndex = from;
        rndata.toIndex = to;
        rndata.rootVisible = this.isRootVisible();
        rndata.parentRootOffset = parent.getRootOffset();
        this.removingChild.put(child, rndata);
    }

    protected synchronized void onTreeNodeRemoved(TreeNodeRemoved ev, TreeTableNode parent, TreeTableNode child, Integer childIndex) {
        RemovingNodeData rndata = this.removingChild.get(child);
        if (rndata != null) {
            rndata.fireEvent(this.evsupport, child);
        }
    }

    protected synchronized void listenRoot() {
        this.rootListeners.closeAll();
        if (this.root == null) {
            return;
        }
        Closeable cl = this.root.onTreeNodeEvent(TreeNodeAdded.class, new Reciver(){

            public void recive(Object ev) {
                if (!(ev instanceof TreeNodeAdded)) {
                    return;
                }
                TreeNodeAdded tnaev = (TreeNodeAdded)ev;
                TreeNode tnchild = tnaev.getChild();
                TreeNode tnprnt = tnaev.getParent();
                if (!(tnchild instanceof TreeTableNode)) {
                    return;
                }
                if (!(tnprnt instanceof TreeTableNode)) {
                    return;
                }
                TreeTableNode child = (TreeTableNode)tnchild;
                TreeTableNode parent = (TreeTableNode)tnprnt;
                TreeTableDirectModel.this.onTreeNodeAdded(tnaev, parent, child, tnaev.getChildIndex());
            }
        });
        this.rootListeners.add(cl);
        cl = this.root.onTreeNodeEvent(TreeNodeBulkInserted.class, new Reciver(){

            public void recive(Object ev) {
                if (!(ev instanceof TreeNodeBulkInserted)) {
                    return;
                }
                TreeNodeBulkInserted bev = (TreeNodeBulkInserted)((Object)ev);
                int insIdx = bev.getInsertIndex();
                List insItms = bev.getItems();
                TreeNode tnParent = bev.getParent();
                if (!(tnParent instanceof TreeTableNode)) {
                    throw new IllegalStateException("inserted parent not TreeTableNode");
                }
                TreeTableNode parent = (TreeTableNode)tnParent;
                TreeTableDirectModel.this.onTreeNodeBulkInserted(bev, parent, insIdx, insItms);
            }
        });
        this.rootListeners.add(cl);
        cl = this.root.onTreeNodeEvent(TreeNodeRemoving.class, new Reciver(){

            public void recive(Object ev) {
                if (!(ev instanceof TreeNodeRemoving)) {
                    return;
                }
                TreeNodeRemoving tev = (TreeNodeRemoving)ev;
                TreeNode tnchild = tev.getChild();
                TreeNode tnprnt = tev.getParent();
                if (!(tnchild instanceof TreeTableNode)) {
                    return;
                }
                if (!(tnprnt instanceof TreeTableNode)) {
                    return;
                }
                TreeTableNode child = (TreeTableNode)tnchild;
                TreeTableNode parent = (TreeTableNode)tnprnt;
                TreeTableDirectModel.this.onTreeNodeRemoving(tev, parent, child, tev.getChildIndex());
            }
        });
        this.rootListeners.add(cl);
        cl = this.root.onTreeNodeEvent(TreeNodeRemoved.class, new Reciver(){

            public void recive(Object ev) {
                if (!(ev instanceof TreeNodeRemoved)) {
                    return;
                }
                TreeNodeRemoved tev = (TreeNodeRemoved)ev;
                TreeNode tnchild = tev.getChild();
                TreeNode tnprnt = tev.getParent();
                if (!(tnchild instanceof TreeTableNode)) {
                    return;
                }
                if (!(tnprnt instanceof TreeTableNode)) {
                    return;
                }
                TreeTableNode child = (TreeTableNode)tnchild;
                TreeTableNode parent = (TreeTableNode)tnprnt;
                TreeTableDirectModel.this.onTreeNodeRemoved(tev, parent, child, tev.getChildIndex());
            }
        });
        this.rootListeners.add(cl);
    }

    @Override
    public synchronized boolean isRootVisible() {
        return this.rootVisible;
    }

    public synchronized void setRootVisible(boolean rootVisible) {
        this.rootVisible = rootVisible;
        this.fireAllChanged();
    }

    @Override
    public synchronized TreeTableNode getNodeOf(int row) {
        if (this.root == null) {
            return null;
        }
        if (!this.rootVisible) {
            int trow = row + 1;
            TreeTableNode ttn = (TreeTableNode)this.root.deepOffset(trow);
            return ttn;
        }
        return (TreeTableNode)this.root.deepOffset(row);
    }

    @Override
    public synchronized int getRowOf(TreeTableNode node) {
        if (node == null) {
            return -1;
        }
        if (this.root == null) {
            return -1;
        }
        int roff = node.getRootOffset();
        TreeNode o = this.root.deepOffset(roff);
        if (o == null) {
            return -1;
        }
        if (!TreeTableDirectModel.eq(o, node)) {
            return -1;
        }
        if (TreeTableDirectModel.eq(this.root, node)) {
            if (this.rootVisible) {
                return 0;
            }
            return roff - 1;
        }
        return this.rootVisible ? roff : roff - 1;
    }

    public synchronized Columns getColumns() {
        if (this.columns != null) {
            return this.columns;
        }
        this.columns = new Columns();
        this.columns.add(new TreeTableNodeColumn());
        this.columns.onChanged((Func3)new Func3<Object, Integer, Column, Column>(){

            public Object apply(Integer idx, Column oldc, Column newc) {
                TreeTableDirectModel.this.evsupport.fireAllChanged();
                return null;
            }
        });
        return this.columns;
    }

    @Override
    public synchronized int getRowCount() {
        if (this.root == null) {
            return 0;
        }
        int rc = this.root.getNodesCount();
        if (rc < 0) {
            return 0;
        }
        if (!this.rootVisible) {
            if (rc <= 1) {
                return 0;
            }
            return rc - 1;
        }
        return rc;
    }

    @Override
    public synchronized int getColumnCount() {
        return this.getColumns().size();
    }

    @Override
    public synchronized String getColumnName(int columnIndex) {
        String name = null;
        if (columnIndex >= 0 && columnIndex < this.getColumnCount()) {
            Column col = (Column)this.getColumns().get(columnIndex);
            name = col != null ? col.getName() : null;
        }
        return name == null ? "?" : name;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        Class type = null;
        if (columnIndex >= 0 && columnIndex < this.getColumnCount()) {
            Column col = (Column)this.getColumns().get(columnIndex);
            type = col != null ? col.getType() : null;
        }
        return type == null ? String.class : type;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        Convertor<Column.Cell, Boolean> conv;
        TreeTableNode node = this.getNodeOf(rowIndex);
        if (node == null) {
            return false;
        }
        Column col = null;
        Class type = null;
        if (columnIndex >= 0 && columnIndex < this.getColumnCount()) {
            col = (Column)this.getColumns().get(columnIndex);
            Class clazz = type = col != null ? col.getType() : null;
        }
        if (col instanceof IsRowEditable) {
            boolean editable = ((IsRowEditable)((Object)col)).isRowEditable(node);
            return editable;
        }
        Convertor<Column.Cell, Boolean> convertor = conv = col == null ? null : col.getWriter();
        return conv != null;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        TreeTableNode node = this.getNodeOf(rowIndex);
        if (node == null) {
            return null;
        }
        Column col = null;
        Class type = null;
        if (columnIndex >= 0 && columnIndex < this.getColumnCount()) {
            col = (Column)this.getColumns().get(columnIndex);
            type = col != null ? col.getType() : null;
        }
        Convertor<Object, Object> conv = null;
        if (col != null) {
            Convertor<Object, Object> convertor = conv = col instanceof GetReaderForRow ? col.getReader(rowIndex) : col.getReader();
        }
        if (type == null || conv == null) {
            return node.toString();
        }
        return conv.convert((Object)node);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Convertor<Column.Cell, Boolean> conv;
        TreeTableNode node = this.getNodeOf(rowIndex);
        if (node == null) {
            return;
        }
        Column col = null;
        Class type = null;
        if (columnIndex >= 0 && columnIndex < this.getColumnCount()) {
            col = (Column)this.getColumns().get(columnIndex);
            type = col != null ? col.getType() : null;
        }
        Convertor<Column.Cell, Boolean> convertor = conv = col == null ? null : col.getWriter();
        if (conv != null && ((Boolean)conv.convert((Object)new Column.Cell(node, aValue))).booleanValue()) {
            this.fireCellChanged(rowIndex, columnIndex);
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.evsupport.addTableModelListener(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.evsupport.removeTableModelListener(l);
    }

    protected static class RemovingNodeData {
        public int childRootOffset;
        public int childNodesCount;
        public int fromIndex;
        public int toIndex;
        public boolean rootVisible;
        public int parentRootOffset;

        protected RemovingNodeData() {
        }

        public void fireEvent(EventSupport evsup, TreeTableNode child) {
            TreeTableDirectModel.logFiner("onTreeNodeRemoved() fireRowsDeleted( {0}, {1} ) roff={2} cnt={3} data={4}", new Object[]{this.fromIndex, this.toIndex, this.childRootOffset, this.childNodesCount, child.getData()});
            evsup.fireRowsDeleted(this.fromIndex, this.toIndex);
            if (this.rootVisible) {
                int poff = this.parentRootOffset;
                if (poff >= 0) {
                    TreeTableDirectModel.logFiner("onTreeNodeRemoved() fireRowsUpdated( {0}, {1} ) roff={2}", new Object[]{this.parentRootOffset, this.parentRootOffset, this.childRootOffset});
                    evsup.fireRowsUpdated(this.parentRootOffset, this.parentRootOffset);
                }
            } else {
                int poff = this.parentRootOffset - 1;
                if (poff >= 0) {
                    TreeTableDirectModel.logFiner("onTreeNodeRemoved() fireRowsUpdated( {0}, {1} ) roff={2}", new Object[]{poff, poff, this.childRootOffset});
                    evsup.fireRowsUpdated(poff, poff);
                }
            }
        }
    }
}

