/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.tree;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.Predicate;
import xyz.cofe.collection.iterators.TreeWalk;
import xyz.cofe.collection.tree.TreeNode;
import xyz.cofe.common.CloseableSet;
import xyz.cofe.common.Reciver;
import xyz.cofe.gui.swing.table.FilterRowTM;
import xyz.cofe.gui.swing.table.RowData;
import xyz.cofe.gui.swing.tree.TreeTableModelInterface;
import xyz.cofe.gui.swing.tree.TreeTableNode;
import xyz.cofe.gui.swing.tree.TreeTableNodeBasic;
import xyz.cofe.gui.swing.tree.TreeTableNodeCollapsed;
import xyz.cofe.gui.swing.tree.TreeTableNodeExpanded;

public class TreeTableFilterModel
extends FilterRowTM
implements TreeTableModelInterface {
    private static final Logger logger = Logger.getLogger(TreeTableFilterModel.class.getName());
    protected final Predicate<RowData> filter = new Predicate<RowData>(){

        public boolean validate(RowData rowdata) {
            Object onode = rowdata.getValue(0);
            if (onode instanceof TreeTableNode) {
                TreeTableNode node = (TreeTableNode)onode;
                boolean visible = TreeTableFilterModel.this.isVisible(node);
                TreeTableFilterModel.logFinest("filter.validate visible={0} ro={1} data={2}", new Object[]{visible, node.getRootOffset(), node.getData()});
                return visible;
            }
            return true;
        }
    };
    protected TreeTableNode root;
    protected final CloseableSet rootListeners = new CloseableSet();

    private static final Level logLevel() {
        return Logger.getLogger(TreeTableFilterModel.class.getName()).getLevel();
    }

    private static final boolean isLogSevere() {
        Level logLevel = TreeTableFilterModel.logLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.SEVERE.intValue();
    }

    private static final boolean isLogWarning() {
        Level logLevel = TreeTableFilterModel.logLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.WARNING.intValue();
    }

    private static final boolean isLogInfo() {
        Level logLevel = TreeTableFilterModel.logLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.INFO.intValue();
    }

    private static final boolean isLogFine() {
        Level logLevel = TreeTableFilterModel.logLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINE.intValue();
    }

    private static final boolean isLogFiner() {
        Level logLevel = TreeTableFilterModel.logLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINER.intValue();
    }

    private static final boolean isLogFinest() {
        Level logLevel = TreeTableFilterModel.logLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(TreeTableFilterModel.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(TreeTableFilterModel.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(TreeTableFilterModel.class.getName(), method, result);
    }

    public TreeTableFilterModel(TreeTableModelInterface dm) {
        if (dm == null) {
            throw new IllegalArgumentException("dm==null");
        }
        this.setRowFilter(this.filter);
        this.setSourceListen(true);
        this.setTableModel(dm);
        TreeTableNode root = dm.getRoot();
        if (root != null) {
            this.setRoot(root);
        }
    }

    public synchronized boolean isVisible(TreeTableNode node) {
        if (node == null) {
            return true;
        }
        List npath = node.getNodePath();
        if (npath == null) {
            return true;
        }
        int level = npath.size();
        if (level == 0) {
            return true;
        }
        if (level == 1) {
            return true;
        }
        if (!this.isRootVisible() && level == 2) {
            return true;
        }
        npath.remove(npath.size() - 1);
        int ito = this.isRootVisible() ? 0 : 1;
        for (int i = npath.size() - 1; i >= ito; --i) {
            TreeTableNode n;
            boolean exp;
            Object o_n = npath.get(i);
            if (!(o_n instanceof TreeTableNode) || (exp = (n = (TreeTableNode)o_n).isExpanded())) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized TreeTableNode getNodeOf(int row) {
        int directRow = this.mapRowToInside(row);
        if (directRow < 0) {
            return null;
        }
        return ((TreeTableModelInterface)this.getTableModel()).getNodeOf(directRow);
    }

    @Override
    public synchronized int getRowOf(TreeTableNode node) {
        if (node == null) {
            return -1;
        }
        if (this.root == null) {
            return -1;
        }
        int sortrow = ((TreeTableModelInterface)this.getTableModel()).getRowOf(node);
        if (sortrow < 0) {
            return -1;
        }
        int frow = this.mapRowToOutside(sortrow);
        return frow;
    }

    @Override
    public synchronized boolean isRootVisible() {
        return ((TreeTableModelInterface)this.getTableModel()).isRootVisible();
    }

    @Override
    public synchronized TreeTableNode getRoot() {
        if (this.root != null) {
            return this.root;
        }
        this.root = new TreeTableNodeBasic();
        return this.root;
    }

    @Override
    public synchronized void setRoot(TreeTableNode root) {
        ((TreeTableModelInterface)this.getTableModel()).setRoot(root);
        TreeTableNode old = this.getRoot();
        this.root = root;
        TreeTableNode newv = this.getRoot();
        TreeTableFilterModel.logFine("setRoot old={0} current={1}", old, newv);
        this.listenRoot();
        this.applyFilter();
    }

    protected synchronized void listenRoot() {
        TreeTableFilterModel.logFine("listenRoot", new Object[0]);
        TreeTableFilterModel.logFinest("rootListeners.closeAll", new Object[0]);
        this.rootListeners.closeAll();
        if (this.root == null) {
            return;
        }
        Closeable cl = null;
        cl = this.root.onTreeNodeEvent(TreeTableNodeCollapsed.class, new Reciver(){

            public void recive(Object e) {
                TreeTableNodeCollapsed ev = (TreeTableNodeCollapsed)((Object)e);
                TreeTableFilterModel.this.onTreeNodeCollapsed(ev);
            }
        });
        this.rootListeners.add(cl);
        cl = this.root.onTreeNodeEvent(TreeTableNodeExpanded.class, new Reciver(){

            public void recive(Object e) {
                TreeTableNodeExpanded ev = (TreeTableNodeExpanded)((Object)e);
                TreeTableFilterModel.this.onTreeNodeExpanded(ev);
            }
        });
        this.rootListeners.add(cl);
    }

    private void onTreeNodeExpanded(TreeTableNodeExpanded ev) {
        TreeNode ettn1 = ev == null ? null : ev.getSource();
        TreeTableNodeBasic ettn = (TreeTableNodeBasic)ettn1;
        Object ettnData = ettn == null ? null : ettn.getData();
        TreeTableFilterModel.logFine("onTreeNodeExpanded ev.source.data={0}", ettnData);
        if (this.source == null) {
            return;
        }
        TreeSet<Integer> includeRows = new TreeSet<Integer>();
        for (TreeWalk twnode : ev.getSource().tree()) {
            Integer di;
            TreeTableNode node = (TreeTableNode)twnode.currentNode();
            int si = ((TreeTableModelInterface)this.getTableModel()).getRowOf(node);
            if (si < 0 || (di = Integer.valueOf(this.source.indexOf((Comparable)Integer.valueOf(si)))) != null && di >= 0 || !this.isVisible(node)) continue;
            di = this.source.add((Comparable)Integer.valueOf(si));
            includeRows.add(di);
        }
        if (includeRows.isEmpty()) {
            return;
        }
        if (includeRows.size() == 1) {
            int di = (Integer)includeRows.first();
            this.fireRowsInserted(di, di);
            return;
        }
        ArrayList<int[]> ranges = new ArrayList<int[]>();
        int rangeStart = -1;
        int rangeEnd = -1;
        int diPrev = -1;
        int i = -1;
        Iterator iterator = includeRows.iterator();
        while (iterator.hasNext()) {
            int di = (Integer)iterator.next();
            if (++i == 0) {
                rangeStart = di;
            } else {
                int d = Math.abs(diPrev - di);
                if (d > 1) {
                    rangeEnd = diPrev;
                    ranges.add(new int[]{rangeStart, rangeEnd});
                }
                rangeStart = di;
            }
            diPrev = di;
        }
        ranges.add(new int[]{rangeStart, diPrev});
        for (int ri = 0; ri < ranges.size(); ++ri) {
            int[] range = (int[])ranges.get(ri);
            int rStart = range[0];
            int rEnd = range[1];
            int rFrom = Math.min(rStart, rEnd);
            int rTo = Math.max(rStart, rEnd);
            this.fireRowsInserted(rFrom, rTo);
        }
    }

    private void onTreeNodeCollapsed(TreeTableNodeCollapsed ev) {
        TreeNode ettn1 = ev == null ? null : ev.getSource();
        TreeTableNodeBasic ettn = (TreeTableNodeBasic)ettn1;
        Object ettnData = ettn == null ? null : ettn.getData();
        TreeTableFilterModel.logFine("onTreeNodeCollapsed ev.source.data={0}", ettnData);
        if (this.source == null) {
            return;
        }
        TreeSet<Integer> removedRows = new TreeSet<Integer>();
        for (TreeWalk twnode : ev.getSource().tree()) {
            Integer di;
            TreeTableNode node = (TreeTableNode)twnode.currentNode();
            int si = ((TreeTableModelInterface)this.getTableModel()).getRowOf(node);
            if (si < 0 || (di = Integer.valueOf(this.source.indexOf((Comparable)Integer.valueOf(si)))) == null || di < 0) continue;
            int lvl = Math.abs(twnode.currentLevel() - twnode.startLevel());
            if (lvl > 0) {
                this.source.removeByIndex(di.intValue());
                removedRows.add(di);
                continue;
            }
            if (this.isVisible(node)) continue;
            this.source.removeByIndex(di.intValue());
        }
        if (removedRows.isEmpty()) {
            return;
        }
        if (removedRows.size() == 1) {
            int di = (Integer)removedRows.first();
            this.fireRowsDeleted(di, di);
            return;
        }
        ArrayList<int[]> ranges = new ArrayList<int[]>();
        int rangeStart = -1;
        int rangeEnd = -1;
        int diPrev = -1;
        int i = -1;
        Iterator lvl = removedRows.iterator();
        while (lvl.hasNext()) {
            int di = (Integer)lvl.next();
            if (++i == 0) {
                rangeStart = di;
            } else {
                int d = Math.abs(diPrev - di);
                if (d > 1) {
                    rangeEnd = diPrev;
                    ranges.add(new int[]{rangeStart, rangeEnd});
                }
                rangeStart = di;
            }
            diPrev = di;
        }
        ranges.add(new int[]{rangeStart, diPrev});
        for (int ri = ranges.size() - 1; ri >= 0; --ri) {
            int[] range = (int[])ranges.get(ri);
            int rStart = range[0];
            int rEnd = range[1];
            int rFrom = Math.min(rStart, rEnd);
            int rTo = Math.max(rStart, rEnd);
            this.fireRowsDeleted(rFrom, rTo);
        }
    }
}

