/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.tree;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.TableColumn;
import xyz.cofe.collection.Func1;
import xyz.cofe.collection.Func2;
import xyz.cofe.collection.Func3;
import xyz.cofe.collection.NodesExtracter;
import xyz.cofe.collection.map.ClassMap;
import xyz.cofe.collection.tree.ClassNode;
import xyz.cofe.gui.swing.table.Column;
import xyz.cofe.gui.swing.tree.TreeTable;
import xyz.cofe.gui.swing.tree.TreeTableNode;
import xyz.cofe.gui.swing.tree.TreeTableNodeBasic;
import xyz.cofe.gui.swing.tree.TreeTableNodeFormat;
import xyz.cofe.gui.swing.tree.TreeTableNodeGetFormatOf;
import xyz.cofe.gui.swing.tree.TreeTableNodeValueColumn;
import xyz.cofe.gui.swing.tree.TreeTableNodeValueEditor;

public class TreeTableHelper {
    private static final Logger logger = Logger.getLogger(TreeTableHelper.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    public final TreeTable treeTable;
    protected final NodesConf nodes = new NodesConf();
    protected DataColumnsConf columns = new DataColumnsConf();

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(TreeTableHelper.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(TreeTableHelper.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(TreeTableHelper.class.getName(), method, result);
    }

    public TreeTableHelper(TreeTable treeTable) {
        if (treeTable == null) {
            throw new IllegalArgumentException("treeTable==null");
        }
        this.treeTable = treeTable;
    }

    public RootConf root(Object root) {
        RootConf rc = new RootConf();
        rc.root = root;
        return rc;
    }

    public NodesConf nodes() {
        return this.nodes;
    }

    public <T> NodeConf<T> node(Class<T> cls) {
        if (cls == null) {
            throw new IllegalArgumentException("cls==null");
        }
        return new NodeConf<T>(cls);
    }

    public DataColumnsConf columns() {
        if (this.columns == null) {
            this.columns = new DataColumnsConf();
        }
        return this.columns;
    }

    public DataColumnConf column(String name) {
        return this.columns().column(name);
    }

    public TreeTableHelper apply() {
        this.nodes().apply();
        this.columns().apply();
        return this;
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }

    public class DataColumnsConf {
        protected Map<String, DataColumnConf> columns = new LinkedHashMap<String, DataColumnConf>();

        public Map<String, DataColumnConf> getColumns() {
            if (this.columns == null) {
                this.columns = new LinkedHashMap<String, DataColumnConf>();
            }
            return this.columns;
        }

        public void setColumns(Map<String, DataColumnConf> columns) {
            this.columns = columns;
        }

        public DataColumnConf column(String name) {
            if (name == null) {
                throw new IllegalArgumentException("name==null");
            }
            DataColumnConf dcc = this.columns.get(name);
            if (dcc == null) {
                dcc = new DataColumnConf();
                dcc.setName(name);
                dcc.setDataColumnsConf(this);
                this.columns.put(name, dcc);
            }
            return dcc;
        }

        public TreeTableHelper apply() {
            for (Map.Entry<String, DataColumnConf> en : this.getColumns().entrySet()) {
                String name = en.getKey();
                DataColumnConf dcc = en.getValue();
                if (name == null || dcc == null) continue;
                dcc.setName(name);
                dcc.setDataColumnsConf(this);
                dcc.apply();
            }
            return TreeTableHelper.this;
        }
    }

    public class DataColumnConf {
        protected Column dataColumn;
        protected TableColumn tableColumn;
        protected String name;
        protected boolean addDataColumnIfNotExists = true;
        protected boolean addTableColumnIfNotExists = true;
        protected DataColumnsConf dataColumnsConf = null;
        protected ClassMap<Object> valueReaders = new ClassMap();
        protected ClassMap<Object> valueWriters = new ClassMap();
        protected ClassMap<Object> valueType = new ClassMap();
        protected ClassMap<Object> valueFormat = new ClassMap();
        protected ClassMap<Object> customPainter = new ClassMap();
        protected ClassMap<Object> valueEditor = new ClassMap();

        public Column getDataColumn() {
            return this.dataColumn;
        }

        public void setDataColumn(Column dataColumn) {
            this.dataColumn = dataColumn;
        }

        public TableColumn getTableColumn() {
            return this.tableColumn;
        }

        public void setTableColumn(TableColumn tableColumn) {
            this.tableColumn = tableColumn;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isAddDataColumnIfNotExists() {
            return this.addDataColumnIfNotExists;
        }

        public void setAddDataColumnIfNotExists(boolean addDataColumnIfNotExists) {
            this.addDataColumnIfNotExists = addDataColumnIfNotExists;
        }

        public boolean isAddTableColumnIfNotExists() {
            return this.addTableColumnIfNotExists;
        }

        public void setAddTableColumnIfNotExists(boolean addTableColumnIfNotExists) {
            this.addTableColumnIfNotExists = addTableColumnIfNotExists;
        }

        public DataColumnsConf getDataColumnsConf() {
            return this.dataColumnsConf;
        }

        public void setDataColumnsConf(DataColumnsConf dataColumnsConf) {
            this.dataColumnsConf = dataColumnsConf;
        }

        public ClassMap<Object> getValueReaders() {
            if (this.valueReaders == null) {
                this.valueReaders = new ClassMap();
            }
            return this.valueReaders;
        }

        public ClassMap<Object> getValueWriters() {
            if (this.valueWriters == null) {
                this.valueWriters = new ClassMap();
            }
            return this.valueWriters;
        }

        public ClassMap<Object> getValueType() {
            if (this.valueType == null) {
                this.valueType = new ClassMap();
            }
            return this.valueType;
        }

        public ClassMap<Object> getValueFormat() {
            if (this.valueFormat == null) {
                this.valueFormat = new ClassMap();
            }
            return this.valueFormat;
        }

        public ClassMap<Object> getCustomPaintert() {
            if (this.customPainter == null) {
                this.customPainter = new ClassMap();
            }
            return this.customPainter;
        }

        public ClassMap<Object> getValueEditor() {
            if (this.valueEditor == null) {
                this.valueEditor = new ClassMap();
            }
            return this.valueEditor;
        }

        protected TableColumn getTableColumnOf(Column col) {
            if (col == null) {
                return null;
            }
            int idx = TreeTableHelper.this.treeTable.getDataTreeColumns().indexOf(col);
            if (idx < 0) {
                return null;
            }
            for (int ci = 0; ci < TreeTableHelper.this.treeTable.getColumnModel().getColumnCount(); ++ci) {
                TableColumn tc = TreeTableHelper.this.treeTable.getColumnModel().getColumn(ci);
                if (tc == null || tc.getModelIndex() != idx) continue;
                return tc;
            }
            return null;
        }

        protected TreeTableNodeValueColumn getNodeValueColumn() {
            if (this.dataColumn instanceof TreeTableNodeValueColumn) {
                return (TreeTableNodeValueColumn)this.dataColumn;
            }
            if (this.dataColumn != null) {
                throw new Error("can't fetch TreeTableNodeValueColumn from exists " + this.dataColumn.getClass());
            }
            if (this.name != null) {
                TreeTableNodeValueColumn ttnvc = this.getNodeValueColumnByName(this.name);
                TableColumn tc = this.getTableColumnOf(ttnvc);
                if (tc == null && ttnvc != null && this.addTableColumnIfNotExists) {
                    int mi = TreeTableHelper.this.treeTable.getDataTreeColumns().size() - 1;
                    tc = new TableColumn(mi);
                    String tcHeaderVal = ttnvc.getName();
                    if (tcHeaderVal == null) {
                        tcHeaderVal = "column#" + mi;
                    }
                    tc.setHeaderValue(tcHeaderVal);
                    TreeTableHelper.this.treeTable.getColumnModel().addColumn(tc);
                    this.tableColumn = tc;
                }
                return ttnvc;
            }
            return null;
        }

        protected TreeTableNodeValueColumn getNodeValueColumnByName(String name) {
            if (name == null) {
                return null;
            }
            Iterator iterator = TreeTableHelper.this.treeTable.getDataTreeColumns().iterator();
            while (iterator.hasNext()) {
                String ename;
                Column col = (Column)iterator.next();
                if (col == null || !name.equals(ename = col.getName()) || !(col instanceof TreeTableNodeValueColumn)) continue;
                return (TreeTableNodeValueColumn)col;
            }
            if (this.addDataColumnIfNotExists) {
                TreeTableNodeValueColumn col = new TreeTableNodeValueColumn();
                col.name(name);
                this.dataColumn = col;
                TreeTableHelper.this.treeTable.getDataTreeColumns().add(col);
                TableColumn tc = this.getTableColumnOf(col);
                if (tc == null && this.addTableColumnIfNotExists) {
                    int mi = TreeTableHelper.this.treeTable.getDataTreeColumns().size() - 1;
                    tc = new TableColumn(mi);
                    String tcHeaderVal = col.getName();
                    if (tcHeaderVal == null) {
                        tcHeaderVal = "column#" + mi;
                    }
                    tc.setHeaderValue(tcHeaderVal);
                    TreeTableHelper.this.treeTable.getColumnModel().addColumn(tc);
                }
                return col;
            }
            return null;
        }

        public <T> DataColumnConf reader(Class<T> cls, Func1<Object, T> reader) {
            if (cls == null) {
                throw new IllegalArgumentException("cls==null");
            }
            if (reader == null) {
                throw new IllegalArgumentException("reader==null");
            }
            this.getValueReaders().put(cls, reader);
            return this;
        }

        public <T> DataColumnConf writer(Class<T> cls, Func3<Object, TreeTableNode, T, Object> writer) {
            if (cls == null) {
                throw new IllegalArgumentException("cls==null");
            }
            if (writer == null) {
                throw new IllegalArgumentException("reader==null");
            }
            this.getValueWriters().put(cls, writer);
            return this;
        }

        public <T> DataColumnConf writer(Class<T> cls, Func2<Object, T, Object> writer) {
            if (cls == null) {
                throw new IllegalArgumentException("cls==null");
            }
            if (writer == null) {
                throw new IllegalArgumentException("reader==null");
            }
            this.getValueWriters().put(cls, writer);
            return this;
        }

        public <T> DataColumnConf type(Class<T> cls, Func2<Class, T, TreeTableNode> valueTyp) {
            if (cls == null) {
                throw new IllegalArgumentException("cls==null");
            }
            if (valueTyp == null) {
                throw new IllegalArgumentException("valueTyp==null");
            }
            this.getValueType().put(cls, valueTyp);
            return this;
        }

        public <T> DataColumnConf format(Class<T> cls, Func2<TreeTableNodeFormat, T, TreeTableNode> valueFormat) {
            if (cls == null) {
                throw new IllegalArgumentException("cls==null");
            }
            if (valueFormat == null) {
                throw new IllegalArgumentException("valueTyp==null");
            }
            this.getValueFormat().put(cls, valueFormat);
            return this;
        }

        public <T> DataColumnConf format(Class<T> cls, Func1<TreeTableNodeFormat, T> valueFormat) {
            if (cls == null) {
                throw new IllegalArgumentException("cls==null");
            }
            if (valueFormat == null) {
                throw new IllegalArgumentException("valueTyp==null");
            }
            this.getValueFormat().put(cls, valueFormat);
            return this;
        }

        public <T> DataColumnConf painter(Class<T> cls, Func1<Func2<Object, Graphics, Rectangle>, T> customPainter) {
            if (cls == null) {
                throw new IllegalArgumentException("cls==null");
            }
            if (customPainter == null) {
                throw new IllegalArgumentException("valueTyp==null");
            }
            this.getCustomPaintert().put(cls, customPainter);
            return this;
        }

        public <T> DataColumnConf painter(Class<T> cls, Func2<Func2<Object, Graphics, Rectangle>, T, TreeTableNode> customPainter) {
            if (cls == null) {
                throw new IllegalArgumentException("cls==null");
            }
            if (customPainter == null) {
                throw new IllegalArgumentException("valueTyp==null");
            }
            this.getCustomPaintert().put(cls, customPainter);
            return this;
        }

        public <T> DataColumnConf editor(Class<T> cls, Func2<TreeTableNodeValueEditor.Editor, Object, TreeTableNode> customEditor) {
            if (cls == null) {
                throw new IllegalArgumentException("cls==null");
            }
            if (customEditor == null) {
                throw new IllegalArgumentException("valueTyp==null");
            }
            this.getValueEditor().put(cls, customEditor);
            return this;
        }

        public <T> DataColumnConf editor(Class<T> cls, Func1<TreeTableNodeValueEditor.Editor, T> customEditor) {
            if (cls == null) {
                throw new IllegalArgumentException("cls==null");
            }
            if (customEditor == null) {
                throw new IllegalArgumentException("valueTyp==null");
            }
            this.getValueEditor().put(cls, customEditor);
            return this;
        }

        public DataColumnsConf apply() {
            TreeTableNodeValueColumn ttnvc;
            ClassMap<Object> veditor;
            TreeTableNodeValueColumn ttnvc2;
            ClassMap<Object> vcustomPainter;
            TreeTableNodeValueColumn ttnvc3;
            ClassMap<Object> vformat;
            TreeTableNodeValueColumn ttnvc4;
            ClassMap<Object> vtype;
            TreeTableNodeValueColumn ttnvc5;
            ClassMap<Object> vwriters;
            TreeTableNodeValueColumn ttnvc6;
            ClassMap<Object> vreaders = this.getValueReaders();
            if (vreaders.size() > 0 && (ttnvc6 = this.getNodeValueColumn()) != null) {
                for (Object en : vreaders.entrySet()) {
                    Class cls = (Class)en.getKey();
                    Object rd = en.getValue();
                    if (cls != null && rd != null && rd instanceof Func1) {
                        ttnvc6.addValueReader(cls, (Func1)rd);
                        continue;
                    }
                    if (cls == null || rd == null || !(rd instanceof Func2)) continue;
                    ttnvc6.addValueReader(cls, (Func2)rd);
                }
            }
            if ((vwriters = this.getValueWriters()).size() > 0 && (ttnvc5 = this.getNodeValueColumn()) != null) {
                for (Object en : vwriters.entrySet()) {
                    Class cls = (Class)en.getKey();
                    Object wd = en.getValue();
                    if (cls != null && wd != null && wd instanceof Func2) {
                        ttnvc5.addValueWriter(cls, (Func2)wd);
                        continue;
                    }
                    if (cls == null || wd == null || !(wd instanceof Func3)) continue;
                    ttnvc5.addValueWriter(cls, (Func3)wd);
                }
            }
            if ((vtype = this.getValueType()).size() > 0 && (ttnvc4 = this.getNodeValueColumn()) != null) {
                for (Object en : vtype.entrySet()) {
                    Class cls = (Class)en.getKey();
                    Object vt = en.getValue();
                    if (cls == null || vt == null || !(vt instanceof Func2)) continue;
                    Func2 fn = (Func2)vt;
                    ttnvc4.addValueType(cls, (Func2<Class, Object, TreeTableNode>)fn);
                }
            }
            if ((vformat = this.getValueFormat()).size() > 0 && (ttnvc3 = this.getNodeValueColumn()) != null) {
                for (Object en : vformat.entrySet()) {
                    Func2 fn;
                    Class cls = (Class)en.getKey();
                    Object vf = en.getValue();
                    if (cls != null && vf != null && vf instanceof Func2) {
                        fn = (Func2)vf;
                        ttnvc3.addValueFormat(cls, fn);
                        continue;
                    }
                    if (cls == null || vf == null || !(vf instanceof Func1)) continue;
                    fn = (Func1)vf;
                    ttnvc3.addValueFormat(cls, fn);
                }
            }
            if ((vcustomPainter = this.getCustomPaintert()).size() > 0 && (ttnvc2 = this.getNodeValueColumn()) != null) {
                for (Map.Entry en : vcustomPainter.entrySet()) {
                    Func2 fn;
                    Class cls = (Class)en.getKey();
                    Object vf = en.getValue();
                    if (cls != null && vf != null && vf instanceof Func2) {
                        fn = (Func2)vf;
                        ttnvc2.addCustomPainter(cls, fn);
                        continue;
                    }
                    if (cls == null || vf == null || !(vf instanceof Func1)) continue;
                    fn = (Func1)vf;
                    ttnvc2.addCustomPainter(cls, fn);
                }
            }
            if ((veditor = this.getValueEditor()).size() > 0 && (ttnvc = this.getNodeValueColumn()) != null) {
                for (Map.Entry en : veditor.entrySet()) {
                    Func2 fn;
                    Class cls = (Class)en.getKey();
                    Object vf = en.getValue();
                    if (cls != null && vf != null && vf instanceof Func2) {
                        fn = (Func2)vf;
                        ttnvc.addValueEditor(cls, fn);
                        continue;
                    }
                    if (cls == null || vf == null || !(vf instanceof Func1)) continue;
                    fn = (Func1)vf;
                    ttnvc.addValueEditor(cls, fn);
                }
            }
            return this.dataColumnsConf;
        }
    }

    public class NodeConf<T> {
        protected Class nodeClass = null;
        protected List<NodeColumnConf<T>> columnsConfig = new LinkedList<NodeColumnConf<T>>();

        public Class getNodeClass() {
            return this.nodeClass;
        }

        public void setNodeClass(Class nodeClass) {
            this.nodeClass = nodeClass;
        }

        public NodeConf(Class<T> cls) {
            if (cls == null) {
                throw new IllegalArgumentException("cls==null");
            }
            this.nodeClass = cls;
        }

        public NodeConf<T> follow(NodesExtracter<T, ? super T> follower) {
            if (follower == null) {
                throw new IllegalArgumentException("follower==null");
            }
            TreeTableHelper.this.nodes().follow(this.nodeClass, follower);
            return this;
        }

        public NodeConf<T> followable(Func1<Boolean, T> followable) {
            if (followable == null) {
                throw new IllegalArgumentException("followable==null");
            }
            TreeTableHelper.this.nodes().followable(this.nodeClass, followable);
            return this;
        }

        public NodeConf<T> naming(Func1<String, T> naming) {
            if (naming == null) {
                throw new IllegalArgumentException("naming==null");
            }
            TreeTableHelper.this.nodes().naming(this.nodeClass, naming);
            return this;
        }

        public NodeColumnConf<T> column(String name) {
            if (name == null) {
                throw new IllegalArgumentException("name==null");
            }
            NodeColumnConf ncc = new NodeColumnConf(this.nodeClass, this, name);
            return ncc;
        }

        public TreeTableHelper apply() {
            TreeTableHelper.this.nodes().apply();
            return TreeTableHelper.this;
        }

        public TreeTableHelper apply(TreeTableNodeBasic node) {
            if (node == null) {
                throw new IllegalArgumentException("node==null");
            }
            TreeTableHelper.this.nodes().applyTo(node);
            return TreeTableHelper.this;
        }
    }

    public class NodeColumnConf<T> {
        protected Class nodeClass = null;
        protected NodeConf<T> nodeConf;
        protected String name = null;

        public Class getNodeClass() {
            return this.nodeClass;
        }

        public void setNodeClass(Class nodeClass) {
            this.nodeClass = nodeClass;
        }

        public NodeConf<T> getNodeConf() {
            return this.nodeConf;
        }

        public void setNodeConf(NodeConf<T> nodeConf) {
            this.nodeConf = nodeConf;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public NodeColumnConf(Class<T> cls, NodeConf<T> nodeConf, String column) {
            if (cls == null) {
                throw new IllegalArgumentException("cls==null");
            }
            if (nodeConf == null) {
                throw new IllegalArgumentException("nodeConf==null");
            }
            if (column == null) {
                throw new IllegalArgumentException("column==null");
            }
            this.nodeClass = cls;
            this.nodeConf = nodeConf;
            this.name = column;
        }

        public NodeColumnConf<T> reader(Func1<Object, T> reader) {
            if (reader == null) {
                throw new IllegalArgumentException("reader==null");
            }
            TreeTableHelper.this.column(this.name).reader(this.nodeClass, reader);
            return this;
        }

        public NodeColumnConf<T> writer(Func2<Object, T, Object> writer) {
            if (writer == null) {
                throw new IllegalArgumentException("writer==null");
            }
            TreeTableHelper.this.column(this.name).writer(this.nodeClass, writer);
            return this;
        }

        public NodeColumnConf<T> type(Func2<Class, T, TreeTableNode> valueType) {
            if (valueType == null) {
                throw new IllegalArgumentException("valueType==null");
            }
            TreeTableHelper.this.column(this.name).type(this.nodeClass, valueType);
            return this;
        }

        public NodeColumnConf<T> format(Func2<TreeTableNodeFormat, T, TreeTableNode> valueFormat) {
            if (valueFormat == null) {
                throw new IllegalArgumentException("valueFormat==null");
            }
            TreeTableHelper.this.column(this.name).format(this.nodeClass, valueFormat);
            return this;
        }

        public NodeColumnConf<T> painter(Func1<Func2<Object, Graphics, Rectangle>, T> customPainter) {
            if (customPainter == null) {
                throw new IllegalArgumentException("valueFormat==null");
            }
            TreeTableHelper.this.column(this.name).painter(this.nodeClass, customPainter);
            return this;
        }

        public NodeColumnConf<T> painter(Func2<Func2<Object, Graphics, Rectangle>, T, TreeTableNode> customPainter) {
            if (customPainter == null) {
                throw new IllegalArgumentException("valueFormat==null");
            }
            TreeTableHelper.this.column(this.name).painter(this.nodeClass, customPainter);
            return this;
        }

        public NodeColumnConf<T> editor(Func1<TreeTableNodeValueEditor.Editor, T> customEditor) {
            if (customEditor == null) {
                throw new IllegalArgumentException("customEditor==null");
            }
            TreeTableHelper.this.column(this.name).editor(this.nodeClass, customEditor);
            return this;
        }

        public NodeColumnConf<T> editor(Func2<TreeTableNodeValueEditor.Editor, T, TreeTableNode> customEditor) {
            if (customEditor == null) {
                throw new IllegalArgumentException("customEditor==null");
            }
            TreeTableHelper.this.column(this.name).editor(this.nodeClass, customEditor);
            return this;
        }

        public NodeColumnConf<T> column(String name) {
            if (name == null) {
                throw new IllegalArgumentException("name==null");
            }
            NodeColumnConf<T> ncc = new NodeColumnConf<T>(this.nodeClass, this.nodeConf, name);
            return ncc;
        }

        public NodeConf<T> apply() {
            if (this.nodeConf != null) {
                this.nodeConf.apply();
            }
            TreeTableHelper.this.columns().apply();
            return this.nodeConf;
        }
    }

    public class NodesConf {
        protected ClassMap<Func1<Boolean, Object>> followable = new ClassMap();
        protected ClassNode followers = new ClassNode();
        protected Long cacheLifeTime = null;
        protected ClassMap<Func1<TreeTableNodeFormat, Object>> formats = new ClassMap();
        protected ClassMap<Func1<String, Object>> names = new ClassMap();
        protected String nullName = "?null";

        public <T> NodesConf follow(Class<T> cls, NodesExtracter<T, ?> follower) {
            if (cls == null) {
                throw new IllegalArgumentException("cls==null");
            }
            if (follower == null) {
                throw new IllegalArgumentException("follower==null");
            }
            this.followers.adds(cls, new NodesExtracter[]{follower});
            return this;
        }

        public <T> NodesConf followable(Class<T> cls, Func1<Boolean, T> followable) {
            if (cls == null) {
                throw new IllegalArgumentException("cls==null");
            }
            if (followable == null) {
                throw new IllegalArgumentException("followable==null");
            }
            this.followable.put(cls, followable);
            return this;
        }

        public NodesConf cacheLifeTime(Long clifeTime) {
            this.cacheLifeTime = clifeTime;
            return this;
        }

        public NodesConf cacheLifeTime(int clifeTime) {
            this.cacheLifeTime = clifeTime;
            return this;
        }

        public NodesConf applyFollowers() {
            TreeTableNodeBasic troot = TreeTableHelper.this.treeTable.getRoot();
            if (troot == null) {
                troot = new TreeTableNodeBasic(null);
                TreeTableHelper.this.treeTable.setRoot(troot);
            }
            return this.applyFollowersTo(troot);
        }

        public NodesConf applyFollowersTo(TreeTableNodeBasic node) {
            if (node == null) {
                throw new IllegalArgumentException("node==null");
            }
            final ClassNode cfollowers = this.followers.clone();
            final ClassMap cextr = new ClassMap();
            cextr.putAll(this.followable);
            node.setDataFollower((NodesExtracter<Object, Object>)cfollowers);
            Func1<Boolean, Object> defExtractable = new Func1<Boolean, Object>(){

                public Boolean apply(Object data) {
                    if (data == null) {
                        return false;
                    }
                    Func1 extrble = (Func1)cextr.fetch(data.getClass());
                    if (extrble != null) {
                        return (Boolean)extrble.apply(data);
                    }
                    NodesExtracter[] extrs = cfollowers.extractersOf(data.getClass());
                    return extrs != null && extrs.length >= 1;
                }
            };
            node.setDataFollowable(defExtractable);
            if (this.cacheLifeTime != null) {
                node.setCacheLifeTime(this.cacheLifeTime);
            }
            return this;
        }

        public NodesConf applyFormatsTo(TreeTableNodeBasic node) {
            if (node == null) {
                throw new IllegalArgumentException("node == null");
            }
            final ClassMap cmap = new ClassMap();
            cmap.putAll(this.formats);
            TreeTableNodeGetFormatOf formatter = new TreeTableNodeGetFormatOf(){

                @Override
                public TreeTableNodeFormat getTreeTableNodeFormatOf(Object nodeData) {
                    TreeTableNodeFormat nfmt;
                    Func1 ffmt;
                    if (nodeData != null && (ffmt = (Func1)cmap.fetch(nodeData.getClass())) != null && (nfmt = (TreeTableNodeFormat)ffmt.apply(nodeData)) == null) {
                        return nfmt;
                    }
                    return null;
                }
            };
            node.setDataFormatter(formatter);
            return this;
        }

        public <T> NodesConf naming(Class<T> cls, Func1<String, T> naming) {
            if (cls == null) {
                throw new IllegalArgumentException("cls==null");
            }
            if (naming == null) {
                throw new IllegalArgumentException("naming==null");
            }
            final Class<T> fcls = cls;
            final Func1<String, T> fnamingArg = naming;
            Func1<String, Object> fnaming = new Func1<String, Object>(){

                public String apply(Object arg) {
                    if (arg == null) {
                        return null;
                    }
                    if (fcls.isAssignableFrom(arg.getClass())) {
                        return (String)fnamingArg.apply(arg);
                    }
                    return null;
                }
            };
            this.names.put(fcls, (Object)fnaming);
            return this;
        }

        public NodesConf applyNaming() {
            TreeTableNodeBasic troot = TreeTableHelper.this.treeTable.getRoot();
            if (troot == null) {
                troot = new TreeTableNodeBasic(null);
                TreeTableHelper.this.treeTable.setRoot(troot);
            }
            return this.applyNamingTo(troot);
        }

        public NodesConf applyNamingTo(TreeTableNodeBasic node) {
            if (node == null) {
                throw new IllegalArgumentException("node == null");
            }
            final String fNullName = this.nullName;
            final ClassMap cmap = new ClassMap();
            cmap.putAll(this.names);
            node.setDataTextReader(new Func1<String, Object>(){

                public String apply(Object nodeData) {
                    if (nodeData != null) {
                        if (nodeData != null) {
                            Func1 fText = (Func1)cmap.fetch(nodeData.getClass());
                            if (fText != null) {
                                String ntext = (String)fText.apply(nodeData);
                                if (ntext == null) {
                                    return fNullName;
                                }
                                return ntext;
                            }
                            return nodeData.toString();
                        }
                        return fNullName;
                    }
                    return fNullName;
                }
            });
            return this;
        }

        public TreeTableHelper apply() {
            this.applyNaming();
            this.applyFollowers();
            return TreeTableHelper.this;
        }

        public TreeTableHelper applyTo(TreeTableNodeBasic node) {
            if (node == null) {
                throw new IllegalArgumentException("node==null");
            }
            this.applyNamingTo(node);
            this.applyFollowersTo(node);
            return TreeTableHelper.this;
        }
    }

    public class RootConf {
        public Object root;
        public Boolean visible;

        public RootConf set(Object root) {
            this.root = root;
            return this;
        }

        public RootConf visible(boolean v) {
            this.visible = v;
            return this;
        }

        public TreeTableHelper apply() {
            if (this.root != null) {
                TreeTableNodeBasic troot = TreeTableHelper.this.treeTable.getRoot();
                if (troot == null) {
                    troot = new TreeTableNodeBasic(this.root);
                    TreeTableHelper.this.treeTable.setRoot(troot);
                } else {
                    troot.setData(this.root);
                }
            }
            if (this.visible != null) {
                TreeTableHelper.this.treeTable.setRootVisible(this.visible);
            }
            return TreeTableHelper.this;
        }
    }
}

