/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.tree;

import java.io.Closeable;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import xyz.cofe.collection.Func1;
import xyz.cofe.common.CloseableSet;
import xyz.cofe.common.Reciver;
import xyz.cofe.gui.swing.table.Columns;
import xyz.cofe.gui.swing.table.EventSupport;
import xyz.cofe.gui.swing.table.FilterRowTM;
import xyz.cofe.gui.swing.table.TableModelEventDelegator;
import xyz.cofe.gui.swing.tree.TreeTableDirectModel;
import xyz.cofe.gui.swing.tree.TreeTableFilterModel;
import xyz.cofe.gui.swing.tree.TreeTableNode;
import xyz.cofe.gui.swing.tree.TreeTableNodeBasic;
import xyz.cofe.gui.swing.tree.TreeTableNodeCollapsed;
import xyz.cofe.gui.swing.tree.TreeTableNodeCollapsing;
import xyz.cofe.gui.swing.tree.TreeTableNodeExpanded;
import xyz.cofe.gui.swing.tree.TreeTableNodeExpanding;

public class TreeTableModel
implements TableModel {
    private static final Logger logger = Logger.getLogger(TreeTableModel.class.getName());
    protected TreeTableNode root;
    protected TreeTableDirectModel directModel;
    protected FilterRowTM filterModel;
    protected final EventSupport evsupport;
    protected final TableModelEventDelegator evdelegator;
    protected final CloseableSet rootListeners = new CloseableSet();

    private static boolean eq(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null && b != null) {
            return false;
        }
        if (a != null && b == null) {
            return false;
        }
        return a.equals(b);
    }

    private static Level logLevel() {
        return logger.getLevel();
    }

    private static boolean isLogSevere() {
        Level ll = TreeTableModel.logLevel();
        return ll == null ? true : ll.intValue() <= Level.SEVERE.intValue();
    }

    private static boolean isLogWarning() {
        Level ll = TreeTableModel.logLevel();
        return ll == null ? true : ll.intValue() <= Level.WARNING.intValue();
    }

    private static boolean isLogInfo() {
        Level ll = TreeTableModel.logLevel();
        return ll == null ? true : ll.intValue() <= Level.INFO.intValue();
    }

    private static boolean isLogFine() {
        Level ll = TreeTableModel.logLevel();
        return ll == null ? true : ll.intValue() <= Level.FINE.intValue();
    }

    private static boolean isLogFiner() {
        Level ll = TreeTableModel.logLevel();
        return ll == null ? false : ll.intValue() <= Level.FINER.intValue();
    }

    private static boolean isLogFinest() {
        Level ll = TreeTableModel.logLevel();
        return ll == null ? false : ll.intValue() <= Level.FINEST.intValue();
    }

    private static void logEntering(String method, Object ... args) {
        logger.entering(TreeTableModel.class.getName(), method, args);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(TreeTableModel.class.getName(), method, result);
    }

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public synchronized TreeTableNode getRoot() {
        if (this.root != null) {
            return this.root;
        }
        this.root = new TreeTableNodeBasic();
        return this.root;
    }

    public synchronized void setRoot(TreeTableNode root) {
        TreeTableNode old = this.getRoot();
        this.root = root;
        TreeTableNode newv = this.getRoot();
        this.listenRoot();
        this.getDirectModel().setRoot(newv);
        FilterRowTM fm = this.getFilterModel();
        if (fm instanceof TreeTableFilterModel) {
            ((TreeTableFilterModel)fm).setRoot(newv);
        }
        this.fireAllChanged();
    }

    public synchronized TreeTableDirectModel getDirectModel() {
        if (this.directModel != null) {
            return this.directModel;
        }
        this.directModel = new TreeTableDirectModel();
        this.directModel.setRootVisible(false);
        this.directModel.setRoot(this.getRoot());
        return this.directModel;
    }

    public synchronized FilterRowTM getFilterModel() {
        if (this.filterModel != null) {
            return this.filterModel;
        }
        this.filterModel = new TreeTableFilterModel(this.getDirectModel());
        return this.filterModel;
    }

    public void fireAllChanged() {
        this.evsupport.fireAllChanged();
    }

    public void fireColumnsChanged() {
        this.evsupport.fireColumnsChanged();
    }

    public void fireRowUpdated(int row) {
        this.evsupport.fireRowUpdated(row);
    }

    public void fireRowsUpdated(int rowIndexFrom, int toIndexInclude) {
        this.evsupport.fireRowsUpdated(rowIndexFrom, toIndexInclude);
    }

    public void fireCellChanged(int rowIndex, int columnIndex) {
        this.evsupport.fireCellChanged(rowIndex, columnIndex);
    }

    public void fireRowsInserted(int rowIndexFrom, int toIndexInclude) {
        this.evsupport.fireRowsInserted(rowIndexFrom, toIndexInclude);
    }

    public void fireRowsDeleted(int rowIndexFrom, int toIndexInclude) {
        this.evsupport.fireRowsDeleted(rowIndexFrom, toIndexInclude);
    }

    public void fireTableModelEvent(TableModelEvent e) {
        this.evsupport.fireTableModelEvent(e);
    }

    public boolean isNotifyInAwtThread() {
        return this.evsupport.isNotifyInAwtThread();
    }

    public void setNotifyInAwtThread(boolean notifyInAwtThread) {
        this.evsupport.setNotifyInAwtThread(notifyInAwtThread);
    }

    public boolean isAwtInvokeAndWait() {
        return this.evsupport.isAwtInvokeAndWait();
    }

    public void setAwtInvokeAndWait(boolean awtInvokeAndWait) {
        this.evsupport.setAwtInvokeAndWait(awtInvokeAndWait);
    }

    public Collection<TableModelListener> getListenersCollection() {
        return this.evsupport.getListenersCollection();
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.evsupport.addTableModelListener(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.evsupport.removeTableModelListener(l);
    }

    public TreeTableNode getNodeOf(int row) {
        int directRow = this.getFilterModel().mapRowToInside(row);
        if (directRow < 0) {
            return null;
        }
        return this.getDirectModel().getNodeOf(directRow);
    }

    public int getRowOf(TreeTableNode ttnode) {
        if (ttnode == null) {
            return -1;
        }
        int directRow = this.getDirectModel().getRowOf(ttnode);
        if (directRow < 0) {
            return -1;
        }
        int filterRow = this.getFilterModel().mapRowToOutside(directRow);
        if (filterRow < 0) {
            return -1;
        }
        return filterRow;
    }

    public synchronized Columns getColumns() {
        return this.getDirectModel().getColumns();
    }

    public TableModelEventDelegator getEventDelegator() {
        return this.evdelegator;
    }

    protected synchronized void listenRoot() {
        this.rootListeners.closeAll();
        if (this.root == null) {
            return;
        }
        Closeable cl = null;
        cl = this.root.onTreeNodeEvent(TreeTableNodeCollapsing.class, new Reciver(){

            public void recive(Object e) {
                TreeTableNodeCollapsing ev = (TreeTableNodeCollapsing)((Object)e);
            }
        });
        this.rootListeners.add(cl);
        cl = this.root.onTreeNodeEvent(TreeTableNodeCollapsed.class, new Reciver(){

            public void recive(Object e) {
                TreeTableNodeCollapsed ev = (TreeTableNodeCollapsed)((Object)e);
            }
        });
        this.rootListeners.add(cl);
        cl = this.root.onTreeNodeEvent(TreeTableNodeExpanding.class, new Reciver(){

            public void recive(Object e) {
                TreeTableNodeExpanding ev = (TreeTableNodeExpanding)((Object)e);
            }
        });
        this.rootListeners.add(cl);
        cl = this.root.onTreeNodeEvent(TreeTableNodeExpanded.class, new Reciver(){

            public void recive(Object e) {
                TreeTableNodeExpanded ev = (TreeTableNodeExpanded)((Object)e);
            }
        });
        this.rootListeners.add(cl);
    }

    public TreeTableModel() {
        this.evsupport = new EventSupport(this);
        this.evdelegator = new TableModelEventDelegator();
        this.evdelegator.setMapColumnToOutside(new Func1<Integer, Integer>(){

            public Integer apply(Integer arg) {
                return arg;
            }
        });
        this.evdelegator.setMapRowToOutside(new Func1<Integer, Integer>(){

            public Integer apply(Integer arg) {
                return arg;
            }
        });
        this.evdelegator.setSourceModel(this.getFilterModel());
        this.evdelegator.setTargetModel(this);
        this.evdelegator.setSender(new Reciver<TableModelEvent>(){

            public void recive(TableModelEvent ev) {
                TreeTableModel.this.evsupport.fireTableModelEvent(ev);
            }
        });
        this.evdelegator.start();
    }

    @Override
    public int getRowCount() {
        int rc = this.getFilterModel().getRowCount();
        return rc;
    }

    @Override
    public int getColumnCount() {
        int cc = this.getFilterModel().getColumnCount();
        return cc;
    }

    @Override
    public String getColumnName(int columnIndex) {
        String colname = this.getFilterModel().getColumnName(columnIndex);
        return colname;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        Class<?> c = this.getFilterModel().getColumnClass(columnIndex);
        return c;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        boolean ce = this.getFilterModel().isCellEditable(rowIndex, columnIndex);
        return ce;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object v = this.getFilterModel().getValueAt(rowIndex, columnIndex);
        return v;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.getFilterModel().setValueAt(aValue, rowIndex, columnIndex);
    }
}

