/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.tree;

import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.Func0;
import xyz.cofe.collection.Func1;
import xyz.cofe.collection.NodesExtracter;
import xyz.cofe.collection.list.BulkInsertEvent;
import xyz.cofe.collection.list.BulkInsertListener;
import xyz.cofe.collection.list.BulkInsertedEvent;
import xyz.cofe.collection.list.EventList;
import xyz.cofe.collection.list.EventListListener;
import xyz.cofe.collection.list.SimpleListAdapter;
import xyz.cofe.collection.tree.IndexTreeNode;
import xyz.cofe.collection.tree.TreeNode;
import xyz.cofe.collection.tree.TreeNodeAdded;
import xyz.cofe.collection.tree.TreeNodeBulkInserted;
import xyz.cofe.collection.tree.TreeNodeCacheDropped;
import xyz.cofe.collection.tree.TreeNodeEvent;
import xyz.cofe.collection.tree.TreeNodeFollowed;
import xyz.cofe.collection.tree.TreeNodeFollowing;
import xyz.cofe.collection.tree.TreeNodeRemoved;
import xyz.cofe.collection.tree.TreeNodeSetParent;
import xyz.cofe.collection.tree.TreeNodeUpdateParent;
import xyz.cofe.common.Reciver;
import xyz.cofe.gui.swing.tree.TreeNodesExtracter;
import xyz.cofe.gui.swing.tree.TreeTableDataChanged;
import xyz.cofe.gui.swing.tree.TreeTableNode;
import xyz.cofe.gui.swing.tree.TreeTableNodeCollapsed;
import xyz.cofe.gui.swing.tree.TreeTableNodeCollapsing;
import xyz.cofe.gui.swing.tree.TreeTableNodeDefs;
import xyz.cofe.gui.swing.tree.TreeTableNodeExpanded;
import xyz.cofe.gui.swing.tree.TreeTableNodeExpander;
import xyz.cofe.gui.swing.tree.TreeTableNodeExpanding;
import xyz.cofe.gui.swing.tree.TreeTableNodeFormat;
import xyz.cofe.gui.swing.tree.TreeTableNodeGetFormat;
import xyz.cofe.gui.swing.tree.TreeTableNodeGetFormatOf;
import xyz.cofe.gui.swing.tree.TreeTableNodeGetText;
import xyz.cofe.gui.swing.tree.impl.TreeTableNodeBasicImpl;

public class TreeTableNodeBasic
extends IndexTreeNode<TreeTableNodeBasic>
implements TreeTableNode<TreeTableNodeBasic>,
TreeTableNodeGetText,
TreeTableNodeGetFormat {
    private static final Logger logger = Logger.getLogger(TreeTableNodeBasic.class.getName());
    protected Object data = null;
    private int toStringCall = 0;
    protected Func1<String, Object> dataTextReader;
    protected TreeTableNodeGetFormatOf dataFormatter;
    protected NodesExtracter<Object, Object> dataFollower;
    protected Func1<Boolean, Object> dataFollowable;
    protected Date followStarted;
    protected Date followFinished;
    protected Long cacheLifeTime = null;
    protected WeakHashMap<TreeTableNode, Date> cachedNodes = new WeakHashMap();
    protected long rootScn = 0L;
    protected long childrenSCN = 0L;
    protected final ChildrenCollectionListener collectionNotifier = new ChildrenCollectionListener();
    private static final Map<String, Number> stat = new LinkedHashMap<String, Number>();
    protected int index;
    protected long indexParentStuctSCN;
    protected TreeTableNodeBasic prevSibling;
    protected long prevSiblingPSSCN;

    private static Level logLevel() {
        return logger.getLevel();
    }

    private static boolean isLogSevere() {
        Level ll = TreeTableNodeBasic.logLevel();
        return ll == null ? true : ll.intValue() <= Level.SEVERE.intValue();
    }

    private static boolean isLogWarning() {
        Level ll = TreeTableNodeBasic.logLevel();
        return ll == null ? true : ll.intValue() <= Level.WARNING.intValue();
    }

    private static boolean isLogInfo() {
        Level ll = TreeTableNodeBasic.logLevel();
        return ll == null ? true : ll.intValue() <= Level.INFO.intValue();
    }

    private static boolean isLogFine() {
        Level ll = TreeTableNodeBasic.logLevel();
        return ll == null ? true : ll.intValue() <= Level.FINE.intValue();
    }

    private static boolean isLogFiner() {
        Level ll = TreeTableNodeBasic.logLevel();
        return ll == null ? false : ll.intValue() <= Level.FINER.intValue();
    }

    private static boolean isLogFinest() {
        Level ll = TreeTableNodeBasic.logLevel();
        return ll == null ? false : ll.intValue() <= Level.FINEST.intValue();
    }

    private static void logEntering(String method, Object ... args) {
        logger.entering(TreeTableNodeBasic.class.getName(), method, args);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(TreeTableNodeBasic.class.getName(), method, result);
    }

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public TreeTableNodeBasic[] getChildren() {
        return (TreeTableNodeBasic[])this.syncrun(new Func0(){

            public Object apply() {
                return TreeTableNodeBasic.this.getChildrenList().toArray((Object[])new TreeTableNodeBasic[0]);
            }
        }, "getChildren", new Object[0]);
    }

    public TreeTableNodeBasic() {
    }

    public TreeTableNodeBasic(Object data) {
        this.setData(data);
    }

    public TreeTableNodeBasic(TreeTableNodeBasic sample, boolean withChildren, boolean preferred) {
        if (sample != null) {
            this.setData(sample.getData());
            this.setCacheLifeTime(preferred ? sample.getPreferredCacheLifeTime() : sample.getCacheLifeTime());
            this.setDataFollowable(preferred ? sample.getPreferredDataFollowable() : sample.getDataFollowable());
            this.setDataFollower(preferred ? sample.getPreferredDataFollower() : sample.getDataFollower());
            this.setDataTextReader(sample.getDataTextReader());
            this.setDataFormatter(preferred ? sample.getPreferredDataFormatter() : sample.getDataFormatter());
            LinkedHashMap<TreeTableNode, Date> sampleCached = new LinkedHashMap<TreeTableNode, Date>();
            sampleCached.putAll(sample.getCachedNodes());
            this.setFollowStarted(sample.getFollowStarted());
            this.setFollowStarted(sample.getFollowFinished());
            if (withChildren) {
                EventList sampleChildren = sample.getChildrenList();
                EventList children = this.getChildrenList();
                if (sampleChildren != null && !sampleChildren.isEmpty()) {
                    LinkedHashMap<TreeTableNodeBasic, TreeTableNodeBasic> clones = new LinkedHashMap<TreeTableNodeBasic, TreeTableNodeBasic>();
                    for (TreeTableNodeBasic treeTableNodeBasic : sampleChildren) {
                        if (treeTableNodeBasic == null) continue;
                        TreeTableNodeBasic child = treeTableNodeBasic.clone(withChildren, preferred);
                        clones.put(treeTableNodeBasic, child);
                        children.add(child);
                    }
                    for (Map.Entry entry : sampleCached.entrySet()) {
                        TreeTableNode child;
                        TreeTableNode schild = (TreeTableNode)entry.getKey();
                        Date d = (Date)entry.getValue();
                        if (schild == null || (child = (TreeTableNode)clones.get(schild)) == null) continue;
                        this.getCachedNodes().put(child, d);
                    }
                }
            }
            this.setExpanded(sample.isExpanded());
        }
    }

    public TreeTableNodeBasic clone() {
        TreeTableNodeBasic cloned = (TreeTableNodeBasic)this.syncrun(new Func0(){

            public Object apply() {
                return new TreeTableNodeBasic(TreeTableNodeBasic.this, true, false);
            }
        }, "clone", new Object[0]);
        return cloned;
    }

    public TreeTableNodeBasic clone(final boolean withChildren, final boolean preferred) {
        TreeTableNodeBasic cloned = (TreeTableNodeBasic)this.syncrun(new Func0(){

            public Object apply() {
                return new TreeTableNodeBasic(TreeTableNodeBasic.this, withChildren, preferred);
            }
        }, "clone", new Object[0]);
        return cloned;
    }

    @Override
    public Object getData() {
        return this.data;
    }

    @Override
    public void setData(Object v) {
        Object old = this.data;
        this.data = v;
        TreeTableDataChanged ev = new TreeTableDataChanged(this, old, v);
        this.popup(ev);
    }

    @Override
    public List<Object> getDataPath() {
        LinkedList<Object> ll = new LinkedList<Object>();
        for (TreeTableNodeBasic n : this.getNodePath()) {
            ll.add(n.getData());
        }
        return ll;
    }

    @Override
    public int getTreeLevel() {
        return this.getNodePath().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String toString() {
        try {
            ++this.toStringCall;
            if (this.toStringCall > 1) {
                String string = "";
                return string;
            }
            StringBuilder sb = new StringBuilder();
            Object d = this.getData();
            sb.append(this.getClass().getSimpleName()).append("{");
            sb.append("data=");
            if (d == null) {
                sb.append("null");
            } else {
                sb.append(d.toString());
            }
            sb.append("}");
            String string = sb.toString();
            return string;
        }
        finally {
            --this.toStringCall;
        }
    }

    public Func1<String, Object> getDataTextReader() {
        return this.dataTextReader;
    }

    public void setDataTextReader(Func1<String, Object> dataTextReader) {
        this.dataTextReader = dataTextReader;
    }

    public String getDataText() {
        Object data;
        Func1<String, Object> dataTextResolver = this.dataTextReader;
        if (dataTextResolver == null) {
            TreeTableNodeBasic n;
            List path = this.getNodePath();
            if (path != null && path.size() > 0) {
                path.remove(path.size() - 1);
            }
            for (int i = path.size() - 1; i >= 0 && (dataTextResolver = (n = (TreeTableNodeBasic)path.get(i)).getDataTextReader()) == null; --i) {
            }
        }
        if (dataTextResolver != null) {
            data = this.getData();
            String txt = (String)dataTextResolver.apply(data);
            if (txt == null && data != null) {
                return data.toString();
            }
            return txt;
        }
        data = this.getData();
        return data == null ? data.toString() : null;
    }

    @Override
    public String treeTableNodeGetText() {
        return this.getDataText();
    }

    public TreeTableNodeGetFormatOf getDataFormatter() {
        return this.dataFormatter;
    }

    public void setDataFormatter(TreeTableNodeGetFormatOf dataFormatter) {
        this.dataFormatter = dataFormatter;
    }

    public TreeTableNodeGetFormatOf getPreferredDataFormatter() {
        TreeTableNodeGetFormatOf formatter = this.dataFormatter;
        if (formatter == null) {
            TreeTableNodeBasic n;
            List path = this.getNodePath();
            if (path != null && path.size() > 0) {
                path.remove(path.size() - 1);
            }
            for (int i = path.size() - 1; i >= 0 && (formatter = (n = (TreeTableNodeBasic)path.get(i)).getDataFormatter()) == null; --i) {
            }
        }
        return formatter;
    }

    @Override
    public TreeTableNodeFormat getTreeTableNodeFormat() {
        Object data = this.getData();
        if (data == null) {
            return null;
        }
        TreeTableNodeGetFormatOf getFmt = this.getPreferredDataFormatter();
        if (getFmt == null) {
            return null;
        }
        return getFmt.getTreeTableNodeFormatOf(data);
    }

    public NodesExtracter<Object, Object> getDataFollower() {
        return this.dataFollower;
    }

    public void setDataFollower(NodesExtracter<Object, Object> dataFollower) {
        this.dataFollower = dataFollower;
    }

    public NodesExtracter<Object, Object> getPreferredDataFollower() {
        NodesExtracter<Object, Object> extracter = this.dataFollower;
        if (extracter == null) {
            TreeTableNodeBasic n;
            List path = this.getNodePath();
            if (path != null && path.size() > 0) {
                path.remove(path.size() - 1);
            }
            for (int i = path.size() - 1; i >= 0 && (extracter = (n = (TreeTableNodeBasic)path.get(i)).getDataFollower()) == null; --i) {
            }
        }
        return extracter;
    }

    public Iterable getFollowChildrenIterable() {
        NodesExtracter<Object, Object> ne = this.getPreferredDataFollower();
        Object data = this.getData();
        if (ne == null || data == null) {
            return null;
        }
        if (ne instanceof TreeNodesExtracter) {
            return ((TreeNodesExtracter)ne).extract(this);
        }
        return ne.extract(data);
    }

    public Func1<Boolean, Object> getDataFollowable() {
        return this.dataFollowable;
    }

    public void setDataFollowable(Func1<Boolean, Object> dataFollowable) {
        this.dataFollowable = dataFollowable;
    }

    public Func1<Boolean, Object> getPreferredDataFollowable() {
        Func1<Boolean, Object> extractable = this.dataFollowable;
        if (extractable == null) {
            TreeTableNodeBasic n;
            List path = this.getNodePath();
            if (path != null && path.size() > 0) {
                path.remove(path.size() - 1);
            }
            for (int i = path.size() - 1; i >= 0 && (extractable = (n = (TreeTableNodeBasic)path.get(i)).getDataFollowable()) == null; --i) {
            }
        }
        return extractable;
    }

    public Date getFollowStarted() {
        return this.followStarted;
    }

    public void setFollowStarted(Date followStarted) {
        this.followStarted = followStarted;
    }

    public Date getFollowFinished() {
        return this.followFinished;
    }

    public void setFollowFinished(Date followFinished) {
        this.followFinished = followFinished;
    }

    public Long getCacheLifeTime() {
        return this.cacheLifeTime;
    }

    public void setCacheLifeTime(Long cacheLifeTime) {
        this.cacheLifeTime = cacheLifeTime;
    }

    public Long getPreferredCacheLifeTime() {
        Long lifetime = -1L;
        List path = this.getNodePath();
        for (int i = path.size() - 1; i >= 0; --i) {
            TreeTableNodeBasic ttnb = (TreeTableNodeBasic)path.get(i);
            if (ttnb.cacheLifeTime == null) continue;
            lifetime = ttnb.cacheLifeTime;
            break;
        }
        return lifetime;
    }

    public Map<TreeTableNode, Date> getCachedNodes() {
        return this.cachedNodes;
    }

    protected void readFollowChildrenTo(Reciver<Object> childDataConsumer) {
        Iterable children = this.getFollowChildrenIterable();
        if (children != null) {
            int timeoutThreshold = TreeTableNodeBasicImpl.getUseExpanderThresholdTimeout();
            long tStart = System.currentTimeMillis();
            long tReadTotal = 0L;
            long tConsumeTotal = 0L;
            int readed = 0;
            Iterator iter = children.iterator();
            boolean createExpander = false;
            while (true) {
                long tRead0 = System.currentTimeMillis();
                boolean hnext = iter.hasNext();
                if (!hnext) break;
                long tCurrent = System.currentTimeMillis();
                long tDiff = Math.abs(tCurrent - tStart);
                if (timeoutThreshold > 0 && tDiff >= (long)timeoutThreshold) {
                    createExpander = true;
                    TreeTableNodeBasic.logFine("terminate readFollowChildrenTo by timeoutThreshold={0} timeout={1}", timeoutThreshold, tDiff);
                    break;
                }
                Object childData = iter.next();
                long tRead1 = System.currentTimeMillis();
                long tConsume0 = System.currentTimeMillis();
                childDataConsumer.recive(childData);
                long tConsume1 = System.currentTimeMillis();
                TreeTableNodeBasic.logFiner("node readed, total={0}, t.consume={1} {4} t.read1={2} {5}, t.*1={3} {6}", ++readed, Math.abs(tConsume1 - tConsume0), Math.abs(tRead0 - tRead1), Math.abs(tConsume1 - tConsume0) + Math.abs(tRead0 - tRead1), tConsumeTotal += Math.abs(tConsume1 - tConsume0), tReadTotal += Math.abs(tRead0 - tRead1), tConsumeTotal + tReadTotal);
            }
            if (createExpander) {
                TreeTableNodeBasic.logFine("create expander by timeoutThreshold={0}", timeoutThreshold);
                TreeTableNodeExpander expander = new TreeTableNodeExpander(iter);
                childDataConsumer.recive((Object)expander);
            }
        }
    }

    protected Reciver<Object> consumeChildData() {
        return new Reciver<Object>(){

            public void recive(Object childData) {
                TreeTableNodeBasic ttnb = null;
                ttnb = childData instanceof TreeTableNodeBasic ? (TreeTableNodeBasic)childData : new TreeTableNodeBasic(childData);
                TreeTableNodeBasic.this.appendChild(ttnb);
                TreeTableNodeBasic.this.cachedNodes.put(ttnb, new Date());
            }
        };
    }

    public void dropCache() {
        TreeNodeCacheDropped ev = new TreeNodeCacheDropped(this);
        AtomicInteger cnt = new AtomicInteger(0);
        for (TreeTableNode node : this.cachedNodes.keySet()) {
            if (node == null || !(node instanceof TreeTableNodeBasic)) continue;
            this.removeChild((TreeTableNodeBasic)node);
            cnt.addAndGet(((TreeTableNodeBasic)node).getNodesCount());
            ev.getDropped().add(node);
        }
        this.cachedNodes.clear();
        this.followFinished = null;
        this.followStarted = null;
        this.popup(ev);
        TreeTableNodeBasic.logFine("dropped {0} child nodes", cnt.get());
    }

    public void follow() {
        this.followStarted = new Date();
        Func1<Boolean, Object> extrSuppTester = this.getPreferredDataFollowable();
        if (extrSuppTester != null) {
            Object data = this.getData();
            if (((Boolean)extrSuppTester.apply(data)).booleanValue()) {
                this.popup(new TreeNodeFollowing(this));
                this.readFollowChildrenTo(this.consumeChildData());
                this.popup(new TreeNodeFollowed(this));
            }
        } else {
            this.popup(new TreeNodeFollowing(this));
            this.readFollowChildrenTo(this.consumeChildData());
            this.popup(new TreeNodeFollowed(this));
        }
        this.followFinished = new Date();
    }

    @Override
    public void expand() {
        boolean exp;
        Boolean old2;
        TreeTableNodeBasic prnt;
        TreeTableNodeExpanding ev1 = null;
        Boolean old1 = TreeTableNodeDefs.getExpandedOf(this);
        if (!Objects.equals(old1, true)) {
            ev1 = new TreeTableNodeExpanding(this);
            this.popup(ev1);
        }
        if ((prnt = (TreeTableNodeBasic)this.getParent()) != null) {
            prnt.expand();
        }
        if (this.followStarted == null) {
            this.follow();
        }
        if (!Objects.equals(old2 = TreeTableNodeDefs.setExpandedOf(this, exp = true), exp)) {
            TreeTableNodeExpanded ev2 = new TreeTableNodeExpanded(this, ev1);
            this.popup(ev2);
        }
    }

    @Override
    public void collapse() {
        long tdiff;
        Long lifet;
        if (this.followFinished != null && (lifet = this.getPreferredCacheLifeTime()) != null && lifet > 0L && (tdiff = Math.abs(this.followFinished.getTime() - System.currentTimeMillis())) > lifet) {
            this.dropCache();
            this.followFinished = null;
            this.followStarted = null;
        }
        TreeTableNodeCollapsing ev1 = null;
        Boolean old1 = TreeTableNodeDefs.getExpandedOf(this);
        if (!Objects.equals(old1, false)) {
            ev1 = new TreeTableNodeCollapsing(this);
            this.popup(ev1);
        }
        boolean exp = false;
        Boolean old2 = TreeTableNodeDefs.setExpandedOf(this, false);
        if (!Objects.equals(old2, exp)) {
            TreeTableNodeCollapsed ev2 = new TreeTableNodeCollapsed(this, ev1);
            this.popup(ev2);
        }
    }

    @Override
    public boolean isExpanded() {
        Boolean ex = TreeTableNodeDefs.getExpandedOf(this);
        if (ex == null) {
            return false;
        }
        return ex;
    }

    @Override
    public void setExpanded(boolean v) {
        Boolean old = TreeTableNodeDefs.setExpandedOf(this, v);
    }

    public long getRootScn() {
        TreeTableNodeBasic n = this;
        TreeTableNodeBasic np;
        while ((np = (TreeTableNodeBasic)n.parent) != null) {
            n = np;
        }
        return this.rootScn;
    }

    public void popup(TreeNodeEvent<TreeTableNodeBasic> ev) {
        TreeTableNodeBasic parent = (TreeTableNodeBasic)this.parent;
        if (parent == null && (ev instanceof TreeNodeAdded || ev instanceof TreeNodeRemoved || ev instanceof TreeNodeBulkInserted)) {
            ++this.rootScn;
        }
        super.popup(ev);
    }

    public long getChildrenSCN() {
        return (Long)this.syncrun(new Func0(){

            public Object apply() {
                return TreeTableNodeBasic.this.childrenSCN;
            }
        }, "getStructSCN", new Object[0]);
    }

    protected void attachListeners(final EventList<TreeTableNodeBasic> elist) {
        this.syncrun(new Func0(){

            public Object apply() {
                if (elist != null) {
                    elist.addEventListListener((EventListListener)TreeTableNodeBasic.this.collectionNotifier, true);
                }
                return null;
            }
        }, "attachListeners", new Object[]{elist});
    }

    public void onTreeBulkInserted(final Integer index, final List<TreeTableNodeBasic> insertedChildren) {
        this.syncrun(new Func0(){

            public Object apply() {
                ++TreeTableNodeBasic.this.childrenSCN;
                TreeTableNodeBasic.this.resetNodesCount();
                for (TreeTableNodeBasic child : insertedChildren) {
                    if (!(child instanceof TreeNodeSetParent)) continue;
                    TreeTableNodeBasic tn = child;
                    tn.setParent(TreeTableNodeBasic.this);
                }
                EventList clist = TreeTableNodeBasic.this.childrenList;
                int ichild = -1;
                for (TreeTableNodeBasic child : insertedChildren) {
                    TreeTableNodeBasic prevChild;
                    int childIndex = index + ++ichild;
                    if (clist == null || child == null) continue;
                    child.updateIndex(childIndex, TreeTableNodeBasic.this.childrenSCN);
                    TreeTableNodeBasic nextChild = childIndex < clist.size() - 1 ? (TreeTableNodeBasic)clist.get(childIndex + 1) : null;
                    child.prevSibling = prevChild = childIndex > 0 ? (TreeTableNodeBasic)clist.get(childIndex - 1) : null;
                    child.prevSiblingPSSCN = TreeTableNodeBasic.this.childrenSCN;
                    if (nextChild == null) continue;
                    nextChild.prevSibling = child;
                    nextChild.prevSiblingPSSCN = TreeTableNodeBasic.this.childrenSCN;
                }
                TreeNodeBulkInserted<TreeTableNodeBasic> ev = new TreeNodeBulkInserted<TreeTableNodeBasic>(TreeTableNodeBasic.this, TreeTableNodeBasic.this, index, insertedChildren);
                ev.getPopupPath().add(TreeTableNodeBasic.this);
                TreeTableNodeBasic.this.popup((TreeNodeEvent<TreeTableNodeBasic>)ev);
                return null;
            }
        }, "onTreeBulkInserted", new Object[]{index, insertedChildren});
    }

    public void onTreeNodeAdded(final Integer index, final TreeTableNodeBasic child) {
        this.syncrun(new Func0(){

            public Object apply() {
                ++TreeTableNodeBasic.this.childrenSCN;
                EventList clist = TreeTableNodeBasic.this.childrenList;
                if (clist != null && child != null && index != null) {
                    TreeTableNodeBasic prevChild;
                    child.updateIndex(index, TreeTableNodeBasic.this.childrenSCN);
                    TreeTableNodeBasic nextChild = index < clist.size() - 1 ? (TreeTableNodeBasic)clist.get(index + 1) : null;
                    child.prevSibling = prevChild = index > 0 ? (TreeTableNodeBasic)clist.get(index - 1) : null;
                    child.prevSiblingPSSCN = TreeTableNodeBasic.this.childrenSCN;
                    if (nextChild != null) {
                        nextChild.prevSibling = child;
                        nextChild.prevSiblingPSSCN = TreeTableNodeBasic.this.childrenSCN;
                    }
                }
                TreeTableNodeBasic.this.resetNodesCount();
                if (child instanceof TreeNodeSetParent) {
                    TreeTableNodeBasic tn = child;
                    tn.setParent(TreeTableNodeBasic.this);
                }
                TreeNodeAdded ev = new TreeNodeAdded((TreeNode)TreeTableNodeBasic.this, (TreeNode)child, index);
                ev.getPopupPath().add(child);
                TreeTableNodeBasic.this.popup((TreeNodeEvent<TreeTableNodeBasic>)ev);
                return null;
            }
        }, "onTreeNodeAdded", new Object[]{index, child});
    }

    public void onTreeNodeRemoved(final Integer index, final TreeTableNodeBasic child) {
        this.syncrun(new Func0(){

            public Object apply() {
                ++TreeTableNodeBasic.this.childrenSCN;
                EventList clist = TreeTableNodeBasic.this.childrenList;
                if (clist != null && child != null && index != null) {
                    TreeTableNodeBasic nextChild = index + 1 < clist.size() && index + 1 >= 0 ? (TreeTableNodeBasic)clist.get(index + 1) : null;
                    TreeTableNodeBasic prevChild = index >= 0 && index < clist.size() ? (TreeTableNodeBasic)clist.get(index) : null;
                    child.prevSibling = null;
                    if (nextChild != null) {
                        nextChild.prevSibling = prevChild;
                        nextChild.prevSiblingPSSCN = TreeTableNodeBasic.this.childrenSCN;
                    }
                }
                TreeTableNodeBasic.this.resetNodesCount();
                if (child instanceof TreeNodeUpdateParent) {
                    child.updateParent(TreeTableNodeBasic.this, null);
                    child.updateIndex(-1, TreeTableNodeBasic.this.childrenSCN);
                }
                TreeNodeRemoved ev = new TreeNodeRemoved((TreeNode)TreeTableNodeBasic.this, (TreeNode)child, index);
                ev.getPopupPath().add(child);
                TreeTableNodeBasic.this.popup((TreeNodeEvent<TreeTableNodeBasic>)ev);
                return null;
            }
        }, "onTreeNodeRemoved", new Object[]{index, child});
    }

    public static Map<String, Number> stat() {
        stat.clear();
        return stat;
    }

    protected void updateIndex(int idx, long psscn) {
        this.index = idx;
        this.indexParentStuctSCN = psscn;
    }

    public int getIndex() {
        TreeTableNodeBasic prnt = (TreeTableNodeBasic)this.getParent();
        if (prnt != null) {
            long pscn = prnt.getChildrenSCN();
            long cscn = this.indexParentStuctSCN;
            int idx = this.index;
            if (pscn == cscn && idx >= 0) {
                return idx;
            }
            this.index = TreeTableNodeBasic.getIndex(this);
            this.indexParentStuctSCN = pscn;
            return this.index;
        }
        return -1;
    }

    public static int getIndex(TreeTableNodeBasic thisNode) {
        if (thisNode == null) {
            throw new IllegalArgumentException("thisNode==null");
        }
        TreeNode parent = thisNode.getParent();
        if (parent == null) {
            return -1;
        }
        if (!(parent instanceof TreeNode)) {
            return -1;
        }
        TreeNode parentTN = parent;
        TreeNode[] siblings = parentTN.getChildren();
        if (siblings == null) {
            return -1;
        }
        int idx = -1;
        for (idx = 0; idx < siblings.length; ++idx) {
            TreeNode sibling = siblings[idx];
            if (sibling == null || sibling != thisNode) continue;
            return idx;
        }
        return -1;
    }

    public TreeTableNodeBasic getPreviousSibling() {
        TreeTableNodeBasic parent = (TreeTableNodeBasic)this.parent;
        if (parent == null) {
            return null;
        }
        if (parent.childrenSCN != this.prevSiblingPSSCN) {
            TreeTableNodeBasic sib;
            this.prevSibling = sib = this.getSibling(-1);
            this.prevSiblingPSSCN = parent.childrenSCN;
            return sib;
        }
        return this.prevSibling;
    }

    public TreeTableNodeBasic getSibling(int offset) {
        final TreeTableNodeBasic self = this;
        final int foffset = offset;
        return (TreeTableNodeBasic)this.syncrun(new Func0(){

            public Object apply() {
                Object o1 = TreeTableNodeBasic.getSibling(self, foffset);
                return (TreeTableNodeBasic)o1;
            }
        }, "getSibling", new Object[]{offset});
    }

    public static Object getSibling(TreeTableNodeBasic thisNode, int offset) {
        if (thisNode == null) {
            throw new IllegalArgumentException("thisNode==null");
        }
        if (offset == 0) {
            return thisNode;
        }
        TreeTableNodeBasic parent = (TreeTableNodeBasic)thisNode.getParent();
        if (parent == null) {
            return null;
        }
        EventList sibs = parent.getChildrenList();
        if (sibs == null || sibs.isEmpty()) {
            return null;
        }
        int sibIdx = -1;
        int thisIdx = -1;
        for (TreeTableNodeBasic sib : sibs) {
            ++sibIdx;
            if (sib == null || sib != thisNode) continue;
            thisIdx = sibIdx;
            break;
        }
        if (thisIdx < 0) {
            return null;
        }
        int targetIdx = thisIdx + offset;
        if (targetIdx < 0) {
            return null;
        }
        if (targetIdx < sibs.size()) {
            TreeTableNodeBasic target = (TreeTableNodeBasic)sibs.get(targetIdx);
            return target;
        }
        return null;
    }

    protected class ChildrenCollectionListener
    extends SimpleListAdapter<TreeTableNodeBasic>
    implements BulkInsertListener<TreeTableNodeBasic> {
        protected ChildrenCollectionListener() {
        }

        public void bulkInsertEvent(BulkInsertEvent<TreeTableNodeBasic> ev) {
            if (ev instanceof BulkInsertedEvent) {
                BulkInsertedEvent bev = (BulkInsertedEvent)ev;
                List itms = bev.getItems();
                int insIdx = bev.getInsertIndex();
                TreeTableNodeBasic.this.onTreeBulkInserted(insIdx, itms);
            }
        }

        protected void added(TreeTableNodeBasic e, EventList<TreeTableNodeBasic> list, Integer position) {
            TreeTableNodeBasic.this.onTreeNodeAdded(position, e);
        }

        protected void adding(TreeTableNodeBasic e, EventList<TreeTableNodeBasic> list, Integer position) {
            TreeTableNodeBasic.this.onTreeNodeAdding(position, e);
        }

        protected void removed(TreeTableNodeBasic e, EventList<TreeTableNodeBasic> list, Integer position) {
            TreeTableNodeBasic.this.onTreeNodeRemoved(position, e);
        }

        protected void removing(TreeTableNodeBasic e, EventList<TreeTableNodeBasic> list, Integer position) {
            TreeTableNodeBasic.this.onTreeNodeRemoving(position, e);
        }
    }
}

