/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.tree;

import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.list.BulkInsert;
import xyz.cofe.collection.list.EventList;
import xyz.cofe.gui.swing.tree.TreeTableExpanderFinish;
import xyz.cofe.gui.swing.tree.TreeTableNodeBasic;
import xyz.cofe.gui.swing.tree.impl.TreeTableNodeExpanderImpl;

public class TreeTableNodeExpander
extends TreeTableNodeBasic {
    private static final Logger logger = Logger.getLogger(TreeTableNodeExpander.class.getName());
    protected Iterable iterable;
    protected Iterator iterator;
    protected int totalReaded;
    protected long totalReadTime;
    protected int lastReaded;
    protected long lastReadTime;
    protected long lastInsertTime = 0L;
    protected long totalInsertTime = 0L;
    protected boolean removeOnFinish = TreeTableNodeExpanderImpl.isRemoveOnFinish();
    protected int insertEachCount = TreeTableNodeExpanderImpl.getInsertEachCount();
    protected long timeout = TreeTableNodeExpanderImpl.getTimeout();
    protected boolean cacheFetched = TreeTableNodeExpanderImpl.isCacheFetched();

    private static Level logLevel() {
        return logger.getLevel();
    }

    private static boolean isLogSevere() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.SEVERE.intValue();
    }

    private static boolean isLogWarning() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.WARNING.intValue();
    }

    private static boolean isLogInfo() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.INFO.intValue();
    }

    private static boolean isLogFine() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINE.intValue();
    }

    private static boolean isLogFiner() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINER.intValue();
    }

    private static boolean isLogFinest() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(TreeTableNodeExpander.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(TreeTableNodeExpander.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(TreeTableNodeExpander.class.getName(), method, result);
    }

    public TreeTableNodeExpander(Iterator iterator) {
        if (iterator == null) {
            throw new IllegalArgumentException("iterator == null");
        }
        this.iterable = null;
        this.iterator = iterator;
        this.totalReaded = 0;
        this.totalReadTime = 0L;
        this.lastReaded = 0;
        this.lastReadTime = 0L;
        TreeTableNodeExpander.logFine("created TreeTableNodeExpander with iterator", new Object[0]);
    }

    public TreeTableNodeExpander(Iterable iterable) {
        if (iterable == null) {
            throw new IllegalArgumentException("iterable == null");
        }
        this.iterable = iterable;
        this.iterator = iterable.iterator();
        this.totalReaded = 0;
        this.totalReadTime = 0L;
        this.lastReaded = 0;
        this.lastReadTime = 0L;
        TreeTableNodeExpander.logFine("created TreeTableNodeExpander with iterable", new Object[0]);
    }

    public Iterable getIterable() {
        return this.iterable;
    }

    public Iterator getIterator() {
        return this.iterator;
    }

    public int getTotalReaded() {
        return this.totalReaded;
    }

    public long getTotalReadTime() {
        return this.totalReadTime;
    }

    public int getLastReaded() {
        return this.lastReaded;
    }

    public long getLastReadTime() {
        return this.lastReadTime;
    }

    public long getLastInsertTime() {
        return this.lastInsertTime;
    }

    public long getTotalInsertTime() {
        return this.totalInsertTime;
    }

    public long getTotalTime() {
        return this.totalReadTime + this.totalInsertTime;
    }

    public boolean isRemoveOnFinish() {
        return this.removeOnFinish;
    }

    public void setRemoveOnFinish(boolean removeOnFinish) {
        this.removeOnFinish = removeOnFinish;
    }

    public boolean hasNext() {
        if (this.iterator == null) {
            return false;
        }
        return this.iterator.hasNext();
    }

    public TreeTableNodeBasic getTargetRecipient() {
        TreeTableNodeBasic prnt = (TreeTableNodeBasic)this.getParent();
        return prnt;
    }

    public int getTargetIndex() {
        int idx = this.getIndex();
        if (idx < 0) {
            return Integer.MAX_VALUE;
        }
        return idx;
    }

    public int getInsertEachCount() {
        return this.insertEachCount;
    }

    public void setInsertEachCount(int insertEachCount) {
        this.insertEachCount = insertEachCount;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public boolean isCacheFetched() {
        return this.cacheFetched;
    }

    public void setCacheFetched(boolean cacheFetched) {
        this.cacheFetched = cacheFetched;
    }

    public void fetch() {
        TreeTableNodeExpander.logFine("fetch begin", new Object[0]);
        this.fetch0();
        TreeTableNodeExpander.logFine("fetch end, readed={0} t.read={1}ms t.insert={2}", this.lastReaded, this.lastReadTime, this.lastInsertTime);
    }

    private void fetch0() {
        boolean insAtRead;
        long readFinish;
        long readStart;
        List<TreeTableNodeBasic> nodeList;
        EventList recipientList;
        boolean insertAtEnd;
        int trgtIdx;
        TreeTableNodeBasic recipient;
        block33: {
            this.lastReaded = 0;
            this.lastReadTime = 0L;
            this.lastInsertTime = 0L;
            Iterator itr = this.getIterator();
            if (itr == null) {
                return;
            }
            recipient = this.getTargetRecipient();
            if (recipient == null) {
                return;
            }
            trgtIdx = this.getTargetIndex();
            if (!itr.hasNext()) {
                this.readFinished();
                return;
            }
            insertAtEnd = false;
            recipientList = recipient.getChildrenList();
            insertAtEnd = trgtIdx >= recipientList.size();
            nodeList = this.createNodeList();
            readStart = System.currentTimeMillis();
            readFinish = System.currentTimeMillis();
            boolean tInterrupt = false;
            insAtRead = this.insertEachCount > 0;
            long timeoutStart = System.currentTimeMillis();
            while (true) {
                if (Thread.interrupted()) {
                    tInterrupt = true;
                    TreeTableNodeExpander.logFine("interrupt thread", new Object[0]);
                    break block33;
                }
                long timeoutCurrent = System.currentTimeMillis();
                long timeoutDiff = Math.abs(timeoutCurrent - timeoutStart);
                long timeoutVal = this.getTimeout();
                if (timeoutVal > 0L && timeoutDiff >= timeoutVal) {
                    TreeTableNodeExpander.logFine("interrupt by timeout={0}ms - now={1}ms", timeoutVal, timeoutDiff);
                    break block33;
                }
                if (!itr.hasNext()) break;
                Object fetched = itr.next();
                nodeList.add(this.createNode(fetched));
                if (!insAtRead) continue;
                int insEachN = this.getInsertEachCount();
                if (nodeList.isEmpty() || insEachN != 1 && nodeList.size() < insEachN) continue;
                readFinish = System.currentTimeMillis();
                this.lastReadTime += Math.abs(readStart - readFinish);
                readStart = readFinish;
                if (recipientList instanceof BulkInsert) {
                    if (insertAtEnd) {
                        int rsize = recipientList.size();
                        ((BulkInsert)recipientList).bulkInsert(rsize, nodeList);
                    } else {
                        ((BulkInsert)recipientList).bulkInsert(trgtIdx, nodeList);
                    }
                } else if (insertAtEnd) {
                    recipientList.addAll(nodeList);
                } else {
                    recipientList.addAll(trgtIdx, nodeList);
                }
                trgtIdx += nodeList.size();
                if (this.cacheFetched) {
                    for (TreeTableNodeBasic nb : nodeList) {
                        recipient.getCachedNodes().put(nb, new Date());
                    }
                }
                long tInserted = System.currentTimeMillis();
                this.lastInsertTime += Math.abs(readFinish - tInserted);
                this.lastReaded += nodeList.size();
                nodeList.clear();
            }
            this.readFinished();
        }
        readFinish = System.currentTimeMillis();
        if (!insAtRead) {
            if (!nodeList.isEmpty()) {
                if (recipientList instanceof BulkInsert) {
                    if (insertAtEnd) {
                        int rsize = recipientList.size();
                        ((BulkInsert)recipientList).bulkInsert(rsize, nodeList);
                    } else {
                        ((BulkInsert)recipientList).bulkInsert(trgtIdx, nodeList);
                    }
                } else if (insertAtEnd) {
                    recipientList.addAll(nodeList);
                } else {
                    recipientList.addAll(trgtIdx, nodeList);
                }
            }
            if (this.cacheFetched) {
                for (TreeTableNodeBasic nb : nodeList) {
                    recipient.getCachedNodes().put(nb, new Date());
                }
            }
            long insertFinished = System.currentTimeMillis();
            this.lastReaded = nodeList.size();
            this.lastReadTime = Math.abs(readFinish - readStart);
            this.lastInsertTime = Math.abs(readFinish - insertFinished);
        } else {
            readFinish = System.currentTimeMillis();
            this.lastReadTime += Math.abs(readStart - readFinish);
            readStart = readFinish;
            if (recipientList instanceof BulkInsert) {
                if (insertAtEnd) {
                    int rsize = recipientList.size();
                    ((BulkInsert)recipientList).bulkInsert(rsize, nodeList);
                } else {
                    ((BulkInsert)recipientList).bulkInsert(trgtIdx, nodeList);
                }
            } else if (insertAtEnd) {
                recipientList.addAll(nodeList);
            } else {
                recipientList.addAll(trgtIdx, nodeList);
            }
            trgtIdx += nodeList.size();
            long tInserted = System.currentTimeMillis();
            this.lastInsertTime += Math.abs(readFinish - tInserted);
            this.lastReaded += nodeList.size();
            if (this.cacheFetched) {
                for (TreeTableNodeBasic nb : nodeList) {
                    recipient.getCachedNodes().put(nb, new Date());
                }
            }
            nodeList.clear();
        }
        this.totalReaded += this.lastReaded;
        this.totalReadTime += this.lastReadTime;
        this.totalInsertTime += this.lastInsertTime;
    }

    protected List<TreeTableNodeBasic> createNodeList() {
        return new LinkedList<TreeTableNodeBasic>();
    }

    protected TreeTableNodeBasic createNode(Object data) {
        return new TreeTableNodeBasic(data);
    }

    protected void readFinished() {
        this.removeSelf();
    }

    protected void removeSelf() {
        TreeTableNodeBasic parent = (TreeTableNodeBasic)this.getParent();
        if (parent != null) {
            TreeTableNodeExpander.logFine("removeSelf {0}", this);
            this.popup(new TreeTableExpanderFinish(this));
            parent.removeChild(this);
            this.setParent(null);
        }
    }

    @Override
    public void follow() {
        this.fetch();
    }

    @Override
    public boolean isExpanded() {
        return false;
    }

    @Override
    public void expand() {
        this.fetch();
    }
}

