/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.tree;

import java.awt.Color;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import xyz.cofe.collection.Convertor;
import xyz.cofe.gui.swing.color.ColorModificator;
import xyz.cofe.gui.swing.tree.TreeTableNodeFormat;

public class TreeTableNodeFormatBasic
implements TreeTableNodeFormat {
    private static final Logger logger = Logger.getLogger(TreeTableNodeFormatBasic.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected String fontFamily;
    protected Float fontSize;
    protected Boolean italic;
    protected Float weight;
    private Color background;
    private Color foreground;
    private ColorModificator baseModificator;
    private ColorModificator foregroundModificator;
    private ColorModificator backgroundModificator;
    private List<Icon> icons;
    protected Convertor<Object, String> convertor;
    protected Integer iconWidthMin = 0;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(TreeTableNodeFormatBasic.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(TreeTableNodeFormatBasic.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(TreeTableNodeFormatBasic.class.getName(), method, result);
    }

    private static boolean eq(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null && b != null) {
            return false;
        }
        if (a != null && b == null) {
            return false;
        }
        return a.equals(b);
    }

    public TreeTableNodeFormatBasic() {
    }

    public TreeTableNodeFormatBasic(TreeTableNodeFormatBasic sample) {
        if (sample != null) {
            this.background = sample.background;
            this.foreground = sample.foreground;
            this.fontFamily = sample.fontFamily;
            this.weight = sample.weight;
            this.italic = sample.italic;
            this.fontSize = sample.fontSize;
            this.iconWidthMin = sample.iconWidthMin;
            this.convertor = sample.convertor;
            if (sample.icons != null) {
                this.getIcons().addAll(sample.icons);
            }
        }
    }

    @Override
    public TreeTableNodeFormatBasic clone() {
        return new TreeTableNodeFormatBasic(this);
    }

    @Override
    public AttributedString createAttributedString(String text, Object value) {
        String txtc;
        if (text == null) {
            throw new IllegalArgumentException("text==null");
        }
        Convertor<Object, String> txtConv = this.convertor;
        String txt = text.toString();
        if (txtConv != null && (txtc = (String)txtConv.convert(value)) != null) {
            txt = txtc;
        }
        AttributedString astr = new AttributedString(txt);
        if (txt.length() > 0) {
            if (this.fontFamily != null) {
                astr.addAttribute(TextAttribute.FAMILY, this.fontFamily);
            }
            if (this.fontSize != null) {
                astr.addAttribute(TextAttribute.SIZE, this.fontSize);
            }
            if (this.foreground != null) {
                astr.addAttribute(TextAttribute.FOREGROUND, this.foreground);
            }
            if (this.weight != null) {
                astr.addAttribute(TextAttribute.WEIGHT, this.weight);
            }
            if (this.italic != null) {
                if (this.italic.booleanValue()) {
                    astr.addAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
                } else {
                    astr.addAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_REGULAR);
                }
            }
        }
        return astr;
    }

    @Override
    public String getFontFamily() {
        return this.fontFamily;
    }

    @Override
    public void setFontFamily(String fontFamily) {
        this.fontFamily = fontFamily;
    }

    public TreeTableNodeFormatBasic fontFamily(String ffamily) {
        this.setFontFamily(ffamily);
        return this;
    }

    @Override
    public Float getFontSize() {
        return this.fontSize;
    }

    @Override
    public void setFontSize(Float fontSize) {
        this.fontSize = fontSize;
    }

    public TreeTableNodeFormatBasic fontSize(Float fsize) {
        this.setFontSize(fsize);
        return this;
    }

    @Override
    public Boolean getItalic() {
        return this.italic;
    }

    @Override
    public void setItalic(Boolean italic) {
        this.italic = italic;
    }

    public TreeTableNodeFormatBasic italic(Boolean italic) {
        this.italic = italic;
        return this;
    }

    @Override
    public Boolean getBold() {
        if (this.weight == null) {
            return null;
        }
        if (this.weight.floatValue() > TextAttribute.WEIGHT_REGULAR.floatValue()) {
            return true;
        }
        return false;
    }

    @Override
    public void setBold(Boolean bold) {
        if (bold == null) {
            this.weight = null;
            return;
        }
        this.weight = bold != false ? TextAttribute.WEIGHT_BOLD : TextAttribute.WEIGHT_REGULAR;
    }

    public TreeTableNodeFormatBasic bold(Boolean bld) {
        this.setBold(bld);
        return this;
    }

    @Override
    public Float getWeight() {
        return this.weight;
    }

    @Override
    public void setWeight(Float weight) {
        this.weight = weight;
    }

    public TreeTableNodeFormatBasic weight(Float w) {
        this.setWeight(w);
        return this;
    }

    @Override
    public Color getBackground() {
        return this.background;
    }

    @Override
    public void setBackground(Color background) {
        this.background = background;
    }

    public TreeTableNodeFormatBasic background(Color background) {
        this.setBackground(background);
        return this;
    }

    @Override
    public Color getForeground() {
        return this.foreground;
    }

    @Override
    public void setForeground(Color foreground) {
        this.foreground = foreground;
    }

    public TreeTableNodeFormatBasic foreground(Color fg) {
        this.foreground = fg;
        return this;
    }

    @Override
    public ColorModificator getBaseModificator() {
        return this.baseModificator;
    }

    @Override
    public void setBaseModificator(ColorModificator baseModificator) {
        this.baseModificator = baseModificator;
    }

    public TreeTableNodeFormatBasic base(ColorModificator baseMod) {
        this.baseModificator = baseMod;
        return this;
    }

    @Override
    public ColorModificator getForegroundModificator() {
        return this.foregroundModificator;
    }

    @Override
    public void setForegroundModificator(ColorModificator foregroundModificator) {
        this.foregroundModificator = foregroundModificator;
    }

    public TreeTableNodeFormatBasic foreground(ColorModificator foregroundModificator) {
        this.foregroundModificator = foregroundModificator;
        return this;
    }

    @Override
    public ColorModificator getBackgroundModificator() {
        return this.backgroundModificator;
    }

    @Override
    public void setBackgroundModificator(ColorModificator backgroundModificator) {
        this.backgroundModificator = backgroundModificator;
    }

    public TreeTableNodeFormatBasic background(ColorModificator backgroundModificator) {
        this.backgroundModificator = backgroundModificator;
        return this;
    }

    @Override
    public List<Icon> getIcons() {
        if (this.icons != null) {
            return this.icons;
        }
        this.icons = new ArrayList<Icon>();
        return this.icons;
    }

    @Override
    public void setIcons(List<Icon> icons) {
        this.icons = icons;
    }

    public TreeTableNodeFormatBasic icons(List<Icon> icons) {
        this.setIcons(icons);
        return this;
    }

    public TreeTableNodeFormatBasic icons(Icon ... icons) {
        this.getIcons().addAll(Arrays.asList(icons));
        return this;
    }

    @Override
    public Convertor<Object, String> getConvertor() {
        return this.convertor;
    }

    @Override
    public void setConvertor(Convertor<Object, String> convertor) {
        this.convertor = convertor;
    }

    public TreeTableNodeFormatBasic convertor(Convertor<Object, String> convertor) {
        this.convertor = convertor;
        return this;
    }

    @Override
    public Integer getIconWidthMin() {
        return this.iconWidthMin;
    }

    @Override
    public void setIconWidthMin(Integer iconWidthMin) {
        this.iconWidthMin = iconWidthMin;
    }

    public TreeTableNodeFormatBasic iconWidthMin(Integer iconWidthMin) {
        this.iconWidthMin = iconWidthMin;
        return this;
    }

    @Override
    public void merge(TreeTableNodeFormat fmt) {
        if (fmt == null) {
            return;
        }
        if (fmt.getFontFamily() != null) {
            this.setFontFamily(fmt.getFontFamily());
        }
        if (fmt.getFontSize() != null) {
            this.setFontSize(fmt.getFontSize());
        }
        if (fmt.getItalic() != null) {
            this.setItalic(fmt.getItalic());
        }
        if (fmt.getWeight() != null) {
            this.setWeight(fmt.getWeight());
        }
        if (fmt.getBackground() != null) {
            this.setBackground(fmt.getBackground());
        }
        if (fmt.getForeground() != null) {
            this.setForeground(fmt.getForeground());
        }
        if (fmt.getIconWidthMin() != null) {
            this.setIconWidthMin(fmt.getIconWidthMin());
        }
        if (fmt.getConvertor() != null) {
            this.setConvertor(fmt.getConvertor());
        }
        if (fmt.getIcons() != null && !fmt.getIcons().isEmpty()) {
            this.getIcons().clear();
            this.getIcons().addAll(fmt.getIcons());
        }
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

