/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.tree;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.LineMetrics;
import java.net.URL;
import java.text.AttributedString;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import xyz.cofe.collection.Func1;
import xyz.cofe.collection.Func2;
import xyz.cofe.collection.NodesExtracter;
import xyz.cofe.collection.tree.TreeNode;
import xyz.cofe.gui.swing.color.ColorModificator;
import xyz.cofe.gui.swing.color.Colors;
import xyz.cofe.gui.swing.properties.PropertyValue;
import xyz.cofe.gui.swing.tree.FormattedValue;
import xyz.cofe.gui.swing.tree.TreeTableDirectModel;
import xyz.cofe.gui.swing.tree.TreeTableNode;
import xyz.cofe.gui.swing.tree.TreeTableNodeBasic;
import xyz.cofe.gui.swing.tree.TreeTableNodeExpander;
import xyz.cofe.gui.swing.tree.TreeTableNodeFormat;
import xyz.cofe.gui.swing.tree.TreeTableNodeGetFormat;
import xyz.cofe.gui.swing.tree.TreeTableNodeGetFormatOf;
import xyz.cofe.gui.swing.tree.TreeTableNodeGetText;
import xyz.cofe.gui.swing.tree.TreeTableNodeValue;

public class TreeTableNodeRender
extends JComponent
implements TableCellRenderer {
    private static final Logger logger = Logger.getLogger(TreeTableNodeRender.class.getName());
    protected Color foregroundBase = Color.black;
    protected Color backgroundBase = Color.white;
    protected Color foregroundAlternative = this.foregroundBase;
    protected Color backgroundAlternative = new ColorModificator().brighter(-0.1f).apply(this.backgroundBase);
    protected Color foregroundSelected = this.foregroundBase;
    protected Color backgroundSelected = new ColorModificator().bright(0.9f).saturation(0.25f).apply(Colors.HUE_210);
    protected Color foregroundSelectedAlternative = this.foregroundBase;
    protected Color backgroundSelectedAlternative = new ColorModificator().brighter(-0.1f).apply(this.backgroundSelected);
    protected Color foregroundFocused = Color.white;
    protected Color backgroundFocused = Color.black;
    protected Color foregroundFocusedAlternative = new ColorModificator().brighter(0.1f).apply(this.foregroundFocused);
    protected Color backgroundFocusedAlternative = new ColorModificator().brighter(0.1f).apply(this.backgroundFocused);
    protected ColorModificator baseModificator = null;
    protected ColorModificator foregroundModificator = null;
    protected ColorModificator backgroundModificator = null;
    protected String text = "";
    protected int row = -1;
    protected int column = -1;
    protected boolean focused = false;
    protected boolean selected = false;
    protected int level = 0;
    protected int levelIndent = 20;
    protected boolean textAntialiasing = true;
    protected Icon nullIcon;
    protected Icon leafIcon;
    protected Icon expandedIcon;
    protected Icon collapsedIcon;
    protected Icon nodeIcon;
    protected int nodeIconWidthMax;
    protected float nodeIconVAlign = 0.5f;
    protected int nodeIconPaddingLeft;
    protected int nodeIconPaddingRight;
    protected int iconWidthMin = 0;
    protected Icon[] icons = null;
    protected Func2<Object, Graphics, Rectangle> customPainter;
    protected AttributedString atext;
    protected boolean isLastRow = false;
    protected Border lastRowBorder = null;
    protected Border cellBorder = null;
    protected boolean valueIsNode = false;
    protected TreeTableDirectModel directModel;

    private static Level logLevel() {
        return logger.getLevel();
    }

    private static boolean isLogSevere() {
        Level ll = TreeTableNodeRender.logLevel();
        return ll == null ? true : ll.intValue() <= Level.SEVERE.intValue();
    }

    private static boolean isLogWarning() {
        Level ll = TreeTableNodeRender.logLevel();
        return ll == null ? true : ll.intValue() <= Level.WARNING.intValue();
    }

    private static boolean isLogInfo() {
        Level ll = TreeTableNodeRender.logLevel();
        return ll == null ? true : ll.intValue() <= Level.INFO.intValue();
    }

    private static boolean isLogFine() {
        Level ll = TreeTableNodeRender.logLevel();
        return ll == null ? true : ll.intValue() <= Level.FINE.intValue();
    }

    private static boolean isLogFiner() {
        Level ll = TreeTableNodeRender.logLevel();
        return ll == null ? false : ll.intValue() <= Level.FINER.intValue();
    }

    private static boolean isLogFinest() {
        Level ll = TreeTableNodeRender.logLevel();
        return ll == null ? false : ll.intValue() <= Level.FINEST.intValue();
    }

    private static void logEntering(String method, Object ... args) {
        logger.entering(TreeTableNodeRender.class.getName(), method, args);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(TreeTableNodeRender.class.getName(), method, result);
    }

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public Color getForegroundBase() {
        return this.foregroundBase;
    }

    public void setForegroundBase(Color foregroundBase) {
        this.foregroundBase = foregroundBase;
    }

    public Color getBackgroundBase() {
        return this.backgroundBase;
    }

    public void setBackgroundBase(Color backgroundBase) {
        this.backgroundBase = backgroundBase;
    }

    public Color getForegroundAlternative() {
        return this.foregroundAlternative;
    }

    public void setForegroundAlternative(Color foregroundAlternative) {
        this.foregroundAlternative = foregroundAlternative;
    }

    public Color getBackgroundAlternative() {
        return this.backgroundAlternative;
    }

    public void setBackgroundAlternative(Color backgroundAlternative) {
        this.backgroundAlternative = backgroundAlternative;
    }

    public Color getForegroundSelected() {
        return this.foregroundSelected;
    }

    public void setForegroundSelected(Color foregroundSelected) {
        this.foregroundSelected = foregroundSelected;
    }

    public Color getBackgroundSelected() {
        return this.backgroundSelected;
    }

    public void setBackgroundSelected(Color backgroundSelected) {
        this.backgroundSelected = backgroundSelected;
    }

    public Color getForegroundSelectedAlternative() {
        return this.foregroundSelectedAlternative;
    }

    public void setForegroundSelectedAlternative(Color foregroundSelectedAlternative) {
        this.foregroundSelectedAlternative = foregroundSelectedAlternative;
    }

    public Color getBackgroundSelectedAlternative() {
        return this.backgroundSelectedAlternative;
    }

    public void setBackgroundSelectedAlternative(Color backgroundSelectedAlternative) {
        this.backgroundSelectedAlternative = backgroundSelectedAlternative;
    }

    public Color getForegroundFocused() {
        return this.foregroundFocused;
    }

    public void setForegroundFocused(Color foregroundFocused) {
        this.foregroundFocused = foregroundFocused;
    }

    public Color getBackgroundFocused() {
        return this.backgroundFocused;
    }

    public void setBackgroundFocused(Color backgroundFocused) {
        this.backgroundFocused = backgroundFocused;
    }

    public Color getForegroundFocusedAlternative() {
        return this.foregroundFocusedAlternative;
    }

    public void setForegroundFocusedAlternative(Color foregroundFocusedAlternative) {
        this.foregroundFocusedAlternative = foregroundFocusedAlternative;
    }

    public Color getBackgroundFocusedAlternative() {
        return this.backgroundFocusedAlternative;
    }

    public void setBackgroundFocusedAlternative(Color backgroundFocusedAlternative) {
        this.backgroundFocusedAlternative = backgroundFocusedAlternative;
    }

    public ColorModificator getBaseModificator() {
        return this.baseModificator;
    }

    public void setBaseModificator(ColorModificator baseModificator) {
        this.baseModificator = baseModificator;
    }

    public ColorModificator getForegroundModificator() {
        return this.foregroundModificator;
    }

    public void setForegroundModificator(ColorModificator foregroundModificator) {
        this.foregroundModificator = foregroundModificator;
    }

    public ColorModificator getBackgroundModificator() {
        return this.backgroundModificator;
    }

    public void setBackgroundModificator(ColorModificator backgroundModificator) {
        this.backgroundModificator = backgroundModificator;
    }

    public synchronized String getText() {
        return this.text;
    }

    public synchronized void setText(String text) {
        this.text = text;
    }

    public int getRow() {
        return this.row;
    }

    public void setRow(int row) {
        this.row = row;
    }

    public int getColumn() {
        return this.column;
    }

    public void setColumn(int column) {
        this.column = column;
    }

    public boolean isFocused() {
        return this.focused;
    }

    public void setFocused(boolean focused) {
        this.focused = focused;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int getLevelIndent() {
        return this.levelIndent;
    }

    public void setLevelIndent(int levelIndent) {
        this.levelIndent = levelIndent;
    }

    public boolean isTextAntialiasing() {
        return this.textAntialiasing;
    }

    public void setTextAntialiasing(boolean textAntialiasing) {
        this.textAntialiasing = textAntialiasing;
    }

    public Icon getNullIcon() {
        return this.nullIcon;
    }

    public void setNullIcon(Icon nullIcon) {
        this.nullIcon = nullIcon;
    }

    public Icon getLeafIcon() {
        return this.leafIcon;
    }

    public void setLeafIcon(Icon leafIcon) {
        this.leafIcon = leafIcon;
    }

    public Icon getExpandedIcon() {
        return this.expandedIcon;
    }

    public void setExpandedIcon(Icon expandedIcon) {
        this.expandedIcon = expandedIcon;
    }

    public Icon getCollapsedIcon() {
        return this.collapsedIcon;
    }

    public void setCollapsedIcon(Icon collapsedIcon) {
        this.collapsedIcon = collapsedIcon;
    }

    public Icon getNodeIcon() {
        return this.nodeIcon;
    }

    public void setNodeIcon(Icon nodeIcon) {
        this.nodeIcon = nodeIcon;
    }

    public int getNodeIconWidthMax() {
        return this.nodeIconWidthMax;
    }

    public void setNodeIconWidthMax(int nodeIconWidthMax) {
        this.nodeIconWidthMax = nodeIconWidthMax;
    }

    public float getNodeIconVAlign() {
        return this.nodeIconVAlign;
    }

    public void setNodeIconVAlign(float nodeIconVAlign) {
        this.nodeIconVAlign = nodeIconVAlign;
    }

    public int getNodeIconPaddingLeft() {
        return this.nodeIconPaddingLeft;
    }

    public void setNodeIconPaddingLeft(int nodeIconPaddingLeft) {
        this.nodeIconPaddingLeft = nodeIconPaddingLeft;
    }

    public int getNodeIconPaddingRight() {
        return this.nodeIconPaddingRight;
    }

    public void setNodeIconPaddingRight(int nodeIconPaddingRight) {
        this.nodeIconPaddingRight = nodeIconPaddingRight;
    }

    public Icon[] getIcons() {
        return this.icons;
    }

    public void setIcons(Icon[] icons) {
        this.icons = icons;
    }

    public Func2<Object, Graphics, Rectangle> getCustomPainter() {
        return this.customPainter;
    }

    public void setCustomPainter(Func2<Object, Graphics, Rectangle> customPainter) {
        this.customPainter = customPainter;
    }

    public AttributedString getAtext() {
        return this.atext;
    }

    public void setAtext(AttributedString atext) {
        this.atext = atext;
    }

    public boolean isIsLastRow() {
        return this.isLastRow;
    }

    public void setIsLastRow(boolean isLastRow) {
        this.isLastRow = isLastRow;
    }

    public Border getLastRowBorder() {
        return this.lastRowBorder;
    }

    public void setLastRowBorder(Border lastRowBorder) {
        this.lastRowBorder = lastRowBorder;
    }

    public Border getCellBorder() {
        return this.cellBorder;
    }

    public void setCellBorder(Border cellBorder) {
        this.cellBorder = cellBorder;
    }

    public TreeTableDirectModel getDirectModel() {
        return this.directModel;
    }

    public void setDirectModel(TreeTableDirectModel directModel) {
        this.directModel = directModel;
    }

    public TreeTableNodeRender() {
        URL uNullIcon = TreeTableNodeRender.class.getResource("/xyz/cofe/gui/swing/properties/editors/null.png");
        this.nullIcon = uNullIcon == null ? null : new ImageIcon(uNullIcon);
        URL uExpandedIcon = TreeTableNodeRender.class.getResource("/xyz/cofe/gui/swing/table/node-minus-v1-12x12.png");
        this.expandedIcon = uExpandedIcon == null ? null : new ImageIcon(uExpandedIcon);
        URL uCollapsedIcon = TreeTableNodeRender.class.getResource("/xyz/cofe/gui/swing/table/node-plus-v1-12x12.png");
        this.collapsedIcon = uCollapsedIcon == null ? null : new ImageIcon(uCollapsedIcon);
        this.leafIcon = null;
        for (Icon ico : new Icon[]{this.expandedIcon, this.collapsedIcon, this.leafIcon}) {
            int iw;
            if (ico == null || this.nodeIconWidthMax >= (iw = ico.getIconWidth())) continue;
            this.nodeIconWidthMax = iw;
        }
        this.nodeIconPaddingLeft = 2;
        this.nodeIconPaddingRight = 2;
    }

    public void prepareDefaults(JTable tbl) {
        if (tbl == null) {
            throw new IllegalArgumentException("tbl == null");
        }
        tbl.setDefaultRenderer(TreeTableNode.class, this);
        tbl.setDefaultRenderer(TreeTableNodeBasic.class, this);
        tbl.setDefaultRenderer(FormattedValue.class, this);
        tbl.setDefaultRenderer(PropertyValue.class, this);
        tbl.setDefaultRenderer(TreeTableNodeValue.class, this);
    }

    protected boolean isAlternativeRow() {
        return this.getRow() % 2 == 1;
    }

    public int getTreeLevelOf(TreeTableNode node) {
        int nlevel;
        if (node == null) {
            return 0;
        }
        TreeTableDirectModel dm = this.directModel;
        boolean showRoot = true;
        if (dm != null) {
            showRoot = dm.isRootVisible();
        }
        if ((nlevel = node.getTreeLevel() - (showRoot ? 1 : 2)) < 0) {
            nlevel = 0;
        }
        return nlevel;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.baseModificator = null;
        this.foregroundModificator = null;
        this.backgroundModificator = null;
        this.setSelected(isSelected);
        this.setFocused(hasFocus);
        this.setRow(row);
        this.setColumn(column);
        this.setLevel(0);
        this.setText(value == null ? "" : value.toString());
        this.setNodeIcon(null);
        this.setIcons(null);
        this.setCustomPainter(null);
        this.setAtext(null);
        this.iconWidthMin = 0;
        this.setIsLastRow(false);
        this.valueIsNode = value instanceof TreeTableNode;
        this.prepareColors();
        this.setText(value == null ? "" : value.toString());
        if (table != null) {
            int rcount = table.getRowCount();
            this.setIsLastRow(row == rcount - 1);
        }
        if (value instanceof TreeTableNode) {
            this.prepareTreeTableNode((TreeTableNode)value);
        } else if (value instanceof TreeTableNodeValue) {
            TreeTableNodeValue ttNodeValue = (TreeTableNodeValue)value;
            this.prepareTreeTableNodeValue(ttNodeValue);
        } else if (value instanceof FormattedValue) {
            this.prepareFormattedValue((FormattedValue)value);
        }
        return this;
    }

    protected void prepareColors() {
        Color bg;
        Color fg;
        if (this.isSelected()) {
            if (this.isFocused()) {
                if (this.isAlternativeRow()) {
                    fg = this.getForegroundFocusedAlternative();
                    bg = this.getBackgroundFocusedAlternative();
                } else {
                    fg = this.getForegroundFocused();
                    bg = this.getBackgroundFocused();
                }
            } else if (this.isAlternativeRow()) {
                fg = this.getForegroundSelectedAlternative();
                bg = this.getBackgroundSelectedAlternative();
            } else {
                fg = this.getForegroundSelected();
                bg = this.getBackgroundSelected();
            }
        } else if (this.isAlternativeRow()) {
            fg = this.getForegroundAlternative();
            bg = this.getBackgroundAlternative();
        } else {
            fg = this.getForegroundBase();
            bg = this.getBackgroundBase();
        }
        this.setForeground(fg);
        this.setBackground(bg);
    }

    protected void prepareTreeTableNode(TreeTableNode node) {
        boolean isLeaf;
        TreeTableNodeFormat fmt;
        this.valueIsNode = true;
        String text = null;
        if (node instanceof TreeTableNodeGetText) {
            text = ((TreeTableNodeGetText)((Object)node)).treeTableNodeGetText();
            if (text != null) {
                this.setText(text);
            } else {
                Object data = node.getData();
                if (data != null) {
                    text = data.toString();
                    this.setText(text);
                } else {
                    text = "null";
                    this.setText(text);
                }
            }
        }
        if (node instanceof TreeTableNodeGetFormat && (fmt = ((TreeTableNodeGetFormat)((Object)node)).getTreeTableNodeFormat()) != null) {
            Integer icWMin;
            AttributedString astr;
            List<Icon> ics;
            if (!this.isFocused()) {
                Color fg;
                Color bg = fmt.getBackground();
                if (bg != null) {
                    this.setBackground(bg);
                }
                if ((fg = fmt.getForeground()) != null) {
                    this.setForeground(fg);
                }
            }
            if ((ics = fmt.getIcons()) != null) {
                this.setIcons(ics.toArray(new Icon[0]));
            }
            if ((astr = fmt.createAttributedString(text, node)) != null) {
                this.setAtext(astr);
            }
            if ((icWMin = fmt.getIconWidthMin()) != null && icWMin >= 0) {
                this.iconWidthMin = icWMin;
            }
            this.setBaseModificator(fmt.getBaseModificator());
            this.setForegroundModificator(fmt.getForegroundModificator());
            this.setBackgroundModificator(fmt.getBackgroundModificator());
        }
        int nlevel = this.getTreeLevelOf(node);
        this.setLevel(nlevel);
        TreeNode[] children = node.getChildren();
        boolean hasChildren = children != null && children.length > 0;
        boolean bl = isLeaf = !hasChildren;
        if (node instanceof TreeTableNodeExpander) {
            isLeaf = false;
        } else if (node instanceof TreeTableNodeBasic) {
            TreeTableNodeBasic ttnb = (TreeTableNodeBasic)node;
            if (isLeaf) {
                Func1<Boolean, Object> extractable = ttnb.getPreferredDataFollowable();
                Object data = ttnb.getData();
                if (extractable != null) {
                    boolean canExtract = (Boolean)extractable.apply(data);
                    if (canExtract) {
                        isLeaf = false;
                    }
                } else {
                    NodesExtracter<Object, Object> extracter = ttnb.getPreferredDataFollower();
                    Date extractFinished = ttnb.getFollowFinished();
                    if (extracter != null && extractFinished == null) {
                        isLeaf = false;
                    }
                }
            }
        }
        if (isLeaf) {
            this.setNodeIcon(this.getLeafIcon());
        } else if (node.isExpanded()) {
            this.setNodeIcon(this.getExpandedIcon());
        } else {
            this.setNodeIcon(this.getCollapsedIcon());
        }
    }

    protected void prepareTreeTableNodeValue(TreeTableNodeValue nodeValue) {
        Func2<Object, Graphics, Rectangle> custPaint;
        Object value = nodeValue.getValue();
        String text = value == null ? "null" : value.toString();
        this.setText(text);
        TreeTableNodeFormat fmt = nodeValue.getFormat();
        if (fmt != null) {
            Integer icWMin;
            AttributedString astr;
            List<Icon> ics;
            if (!this.isFocused()) {
                Color fg;
                Color bg = fmt.getBackground();
                if (bg != null) {
                    this.setBackground(bg);
                }
                if ((fg = fmt.getForeground()) != null) {
                    this.setForeground(fg);
                }
            }
            if ((ics = fmt.getIcons()) != null) {
                this.setIcons(ics.toArray(new Icon[0]));
            }
            if ((astr = fmt.createAttributedString(text, value)) != null) {
                this.setAtext(astr);
            }
            if ((icWMin = fmt.getIconWidthMin()) != null && icWMin >= 0) {
                this.iconWidthMin = icWMin;
            }
            this.setBaseModificator(fmt.getBaseModificator());
            this.setForegroundModificator(fmt.getForegroundModificator());
            this.setBackgroundModificator(fmt.getBackgroundModificator());
        }
        if ((custPaint = nodeValue.getCustomPainter()) != null) {
            this.setCustomPainter(custPaint);
        }
    }

    protected void prepareFormattedValue(FormattedValue propertyValue) {
        Object value = propertyValue.getValue();
        String text = value == null ? "" : value.toString();
        this.setText(text);
        if (value instanceof Icon) {
            this.setIcons(new Icon[]{(Icon)value});
        }
        TreeTableNodeFormat fmt = null;
        if (propertyValue instanceof TreeTableNodeGetFormat) {
            fmt = propertyValue.getTreeTableNodeFormat();
        } else if (propertyValue instanceof TreeTableNodeGetFormatOf) {
            fmt = ((TreeTableNodeGetFormatOf)((Object)propertyValue)).getTreeTableNodeFormatOf(value);
        }
        if (fmt != null) {
            Integer icWMin;
            AttributedString astr;
            List<Icon> ics;
            if (!this.isFocused()) {
                Color fg;
                Color bg = fmt.getBackground();
                if (bg != null) {
                    this.setBackground(bg);
                }
                if ((fg = fmt.getForeground()) != null) {
                    this.setForeground(fg);
                }
            }
            if ((ics = fmt.getIcons()) != null) {
                this.setIcons(ics.toArray(new Icon[0]));
            }
            if ((astr = fmt.createAttributedString(text, value)) != null) {
                this.setAtext(astr);
            }
            if ((icWMin = fmt.getIconWidthMin()) != null && icWMin >= 0) {
                this.iconWidthMin = icWMin;
            }
            this.setBaseModificator(fmt.getBaseModificator());
            this.setForegroundModificator(fmt.getForegroundModificator());
            this.setBackgroundModificator(fmt.getBackgroundModificator());
        }
    }

    public int getNodeIconXBeginForLevel(int level) {
        float nodeico_x = level * this.getLevelIndent() + this.getNodeIconPaddingLeft();
        return (int)nodeico_x;
    }

    public int getNodeIconXWidthForLevel(int level) {
        return this.getNodeIconWidthMax();
    }

    public int getNodeIconXEndForLevel(int level) {
        int begin = this.getNodeIconXBeginForLevel(level);
        return begin + this.getNodeIconXWidthForLevel(level) - 1;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Icon[] icons;
        if (!(g instanceof Graphics2D)) {
            throw new IllegalArgumentException("g not instanceof Graphics2D");
        }
        Graphics2D gs = (Graphics2D)g;
        Color bg = this.getBackground();
        Color fg = this.getForeground();
        bg = bg == null ? Color.white : bg;
        fg = fg == null ? Color.black : fg;
        ColorModificator basemod = this.baseModificator;
        ColorModificator foremod = this.foregroundModificator;
        ColorModificator backmod = this.backgroundModificator;
        if (bg != null) {
            if (basemod != null) {
                bg = basemod.apply(bg);
            }
            if (backmod != null) {
                bg = backmod.apply(bg);
            }
        }
        if (fg != null) {
            if (basemod != null) {
                fg = basemod.apply(fg);
            }
            if (foremod != null) {
                fg = foremod.apply(fg);
            }
        }
        int w = this.getWidth();
        int h = this.getHeight();
        gs.setPaint(bg);
        gs.fillRect(0, 0, w, h);
        Icon nodeIco = this.getNodeIcon();
        String txt = this.getText();
        AttributedString atext = this.getAtext();
        Font fnt = this.getFont();
        int maxIcoWidth = this.getNodeIconWidthMax();
        int lvl = this.getLevel();
        int ico_x = this.getNodeIconXBeginForLevel(lvl);
        float text_x = lvl * this.getLevelIndent() + maxIcoWidth + this.getNodeIconPaddingLeft() + this.getNodeIconPaddingRight();
        if (!this.valueIsNode) {
            ico_x = this.getNodeIconPaddingLeft();
            text_x = nodeIco != null ? (float)(this.getNodeIconPaddingLeft() + maxIcoWidth + this.getNodeIconPaddingRight()) : (float)this.getNodeIconPaddingLeft();
        }
        if (nodeIco != null) {
            int ih = nodeIco.getIconHeight();
            if (ih >= h) {
                nodeIco.paintIcon(this, g, ico_x, 0);
            } else {
                float ihExtra = h - ih;
                float iconVAlign = this.getNodeIconVAlign();
                float ioff = ihExtra * iconVAlign;
                nodeIco.paintIcon(this, g, ico_x, (int)ioff);
            }
        }
        if ((icons = this.icons) != null && icons.length > 0) {
            int iconCount = 0;
            int iconWidthSummary = 0;
            int iconWidthMin = Integer.MAX_VALUE;
            int iconWidthMax = Integer.MIN_VALUE;
            int iconHeightSummary = 0;
            int iconHeightMin = Integer.MAX_VALUE;
            int iconHeightMax = Integer.MIN_VALUE;
            for (Icon ico : icons) {
                if (ico == null) continue;
                int icoW = ico.getIconWidth();
                int icoH = ico.getIconHeight();
                ++iconCount;
                iconWidthSummary += icoW;
                iconHeightSummary += icoH;
                iconWidthMin = iconWidthMin > icoW ? icoW : iconWidthMin;
                iconHeightMin = iconHeightMin > icoH ? icoH : iconHeightMin;
                iconWidthMax = iconWidthMax < icoW ? icoW : iconWidthMax;
                iconHeightMax = iconHeightMax < icoH ? icoH : iconHeightMax;
            }
            if (iconCount > 0) {
                float x_icon = text_x;
                int iconXOutput = (int)x_icon;
                boolean iconYOutput = false;
                int iconsWidthSum = 0;
                int cHeight = this.getHeight();
                double vAlign = 0.5;
                for (Icon ico : icons) {
                    if (ico == null) continue;
                    int wico = ico.getIconWidth();
                    int hico = ico.getIconHeight();
                    double icoHeightDouble = hico;
                    double alignPointY = (double)cHeight * vAlign;
                    double icoTopOffset = -((double)hico * vAlign);
                    ico.paintIcon(this, g, iconXOutput, (int)(alignPointY + icoTopOffset));
                    iconXOutput += wico + 2;
                    iconsWidthSum += wico + 2;
                }
                text_x += this.iconWidthMin > 0 && this.iconWidthMin > iconsWidthSum ? (float)this.iconWidthMin : (float)iconsWidthSum;
            }
        }
        if (this.customPainter != null) {
            Rectangle rect = new Rectangle((int)text_x, 0, (int)((float)w - text_x), h);
            this.customPainter.apply((Object)g, (Object)rect);
        } else if ((txt != null || atext != null) && fnt != null) {
            LineMetrics lm = fnt.getLineMetrics(txt, gs.getFontRenderContext());
            float fnt_ascent = lm.getAscent();
            float fnt_height = lm.getHeight();
            float fnt_descent = lm.getDescent();
            float fnt_leading = lm.getLeading();
            float fnt_h = fnt_ascent;
            float c_height = this.getHeight();
            float ty = fnt_h;
            if (fnt_h < c_height) {
                ty = (c_height - fnt_h) / 2.0f + fnt_h;
            }
            gs.setPaint(fg);
            if (this.isTextAntialiasing()) {
                gs.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            } else {
                gs.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            }
            if (atext != null) {
                gs.drawString(atext.getIterator(), text_x, ty);
            } else {
                gs.drawString(txt, text_x, ty);
            }
        }
        Border brd = this.cellBorder;
        if (this.isLastRow && this.lastRowBorder != null) {
            brd = this.lastRowBorder;
        }
        if (brd != null) {
            brd.paintBorder(this, g, 0, 0, w, h);
        }
    }
}

