/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.tree;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.Convertor;
import xyz.cofe.collection.Func1;
import xyz.cofe.collection.Func2;
import xyz.cofe.collection.Func3;
import xyz.cofe.collection.map.ClassMap;
import xyz.cofe.gui.swing.table.Column;
import xyz.cofe.gui.swing.table.IsRowEditable;
import xyz.cofe.gui.swing.tree.TreeTableNode;
import xyz.cofe.gui.swing.tree.TreeTableNodeFormat;
import xyz.cofe.gui.swing.tree.TreeTableNodeValue;
import xyz.cofe.gui.swing.tree.TreeTableNodeValueEditor;

public class TreeTableNodeValueColumn
extends Column
implements IsRowEditable {
    private static final Logger logger = Logger.getLogger(TreeTableNodeValueColumn.class.getName());
    protected ClassMap<Func2<Func2<Object, Graphics, Rectangle>, Object, TreeTableNode>> customPainter = new ClassMap();
    protected ClassMap<Func2<TreeTableNodeFormat, Object, TreeTableNode>> valueFormat = new ClassMap();
    protected ClassMap<Func2<Object, Object, TreeTableNode>> valueReader = new ClassMap();
    protected ClassMap<Func3<Object, TreeTableNode, Object, Object>> valueWriter = new ClassMap();
    protected ClassMap<Func2<Class, Object, TreeTableNode>> valueType = new ClassMap();
    protected ClassMap<Func2<TreeTableNodeValueEditor.Editor, Object, TreeTableNode>> valueEditor = new ClassMap();

    private static Level logLevel() {
        return logger.getLevel();
    }

    private static boolean isLogSevere() {
        Level ll = TreeTableNodeValueColumn.logLevel();
        return ll == null ? true : ll.intValue() <= Level.SEVERE.intValue();
    }

    private static boolean isLogWarning() {
        Level ll = TreeTableNodeValueColumn.logLevel();
        return ll == null ? true : ll.intValue() <= Level.WARNING.intValue();
    }

    private static boolean isLogInfo() {
        Level ll = TreeTableNodeValueColumn.logLevel();
        return ll == null ? true : ll.intValue() <= Level.INFO.intValue();
    }

    private static boolean isLogFine() {
        Level ll = TreeTableNodeValueColumn.logLevel();
        return ll == null ? true : ll.intValue() <= Level.FINE.intValue();
    }

    private static boolean isLogFiner() {
        Level ll = TreeTableNodeValueColumn.logLevel();
        return ll == null ? false : ll.intValue() <= Level.FINER.intValue();
    }

    private static boolean isLogFinest() {
        Level ll = TreeTableNodeValueColumn.logLevel();
        return ll == null ? false : ll.intValue() <= Level.FINEST.intValue();
    }

    private static void logEntering(String method, Object ... args) {
        logger.entering(TreeTableNodeValueColumn.class.getName(), method, args);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(TreeTableNodeValueColumn.class.getName(), method, result);
    }

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public TreeTableNodeValueColumn() {
        this.setName("value");
        this.setType(TreeTableNodeValue.class);
        this.setReader((Convertor<Object, Object>)this.createReader());
        this.setWriter(this.createWriter());
    }

    public TreeTableNodeValueColumn(Object sync) {
        super(sync);
        this.setName("value");
        this.setType(TreeTableNodeValue.class);
        this.setReader((Convertor<Object, Object>)this.createReader());
    }

    public TreeTableNodeValueColumn(Column src) {
        super(src);
    }

    public TreeTableNodeValueColumn(Object sync, Column src) {
        super(sync, src);
    }

    @Override
    public TreeTableNodeValueColumn name(String name) {
        super.name(name);
        return this;
    }

    public ClassMap<Func2<Func2<Object, Graphics, Rectangle>, Object, TreeTableNode>> getCustomPainter() {
        if (this.customPainter != null) {
            return this.customPainter;
        }
        this.customPainter = new ClassMap();
        return this.customPainter;
    }

    public <T> TreeTableNodeValueColumn addCustomPainter(Class<T> cls, Func2<Func2<Object, Graphics, Rectangle>, T, TreeTableNode> reader) {
        if (cls == null) {
            throw new IllegalArgumentException("cls==null");
        }
        if (reader == null) {
            throw new IllegalArgumentException("reader==null");
        }
        this.getCustomPainter().put(cls, reader);
        return this;
    }

    public <T> TreeTableNodeValueColumn addCustomPainter(final Class<T> cls, final Func1<Func2<Object, Graphics, Rectangle>, T> reader) {
        if (cls == null) {
            throw new IllegalArgumentException("cls==null");
        }
        if (reader == null) {
            throw new IllegalArgumentException("reader==null");
        }
        Func2<Func2<Object, Graphics, Rectangle>, Object, TreeTableNode> freader = new Func2<Func2<Object, Graphics, Rectangle>, Object, TreeTableNode>(){

            public Func2<Object, Graphics, Rectangle> apply(Object dataOfNode, TreeTableNode node) {
                if (dataOfNode != null && cls.isAssignableFrom(dataOfNode.getClass())) {
                    return (Func2)reader.apply(dataOfNode);
                }
                return null;
            }
        };
        this.getCustomPainter().put(cls, (Object)freader);
        return this;
    }

    public ClassMap<Func2<TreeTableNodeFormat, Object, TreeTableNode>> getValueFormat() {
        if (this.valueFormat != null) {
            return this.valueFormat;
        }
        this.valueFormat = new ClassMap();
        return this.valueFormat;
    }

    public <T> TreeTableNodeValueColumn addValueFormat(Class<T> cls, Func2<TreeTableNodeFormat, T, TreeTableNode> reader) {
        if (cls == null) {
            throw new IllegalArgumentException("cls==null");
        }
        if (reader == null) {
            throw new IllegalArgumentException("reader==null");
        }
        this.getValueFormat().put(cls, reader);
        return this;
    }

    public <T> TreeTableNodeValueColumn addValueFormat(final Class<T> cls, final Func1<TreeTableNodeFormat, T> reader) {
        if (cls == null) {
            throw new IllegalArgumentException("cls==null");
        }
        if (reader == null) {
            throw new IllegalArgumentException("reader==null");
        }
        Func2<TreeTableNodeFormat, Object, TreeTableNode> freader = new Func2<TreeTableNodeFormat, Object, TreeTableNode>(){

            public TreeTableNodeFormat apply(Object dataOfNode, TreeTableNode node) {
                if (dataOfNode != null && cls.isAssignableFrom(dataOfNode.getClass())) {
                    return (TreeTableNodeFormat)reader.apply(dataOfNode);
                }
                return null;
            }
        };
        this.getValueFormat().put(cls, (Object)freader);
        return this;
    }

    public ClassMap<Func2<Object, Object, TreeTableNode>> getValueReaders() {
        if (this.valueReader == null) {
            this.valueReader = new ClassMap();
        }
        return this.valueReader;
    }

    public <T> TreeTableNodeValueColumn addValueReader(Class<T> cls, Func2<Object, T, TreeTableNode> reader) {
        if (cls == null) {
            throw new IllegalArgumentException("cls==null");
        }
        if (reader == null) {
            throw new IllegalArgumentException("reader==null");
        }
        this.getValueReaders().put(cls, reader);
        return this;
    }

    public <T> TreeTableNodeValueColumn addValueReader(final Class<T> cls, final Func1<Object, T> reader) {
        if (cls == null) {
            throw new IllegalArgumentException("cls==null");
        }
        if (reader == null) {
            throw new IllegalArgumentException("reader==null");
        }
        Func2<Object, Object, TreeTableNode> freader = new Func2<Object, Object, TreeTableNode>(){

            public Object apply(Object dataOfNode, TreeTableNode node) {
                if (dataOfNode != null && cls.isAssignableFrom(dataOfNode.getClass())) {
                    return reader.apply(dataOfNode);
                }
                return null;
            }
        };
        this.getValueReaders().put(cls, (Object)freader);
        return this;
    }

    public Convertor createReader() {
        return new Convertor(){

            public Object convert(Object node) {
                Func2 fnReader;
                Object dataOfNode;
                if (node instanceof TreeTableNode && (dataOfNode = ((TreeTableNode)node).getData()) != null && (fnReader = (Func2)TreeTableNodeValueColumn.this.getValueReaders().fetch(dataOfNode.getClass())) != null) {
                    Func2 fnPainter;
                    Func2 fnEditor;
                    Object value = fnReader.apply(dataOfNode, node);
                    TreeTableNodeValue ttnv = new TreeTableNodeValue(value, dataOfNode, (TreeTableNode)node);
                    ttnv.valueReader = fnReader;
                    ttnv.valueWriter = (Func3)TreeTableNodeValueColumn.this.getValueWriters().fetch(dataOfNode.getClass());
                    Func2 fnType = (Func2)TreeTableNodeValueColumn.this.getValueType().fetch(dataOfNode.getClass());
                    ttnv.valueType = fnType != null ? (Class)fnType.apply(dataOfNode, (Object)((TreeTableNode)node)) : null;
                    Func2 fnFormat = (Func2)TreeTableNodeValueColumn.this.getValueFormat().fetch(dataOfNode.getClass());
                    if (fnFormat != null) {
                        TreeTableNodeFormat fmt = (TreeTableNodeFormat)fnFormat.apply(dataOfNode, (Object)((TreeTableNode)node));
                        ttnv.setFormat(fmt);
                    }
                    if ((fnEditor = (Func2)TreeTableNodeValueColumn.this.getValueEditor().fetch(dataOfNode.getClass())) != null) {
                        ttnv.setEditor((TreeTableNodeValueEditor.Editor)fnEditor.apply(dataOfNode, (Object)((TreeTableNode)node)));
                    }
                    if ((fnPainter = (Func2)TreeTableNodeValueColumn.this.getCustomPainter().fetch(dataOfNode.getClass())) != null) {
                        ttnv.setCustomPainter((Func2<Object, Graphics, Rectangle>)((Func2)fnPainter.apply(dataOfNode, (Object)((TreeTableNode)node))));
                    }
                    return ttnv;
                }
                return new TreeTableNodeValue();
            }
        };
    }

    public ClassMap<Func3<Object, TreeTableNode, Object, Object>> getValueWriters() {
        if (this.valueWriter == null) {
            this.valueWriter = new ClassMap();
        }
        return this.valueWriter;
    }

    public <T> TreeTableNodeValueColumn addValueWriter(Class<T> cls, Func3<Object, TreeTableNode, T, Object> writer) {
        if (cls == null) {
            throw new IllegalArgumentException("cls==null");
        }
        if (writer == null) {
            throw new IllegalArgumentException("writer==null");
        }
        this.getValueWriters().put(cls, writer);
        return this;
    }

    public <T> TreeTableNodeValueColumn addValueWriter(Class<T> cls, final Func2<Object, T, Object> writer) {
        if (cls == null) {
            throw new IllegalArgumentException("cls==null");
        }
        if (writer == null) {
            throw new IllegalArgumentException("writer==null");
        }
        Func3 wr = new Func3<Object, TreeTableNode, T, Object>(){

            public Object apply(TreeTableNode node, T t, Object v) {
                Object r = writer.apply(t, v);
                return r;
            }
        };
        this.getValueWriters().put(cls, (Object)wr);
        return this;
    }

    public Convertor<Column.Cell, Boolean> createWriter() {
        return new Convertor<Column.Cell, Boolean>(){

            public Boolean convert(Column.Cell cell) {
                TreeTableNode ttnode;
                Object dataOfNode;
                if (cell.object instanceof TreeTableNode && (dataOfNode = (ttnode = (TreeTableNode)cell.object).getData()) != null) {
                    Func3 writer = (Func3)TreeTableNodeValueColumn.this.getValueWriters().fetch(dataOfNode.getClass());
                    if (writer == null) {
                        return false;
                    }
                    Object writed = writer.apply((Object)ttnode, dataOfNode, cell.newValue);
                    return true;
                }
                return false;
            }
        };
    }

    public ClassMap<Func2<Class, Object, TreeTableNode>> getValueType() {
        if (this.valueType == null) {
            this.valueType = new ClassMap();
        }
        return this.valueType;
    }

    public <T> TreeTableNodeValueColumn addValueType(Class<T> cls, Func2<Class, Object, TreeTableNode> t) {
        if (cls == null) {
            throw new IllegalArgumentException("cls==null");
        }
        if (t == null) {
            throw new IllegalArgumentException("t==null");
        }
        this.getValueType().put(cls, t);
        return this;
    }

    public <T> TreeTableNodeValueColumn addValueType(final Class<T> cls, final Func1<Class, T> typeReader) {
        if (cls == null) {
            throw new IllegalArgumentException("cls==null");
        }
        if (typeReader == null) {
            throw new IllegalArgumentException("typeReader==null");
        }
        Func2<Class, Object, TreeTableNode> freader = new Func2<Class, Object, TreeTableNode>(){

            public Class apply(Object dataOfNode, TreeTableNode node) {
                if (dataOfNode != null && cls.isAssignableFrom(dataOfNode.getClass())) {
                    return (Class)typeReader.apply(dataOfNode);
                }
                return null;
            }
        };
        this.getValueType().put(cls, (Object)freader);
        return this;
    }

    public ClassMap<Func2<TreeTableNodeValueEditor.Editor, Object, TreeTableNode>> getValueEditor() {
        if (this.valueEditor != null) {
            return this.valueEditor;
        }
        this.valueEditor = new ClassMap();
        return this.valueEditor;
    }

    public <T> TreeTableNodeValueColumn addValueEditor(Class<T> cls, Func2<TreeTableNodeValueEditor.Editor, T, TreeTableNode> editorFun) {
        if (cls == null) {
            throw new IllegalArgumentException("cls==null");
        }
        if (editorFun == null) {
            throw new IllegalArgumentException("editorFun==null");
        }
        this.getValueEditor().put(cls, editorFun);
        return this;
    }

    public <T> TreeTableNodeValueColumn addValueEditor(final Class<T> cls, final Func1<TreeTableNodeValueEditor.Editor, T> editorFun) {
        if (cls == null) {
            throw new IllegalArgumentException("cls==null");
        }
        if (editorFun == null) {
            throw new IllegalArgumentException("editorFun==null");
        }
        Func2<TreeTableNodeValueEditor.Editor, Object, TreeTableNode> freader = new Func2<TreeTableNodeValueEditor.Editor, Object, TreeTableNode>(){

            public TreeTableNodeValueEditor.Editor apply(Object dataOfNode, TreeTableNode node) {
                if (dataOfNode != null && cls.isAssignableFrom(dataOfNode.getClass())) {
                    return (TreeTableNodeValueEditor.Editor)editorFun.apply(dataOfNode);
                }
                return null;
            }
        };
        this.getValueEditor().put(cls, (Object)freader);
        return this;
    }

    @Override
    public boolean isRowEditable(Object node) {
        if (node == null) {
            return false;
        }
        if (!(node instanceof TreeTableNode)) {
            return false;
        }
        TreeTableNode ttnode = (TreeTableNode)node;
        Object dataOfNode = ttnode.getData();
        if (dataOfNode != null) {
            Func3 writer = (Func3)this.getValueWriters().fetch(dataOfNode.getClass());
            Func2 editor = (Func2)this.getValueEditor().fetch(dataOfNode.getClass());
            if (writer != null || editor != null) {
                return true;
            }
        }
        return false;
    }
}

