/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.tree;

import java.awt.Component;
import java.beans.PropertyEditor;
import java.io.Closeable;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.EventObject;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import xyz.cofe.collection.Func2;
import xyz.cofe.collection.map.ClassMap;
import xyz.cofe.common.CloseableSet;
import xyz.cofe.common.ListenersHelper;
import xyz.cofe.gui.swing.bean.UiBean;
import xyz.cofe.gui.swing.properties.Property;
import xyz.cofe.gui.swing.properties.PropertyValue;
import xyz.cofe.gui.swing.properties.SetPropertyEditorOpts;
import xyz.cofe.gui.swing.properties.editor.EnumEditor;
import xyz.cofe.gui.swing.properties.editor.TreeTableWrapEditor;
import xyz.cofe.gui.swing.tree.TreeTableNodeValue;

public class TreeTableNodeValueEditor
implements TableCellEditor {
    private static final Logger logger = Logger.getLogger(TreeTableNodeValueEditor.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected final CellEditorListenerSupport listenersSupport = new CellEditorListenerSupport();
    protected Editor currentEditor = null;
    protected volatile Editor unsupportedEditor = null;
    protected ClassMap<Editor> typeEditors;
    protected TextFieldEditor textFieldEditor;
    protected WeakReference<JTable> editTable = null;
    protected WeakReference<Object> editValue = null;
    protected int editRow = -1;
    protected int editColumn = -1;
    protected EditorFinder editorFinder;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(TreeTableNodeValueEditor.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(TreeTableNodeValueEditor.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(TreeTableNodeValueEditor.class.getName(), method, result);
    }

    public Editor getCurrentEditor() {
        if (this.currentEditor != null) {
            return this.currentEditor;
        }
        this.currentEditor = this.getUnsupportedEditor();
        return this.currentEditor;
    }

    public void setCurrentEditor(Editor currentEditor) {
        if (this.currentEditor != null) {
            this.currentEditor.cancelCellEditing();
            this.currentEditor.clearAllListeners();
        }
        this.currentEditor = currentEditor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Editor getUnsupportedEditor() {
        if (this.unsupportedEditor != null) {
            return this.unsupportedEditor;
        }
        TreeTableNodeValueEditor treeTableNodeValueEditor = this;
        synchronized (treeTableNodeValueEditor) {
            if (this.unsupportedEditor != null) {
                return this.unsupportedEditor;
            }
            this.unsupportedEditor = this.createUnsupportedEditor(null);
            return this.unsupportedEditor;
        }
    }

    public UnsupportedEditor createUnsupportedEditor(String message) {
        UnsupportedEditor ed = new UnsupportedEditor(message);
        return ed;
    }

    public Editor createTextFieldEditor(TreeTableNodeValue ttnv) {
        BaseEditor ed = new BaseEditor();
        JTextField tf = new JTextField();
        ed.setComponent(tf);
        return ed;
    }

    public ClassMap<Editor> getTypeEditors() {
        if (this.typeEditors != null) {
            return this.typeEditors;
        }
        this.typeEditors = this.createTypeEditors();
        return this.typeEditors;
    }

    public void setTypeEditors(ClassMap<Editor> editors) {
        this.typeEditors = editors;
    }

    protected ClassMap<Editor> createTypeEditors() {
        ClassMap editors = new ClassMap();
        editors.put(String.class, (Object)this.getTextFieldEditor());
        return editors;
    }

    protected TextFieldEditor getTextFieldEditor() {
        if (this.textFieldEditor != null) {
            return this.textFieldEditor;
        }
        this.textFieldEditor = new TextFieldEditor();
        return this.textFieldEditor;
    }

    public EditorFinder getEditorFinder() {
        return this.editorFinder;
    }

    public void setEditorFinder(EditorFinder editorFinder) {
        this.editorFinder = editorFinder;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        Editor ed;
        this.editTable = new WeakReference<JTable>(table);
        this.editValue = new WeakReference<Object>(value);
        this.editRow = row;
        this.editColumn = column;
        EditorFinder edFinder = this.editorFinder;
        if (value instanceof TreeTableNodeValue) {
            Editor ed2;
            TreeTableNodeValue ttnv = (TreeTableNodeValue)value;
            Object val = ttnv.getValue();
            Editor customEditor = ttnv.getEditor();
            if (customEditor != null) {
                customEditor.startEditing(val, ttnv);
                this.setCurrentEditor(customEditor);
                return customEditor.getComponent();
            }
            Class valType = ttnv.getValueType();
            if (valType != null && (ed2 = (Editor)this.getTypeEditors().fetch(valType)) != null) {
                ed2.startEditing(val, ttnv);
                this.setCurrentEditor(ed2);
                return ed2.getComponent();
            }
            if (val instanceof String) {
                ed2 = this.getTextFieldEditor();
                this.setCurrentEditor(ed2);
                ed2.startEditing(val, ttnv);
                return ed2.getComponent();
            }
        } else if (value instanceof PropertyValue) {
            final PropertyValue propertyValue = (PropertyValue)value;
            Property prop = propertyValue.getProperty();
            Class<?> propType = prop != null ? prop.getPropertyType() : null;
            Object val = propertyValue.getValue();
            Throwable err = propertyValue.getError();
            if (err == null && prop != null && propType != null) {
                Class<?> propEditorClass = prop.getPropertyEditorClass();
                Editor ed3 = propertyValue.getEditor();
                if (ed3 != null) {
                    UiBean uib = prop.getUiBean();
                    if (ed3 instanceof SetPropertyEditorOpts) {
                        if (uib != null) {
                            String opts = uib.editorOpts();
                            if (opts != null) {
                                ((SetPropertyEditorOpts)((Object)ed3)).setPropertyEditorOpts(opts);
                            } else {
                                ((SetPropertyEditorOpts)((Object)ed3)).setPropertyEditorOpts("");
                            }
                        } else {
                            ((SetPropertyEditorOpts)((Object)ed3)).setPropertyEditorOpts("");
                        }
                    }
                    WrappedEditor we = new WrappedEditor(ed3){

                        @Override
                        public Object getCellEditorValue() {
                            Object eval = super.getCellEditorValue();
                            propertyValue.setValue(eval);
                            propertyValue.setError(null);
                            return propertyValue;
                        }
                    };
                    we.startEditing(val, propertyValue);
                    this.setCurrentEditor(we);
                    return we.getComponent();
                }
                ed3 = (Editor)this.getTypeEditors().fetch(propType);
                if (ed3 != null) {
                    UiBean uib = prop.getUiBean();
                    if (ed3 instanceof SetPropertyEditorOpts) {
                        if (uib != null) {
                            String opts = uib.editorOpts();
                            if (opts != null) {
                                ((SetPropertyEditorOpts)((Object)ed3)).setPropertyEditorOpts(opts);
                            } else {
                                ((SetPropertyEditorOpts)((Object)ed3)).setPropertyEditorOpts("");
                            }
                        } else {
                            ((SetPropertyEditorOpts)((Object)ed3)).setPropertyEditorOpts("");
                        }
                    }
                    WrappedEditor we = new WrappedEditor(ed3){

                        @Override
                        public Object getCellEditorValue() {
                            Object eval = super.getCellEditorValue();
                            propertyValue.setValue(eval);
                            propertyValue.setError(null);
                            return propertyValue;
                        }
                    };
                    we.startEditing(val, propertyValue);
                    this.setCurrentEditor(we);
                    return we.getComponent();
                }
                if (propEditorClass != null) {
                    try {
                        Object edInst = propEditorClass.newInstance();
                        if (edInst instanceof PropertyEditor) {
                            UiBean uib = prop.getUiBean();
                            if (edInst instanceof SetPropertyEditorOpts) {
                                if (uib != null) {
                                    String opts = uib.editorOpts();
                                    if (opts != null) {
                                        ((SetPropertyEditorOpts)edInst).setPropertyEditorOpts(opts);
                                    } else {
                                        ((SetPropertyEditorOpts)edInst).setPropertyEditorOpts("");
                                    }
                                } else {
                                    ((SetPropertyEditorOpts)edInst).setPropertyEditorOpts("");
                                }
                            }
                            TreeTableWrapEditor ttwe = new TreeTableWrapEditor((PropertyEditor)edInst);
                            WrappedEditor we = new WrappedEditor(ttwe){

                                @Override
                                public Object getCellEditorValue() {
                                    Object eval = super.getCellEditorValue();
                                    propertyValue.setValue(eval);
                                    propertyValue.setError(null);
                                    return propertyValue;
                                }
                            };
                            we.startEditing(val, propertyValue);
                            this.setCurrentEditor(we);
                            return we.getComponent();
                        }
                    }
                    catch (InstantiationException ex) {
                        Logger.getLogger(TreeTableNodeValueEditor.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (IllegalAccessException ex) {
                        Logger.getLogger(TreeTableNodeValueEditor.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                if (propType.isEnum()) {
                    boolean allowNull = true;
                    UiBean ub = prop.getUiBean();
                    if (ub != null && ub.forceNotNull()) {
                        allowNull = false;
                    }
                    EnumEditor enEd = new EnumEditor(propType, allowNull);
                    ed3 = enEd;
                    WrappedEditor we = new WrappedEditor(ed3){

                        @Override
                        public Object getCellEditorValue() {
                            Object eval = super.getCellEditorValue();
                            propertyValue.setValue(eval);
                            propertyValue.setError(null);
                            return propertyValue;
                        }
                    };
                    we.startEditing(val, propertyValue);
                    this.setCurrentEditor(we);
                    return we.getComponent();
                }
            }
        } else if (edFinder != null && (ed = edFinder.findEditor(table, value, isSelected, row, column)) != null) {
            WrappedEditor we = new WrappedEditor(ed);
            we.startEditing(value, null);
            this.setCurrentEditor(we);
            return we.getComponent();
        }
        ed = this.getUnsupportedEditor();
        this.setCurrentEditor(ed);
        ed.startEditing(null, value);
        return ed.getComponent();
    }

    @Override
    public Object getCellEditorValue() {
        return this.getCurrentEditor().getCellEditorValue();
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return this.getCurrentEditor().isCellEditable();
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return this.getCurrentEditor().isShouldSelectCell();
    }

    @Override
    public boolean stopCellEditing() {
        boolean res = this.getCurrentEditor().stopCellEditing();
        this.fireEditingStopped(this);
        return res;
    }

    @Override
    public void cancelCellEditing() {
        this.getCurrentEditor().cancelCellEditing();
        this.fireEditingCanceled(this);
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        if (l == null) {
            throw new IllegalArgumentException("l==null");
        }
        this.getCurrentEditor().addCellEditorListener(l);
        this.listenersSupport.addCellEditorListener(l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        if (l == null) {
            throw new IllegalArgumentException("l==null");
        }
        this.getCurrentEditor().removeCellEditorListener(l);
        this.listenersSupport.removeCellEditorListener(l);
    }

    public void fireEditingCanceled(Object src) {
        this.listenersSupport.fireEditingCanceled(src);
    }

    public void fireEditingStopped(Object src) {
        this.listenersSupport.fireEditingStopped(src);
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }

    public static interface EditorFinder {
        public Editor findEditor(JTable var1, Object var2, boolean var3, int var4, int var5);
    }

    public static class TextFieldEditor
    extends BaseEditor {
        protected JTextField textField = new JTextField();

        public TextFieldEditor() {
            this.textField.setBorder(new EmptyBorder(0, 0, 0, 0));
            this.setComponent(this.textField);
            this.setCellEditable(true);
            this.setShouldSelectCell(true);
        }

        @Override
        public Object getCellEditorValue() {
            return this.textField.getText();
        }

        @Override
        public void startEditing(Object value, Object context) {
            if (value instanceof String) {
                this.textField.setText((String)value);
            } else {
                this.textField.setText("");
            }
            super.startEditing(value, context);
        }
    }

    public static class UnsupportedEditor
    extends BaseEditor {
        protected JLabel label;
        protected WeakReference startValue = null;

        public UnsupportedEditor(String message) {
            this.label = new JLabel(message == null ? "not supported" : message);
            this.setComponent(this.label);
            this.setCellEditable(false);
        }

        @Override
        public Object getCellEditorValue() {
            if (this.startValue != null) {
                Object v = this.startValue.get();
                return v;
            }
            return super.getCellEditorValue();
        }

        @Override
        public void startEditing(Object value, Object context) {
            this.startValue = new WeakReference<Object>(value);
            super.startEditing(value, context);
        }

        @Override
        public JComponent getComponent() {
            return this.label;
        }
    }

    public static class WrappedEditor
    implements Editor,
    Closeable {
        protected Editor source;
        protected CellEditorListener sourceListener = new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                ChangeEvent ce = new ChangeEvent(this);
                WrappedEditor.this.fireEditingStopped(ce);
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
                ChangeEvent ce = new ChangeEvent(this);
                WrappedEditor.this.fireEditingCanceled(ce);
            }
        };
        protected final CellEditorListenerSupport listeners = new CellEditorListenerSupport();

        public WrappedEditor(Editor source) {
            if (source == null) {
                throw new IllegalArgumentException("source==null");
            }
            this.source = source;
            this.source.addCellEditorListener(this.sourceListener);
        }

        @Override
        public void close() throws IOException {
            if (this.source != null) {
                this.source.removeCellEditorListener(this.sourceListener);
                this.source = null;
            }
        }

        @Override
        public JComponent getComponent() {
            if (this.source == null) {
                return null;
            }
            return this.source.getComponent();
        }

        @Override
        public void startEditing(Object value, Object context) {
            if (this.source == null) {
                return;
            }
            this.source.startEditing(value, context);
        }

        @Override
        public boolean stopCellEditing() {
            if (this.source == null) {
                return true;
            }
            return this.source.stopCellEditing();
        }

        @Override
        public void cancelCellEditing() {
            if (this.source == null) {
                return;
            }
            this.source.cancelCellEditing();
        }

        @Override
        public Object getCellEditorValue() {
            if (this.source == null) {
                return null;
            }
            return this.source.getCellEditorValue();
        }

        @Override
        public boolean isCellEditable() {
            if (this.source == null) {
                return false;
            }
            return this.source.isCellEditable();
        }

        @Override
        public boolean isShouldSelectCell() {
            if (this.source == null) {
                return false;
            }
            return this.source.isShouldSelectCell();
        }

        @Override
        public void clearAllListeners() {
            this.listeners.clearAllListeners();
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
            this.listeners.addCellEditorListener(l);
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
            this.listeners.removeCellEditorListener(l);
        }

        @Override
        public void fireEditingCanceled(Object src) {
            this.listeners.fireEditingCanceled(src);
        }

        @Override
        public void fireEditingStopped(Object src) {
            this.listeners.fireEditingStopped(src);
        }
    }

    public static class BaseEditor
    implements Editor {
        protected JComponent component;
        protected boolean cellEditable = true;
        protected boolean shouldSelectCell = true;
        protected final CellEditorListenerSupport listeners = new CellEditorListenerSupport();
        private static Icon editIcon;
        private static Icon nullIcon;
        private static Icon nullSelectedIcon;
        private static Icon nullUnSelectedIcon;

        @Override
        public JComponent getComponent() {
            return this.component;
        }

        public void setComponent(JComponent component) {
            this.component = component;
        }

        @Override
        public void startEditing(Object value, Object context) {
            JComponent cmpt = this.getComponent();
        }

        @Override
        public boolean stopCellEditing() {
            JComponent cmpt = this.getComponent();
            return true;
        }

        @Override
        public void cancelCellEditing() {
            JComponent cmpt = this.getComponent();
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }

        public void setCellEditable(boolean v) {
            this.cellEditable = true;
        }

        @Override
        public boolean isCellEditable() {
            return this.cellEditable;
        }

        @Override
        public boolean isShouldSelectCell() {
            return this.shouldSelectCell;
        }

        public void setShouldSelectCell(boolean shouldSelectCell) {
            this.shouldSelectCell = shouldSelectCell;
        }

        @Override
        public void clearAllListeners() {
            this.listeners.clearAllListeners();
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
            this.listeners.addCellEditorListener(l);
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
            this.listeners.removeCellEditorListener(l);
        }

        @Override
        public void fireEditingCanceled(Object src) {
            this.listeners.fireEditingCanceled(src);
        }

        @Override
        public void fireEditingStopped(Object src) {
            this.listeners.fireEditingStopped(src);
        }

        public static Icon getEditIcon() {
            return editIcon;
        }

        public static Icon getNullIcon() {
            return nullIcon;
        }

        public static Icon getNullSelectedIcon() {
            return nullSelectedIcon;
        }

        public static Icon getNullUnSelectedIcon() {
            return nullUnSelectedIcon;
        }

        static {
            URL u = TreeTableNodeValueEditor.class.getResource("/xyz/cofe/gui/swing/properties/editors/gtk-edit_16.png");
            if (u != null) {
                editIcon = new ImageIcon(u);
            }
            if ((u = TreeTableNodeValueEditor.class.getResource("/xyz/cofe/gui/swing/properties/editors/null.png")) != null) {
                nullIcon = new ImageIcon(u);
            }
            if ((u = TreeTableNodeValueEditor.class.getResource("/xyz/cofe/gui/swing/properties/editors/null-a-001.png")) != null) {
                nullSelectedIcon = new ImageIcon(u);
            }
            if ((u = TreeTableNodeValueEditor.class.getResource("/xyz/cofe/gui/swing/properties/editors/null-b-002.png")) != null) {
                nullUnSelectedIcon = new ImageIcon(u);
            }
        }
    }

    public static interface Editor {
        public JComponent getComponent();

        public void startEditing(Object var1, Object var2);

        public boolean stopCellEditing();

        public void cancelCellEditing();

        public Object getCellEditorValue();

        public boolean isCellEditable();

        public boolean isShouldSelectCell();

        public void clearAllListeners();

        public void addCellEditorListener(CellEditorListener var1);

        public void removeCellEditorListener(CellEditorListener var1);

        public void fireEditingCanceled(Object var1);

        public void fireEditingStopped(Object var1);
    }

    public static class CellEditorListenerSupport {
        protected ListenersHelper<CellEditorListener, ChangeEvent> listeners = new ListenersHelper((Func2)new Func2<Object, CellEditorListener, ChangeEvent>(){

            public Object apply(CellEditorListener lstn, ChangeEvent ev) {
                if (lstn != null) {
                    if (ev instanceof EditingCanceledEvent) {
                        lstn.editingCanceled(ev);
                    } else if (ev instanceof EditingStoppedEvent) {
                        lstn.editingStopped(ev);
                    }
                }
                return null;
            }
        });
        protected CloseableSet listenersCs = new CloseableSet();

        public ListenersHelper<CellEditorListener, ChangeEvent> getListenersHelper() {
            return this.listeners;
        }

        public void clearAllListeners() {
            this.listenersCs.closeAll();
        }

        public void addCellEditorListener(CellEditorListener l) {
            if (l == null) {
                throw new IllegalArgumentException("l==null");
            }
            this.listenersCs.add(this.listeners.addListener((Object)l));
        }

        public void removeCellEditorListener(CellEditorListener l) {
            if (l == null) {
                throw new IllegalArgumentException("l==null");
            }
            this.listeners.removeListener((Object)l);
        }

        public void fireEditingCanceled(Object src) {
            this.listeners.fireEvent((Object)new EditingCanceledEvent(src));
        }

        public void fireEditingStopped(Object src) {
            this.listeners.fireEvent((Object)new EditingStoppedEvent(src));
        }
    }

    public static class EditingStoppedEvent
    extends ChangeEvent {
        public EditingStoppedEvent(Object source) {
            super(source);
        }
    }

    public static class EditingCanceledEvent
    extends ChangeEvent {
        public EditingCanceledEvent(Object source) {
            super(source);
        }
    }
}

