/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.tree;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import xyz.cofe.collection.Func1;
import xyz.cofe.collection.map.ClassMap;
import xyz.cofe.gui.swing.tree.TreeTableNodeValueEditor;

public class TreeTableNodeValueEditorDef
extends TreeTableNodeValueEditor {
    private static final Logger logger = Logger.getLogger(TreeTableNodeValueEditorDef.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(TreeTableNodeValueEditorDef.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(TreeTableNodeValueEditorDef.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(TreeTableNodeValueEditorDef.class.getName(), method, result);
    }

    @Override
    protected ClassMap<TreeTableNodeValueEditor.Editor> createTypeEditors() {
        ClassMap<TreeTableNodeValueEditor.Editor> editors = super.createTypeEditors();
        editors.put(Integer.class, new ConvertTextFieldEditor<Object>(new Func1<Integer, String>(){

            public Integer apply(String str) {
                return "null".equals(str) ? null : Integer.valueOf(Integer.parseInt(str));
            }
        }, new Func1<String, Integer>(){

            public String apply(Integer val) {
                return val != null ? val.toString() : "null";
            }
        }, null));
        editors.put(Integer.TYPE, new ConvertTextFieldEditor<Object>(new Func1<Integer, String>(){

            public Integer apply(String str) {
                return Integer.parseInt(str);
            }
        }, new Func1<String, Integer>(){

            public String apply(Integer val) {
                return val != null ? val.toString() : "null";
            }
        }, null));
        editors.put(Short.TYPE, new ConvertTextFieldEditor<Object>(new Func1<Short, String>(){

            public Short apply(String str) {
                return "null".equals(str) ? null : Short.valueOf(Short.parseShort(str));
            }
        }, new Func1<String, Short>(){

            public String apply(Short val) {
                return val != null ? val.toString() : "null";
            }
        }, null));
        editors.put(Short.class, new ConvertTextFieldEditor<Object>(new Func1<Short, String>(){

            public Short apply(String str) {
                return Short.parseShort(str);
            }
        }, new Func1<String, Short>(){

            public String apply(Short val) {
                return val != null ? val.toString() : "null";
            }
        }, null));
        editors.put(Byte.TYPE, new ConvertTextFieldEditor<Object>(new Func1<Byte, String>(){

            public Byte apply(String str) {
                return "null".equals(str) ? null : Byte.valueOf(Byte.parseByte(str));
            }
        }, new Func1<String, Byte>(){

            public String apply(Byte val) {
                return val != null ? val.toString() : "null";
            }
        }, null));
        editors.put(Byte.class, new ConvertTextFieldEditor<Object>(new Func1<Byte, String>(){

            public Byte apply(String str) {
                return Byte.parseByte(str);
            }
        }, new Func1<String, Byte>(){

            public String apply(Byte val) {
                return val != null ? val.toString() : "null";
            }
        }, null));
        editors.put(Long.TYPE, new ConvertTextFieldEditor<Object>(new Func1<Long, String>(){

            public Long apply(String str) {
                return "null".equals(str) ? null : Long.valueOf(Long.parseLong(str));
            }
        }, new Func1<String, Long>(){

            public String apply(Long val) {
                return val != null ? val.toString() : "null";
            }
        }, null));
        editors.put(Long.class, new ConvertTextFieldEditor<Object>(new Func1<Long, String>(){

            public Long apply(String str) {
                return Long.parseLong(str);
            }
        }, new Func1<String, Long>(){

            public String apply(Long val) {
                return val != null ? val.toString() : "null";
            }
        }, null));
        editors.put(Float.TYPE, new ConvertTextFieldEditor<Object>(new Func1<Float, String>(){

            public Float apply(String str) {
                return "null".equals(str) ? null : Float.valueOf(Float.parseFloat(str));
            }
        }, new Func1<String, Float>(){

            public String apply(Float val) {
                return val != null ? val.toString() : "null";
            }
        }, null));
        editors.put(Float.class, new ConvertTextFieldEditor<Object>(new Func1<Float, String>(){

            public Float apply(String str) {
                return Float.valueOf(Float.parseFloat(str));
            }
        }, new Func1<String, Float>(){

            public String apply(Float val) {
                return val != null ? val.toString() : "null";
            }
        }, null));
        editors.put(Double.TYPE, new ConvertTextFieldEditor<Object>(new Func1<Double, String>(){

            public Double apply(String str) {
                return "null".equals(str) ? null : Double.valueOf(Double.parseDouble(str));
            }
        }, new Func1<String, Double>(){

            public String apply(Double val) {
                return val != null ? val.toString() : "null";
            }
        }, null));
        editors.put(Double.class, new ConvertTextFieldEditor<Object>(new Func1<Double, String>(){

            public Double apply(String str) {
                return Double.parseDouble(str);
            }
        }, new Func1<String, Double>(){

            public String apply(Double val) {
                return val != null ? val.toString() : "null";
            }
        }, null));
        editors.put(Boolean.TYPE, new ConvertTextFieldEditor<Object>(new Func1<Boolean, String>(){

            public Boolean apply(String str) {
                return "null".equals(str) ? null : Boolean.valueOf(str.trim().equalsIgnoreCase("true"));
            }
        }, new Func1<String, Boolean>(){

            public String apply(Boolean val) {
                return val != null ? val.toString() : "null";
            }
        }, null));
        editors.put(Boolean.class, new ConvertTextFieldEditor<Object>(new Func1<Boolean, String>(){

            public Boolean apply(String str) {
                return "null".equals(str) ? null : Boolean.valueOf(str.trim().equalsIgnoreCase("true"));
            }
        }, new Func1<String, Boolean>(){

            public String apply(Boolean val) {
                return val != null ? val.toString() : "null";
            }
        }, null));
        return editors;
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }

    public static class ConvertTextFieldEditor<T>
    extends TreeTableNodeValueEditor.TextFieldEditor {
        protected Func1<T, String> parser;
        protected Func1<String, T> serializer;
        protected T defValue;

        public Func1<T, String> getParser() {
            return this.parser;
        }

        public void setParser(Func1<T, String> parser) {
            this.parser = parser;
        }

        @Override
        public Object getCellEditorValue() {
            try {
                Object ostr = super.getCellEditorValue();
                Func1<T, String> prsr = this.parser;
                if (prsr == null) {
                    throw new IllegalStateException("parser not set");
                }
                if (ostr == null) {
                    throw new IllegalStateException("return null string");
                }
                return prsr.apply((Object)ostr.toString());
            }
            catch (Throwable err) {
                JOptionPane.showMessageDialog(null, err.getMessage(), "parse error", 0);
                return this.defValue;
            }
        }

        public Func1<String, T> getSerializer() {
            return this.serializer;
        }

        public void setSerializer(Func1<String, T> serializer) {
            this.serializer = serializer;
        }

        @Override
        public void startEditing(Object value, Object context) {
            try {
                Func1<String, T> srlz = this.getSerializer();
                if (srlz == null) {
                    throw new IllegalStateException("serializer not set");
                }
                String str = (String)srlz.apply(value);
                super.startEditing(str, context);
            }
            catch (Throwable err) {
                JOptionPane.showMessageDialog(null, err.getMessage(), "serilize error", 0);
            }
        }

        public T getDefValue() {
            return this.defValue;
        }

        public void setDefValue(T defValue) {
            this.defValue = defValue;
        }

        public ConvertTextFieldEditor(Func1<T, String> parser, Func1<String, T> serializer, T defValue) {
            this.parser = parser;
            this.serializer = serializer;
            this.defValue = defValue;
        }
    }
}

