/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.tree;

import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.BasicPair;
import xyz.cofe.collection.Pair;
import xyz.cofe.common.Reciver;
import xyz.cofe.gui.swing.table.RowData;
import xyz.cofe.gui.swing.table.SortRowTM;
import xyz.cofe.gui.swing.tree.TreeTableModelInterface;
import xyz.cofe.gui.swing.tree.TreeTableNode;

public class TreeTableSortModel
extends SortRowTM
implements TreeTableModelInterface {
    private static final Logger logger = Logger.getLogger(TreeTableSortModel.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;

    private static boolean eq(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null && b != null) {
            return false;
        }
        if (a != null && b == null) {
            return false;
        }
        return a.equals(b);
    }

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(TreeTableSortModel.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(TreeTableSortModel.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(TreeTableSortModel.class.getName(), method, result);
    }

    public TreeTableSortModel(TreeTableModelInterface dm) {
        this(dm, null);
    }

    public TreeTableSortModel(TreeTableModelInterface dm, final Reciver<Pair<RowData, RowData>> dumpDetail) {
        if (dm == null) {
            throw new IllegalArgumentException("dm==null");
        }
        this.setRowComparator(new Comparator<RowData>(){

            @Override
            public int compare(RowData row1, RowData row2) {
                int ro2;
                TreeTableNode ttn2;
                int ri1 = row1.getRowIndex();
                int ri2 = row2.getRowIndex();
                Object onode1 = row1.getValue(0);
                Object onode2 = row2.getValue(0);
                if (onode1 == null || onode2 == null) {
                    return 0;
                }
                TreeTableNode ttn1 = onode1 instanceof TreeTableNode ? (TreeTableNode)onode1 : null;
                TreeTableNode treeTableNode = ttn2 = onode2 instanceof TreeTableNode ? (TreeTableNode)onode2 : null;
                if (ttn1 == null || ttn2 == null) {
                    if (dumpDetail != null) {
                        dumpDetail.recive((Object)new BasicPair((Object)row1, (Object)row2));
                    }
                    throw new Error("sort fail\no1=" + onode1 + "\no2=" + onode2);
                }
                int ro1 = ttn1.getRootOffset();
                int cmp = ro1 == (ro2 = ttn2.getRootOffset()) ? 0 : (ro1 < ro2 ? -1 : 1);
                return cmp;
            }
        });
        this.setTableModel(dm);
        this.setSourceListen(true);
        this.applySort();
        this.fireAllChanged();
    }

    @Override
    public synchronized TreeTableNode getNodeOf(int row) {
        int directRow = this.mapRowToInside(row);
        if (directRow < 0) {
            return null;
        }
        return ((TreeTableModelInterface)this.getTableModel()).getNodeOf(directRow);
    }

    @Override
    public synchronized int getRowOf(TreeTableNode node) {
        if (node == null) {
            return -1;
        }
        int directrow = ((TreeTableModelInterface)this.getTableModel()).getRowOf(node);
        if (directrow < 0) {
            return -1;
        }
        int sortrow = this.mapRowToOutside(directrow);
        return sortrow;
    }

    @Override
    public boolean isRootVisible() {
        return ((TreeTableModelInterface)this.getTableModel()).isRootVisible();
    }

    @Override
    public TreeTableNode getRoot() {
        return ((TreeTableModelInterface)this.getTableModel()).getRoot();
    }

    @Override
    public void setRoot(TreeTableNode root) {
        ((TreeTableModelInterface)this.getTableModel()).setRoot(root);
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

