/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.tree.ob;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import xyz.cofe.collection.Func1;
import xyz.cofe.collection.Func2;
import xyz.cofe.collection.Func3;
import xyz.cofe.collection.NodesExtracter;
import xyz.cofe.collection.map.ClassMap;
import xyz.cofe.common.CloseableSet;
import xyz.cofe.common.Reciver;
import xyz.cofe.gui.swing.tree.TreeTableNodeBasic;
import xyz.cofe.gui.swing.tree.TreeTableNodeFormat;
import xyz.cofe.gui.swing.tree.ob.Context;
import xyz.cofe.gui.swing.tree.ob.ContextMenu;
import xyz.cofe.gui.swing.tree.ob.Followable;
import xyz.cofe.gui.swing.tree.ob.FollowableExtracter;
import xyz.cofe.gui.swing.tree.ob.FollowerMap;
import xyz.cofe.gui.swing.tree.ob.FormatMap;
import xyz.cofe.gui.swing.tree.ob.NamedCollection;
import xyz.cofe.gui.swing.tree.ob.ObjectBrowser;

public class ContextBuilder<T>
implements Context<T>,
AutoCloseable {
    private static final Logger logger = Logger.getLogger(ContextBuilder.class.getName());
    private boolean applied;
    private Class<T> cls;
    private ObjectBrowser baseObjectBrowser;
    private final ConcurrentLinkedQueue<Runnable> applyQueue;
    private final CloseableSet cset;

    private static Level logLevel() {
        return logger.getLevel();
    }

    private static boolean isLogSevere() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.SEVERE.intValue();
    }

    private static boolean isLogWarning() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.WARNING.intValue();
    }

    private static boolean isLogInfo() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.INFO.intValue();
    }

    private static boolean isLogFine() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINE.intValue();
    }

    private static boolean isLogFiner() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINER.intValue();
    }

    private static boolean isLogFinest() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(ContextBuilder.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(ContextBuilder.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(ContextBuilder.class.getName(), method, result);
    }

    public ContextBuilder(ObjectBrowser ob, Class<T> cls) {
        if (cls == null) {
            throw new IllegalArgumentException("cls == null");
        }
        if (ob == null) {
            throw new IllegalArgumentException("ob == null");
        }
        this.applied = false;
        this.cls = cls;
        this.baseObjectBrowser = ob;
        this.applyQueue = new ConcurrentLinkedQueue();
        this.cset = new CloseableSet();
    }

    public Class<T> getContextClass() {
        return this.cls;
    }

    @Override
    public synchronized Context<T> naming(final Func1<String, T> nameFn) {
        if (nameFn == null) {
            throw new IllegalArgumentException("nameFn == null");
        }
        if (this.applied) {
            throw new IllegalStateException("already applied");
        }
        if (this.baseObjectBrowser == null) {
            throw new IllegalArgumentException("BaseObjectBrowser(ob field) not set");
        }
        final WeakReference<ObjectBrowser> fob = new WeakReference<ObjectBrowser>(this.baseObjectBrowser);
        this.applyQueue.add(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ObjectBrowser bob = (ObjectBrowser)fob.get();
                if (bob == null) {
                    throw new IllegalStateException("apply fail : BaseObjectBrowser(ob field) not set");
                }
                ClassMap<Func1<String, Object>> classMap = bob.getNamingMap();
                synchronized (classMap) {
                    bob.getNamingMap().put(ContextBuilder.this.cls, (Object)nameFn);
                }
                ContextBuilder.this.cset.add(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        ObjectBrowser bob = (ObjectBrowser)fob.get();
                        if (bob == null) {
                            return;
                        }
                        ClassMap<Func1<String, Object>> classMap = bob.getNamingMap();
                        synchronized (classMap) {
                            Object existsVal = bob.getNamingMap().get(ContextBuilder.this.cls);
                            if (existsVal == nameFn) {
                                bob.getNamingMap().remove(ContextBuilder.this.cls);
                            }
                        }
                    }
                });
            }
        });
        return this;
    }

    @Override
    public synchronized <A> Context<T> follower(final NodesExtracter<T, A> followerFn, final Followable<T> followable) {
        if (followerFn == null) {
            throw new IllegalArgumentException("followerFn == null");
        }
        if (followable == null) {
            throw new IllegalArgumentException("followable == null");
        }
        if (this.applied) {
            throw new IllegalStateException("already applied");
        }
        final WeakReference<ObjectBrowser> fob = new WeakReference<ObjectBrowser>(this.baseObjectBrowser);
        this.applyQueue.add(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ObjectBrowser bob = (ObjectBrowser)fob.get();
                if (bob == null) {
                    throw new IllegalStateException("apply fail : BaseObjectBrowser(ob field) not set");
                }
                FollowableExtracter fe = new FollowableExtracter(followerFn, followable);
                FollowerMap followerMap = bob.getFollowerMap();
                synchronized (followerMap) {
                    bob.getFollowerMap().add(ContextBuilder.this.cls, fe);
                }
                final WeakReference<FollowableExtracter> ffe = new WeakReference<FollowableExtracter>(fe);
                ContextBuilder.this.cset.add(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        ObjectBrowser bob = (ObjectBrowser)fob.get();
                        if (bob == null) {
                            return;
                        }
                        FollowableExtracter fe = (FollowableExtracter)ffe.get();
                        if (fe == null) {
                            return;
                        }
                        FollowerMap followerMap = bob.getFollowerMap();
                        synchronized (followerMap) {
                            bob.getFollowerMap().remove(ContextBuilder.this.cls, fe);
                        }
                    }
                });
            }
        });
        return this;
    }

    @Override
    public <A> Context<T> follower(final NodesExtracter<T, A> followerFn) {
        if (this.applied) {
            throw new IllegalStateException("already applied");
        }
        if (followerFn == null) {
            throw new IllegalArgumentException("followerFn == null");
        }
        final WeakReference<ObjectBrowser> fob = new WeakReference<ObjectBrowser>(this.baseObjectBrowser);
        this.applyQueue.add(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ObjectBrowser bob = (ObjectBrowser)fob.get();
                if (bob == null) {
                    throw new IllegalStateException("apply fail : BaseObjectBrowser(ob field) not set");
                }
                FollowerMap followerMap = bob.getFollowerMap();
                synchronized (followerMap) {
                    bob.getFollowerMap().add(ContextBuilder.this.cls, followerFn);
                }
                final WeakReference<NodesExtracter> ffe = new WeakReference<NodesExtracter>(followerFn);
                ContextBuilder.this.cset.add(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        ObjectBrowser bob = (ObjectBrowser)fob.get();
                        if (bob == null) {
                            return;
                        }
                        NodesExtracter fe = (NodesExtracter)ffe.get();
                        if (fe == null) {
                            return;
                        }
                        FollowerMap followerMap = bob.getFollowerMap();
                        synchronized (followerMap) {
                            bob.getFollowerMap().remove(ContextBuilder.this.cls, fe);
                        }
                    }
                });
            }
        });
        return this;
    }

    public Context<T> followable(final Func1<Boolean, T> followableFn) {
        if (followableFn == null) {
            throw new IllegalArgumentException("followableFn == null");
        }
        if (this.applied) {
            throw new IllegalStateException("already applied");
        }
        final WeakReference<ObjectBrowser> fob = new WeakReference<ObjectBrowser>(this.baseObjectBrowser);
        this.applyQueue.add(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ObjectBrowser bob = (ObjectBrowser)fob.get();
                if (bob == null) {
                    throw new IllegalStateException("apply fail : BaseObjectBrowser(ob field) not set");
                }
                ClassMap<Func1<Boolean, Object>> classMap = bob.getFollowableMap();
                synchronized (classMap) {
                    bob.getFollowableMap().put(ContextBuilder.this.cls, (Object)followableFn);
                }
                final WeakReference<Func1> ffe = new WeakReference<Func1>(followableFn);
                ContextBuilder.this.cset.add(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        ObjectBrowser bob = (ObjectBrowser)fob.get();
                        if (bob == null) {
                            return;
                        }
                        Func1 fe = (Func1)ffe.get();
                        if (fe == null) {
                            return;
                        }
                        ClassMap<Func1<Boolean, Object>> classMap = bob.getFollowableMap();
                        synchronized (classMap) {
                            Object v = bob.getFollowableMap().get(ContextBuilder.this.cls);
                            if (v == fe) {
                                bob.getFollowableMap().remove(ContextBuilder.this.cls);
                            }
                        }
                    }
                });
            }
        });
        return this;
    }

    @Override
    public synchronized Context<T> format(final Func1<TreeTableNodeFormat, T> fmtfn) {
        if (fmtfn == null) {
            throw new IllegalArgumentException("fmtfn == null");
        }
        if (this.applied) {
            throw new IllegalStateException("already applied");
        }
        final WeakReference<ObjectBrowser> fob = new WeakReference<ObjectBrowser>(this.baseObjectBrowser);
        this.applyQueue.add(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ObjectBrowser bob = (ObjectBrowser)fob.get();
                if (bob == null) {
                    throw new IllegalStateException("apply fail : BaseObjectBrowser(ob field) not set");
                }
                FormatMap formatMap = bob.getFormatMap();
                synchronized (formatMap) {
                    bob.getFormatMap().put(ContextBuilder.this.cls, fmtfn);
                }
                final WeakReference<Func1> ffe = new WeakReference<Func1>(fmtfn);
                ContextBuilder.this.cset.add(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        ObjectBrowser bob = (ObjectBrowser)fob.get();
                        if (bob == null) {
                            return;
                        }
                        Func1 fe = (Func1)ffe.get();
                        if (fe == null) {
                            return;
                        }
                        FormatMap formatMap = bob.getFormatMap();
                        synchronized (formatMap) {
                            Object v = bob.getFormatMap().get(ContextBuilder.this.cls);
                            if (v == fe) {
                                bob.getFormatMap().remove(ContextBuilder.this.cls);
                            }
                        }
                    }
                });
            }
        });
        return this;
    }

    @Override
    public synchronized Context<T> icon(final Func1<Icon, T> iconFun) {
        if (this.applied) {
            throw new IllegalStateException("already applied");
        }
        final WeakReference<ObjectBrowser> fob = new WeakReference<ObjectBrowser>(this.baseObjectBrowser);
        this.applyQueue.add(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ObjectBrowser bob = (ObjectBrowser)fob.get();
                if (bob == null) {
                    throw new IllegalStateException("apply fail : BaseObjectBrowser(ob field) not set");
                }
                ClassMap<Func1<Icon, Object>> classMap = bob.getTypeIconMap();
                synchronized (classMap) {
                    if (iconFun != null) {
                        bob.getTypeIconMap().put(ContextBuilder.this.cls, (Object)iconFun);
                    } else {
                        bob.getTypeIconMap().remove(ContextBuilder.this.cls);
                    }
                }
                if (iconFun != null) {
                    final WeakReference<Func1> ffe = new WeakReference<Func1>(iconFun);
                    ContextBuilder.this.cset.add(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            ObjectBrowser bob = (ObjectBrowser)fob.get();
                            if (bob == null) {
                                return;
                            }
                            Func1 fe = (Func1)ffe.get();
                            if (fe == null) {
                                return;
                            }
                            ClassMap<Func1<Icon, Object>> classMap = bob.getTypeIconMap();
                            synchronized (classMap) {
                                Object v = bob.getTypeIconMap().get(ContextBuilder.this.cls);
                                if (v == fe) {
                                    bob.getTypeIconMap().remove(ContextBuilder.this.cls);
                                }
                            }
                        }
                    });
                }
            }
        });
        return this;
    }

    @Override
    public synchronized Context<T> icon(final Icon ico) {
        if (ico == null) {
            return this.icon((Func1)null);
        }
        return this.icon(new Func1<Icon, T>(){

            public Icon apply(T arg) {
                return ico;
            }
        });
    }

    @Override
    public ContextMenu<T> menu() {
        return new ContextMenuBuilder(this);
    }

    @Override
    public ContextMenu<T> menu(boolean matchSoft) {
        return new ContextMenuBuilder(this, matchSoft);
    }

    @Override
    public synchronized Context<T> leftClick(Func3<Object, T, TreeTableNodeBasic, MouseEvent> clickfn) {
        return this.leftClick(false, clickfn);
    }

    @Override
    public synchronized Context<T> leftDblClick(Func3<Object, T, TreeTableNodeBasic, MouseEvent> clickfn) {
        return this.leftClick(true, clickfn);
    }

    public synchronized Context<T> leftClick(final boolean dblClick, final Func3<Object, T, TreeTableNodeBasic, MouseEvent> clickfn) {
        if (clickfn == null) {
            return null;
        }
        this.applyQueue.add(new Runnable(){

            @Override
            public void run() {
                if (ContextBuilder.this.baseObjectBrowser == null) {
                    return;
                }
                Func3<Object, MouseEvent, TreeTableNodeBasic, Object> clickFn = new Func3<Object, MouseEvent, TreeTableNodeBasic, Object>(){

                    public Object apply(MouseEvent arg1, TreeTableNodeBasic arg2, Object arg3) {
                        clickfn.apply(arg2.getData(), (Object)arg2, (Object)arg1);
                        return null;
                    }
                };
                NamedCollection ncol = new NamedCollection();
                ncol.values(clickFn);
                if (dblClick) {
                    ContextBuilder.this.baseObjectBrowser.getLeftMouseDblClick().add(ContextBuilder.this.cls, (NodesExtracter)ncol);
                } else {
                    ContextBuilder.this.baseObjectBrowser.getLeftMouseClick().add(ContextBuilder.this.cls, (NodesExtracter)ncol);
                }
                final WeakReference<ObjectBrowser> fbob = new WeakReference<ObjectBrowser>(ContextBuilder.this.baseObjectBrowser);
                final WeakReference<Class> fcls = new WeakReference<Class>(ContextBuilder.this.cls);
                final WeakReference<NamedCollection> fncol = new WeakReference<NamedCollection>(ncol);
                if (ContextBuilder.this.cset != null) {
                    ContextBuilder.this.cset.add(new Runnable(){

                        @Override
                        public void run() {
                            ObjectBrowser bob = (ObjectBrowser)fbob.get();
                            Class cls = (Class)fcls.get();
                            NamedCollection nc = (NamedCollection)fncol.get();
                            if (bob == null || cls == null || nc == null) {
                                return;
                            }
                            bob.getLeftMouseClick().remove(cls, (NodesExtracter)nc);
                            bob.getLeftMouseDblClick().remove(cls, (NodesExtracter)nc);
                        }
                    });
                }
            }
        });
        return this;
    }

    @Override
    public synchronized AutoCloseable apply() {
        Runnable r;
        if (this.applied) {
            throw new IllegalStateException("already applied");
        }
        while ((r = this.applyQueue.poll()) != null) {
            r.run();
        }
        this.cset.add(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ContextBuilder contextBuilder = ContextBuilder.this;
                synchronized (contextBuilder) {
                    ContextBuilder.this.applied = false;
                }
            }
        });
        this.baseObjectBrowser = null;
        return this;
    }

    @Override
    public void close() throws Exception {
        this.cset.closeAll();
        this.baseObjectBrowser = null;
    }

    public static class ContextMenuBuilder<T>
    implements ContextMenu<T> {
        private ContextBuilder<T> cb;
        private boolean contextMenuBuilder;
        private String label;
        private Icon icon;
        private List<Func2<Object, TreeTableNodeBasic, T>> callList;

        public ContextMenuBuilder(ContextBuilder<T> cb) {
            if (cb == null) {
                throw new IllegalArgumentException("cb == null");
            }
            this.cb = cb;
            this.callList = new ArrayList<Func2<Object, TreeTableNodeBasic, T>>();
            this.contextMenuBuilder = false;
        }

        public ContextMenuBuilder(ContextBuilder<T> cb, boolean ctxmbld) {
            if (cb == null) {
                throw new IllegalArgumentException("cb == null");
            }
            this.cb = cb;
            this.callList = new ArrayList<Func2<Object, TreeTableNodeBasic, T>>();
            this.contextMenuBuilder = ctxmbld;
        }

        @Override
        public ContextMenu<T> label(String label) {
            this.label = label;
            return this;
        }

        @Override
        public ContextMenu<T> icon(Icon icon) {
            this.icon = icon;
            return this;
        }

        @Override
        public ContextMenu<T> call(final Reciver<T> callfn) {
            if (callfn == null) {
                throw new IllegalArgumentException("callfn == null");
            }
            this.callList.add(new Func2<Object, TreeTableNodeBasic, T>(){

                public Object apply(TreeTableNodeBasic arg1, T arg2) {
                    callfn.recive(arg2);
                    return null;
                }
            });
            return this;
        }

        @Override
        public ContextMenu<T> call(Func2<Object, TreeTableNodeBasic, T> callfn) {
            if (callfn == null) {
                throw new IllegalArgumentException("callfn == null");
            }
            this.callList.add(callfn);
            return this;
        }

        @Override
        public Context<T> add() {
            final WeakReference<ObjectBrowser> fbob = new WeakReference<ObjectBrowser>(((ContextBuilder)this.cb).baseObjectBrowser);
            final String flabel = this.label;
            final Icon ico = this.icon;
            final ArrayList<Func2<Object, TreeTableNodeBasic, T>> recivers = new ArrayList<Func2<Object, TreeTableNodeBasic, T>>();
            recivers.addAll(this.callList);
            final WeakReference<ContextBuilder<T>> fcb = new WeakReference<ContextBuilder<T>>(this.cb);
            ((ContextBuilder)this.cb).applyQueue.add(new Runnable(){

                @Override
                public void run() {
                    ContextBuilder cb = (ContextBuilder)fcb.get();
                    if (cb == null) {
                        throw new IllegalStateException("apply fail : ContextBuilder not set");
                    }
                    ObjectBrowser bob = (ObjectBrowser)fbob.get();
                    if (bob == null) {
                        throw new IllegalStateException("apply fail : BaseObjectBrowser(ob field) not set");
                    }
                    final NodesExtracter ne = new NodesExtracter(){

                        public Iterable extract(Object from) {
                            Func2 fn = new Func2(){

                                public Object apply(final Object tn, final Object tnData) {
                                    if (tn instanceof TreeTableNodeBasic) {
                                        JMenuItem mi = new JMenuItem(flabel);
                                        if (ico != null) {
                                            mi.setIcon(ContextMenuBuilder.this.icon);
                                        }
                                        mi.addActionListener(new ActionListener(){

                                            @Override
                                            public void actionPerformed(ActionEvent e) {
                                                for (Func2 rcv : recivers) {
                                                    if (rcv == null) continue;
                                                    rcv.apply(tn, tnData);
                                                }
                                            }
                                        });
                                        return mi;
                                    }
                                    return null;
                                }
                            };
                            return Arrays.asList(fn);
                        }
                    };
                    final Class cbclass = cb.getContextClass();
                    Func1<List<JMenuItem>, TreeTableNodeBasic> ctxMenuBuilder = new Func1<List<JMenuItem>, TreeTableNodeBasic>(){

                        public List<JMenuItem> apply(final TreeTableNodeBasic ttnb) {
                            if (ttnb == null) {
                                return null;
                            }
                            Object data = ttnb.getData();
                            if (data == null) {
                                return null;
                            }
                            Class<?> tdata = data.getClass();
                            if (!cbclass.isAssignableFrom(tdata)) {
                                return null;
                            }
                            JMenuItem mi = new JMenuItem(flabel);
                            if (ico != null) {
                                mi.setIcon(ContextMenuBuilder.this.icon);
                            }
                            mi.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    for (Func2 rcv : recivers) {
                                        if (rcv == null) continue;
                                        rcv.apply((Object)ttnb, ttnb.getData());
                                    }
                                }
                            });
                            ArrayList<JMenuItem> list = new ArrayList<JMenuItem>();
                            list.add(mi);
                            return list;
                        }
                    };
                    if (ContextMenuBuilder.this.contextMenuBuilder) {
                        bob.getContextMenuBuilders().add(ctxMenuBuilder);
                    } else {
                        bob.getNodeContextMenu().add(cb.getContextClass(), ne);
                    }
                    final Class ctxcls = cb.getContextClass();
                    cb.cset.add(new Runnable((Func1)ctxMenuBuilder){
                        final /* synthetic */ Func1 val$ctxMenuBuilder;
                        {
                            this.val$ctxMenuBuilder = func1;
                        }

                        @Override
                        public void run() {
                            ObjectBrowser bob = (ObjectBrowser)fbob.get();
                            if (bob == null) {
                                return;
                            }
                            bob.getNodeContextMenu().remove(ctxcls, ne);
                            bob.getContextMenuBuilders().remove(this.val$ctxMenuBuilder);
                        }
                    });
                }
            });
            ContextBuilder<T> ctx = this.cb;
            this.cb = null;
            return ctx;
        }

        @Override
        public Context<T> items(final Func2<Iterable<JMenuItem>, TreeTableNodeBasic, T> buildMenus) {
            if (buildMenus == null) {
                throw new IllegalArgumentException("buildMenus==null");
            }
            final WeakReference<ObjectBrowser> fbob = new WeakReference<ObjectBrowser>(((ContextBuilder)this.cb).baseObjectBrowser);
            final WeakReference<ContextBuilder<T>> fcb = new WeakReference<ContextBuilder<T>>(this.cb);
            ((ContextBuilder)this.cb).applyQueue.add(new Runnable(){

                @Override
                public void run() {
                    ContextBuilder cb = (ContextBuilder)fcb.get();
                    if (cb == null) {
                        throw new IllegalStateException("apply fail : ContextBuilder not set");
                    }
                    ObjectBrowser bob = (ObjectBrowser)fbob.get();
                    if (bob == null) {
                        throw new IllegalStateException("apply fail : BaseObjectBrowser(ob field) not set");
                    }
                    final NodesExtracter ne = new NodesExtracter(){

                        public Iterable extract(Object from) {
                            Func2 fn = new Func2(){

                                public Object apply(Object tn, Object tnData) {
                                    Iterable miIts;
                                    if (tn instanceof TreeTableNodeBasic && (miIts = (Iterable)buildMenus.apply((Object)((TreeTableNodeBasic)tn), tnData)) != null) {
                                        ArrayList<JMenuItem> res = new ArrayList<JMenuItem>();
                                        for (JMenuItem mi : miIts) {
                                            if (mi == null) continue;
                                            res.add(mi);
                                        }
                                        return res;
                                    }
                                    return null;
                                }
                            };
                            return Arrays.asList(fn);
                        }
                    };
                    final Class cbclass = cb.getContextClass();
                    Func1<List<JMenuItem>, TreeTableNodeBasic> ctxMenuBuilder = new Func1<List<JMenuItem>, TreeTableNodeBasic>(){

                        public List<JMenuItem> apply(TreeTableNodeBasic ttnb) {
                            if (ttnb == null) {
                                return null;
                            }
                            Object data = ttnb.getData();
                            if (data == null) {
                                return null;
                            }
                            Class<?> tdata = data.getClass();
                            if (!cbclass.isAssignableFrom(tdata)) {
                                return null;
                            }
                            Iterable itms = (Iterable)buildMenus.apply((Object)ttnb, data);
                            if (itms == null) {
                                return null;
                            }
                            ArrayList<JMenuItem> list = new ArrayList<JMenuItem>();
                            for (JMenuItem mi : itms) {
                                if (mi == null) continue;
                                list.add(mi);
                            }
                            return list;
                        }
                    };
                    if (ContextMenuBuilder.this.contextMenuBuilder) {
                        bob.getContextMenuBuilders().add(ctxMenuBuilder);
                    } else {
                        bob.getNodeContextMenu().add(cb.getContextClass(), ne);
                    }
                    final Class ctxcls = cb.getContextClass();
                    cb.cset.add(new Runnable((Func1)ctxMenuBuilder){
                        final /* synthetic */ Func1 val$ctxMenuBuilder;
                        {
                            this.val$ctxMenuBuilder = func1;
                        }

                        @Override
                        public void run() {
                            ObjectBrowser bob = (ObjectBrowser)fbob.get();
                            if (bob == null) {
                                return;
                            }
                            bob.getNodeContextMenu().remove(ctxcls, ne);
                            bob.getContextMenuBuilders().remove(this.val$ctxMenuBuilder);
                        }
                    });
                }
            });
            ContextBuilder<T> ctx = this.cb;
            this.cb = null;
            return ctx;
        }
    }
}

