/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.tree.ob;

import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.NodesExtracter;
import xyz.cofe.gui.swing.tree.TreeNodesExtracter;
import xyz.cofe.gui.swing.tree.TreeTableNode;
import xyz.cofe.gui.swing.tree.ob.Followable;

public class FollowableExtracter
implements NodesExtracter,
Followable,
TreeNodesExtracter {
    private static final Logger logger = Logger.getLogger(FollowableExtracter.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    private NodesExtracter nodesExtracter;
    private Followable followable;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(FollowableExtracter.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(FollowableExtracter.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(FollowableExtracter.class.getName(), method, result);
    }

    public FollowableExtracter(NodesExtracter nodesExtracter, Followable followable) {
        if (nodesExtracter == null) {
            throw new IllegalArgumentException("nodesExtracter==null");
        }
        if (followable == null) {
            throw new IllegalArgumentException("followable==null");
        }
        this.nodesExtracter = nodesExtracter;
        this.followable = followable;
    }

    public Iterable extract(Object from) {
        return this.nodesExtracter.extract(from);
    }

    public boolean followable(Object node) {
        return this.followable.followable(node);
    }

    @Override
    public Iterable extract(TreeTableNode node) {
        if (node == null) {
            return null;
        }
        Object ndata = node.getData();
        if (ndata == null) {
            return null;
        }
        return this.extract(ndata);
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

