/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.tree.ob;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import xyz.cofe.collection.BasicTriple;
import xyz.cofe.collection.NodesExtracter;
import xyz.cofe.collection.Triple;
import xyz.cofe.collection.map.ClassMap;
import xyz.cofe.collection.tree.ClassNode;
import xyz.cofe.collection.tree.TreeNode;
import xyz.cofe.collection.tree.TreeNodeAsyncFollowed;
import xyz.cofe.collection.tree.TreeNodeAsyncFollowing;
import xyz.cofe.gui.swing.tree.TreeNodesExtracter;
import xyz.cofe.gui.swing.tree.TreeTableNode;
import xyz.cofe.gui.swing.tree.TreeTableNodeBasic;

public class FollowerMap
extends ClassNode
implements TreeNodesExtracter {
    private static final Logger logger = Logger.getLogger(FollowerMap.class.getName());
    private final WeakHashMap<Object, Boolean> asyncInst = new WeakHashMap();
    private final ClassMap<Boolean> asyncType = new ClassMap();
    protected volatile boolean inheritExtracter = true;
    private ExecutorService executorService;
    private final LinkedBlockingQueue<Triple<TreeTableNode, List<TreeTableNodeBasic>, TreeNodeAsyncFollowed>> awtConsumerQueue = new LinkedBlockingQueue();

    private static Level logLevel() {
        return logger.getLevel();
    }

    private static boolean isLogSevere() {
        Level ll = FollowerMap.logLevel();
        return ll == null ? true : ll.intValue() <= Level.SEVERE.intValue();
    }

    private static boolean isLogWarning() {
        Level ll = FollowerMap.logLevel();
        return ll == null ? true : ll.intValue() <= Level.WARNING.intValue();
    }

    private static boolean isLogInfo() {
        Level ll = FollowerMap.logLevel();
        return ll == null ? true : ll.intValue() <= Level.INFO.intValue();
    }

    private static boolean isLogFine() {
        Level ll = FollowerMap.logLevel();
        return ll == null ? true : ll.intValue() <= Level.FINE.intValue();
    }

    private static boolean isLogFiner() {
        Level ll = FollowerMap.logLevel();
        return ll == null ? false : ll.intValue() <= Level.FINER.intValue();
    }

    private static boolean isLogFinest() {
        Level ll = FollowerMap.logLevel();
        return ll == null ? false : ll.intValue() <= Level.FINEST.intValue();
    }

    private static void logEntering(String method, Object ... args) {
        logger.entering(FollowerMap.class.getName(), method, args);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(FollowerMap.class.getName(), method, result);
    }

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private Boolean isAsyncExtractFrom(TreeTableNode node, Object data) {
        Boolean asnc = this.asyncInst.get(node);
        if (asnc != null) {
            return asnc;
        }
        asnc = this.asyncInst.get(data);
        if (asnc != null) {
            return asnc;
        }
        if (data != null && (asnc = (Boolean)this.asyncType.fetch(data.getClass())) != null) {
            return asnc;
        }
        return null;
    }

    private Boolean isAsyncExtracter(TreeTableNode node, Object data, NodesExtracter ne) {
        Boolean asnc = this.asyncInst.get(ne);
        if (asnc != null) {
            return asnc;
        }
        if (ne != null && (asnc = (Boolean)this.asyncType.fetch(ne.getClass())) != null) {
            return asnc;
        }
        return null;
    }

    public FollowerMap async(Object obj, boolean async) {
        if (obj == null) {
            return this;
        }
        FollowerMap.logFine(async ? "set async {0}" : "set sync {0}", obj);
        this.asyncInst.put(obj, async);
        return this;
    }

    public FollowerMap async(Object obj) {
        return this.async(obj, true);
    }

    public FollowerMap async(Class cls, boolean async) {
        if (cls != null) {
            FollowerMap.logFine(async ? "set async {0}" : "set sync {0}", cls);
            this.asyncType.put(cls, (Object)async);
        }
        return this;
    }

    public FollowerMap async(Class cls) {
        return this.async(cls, true);
    }

    public boolean isInheritExtracter() {
        return this.inheritExtracter;
    }

    public void setInheritExtracter(boolean inheritExtracter) {
        this.inheritExtracter = inheritExtracter;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Iterable extract(TreeTableNode node) {
        void var9_21;
        ArrayList<Object> syncExtracters;
        Object fmaps;
        if (node == null) {
            return null;
        }
        FollowerMap.logFine("extract node={0} data={1}", node, node.getData());
        Object data = node.getData();
        if (data == null) {
            FollowerMap.logFiner("data=null return", new Object[0]);
            return null;
        }
        NodesExtracter[] neArr = null;
        neArr = this.extractersOf(data.getClass());
        if (neArr == null || neArr.length < 1 && this.inheritExtracter) {
            TreeNode oprnt = node.getParent();
            if (oprnt instanceof TreeTableNodeBasic) {
                ClassNode cn;
                FollowerMap.logFiner("found 0 extracters from {0}, try found extracters from parents", data.getClass());
                TreeTableNodeBasic prntNode = (TreeTableNodeBasic)oprnt;
                List prntNodes = prntNode.getNodePath();
                fmaps = new ArrayList();
                for (TreeTableNodeBasic treeTableNodeBasic : prntNodes) {
                    NodesExtracter<Object, Object> df = treeTableNodeBasic.getDataFollower();
                    if (!(df instanceof ClassNode)) continue;
                    fmaps.add((ClassNode)df);
                }
                int n = fmaps.indexOf(this);
                FollowerMap.logFiner("found {0} parent ClassNode's, self index={1}", fmaps.size(), n);
                if (n >= 0) {
                    void var9_15;
                    if (n == 0) {
                        return null;
                    }
                    int n2 = n - 1;
                    while (var9_15 >= 0) {
                        cn = (ClassNode)fmaps.get((int)var9_15);
                        if (cn != null && (neArr = cn.extractersOf(data.getClass())) != null && neArr.length >= 1) {
                            FollowerMap.logFiner("selected [{0}] {1} with {2} extracters", (int)var9_15, cn, neArr.length);
                            break;
                        }
                        --var9_15;
                    }
                } else {
                    void var9_17;
                    int n3 = fmaps.size();
                    while (var9_17 >= 0) {
                        cn = (ClassNode)fmaps.get((int)var9_17);
                        if (cn != null && (neArr = cn.extractersOf(data.getClass())) != null && neArr.length >= 1) {
                            FollowerMap.logFiner("selected [{0}] {1} with {2} extracters", (int)var9_17, cn, neArr.length);
                            break;
                        }
                        --var9_17;
                    }
                }
            } else {
                FollowerMap.logFiner("return, found 0 extracters from {0}", data.getClass());
                return null;
            }
            if (neArr == null || neArr.length < 1) {
                FollowerMap.logFiner("return, found 0 extracters from {0}", data.getClass());
                return null;
            }
        }
        if (neArr == null || neArr.length < 1) {
            FollowerMap.logFiner("return, found 0 extracters from {0}", data.getClass());
            return null;
        }
        Boolean asyncExtrFrm = this.isAsyncExtractFrom(node, data);
        if (asyncExtrFrm != null) {
            if (!asyncExtrFrm.booleanValue()) {
                FollowerMap.logFiner("use sync extract", new Object[0]);
                syncExtracters = new ArrayList<NodesExtracter>(Arrays.asList(neArr));
                ArrayList extracted = new ArrayList();
                for (NodesExtracter nodesExtracter : syncExtracters) {
                    Iterable iterable = nodesExtracter.extract(data);
                    if (iterable == null) continue;
                    for (Object e : iterable) {
                        extracted.add(e);
                    }
                }
                return extracted;
            }
            FollowerMap.logFiner("use async extract", new Object[0]);
            this.startAsync(node, data, Arrays.asList(neArr));
            return null;
        }
        syncExtracters = new ArrayList();
        ArrayList<NodesExtracter> asyncExtracters = new ArrayList<NodesExtracter>();
        fmaps = neArr;
        int n = ((NodesExtracter[])fmaps).length;
        boolean bl = false;
        while (var9_21 < n) {
            NodesExtracter ne = fmaps[var9_21];
            Boolean asyncExt = this.isAsyncExtracter(node, data, ne);
            if (Objects.equals(asyncExt, true)) {
                asyncExtracters.add(ne);
            } else {
                syncExtracters.add(ne);
            }
            ++var9_21;
        }
        FollowerMap.logFiner("use {0} sync extracters, {1} async extracters", syncExtracters.size(), asyncExtracters.size());
        if (asyncExtracters.size() > 0) {
            this.startAsync(node, data, asyncExtracters);
        }
        ArrayList extracted = new ArrayList();
        for (NodesExtracter nodesExtracter : syncExtracters) {
            Iterable iter = nodesExtracter.extract(data);
            if (iter == null) continue;
            for (Object e : iter) {
                extracted.add(e);
            }
        }
        return extracted;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    private void startAsync(TreeTableNode node, Object data, List<NodesExtracter> extracters) {
        for (NodesExtracter ne : extracters) {
            this.startAsync(node, data, ne);
        }
    }

    private void startAsync(final TreeTableNode node, final Object data, final NodesExtracter extracter) {
        if (node == null) {
            return;
        }
        FollowerMap.logFine("startAsync node={0}, data={1}, extracter={2}", node, data, extracter);
        final AtomicReference<TreeNodeAsyncFollowing> beginEvent = new AtomicReference<TreeNodeAsyncFollowing>();
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    Iterable iter = extracter.extract(data);
                    if (iter != null) {
                        ArrayList<TreeTableNodeBasic> fetched = new ArrayList<TreeTableNodeBasic>();
                        for (Object it : iter) {
                            TreeTableNodeBasic tn = null;
                            tn = it instanceof TreeTableNodeBasic ? (TreeTableNodeBasic)it : new TreeTableNodeBasic(it);
                            fetched.add(tn);
                        }
                        FollowerMap.this.sendToAwtConsumer(node, fetched, (TreeNodeAsyncFollowing)((Object)beginEvent.get()));
                    }
                }
                catch (Throwable err) {
                    String msg = err.getMessage();
                    msg = msg == null ? err.toString() : msg;
                    FollowerMap.logSevere("fail extract (follow) from node {2} (data: {3}), extracter={4}, class={0} message={1}", new Object[]{err.getClass().getName(), msg, node, data, extracter});
                    FollowerMap.logException(err);
                }
            }
        };
        ExecutorService esrvc = this.getExecutorService();
        if (esrvc != null) {
            Future<?> f = esrvc.submit(run);
            TreeNodeAsyncFollowing ev = new TreeNodeAsyncFollowing(node);
            ev.setData(data);
            ev.setFuture(f);
            ev.setRunnable(run);
            ev.setExtracter(extracter);
            node.popup(ev);
            beginEvent.set(ev);
        } else {
            Thread th = new Thread(run);
            th.setDaemon(true);
            th.setPriority(1);
            TreeNodeAsyncFollowing ev = new TreeNodeAsyncFollowing(node);
            ev.setData(data);
            ev.setThread(th);
            ev.setRunnable(run);
            ev.setExtracter(extracter);
            node.popup(ev);
            beginEvent.set(ev);
            th.start();
        }
    }

    private void sendToAwtConsumer(TreeTableNode node, List<TreeTableNodeBasic> fetched, TreeNodeAsyncFollowing parentEvent) {
        FollowerMap.logFine("sendToAwtConsumer", new Object[0]);
        TreeNodeAsyncFollowed ev = new TreeNodeAsyncFollowed(node);
        ev.setFetched(fetched);
        ev.setParentEvent(parentEvent);
        this.awtConsumerQueue.add((Triple<TreeTableNode, List<TreeTableNodeBasic>, TreeNodeAsyncFollowed>)new BasicTriple((Object)node, fetched, (Object)ev));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FollowerMap.this.awtFlushQueue();
            }
        });
    }

    private void awtFlushQueue() {
        Triple<TreeTableNode, List<TreeTableNodeBasic>, TreeNodeAsyncFollowed> p;
        FollowerMap.logFine("awtFlushQueue", new Object[0]);
        while ((p = this.awtConsumerQueue.poll()) != null) {
            TreeNode otn;
            TreeNodeAsyncFollowed ev;
            TreeTableNode node = (TreeTableNode)p.A();
            List fetched = (List)p.B();
            List children = node.getChildrenList();
            FollowerMap.logFiner("append {0} nodes at end", fetched.size());
            if (node instanceof TreeTableNodeBasic) {
                for (TreeTableNodeBasic cn : fetched) {
                    ((TreeTableNodeBasic)node).appendChild(cn);
                }
            } else {
                children.addAll(fetched);
            }
            if (node instanceof TreeTableNodeBasic) {
                TreeTableNodeBasic ttnb = (TreeTableNodeBasic)node;
                Date dnow = new Date();
                for (TreeTableNodeBasic cn : fetched) {
                    ttnb.getCachedNodes().put(cn, dnow);
                }
            }
            if ((ev = (TreeNodeAsyncFollowed)((Object)p.C())) == null || !((otn = ev.getSource()) instanceof TreeTableNodeBasic)) continue;
            TreeTableNodeBasic tn = (TreeTableNodeBasic)otn;
            tn.popup(ev);
        }
    }
}

