/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.tree.ob;

import java.net.URL;
import java.util.List;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import xyz.cofe.collection.Func1;
import xyz.cofe.collection.map.ClassMap;
import xyz.cofe.gui.swing.tree.TreeTableNodeFormat;
import xyz.cofe.gui.swing.tree.TreeTableNodeFormatBasic;
import xyz.cofe.gui.swing.tree.TreeTableNodeGetFormatOf;

public class FormatMap
extends ClassMap<Func1<TreeTableNodeFormat, Object>>
implements TreeTableNodeGetFormatOf {
    private static final Logger logger = Logger.getLogger(FormatMap.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    private static volatile Icon componentIcon;
    protected static volatile Icon refreshIconSmall;
    protected volatile TreeTableNodeFormatBasic defaultFormat;
    private final ClassMap<Func1<Icon, Object>> typeIconMap = new ClassMap();
    private final WeakHashMap<Object, Icon> objectIcon = new WeakHashMap();

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(FormatMap.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(FormatMap.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(FormatMap.class.getName(), method, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Icon getComponentIcon() {
        if (componentIcon != null) {
            return componentIcon;
        }
        Class<FormatMap> clazz = FormatMap.class;
        synchronized (FormatMap.class) {
            if (componentIcon != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return componentIcon;
            }
            URL url = FormatMap.class.getResource("component-16.png");
            componentIcon = new ImageIcon(url);
            // ** MonitorExit[var0] (shouldn't be in output)
            return componentIcon;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Icon getRefreshIconSmall() {
        if (refreshIconSmall != null) {
            return refreshIconSmall;
        }
        Class<FormatMap> clazz = FormatMap.class;
        synchronized (FormatMap.class) {
            if (refreshIconSmall != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return refreshIconSmall;
            }
            refreshIconSmall = new ImageIcon(FormatMap.class.getResource("refresh-icon-16.png"));
            // ** MonitorExit[var0] (shouldn't be in output)
            return refreshIconSmall;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeTableNodeFormatBasic getDefaultFormat() {
        FormatMap formatMap = this;
        synchronized (formatMap) {
            if (this.defaultFormat != null) {
                return this.defaultFormat;
            }
            this.defaultFormat = new TreeTableNodeFormatBasic();
            this.defaultFormat.getIcons().add(FormatMap.getComponentIcon());
            this.defaultFormat.setIconWidthMin(16);
            return this.defaultFormat;
        }
    }

    public synchronized void setDefaultFormat(TreeTableNodeFormatBasic fmt) {
        this.defaultFormat = fmt;
    }

    public ClassMap<Func1<Icon, Object>> getTypeIconMap() {
        return this.typeIconMap;
    }

    public WeakHashMap<Object, Icon> getObjectIconMap() {
        return this.objectIcon;
    }

    public Icon objectIcon(Object obj) {
        return this.objectIcon.get(obj);
    }

    public void objectIcon(Object obj, Icon ico) {
        if (obj == null) {
            return;
        }
        if (ico != null) {
            this.objectIcon.put(obj, ico);
        } else {
            this.objectIcon.remove(obj);
        }
    }

    @Override
    public TreeTableNodeFormat getTreeTableNodeFormatOf(Object value) {
        TreeTableNodeFormatBasic deffmt = this.getDefaultFormat();
        if (value != null) {
            Func1 fnIco = (Func1)this.getTypeIconMap().fetch(value.getClass());
            Icon ico = fnIco != null ? (Icon)fnIco.apply(value) : null;
            ico = ico != null ? ico : this.objectIcon(value);
            Func1 fn = (Func1)this.fetch(value.getClass());
            if (fn != null) {
                TreeTableNodeFormat fmt = (TreeTableNodeFormat)fn.apply(value);
                TreeTableNodeFormat rfmt = deffmt.clone();
                rfmt.merge(deffmt);
                rfmt.merge(fmt);
                List<Icon> icons = fmt.getIcons();
                if (icons != null && icons.size() > 0) {
                    rfmt.getIcons().clear();
                    rfmt.getIcons().addAll(icons);
                } else if (ico != null) {
                    rfmt.getIcons().clear();
                    rfmt.getIcons().add(ico);
                }
                return rfmt;
            }
            if (ico != null) {
                TreeTableNodeFormat rfmt = deffmt.clone();
                rfmt.getIcons().clear();
                rfmt.getIcons().add(ico);
                return rfmt;
            }
        }
        return deffmt;
    }

    public <T> void format(Class<T> type, Func1<TreeTableNodeFormat, T> fmtfn) {
        if (type == null) {
            throw new IllegalArgumentException("type==null");
        }
        if (fmtfn == null) {
            this.remove(type);
        } else {
            this.put(type, fmtfn);
        }
    }

    public <T> void format(Class<T> type, final TreeTableNodeFormat fmt) {
        if (type == null) {
            throw new IllegalArgumentException("type==null");
        }
        if (fmt == null) {
            this.remove(type);
        } else {
            this.put(type, new Func1<TreeTableNodeFormat, Object>(){

                public TreeTableNodeFormat apply(Object arg) {
                    return fmt;
                }
            });
        }
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

