/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.tree.ob;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import xyz.cofe.collection.NodesExtracter;
import xyz.cofe.gui.swing.tree.ob.FormatMap;

public class NamedCollection
implements NodesExtracter<Object, Object> {
    private static final Logger logger = Logger.getLogger(NamedCollection.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    private static final transient AtomicLong idseq;
    private final long id = idseq.incrementAndGet();
    protected volatile transient String name;
    protected Icon icon = FormatMap.getComponentIcon();
    protected Boolean bold;
    protected Boolean italic;
    protected Color foreground;
    private volatile transient WeakReference nodeRef;
    private volatile transient NodesExtracter nodesExtracter;
    private volatile transient Iterable extracted;
    protected List<JMenuItem> contextMenu;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(NamedCollection.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(NamedCollection.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(NamedCollection.class.getName(), method, result);
    }

    public long id() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public synchronized NamedCollection name(String name) {
        this.setName(name);
        return this;
    }

    public synchronized NamedCollection name(String name, Icon ico) {
        this.setName(name);
        this.setIcon(ico);
        return this;
    }

    public synchronized Icon getIcon() {
        return this.icon;
    }

    public synchronized void setIcon(Icon icon) {
        this.icon = icon;
    }

    public NamedCollection icon(Icon ico) {
        this.icon = ico;
        return this;
    }

    public synchronized Boolean getBold() {
        return this.bold;
    }

    public synchronized void setBold(Boolean bold) {
        this.bold = bold;
    }

    public NamedCollection bold(Boolean bold) {
        this.bold = bold;
        return this;
    }

    public synchronized Boolean getItalic() {
        return this.italic;
    }

    public synchronized void setItalic(Boolean italic) {
        this.italic = italic;
    }

    public NamedCollection italic(Boolean italic) {
        this.italic = italic;
        return this;
    }

    public synchronized Color getForeground() {
        return this.foreground;
    }

    public synchronized void setForeground(Color foreground) {
        this.foreground = foreground;
    }

    public synchronized Object getNode() {
        if (this.nodeRef != null) {
            return this.nodeRef.get();
        }
        return null;
    }

    public synchronized void setNode(Object node) {
        if (node == null) {
            if (this.nodeRef != null) {
                this.nodeRef.clear();
            }
            this.nodeRef = null;
        } else {
            if (this.nodeRef != null) {
                this.nodeRef.clear();
            }
            this.nodeRef = new WeakReference<Object>(node);
        }
    }

    public synchronized NamedCollection node(Object node) {
        this.setNode(node);
        return this;
    }

    public synchronized NodesExtracter getNodesExtracter() {
        return this.nodesExtracter;
    }

    public synchronized void setNodesExtracter(NodesExtracter nodesExtracter) {
        this.nodesExtracter = nodesExtracter;
    }

    public synchronized NamedCollection extracter(Object node, NodesExtracter extracter) {
        this.setNode(node);
        this.setNodesExtracter(extracter);
        return this;
    }

    public synchronized Iterable getExtracted() {
        return this.extracted;
    }

    public synchronized void setExtracted(Iterable extracted) {
        this.extracted = extracted;
    }

    public synchronized NamedCollection extracted(Iterable extracted) {
        this.setExtracted(extracted);
        return this;
    }

    public synchronized NamedCollection values(Object ... values) {
        if (values == null) {
            throw new IllegalArgumentException("values == null");
        }
        this.setExtracted(Arrays.asList(values));
        return this;
    }

    public synchronized List<JMenuItem> getContextMenu() {
        if (this.contextMenu == null) {
            this.contextMenu = new ArrayList<JMenuItem>();
        }
        return this.contextMenu;
    }

    public NamedCollection menu(String label, final Runnable run) {
        if (label == null) {
            throw new IllegalArgumentException("label == null");
        }
        if (run == null) {
            throw new IllegalArgumentException("run == null");
        }
        JMenuItem mi = new JMenuItem(label);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                run.run();
            }
        });
        this.getContextMenu().add(mi);
        return this;
    }

    public NamedCollection menu(JMenuItem mi) {
        if (mi == null) {
            throw new IllegalArgumentException("mi == null");
        }
        this.getContextMenu().add(mi);
        return this;
    }

    public synchronized Iterable<Object> extract(Object from) {
        if (this.extracted != null) {
            return this.extracted;
        }
        Object node = this.getNode();
        NodesExtracter ne = this.getNodesExtracter();
        if (node == null) {
            return null;
        }
        if (ne == null) {
            return null;
        }
        return ne.extract(node);
    }

    public synchronized String toString() {
        return this.name != null ? this.name : this.getClass().getSimpleName() + "#" + this.id;
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
        idseq = new AtomicLong(0L);
    }
}

