/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.tree.ob;

import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import xyz.cofe.collection.Func1;
import xyz.cofe.collection.Func2;
import xyz.cofe.collection.NodesExtracter;
import xyz.cofe.common.CloseableSet;
import xyz.cofe.gui.swing.tree.TreeTableNodeBasic;
import xyz.cofe.gui.swing.tree.TreeTableNodeFormat;
import xyz.cofe.gui.swing.tree.TreeTableNodeFormatBasic;
import xyz.cofe.gui.swing.tree.ob.Followable;
import xyz.cofe.gui.swing.tree.ob.NamedCollection;
import xyz.cofe.gui.swing.tree.ob.ObjectBrowser;
import xyz.cofe.gui.swing.tree.ob.ObjectBrowserPlugin;

public class NamedCollectionObPlugin
implements ObjectBrowserPlugin {
    private static final Logger logger = Logger.getLogger(NamedCollectionObPlugin.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected final NodesExtracter<NamedCollection, Object> namedCollectionExtract = new NodesExtracter<NamedCollection, Object>(){

        public Iterable extract(NamedCollection from) {
            if (from == null) {
                return null;
            }
            return from.extract(from);
        }
    };
    protected final Followable<NamedCollection> namedCollectionFollowable = new Followable<NamedCollection>(){

        @Override
        public boolean followable(NamedCollection node) {
            Iterable extrd = node.getExtracted();
            if (extrd instanceof Collection) {
                Collection coll = (Collection)extrd;
                return !coll.isEmpty();
            }
            return node.getNodesExtracter() != null;
        }
    };
    protected final Func1<TreeTableNodeFormat, NamedCollection> namedCollectionFormatter = new Func1<TreeTableNodeFormat, NamedCollection>(){

        public TreeTableNodeFormat apply(NamedCollection ncoll) {
            if (ncoll == null) {
                return null;
            }
            TreeTableNodeFormatBasic fmt = new TreeTableNodeFormatBasic();
            if (ncoll.getBold() != null) {
                fmt.setBold(ncoll.getBold());
            }
            if (ncoll.getItalic() != null) {
                fmt.setItalic(ncoll.getItalic());
            }
            if (ncoll.getIcon() != null) {
                fmt.getIcons().add(ncoll.getIcon());
            }
            return fmt;
        }
    };

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(NamedCollectionObPlugin.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(NamedCollectionObPlugin.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(NamedCollectionObPlugin.class.getName(), method, result);
    }

    @Override
    public void register(ObjectBrowser bob, CloseableSet cs) {
        if (bob == null) {
            return;
        }
        AutoCloseable cl = bob.context(NamedCollection.class).follower(this.namedCollectionExtract, this.namedCollectionFollowable).format(this.namedCollectionFormatter).menu(true).items(new Func2<Iterable<JMenuItem>, TreeTableNodeBasic, NamedCollection>(){

            public Iterable<JMenuItem> apply(TreeTableNodeBasic n, NamedCollection nc) {
                if (nc != null) {
                    return nc.getContextMenu();
                }
                return null;
            }
        }).apply();
        if (cs != null) {
            cs.add(cl);
        }
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

