/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.tree.ob;

import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import xyz.cofe.collection.Func1;
import xyz.cofe.collection.Func2;
import xyz.cofe.collection.Func3;
import xyz.cofe.collection.NodesExtracter;
import xyz.cofe.collection.map.ClassMap;
import xyz.cofe.collection.tree.ClassNode;
import xyz.cofe.common.CloseableSet;
import xyz.cofe.common.Reciver;
import xyz.cofe.gui.swing.SwingListener;
import xyz.cofe.gui.swing.tree.TreeTable;
import xyz.cofe.gui.swing.tree.TreeTableNode;
import xyz.cofe.gui.swing.tree.TreeTableNodeBasic;
import xyz.cofe.gui.swing.tree.TreeTableNodeFormat;
import xyz.cofe.gui.swing.tree.ob.Context;
import xyz.cofe.gui.swing.tree.ob.ContextBuilder;
import xyz.cofe.gui.swing.tree.ob.Followable;
import xyz.cofe.gui.swing.tree.ob.FollowableExtracter;
import xyz.cofe.gui.swing.tree.ob.FollowerMap;
import xyz.cofe.gui.swing.tree.ob.FormatMap;
import xyz.cofe.gui.swing.tree.ob.ObjectBrowserPlugin;
import xyz.cofe.gui.swing.tree.ob.TreeRootNode;

public class ObjectBrowser
extends TreeTable {
    private static final Logger logger = Logger.getLogger(ObjectBrowser.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected final Map<ObjectBrowserPlugin, CloseableSet> plugins = new LinkedHashMap<ObjectBrowserPlugin, CloseableSet>();
    private boolean fix_storeColumnsWithOnToggle = true;
    private boolean fix_storeColumnsWithOnToggle_pref = true;
    private final ClassMap<Func1<String, Object>> naming = new ClassMap();
    private final WeakHashMap<Object, String> objectName = new WeakHashMap();
    private final Func1<String, Object> nameFn = new Func1<String, Object>(){

        public String apply(Object arg) {
            if (arg == null) {
                return null;
            }
            Class<?> cl = arg.getClass();
            Func1 namefn = (Func1)ObjectBrowser.this.naming.fetch(cl);
            if (namefn != null) {
                return (String)namefn.apply(arg);
            }
            String name = ObjectBrowser.this.objectName(arg);
            if (name != null) {
                return name;
            }
            return arg.toString();
        }
    };
    private final ClassMap<Func1<Boolean, Object>> followableMap = new ClassMap();
    private final Func1<Boolean, Object> followableFn = new Func1<Boolean, Object>(){

        public Boolean apply(Object arg) {
            if (arg == null) {
                return null;
            }
            Class<?> cl = arg.getClass();
            Func1 fn = (Func1)ObjectBrowser.this.followableMap.fetch(cl);
            if (fn != null) {
                return (Boolean)fn.apply(arg);
            }
            NodesExtracter[] extracters = ObjectBrowser.this.followerMap.extractersOf(arg.getClass());
            if (extracters == null || extracters.length < 1) {
                return false;
            }
            int notFollowableExtrs = 0;
            for (NodesExtracter extr : extracters) {
                if (!(extr instanceof Followable)) break;
                if (((Followable)extr).followable(arg)) {
                    return true;
                }
                ++notFollowableExtrs;
            }
            if (notFollowableExtrs == extracters.length) {
                return false;
            }
            Iterable itr = ObjectBrowser.this.followerMap.fetch(arg);
            return itr != null;
        }
    };
    private final FollowerMap followerMap = new FollowerMap();
    private final FormatMap formatMap = new FormatMap();
    private volatile ClassNode popupMenu;
    private volatile Set<Func1<List<JMenuItem>, TreeTableNodeBasic>> contextMenuBuilders;
    private volatile ClassNode leftMouseDblClick;
    private volatile ClassNode leftMouseClick;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(ObjectBrowser.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(ObjectBrowser.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(ObjectBrowser.class.getName(), method, result);
    }

    public ObjectBrowser() {
        this.setRowHeight(23);
        this.setRequestFocusEnabled(true);
        this.setRootVisible(false);
        TreeRootNode root = new TreeRootNode(this);
        super.setRoot(root);
        root.expand();
        root.setDataTextReader(this.nameFn);
        root.setDataFollowable(this.followableFn);
        root.setDataFollower((NodesExtracter<Object, Object>)this.followerMap);
        root.setDataFormatter(this.formatMap);
        SwingListener.onMousePressed(this, new Reciver<MouseEvent>(){

            public void recive(MouseEvent obj) {
                if (obj == null) {
                    return;
                }
                ObjectBrowser.this.onMousePressed(obj);
            }
        });
        SwingListener.onMouseClicked(this, new Reciver<MouseEvent>(){

            public void recive(MouseEvent obj) {
                if (obj == null) {
                    return;
                }
                ObjectBrowser.this.onMouseClick(obj);
            }
        });
        this.reloadPlugins();
    }

    public void rebuildTree() {
        ObjectBrowser.logFine("rebuildTree", new Object[0]);
        ObjectBrowser.logFiner("direct model - fireAllChanged", new Object[0]);
        this.getTreeTableModel().getDirectModel().fireAllChanged();
        ObjectBrowser.logFiner("filter model - applyFilter", new Object[0]);
        this.getTreeTableModel().getFilterModel().applyFilter();
    }

    public Map<ObjectBrowserPlugin, CloseableSet> getPlugins() {
        return this.plugins;
    }

    public void reloadPlugins() {
        CloseableSet cs;
        if (this.plugins != null) {
            for (Map.Entry entry : this.plugins.entrySet()) {
                cs = entry != null ? (CloseableSet)entry.getValue() : null;
                if (cs == null) continue;
                cs.closeAll();
            }
            this.plugins.clear();
        }
        for (ObjectBrowserPlugin objectBrowserPlugin : ServiceLoader.load(ObjectBrowserPlugin.class)) {
            if (objectBrowserPlugin == null) continue;
            cs = new CloseableSet();
            objectBrowserPlugin.register(this, cs);
            this.plugins.put(objectBrowserPlugin, cs);
        }
    }

    public void refreshFocused() {
        TreeTableNode ofoc = this.getFocusedNode();
        if (ofoc instanceof TreeTableNodeBasic) {
            TreeTableNodeBasic ttnb = (TreeTableNodeBasic)ofoc;
            this.refresh(ttnb);
        }
    }

    public void refresh(TreeTableNodeBasic ttnb) {
        boolean fixCWidth = this.fix_storeColumnsWithOnToggle;
        int[] colWidth = null;
        if (fixCWidth) {
            colWidth = this.getColumnsWidths();
        }
        boolean exp = ttnb.isExpanded();
        ttnb.collapse();
        ttnb.dropCache();
        if (exp) {
            ttnb.expand();
        }
        if (colWidth != null && colWidth.length > 0) {
            this.setColumnsWidths(this.fix_storeColumnsWithOnToggle_pref, colWidth);
        }
        this.repaint();
    }

    @Override
    public synchronized TreeTableNodeBasic getRoot() {
        TreeTableNodeBasic root = super.getRoot();
        if (root == null) {
            root = new TreeTableNodeBasic(this);
            super.setRoot(root);
            root.expand();
            root.setDataTextReader(this.nameFn);
            root.setDataFollowable(this.followableFn);
            root.setDataFollower((NodesExtracter<Object, Object>)this.followerMap);
            root.setDataFormatter(this.formatMap);
        }
        return root;
    }

    @Override
    public void setRoot(TreeTableNodeBasic newroot) {
        super.setRoot(newroot);
    }

    public TreeTableNodeBasic addTop(Object value) {
        TreeTableNodeBasic node = value instanceof TreeTableNodeBasic ? (TreeTableNodeBasic)value : new TreeTableNodeBasic(value);
        TreeTableNodeBasic root = this.getRoot();
        root.appendChild(node);
        return node;
    }

    public ClassMap<Func1<String, Object>> getNamingMap() {
        return this.naming;
    }

    public WeakHashMap<Object, String> objectName() {
        return this.objectName;
    }

    public String objectName(Object obj) {
        return this.objectName.get(obj);
    }

    public void objectName(Object obj, String name) {
        if (obj == null) {
            return;
        }
        if (name == null) {
            this.objectName.remove(obj);
        } else {
            this.objectName.put(obj, name);
        }
    }

    public Func1<String, Object> getNameFn() {
        return this.nameFn;
    }

    public <T> void naming(Class<T> type, Func1<String, T> nameFn) {
        if (type == null) {
            throw new IllegalArgumentException("type==null");
        }
        if (nameFn != null) {
            this.naming.put(type, nameFn);
        } else {
            this.naming.remove(type);
        }
    }

    public ClassMap<Func1<Boolean, Object>> getFollowableMap() {
        return this.followableMap;
    }

    public Func1<Boolean, Object> getFollowableFn() {
        return this.followableFn;
    }

    public <T> void followable(Class<T> type, Func1<Boolean, T> followableFn) {
        if (type == null) {
            throw new IllegalArgumentException("type==null");
        }
        if (followableFn != null) {
            this.followableMap.put(type, followableFn);
        } else {
            this.followableMap.remove(type);
        }
    }

    public FollowerMap getFollowerMap() {
        return this.followerMap;
    }

    public <T> void follower(Class<T> type, NodesExtracter<T, Object> followerFn) {
        if (type == null) {
            throw new IllegalArgumentException("type==null");
        }
        if (followerFn == null) {
            throw new IllegalArgumentException("followerFn==null");
        }
        this.followerMap.add(type, followerFn);
    }

    public <T> void follower(Class<T> type, NodesExtracter<T, Object> followerFn, Followable<T> followable) {
        if (type == null) {
            throw new IllegalArgumentException("type==null");
        }
        if (followerFn == null) {
            throw new IllegalArgumentException("followerFn==null");
        }
        if (followable == null) {
            throw new IllegalArgumentException("followable==null");
        }
        this.follower(type, new FollowableExtracter(followerFn, followable));
    }

    public ClassMap<Func1<Icon, Object>> getTypeIconMap() {
        return this.formatMap.getTypeIconMap();
    }

    public WeakHashMap<Object, Icon> getObjectIconMap() {
        return this.formatMap.getObjectIconMap();
    }

    public Icon objectIcon(Object obj) {
        return this.formatMap.objectIcon(obj);
    }

    public void objectIcon(Object obj, Icon ico) {
        this.formatMap.objectIcon(obj, ico);
    }

    public FormatMap getFormatMap() {
        return this.formatMap;
    }

    public <T> void format(Class<T> type, Func1<TreeTableNodeFormat, T> fmtfn) {
        this.formatMap.format(type, fmtfn);
    }

    public <T> void format(Class<T> type, TreeTableNodeFormat fmt) {
        this.formatMap.format(type, fmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassNode getNodeContextMenu() {
        if (this.popupMenu != null) {
            return this.popupMenu;
        }
        ObjectBrowser objectBrowser = this;
        synchronized (objectBrowser) {
            if (this.popupMenu != null) {
                return this.popupMenu;
            }
            this.popupMenu = new ClassNode();
            return this.popupMenu;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Func1<List<JMenuItem>, TreeTableNodeBasic>> getContextMenuBuilders() {
        if (this.contextMenuBuilders != null) {
            return this.contextMenuBuilders;
        }
        ObjectBrowser objectBrowser = this;
        synchronized (objectBrowser) {
            if (this.contextMenuBuilders != null) {
                return this.contextMenuBuilders;
            }
            this.contextMenuBuilders = new LinkedHashSet<Func1<List<JMenuItem>, TreeTableNodeBasic>>();
            return this.contextMenuBuilders;
        }
    }

    protected void onMousePressed(MouseEvent ev) {
        TreeTableNodeBasic node;
        List<JMenuItem> menuEntries;
        TreeTableNode onode;
        boolean shift = ev.isShiftDown();
        boolean alt = ev.isAltDown();
        boolean cntrl = ev.isControlDown();
        boolean meta = ev.isMetaDown();
        boolean popupTrig = ev.isPopupTrigger();
        if (ev.getButton() == 3 && (onode = this.getFocusedNode()) instanceof TreeTableNodeBasic && (menuEntries = this.contextMenuOf(node = (TreeTableNodeBasic)onode)) != null && menuEntries.size() > 0) {
            JPopupMenu popup = new JPopupMenu();
            for (JMenuItem mi : menuEntries) {
                popup.add(mi);
            }
            popup.show(this, ev.getX(), ev.getY());
        }
    }

    protected List<JMenuItem> contextMenuOf(TreeTableNodeBasic node) {
        ArrayList<JMenuItem> menu = new ArrayList<JMenuItem>();
        if (node == null) {
            return menu;
        }
        Object data = node.getData();
        if (data == null) {
            return menu;
        }
        for (Object o : this.getNodeContextMenu().extract(data)) {
            if (o == null) continue;
            this.processCtxMenuItm(menu, node, o, true);
        }
        Set<Func1<List<JMenuItem>, TreeTableNodeBasic>> set = this.getContextMenuBuilders();
        for (Func1<List<JMenuItem>, TreeTableNodeBasic> fn : set) {
            List lst;
            if (fn == null || (lst = (List)fn.apply((Object)node)) == null) continue;
            for (JMenuItem mi : lst) {
                if (mi == null) continue;
                menu.add(mi);
            }
        }
        return menu;
    }

    private void processCtxMenuItm(List<JMenuItem> consumer, TreeTableNodeBasic node, Object o, boolean acceptFn2) {
        block5: {
            block7: {
                block6: {
                    block4: {
                        if (!(o instanceof Action)) break block4;
                        consumer.add(new JMenuItem((Action)o));
                        break block5;
                    }
                    if (!(o instanceof JMenuItem)) break block6;
                    consumer.add((JMenuItem)o);
                    break block5;
                }
                if (!(o instanceof Func2) || !acceptFn2) break block7;
                Func2 fn = (Func2)o;
                Object fnres = fn.apply((Object)node, node.getData());
                if (fnres instanceof Iterable) {
                    for (Object it : (Iterable)fnres) {
                        this.processCtxMenuItm(consumer, node, it, false);
                    }
                } else {
                    this.processCtxMenuItm(consumer, node, fnres, false);
                }
                break block5;
            }
            if (!(o instanceof Iterable)) break block5;
            for (Object it : (Iterable)o) {
                this.processCtxMenuItm(consumer, node, it, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassNode getLeftMouseDblClick() {
        if (this.leftMouseDblClick != null) {
            return this.leftMouseDblClick;
        }
        ObjectBrowser objectBrowser = this;
        synchronized (objectBrowser) {
            if (this.leftMouseDblClick != null) {
                return this.leftMouseDblClick;
            }
            this.leftMouseDblClick = new ClassNode();
            return this.leftMouseDblClick;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassNode getLeftMouseClick() {
        if (this.leftMouseClick != null) {
            return this.leftMouseClick;
        }
        ObjectBrowser objectBrowser = this;
        synchronized (objectBrowser) {
            if (this.leftMouseClick != null) {
                return this.leftMouseClick;
            }
            this.leftMouseClick = new ClassNode();
            return this.leftMouseClick;
        }
    }

    protected void onMouseClick(MouseEvent me) {
        Object nodeData;
        if (me == null) {
            return;
        }
        TreeTableNodeBasic fnode = (TreeTableNodeBasic)this.getFocusedNode();
        Object object = nodeData = fnode != null ? fnode.getData() : null;
        if (me.getClickCount() > 1 && me.getButton() == 1 && nodeData != null) {
            this.processMouseEventForFocusedNode(me, fnode, nodeData, this.getLeftMouseDblClick().fetch(nodeData));
        } else if (me.getButton() == 1 && nodeData != null) {
            this.processMouseEventForFocusedNode(me, fnode, nodeData, this.getLeftMouseClick().fetch(nodeData));
        }
    }

    private void processMouseEventForFocusedNode(MouseEvent me, TreeTableNodeBasic fnode, Object nodeData, Iterable iter) {
        if (iter == null) {
            return;
        }
        if (nodeData != null) {
            for (Object consumer : iter) {
                if (consumer instanceof Func3) {
                    ((Func3)consumer).apply((Object)me, (Object)fnode, nodeData);
                    continue;
                }
                if (consumer instanceof Func2) {
                    ((Func2)consumer).apply((Object)fnode, nodeData);
                    continue;
                }
                if (consumer instanceof Func1) {
                    ((Func2)consumer).apply((Object)fnode, nodeData);
                    continue;
                }
                if (consumer instanceof Reciver) {
                    ((Reciver)consumer).recive(nodeData);
                    continue;
                }
                if (!(consumer instanceof Runnable)) continue;
                ((Runnable)consumer).run();
            }
        }
    }

    public <T> Context<T> context(Class<T> cls) {
        return new ContextBuilder<T>(this, cls);
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

