/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.tree.ob;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.KeyStroke;
import xyz.cofe.common.CloseableSet;
import xyz.cofe.gui.swing.BasicAction;
import xyz.cofe.gui.swing.tree.ob.FormatMap;
import xyz.cofe.gui.swing.tree.ob.ObjectBrowser;
import xyz.cofe.gui.swing.tree.ob.ObjectBrowserPlugin;

public class RefreshObPlugin
implements ObjectBrowserPlugin {
    private static final Logger logger = Logger.getLogger(RefreshObPlugin.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected static String refreshText;
    protected static String rebuildTreeText;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(RefreshObPlugin.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(RefreshObPlugin.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(RefreshObPlugin.class.getName(), method, result);
    }

    @Override
    public void register(ObjectBrowser bob, CloseableSet cs) {
        if (bob == null) {
            return;
        }
        this.refreshSelected(bob, cs);
        this.rebuildTree(bob, cs);
    }

    private void refreshSelected(final ObjectBrowser bob, CloseableSet cs) {
        BasicAction refreshFocusedAction = new BasicAction(refreshText, new Runnable(){

            @Override
            public void run() {
                bob.refreshFocused();
            }
        });
        refreshFocusedAction.setSmallIcon(FormatMap.getRefreshIconSmall());
        refreshFocusedAction.setShortDescription("CONTROL+R or F5");
        final KeyStroke[] keyStrokes = new KeyStroke[]{KeyStroke.getKeyStroke("control pressed R"), KeyStroke.getKeyStroke("pressed F5")};
        String actId = "refreshFocused";
        bob.getActionMap().put("refreshFocused", refreshFocusedAction);
        for (KeyStroke ks : keyStrokes) {
            bob.getInputMap().put(ks, "refreshFocused");
        }
        if (cs != null) {
            cs.add(new Runnable(){

                @Override
                public void run() {
                    for (KeyStroke ks : keyStrokes) {
                        bob.getInputMap().remove(ks);
                    }
                    bob.getActionMap().remove("refreshFocused");
                }
            });
        }
    }

    private void rebuildTree(final ObjectBrowser bob, CloseableSet cs) {
        BasicAction rebuildTreeAction = new BasicAction(rebuildTreeText, new Runnable(){

            @Override
            public void run() {
                bob.rebuildTree();
            }
        });
        rebuildTreeAction.setSmallIcon(FormatMap.getRefreshIconSmall());
        rebuildTreeAction.setShortDescription("CONTROL+SHIFT+R");
        final KeyStroke[] keyStrokes = new KeyStroke[]{KeyStroke.getKeyStroke("control shift pressed R")};
        String actId = "rebuildTree";
        bob.getActionMap().put("rebuildTree", rebuildTreeAction);
        for (KeyStroke ks : keyStrokes) {
            bob.getInputMap().put(ks, "rebuildTree");
        }
        if (cs != null) {
            cs.add(new Runnable(){

                @Override
                public void run() {
                    for (KeyStroke ks : keyStrokes) {
                        bob.getInputMap().remove(ks);
                    }
                    bob.getActionMap().remove("rebuildTree");
                }
            });
        }
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
        refreshText = "refresh";
        rebuildTreeText = "rebuild tree";
    }
}

