/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.typeconv.impl;

import java.awt.Color;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RGB {
    private static final Logger logger = Logger.getLogger(RGB.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public static String rgb(Color color) {
        if (color == null) {
            return null;
        }
        String sRed = Integer.toHexString(color.getRed());
        String sGreen = Integer.toHexString(color.getGreen());
        String sBlue = Integer.toHexString(color.getBlue());
        if (sRed.length() < 2) {
            sRed = "0" + sRed;
        }
        if (sGreen.length() < 2) {
            sGreen = "0" + sGreen;
        }
        if (sBlue.length() < 2) {
            sBlue = "0" + sBlue;
        }
        return "#" + sRed + sGreen + sBlue;
    }

    public static Color rgb(String rgbValue) {
        if (rgbValue == null) {
            return Color.black;
        }
        if (rgbValue.matches("(?i)#[0-9a-f]{6}")) {
            String sRedComponent = rgbValue.substring(1, 3).toUpperCase();
            String sGreenComponent = rgbValue.substring(3, 5).toUpperCase();
            String sBlueComponent = rgbValue.substring(5, 7).toUpperCase();
            int iRed = Integer.parseInt(sRedComponent, 16);
            int iGreen = Integer.parseInt(sGreenComponent, 16);
            int iBlue = Integer.parseInt(sBlueComponent, 16);
            return new Color(iRed, iGreen, iBlue);
        }
        return Color.black;
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

