/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.typeconv.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.Convertor;
import xyz.cofe.gui.swing.properties.PropertyID;
import xyz.cofe.text.Text;
import xyz.cofe.typeconv.spi.GetTypeConvertor;

public class Str2PropertyIDSPI
implements GetTypeConvertor {
    private static final Logger logger = Logger.getLogger(Str2PropertyIDSPI.class.getName());

    private static Level logLevel() {
        return logger.getLevel();
    }

    private static boolean isLogSevere() {
        Level ll = Str2PropertyIDSPI.logLevel();
        return ll == null ? true : ll.intValue() <= Level.SEVERE.intValue();
    }

    private static boolean isLogWarning() {
        Level ll = Str2PropertyIDSPI.logLevel();
        return ll == null ? true : ll.intValue() <= Level.WARNING.intValue();
    }

    private static boolean isLogInfo() {
        Level ll = Str2PropertyIDSPI.logLevel();
        return ll == null ? true : ll.intValue() <= Level.INFO.intValue();
    }

    private static boolean isLogFine() {
        Level ll = Str2PropertyIDSPI.logLevel();
        return ll == null ? true : ll.intValue() <= Level.FINE.intValue();
    }

    private static boolean isLogFiner() {
        Level ll = Str2PropertyIDSPI.logLevel();
        return ll == null ? false : ll.intValue() <= Level.FINER.intValue();
    }

    private static boolean isLogFinest() {
        Level ll = Str2PropertyIDSPI.logLevel();
        return ll == null ? false : ll.intValue() <= Level.FINEST.intValue();
    }

    private static void logEntering(String method, Object ... args) {
        logger.entering(Str2PropertyIDSPI.class.getName(), method, args);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(Str2PropertyIDSPI.class.getName(), method, result);
    }

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public Class getSourceType() {
        return String.class;
    }

    public Class getTargetType() {
        return PropertyID.class;
    }

    public Convertor getConvertor() {
        return new Convertor(){

            public Object convert(Object p) {
                if (p instanceof String) {
                    String s = (String)p;
                    PropertyID r = PropertyID.parse(s);
                    if (r == null) {
                        throw new Error("can't parse " + Text.encodeStringConstant((String)s) + " as PropertyID");
                    }
                    return r;
                }
                throw new ClassCastException("can't cast from " + (p == null ? "null" : p.getClass().getName()) + " to " + PropertyID.class.getName());
            }
        };
    }
}

