/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.j2d;

import java.awt.geom.Point2D;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Coord {
    private static final Logger logger = Logger.getLogger(Coord.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    private double angle = 0.0;
    private double length = 0.0;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(Coord.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(Coord.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(Coord.class.getName(), method, result);
    }

    public Coord() {
    }

    public Coord(double anlge, double length) {
        this.angle = anlge;
        this.length = length;
    }

    public Coord(Point2D vector) {
        if (vector == null) {
            throw new IllegalArgumentException("vector == null");
        }
        this.angle = Coord.angle(vector.getX(), vector.getY());
        this.length = Coord.distance(vector.getX(), vector.getY());
    }

    public static double angle(double x, double y) {
        if (x == 0.0 && y == 0.0) {
            return 0.0;
        }
        int p = 0;
        if (x >= 0.0 && y >= 0.0) {
            p = 0;
        }
        if (x < 0.0 && y >= 0.0) {
            p = 1;
        }
        if (x < 0.0 && y < 0.0) {
            p = 2;
        }
        if (x >= 0.0 && y < 0.0) {
            p = 3;
        }
        switch (p) {
            case 0: {
                return x == 0.0 ? 1.5707963267948966 : Math.atan(y / x);
            }
            case 1: {
                return Math.PI + Math.atan(y / x);
            }
            case 2: {
                return Math.PI + Math.atan(y / x);
            }
            case 3: {
                return x == 0.0 ? 4.71238898038469 : Math.atan(y / x);
            }
        }
        return 0.0;
    }

    public static double distance(double x, double y) {
        return Math.sqrt(x * x + y * y);
    }

    public double getAngle() {
        return this.angle;
    }

    public double getLength() {
        return this.length;
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

