/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.j2d;

import java.awt.geom.Point2D;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.j2d.LineFactor;
import xyz.cofe.j2d.MathException;

public class Line {
    private static final Logger logger = Logger.getLogger(Line.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    private Point2D Begin;
    private Point2D End;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(Line.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(Line.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(Line.class.getName(), method, result);
    }

    public Line(Point2D begin, Point2D dEnd) {
        if (begin == null) {
            throw new IllegalArgumentException("begin==null");
        }
        if (dEnd == null) {
            throw new IllegalArgumentException("dEnd==null");
        }
        this.Begin = begin;
        this.End = dEnd;
    }

    public Point2D getBegin() {
        return this.Begin;
    }

    public Point2D getEnd() {
        return this.End;
    }

    public boolean hitTest(Point2D d, double r) {
        if (d == null) {
            throw new IllegalArgumentException("d==null");
        }
        if (r < 0.0) {
            throw new IllegalArgumentException("r<0");
        }
        double minx = this.End.getX() < this.Begin.getX() ? this.End.getX() : this.Begin.getX();
        double miny = this.End.getY() < this.Begin.getY() ? this.End.getY() : this.Begin.getY();
        double maxx = this.End.getX() > this.Begin.getX() ? this.End.getX() : this.Begin.getX();
        double maxy = this.End.getY() > this.Begin.getY() ? this.End.getY() : this.Begin.getY();
        miny -= r;
        maxx += r;
        maxy += r;
        if (d.getX() < (minx -= r) || d.getX() > maxx || d.getY() < miny || d.getY() > maxy) {
            return false;
        }
        LineFactor lf = new LineFactor(this.Begin.getX(), this.Begin.getY(), this.End.getX(), this.End.getY());
        double _r = lf.distance(d.getX(), d.getY());
        double d2 = _r = _r < 0.0 ? -_r : _r;
        return _r <= r;
    }

    public LineFactor getLineFactor() {
        return new LineFactor(this);
    }

    public Point2D intersection(Line line) {
        try {
            Point2D cross = this.getLineFactor().intersection(line.getLineFactor());
            boolean dotOnThisLine = false;
            boolean dotOnArgmLine = false;
            double minx = 0.0;
            double miny = 0.0;
            double maxx = 0.0;
            double maxy = 0.0;
            minx = this.Begin.getX() > this.End.getX() ? this.End.getX() : this.Begin.getX();
            miny = this.Begin.getY() > this.End.getY() ? this.End.getY() : this.Begin.getY();
            maxx = this.Begin.getX() > this.End.getX() ? this.Begin.getX() : this.End.getX();
            maxy = this.Begin.getY() > this.End.getY() ? this.Begin.getY() : this.End.getY();
            dotOnThisLine = cross.getX() >= minx && cross.getX() <= maxx && cross.getY() >= miny && cross.getY() <= maxy;
            minx = line.Begin.getX() > line.End.getX() ? line.End.getX() : line.Begin.getX();
            miny = line.Begin.getY() > line.End.getY() ? line.End.getY() : line.Begin.getY();
            maxx = line.Begin.getX() > line.End.getX() ? line.Begin.getX() : line.End.getX();
            maxy = line.Begin.getY() > line.End.getY() ? line.Begin.getY() : line.End.getY();
            boolean bl = dotOnArgmLine = cross.getX() >= minx && cross.getX() <= maxx && cross.getY() >= miny && cross.getY() <= maxy;
            if (dotOnArgmLine && dotOnThisLine) {
                return cross;
            }
            return null;
        }
        catch (MathException ex) {
            return null;
        }
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

