/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.j2d;

import java.awt.geom.Point2D;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.j2d.Line;
import xyz.cofe.j2d.MathException;

public class LineFactor {
    private static final Logger logger = Logger.getLogger(LineFactor.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    private double A;
    private double B;
    private double C;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(LineFactor.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(LineFactor.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(LineFactor.class.getName(), method, result);
    }

    public LineFactor(double a, double b, double c) {
        this.A = a;
        this.B = b;
        this.C = c;
    }

    public LineFactor(double x1, double y1, double x2, double y2) {
        this.A = y1 - y2;
        this.B = x2 - x1;
        this.C = -this.A * x1 - this.B * y1;
    }

    public LineFactor(Point2D d1, Point2D d2) {
        this(d1.getX(), d1.getY(), d2.getX(), d2.getY());
    }

    public LineFactor(Line line) {
        this(line.getBegin(), line.getEnd());
    }

    public double getA() {
        return this.A;
    }

    public double getB() {
        return this.B;
    }

    public double getC() {
        return this.C;
    }

    public double getX(double y) {
        if (this.A == 0.0) {
            throw new MathException("\u0418\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u043a\u043e\u043e\u0440\u0434\u0438\u043d\u0430\u0442\u0430 \u043d\u0435 \u043b\u0435\u0436\u0438\u0442 \u043d\u0430 \u043f\u0440\u044f\u043c\u043e\u0439");
        }
        return -(this.B * y + this.C) / this.A;
    }

    public double getY(double x) {
        if (this.B == 0.0) {
            throw new MathException("\u0418\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u043a\u043e\u043e\u0440\u0434\u0438\u043d\u0430\u0442\u0430 \u043d\u0435 \u043b\u0435\u0436\u0438\u0442 \u043d\u0430 \u043f\u0440\u044f\u043c\u043e\u0439");
        }
        return -(this.A * x + this.C) / this.B;
    }

    public LineFactor makeNormal(double x, double y) {
        double x2 = x + this.A;
        double y2 = y + this.B;
        return new LineFactor(x, y, x2, y2);
    }

    public LineFactor makeNormal(Point2D dot) {
        return this.makeNormal(dot.getX(), dot.getY());
    }

    public boolean IsParallel(LineFactor line) {
        double f1 = this.B == 0.0 ? 0.0 : this.A / this.B;
        double f2 = line.B == 0.0 ? 0.0 : line.A / line.B;
        return f1 == f2;
    }

    public Point2D intersection(LineFactor line) {
        if (this.IsParallel(line)) {
            throw new MathException("\u041f\u0440\u044f\u043c\u044b\u0435 \u043f\u0430\u0440\u0430\u043b\u0435\u043b\u044c\u043d\u044b");
        }
        double a1 = this.A;
        double b1 = this.B;
        double c1 = this.C;
        double a2 = line.A;
        double b2 = line.B;
        double c2 = line.C;
        double x = (b1 * c2 - b2 * c1) / (a1 * b2 - a2 * b1);
        double y = (c1 * a2 - c2 * a1) / (a1 * b2 - a2 * b1);
        return new Point2D.Double(x, y);
    }

    public double distance(double x, double y) {
        double v = this.value(x, y);
        v = v < 0.0 ? -v : v;
        return v / Math.sqrt(this.A * this.A + this.B * this.B);
    }

    public double value(double x, double y) {
        return this.A * x + this.B * y + this.C;
    }

    public Point2D crossDot(Point2D d) {
        LineFactor normal = this.makeNormal(d);
        return this.intersection(normal);
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

