/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.j2d;

import java.awt.geom.Rectangle2D;

public class RectangleFn {
    public static Rectangle2D paddingLeft(Rectangle2D rect, double padding) {
        if (rect == null) {
            throw new IllegalArgumentException("rect == null");
        }
        if (padding == 0.0) {
            return rect;
        }
        if (padding > 0.0 && padding > rect.getWidth()) {
            padding = rect.getWidth();
        }
        return new Rectangle2D.Double(rect.getMinX() + padding, rect.getMinY(), rect.getMaxX() - rect.getMinX() - padding, rect.getMaxY() - rect.getMinY());
    }

    public static Rectangle2D paddingRight(Rectangle2D rect, double padding) {
        if (rect == null) {
            throw new IllegalArgumentException("rect == null");
        }
        if (padding == 0.0) {
            return rect;
        }
        if (padding > 0.0 && padding > rect.getWidth()) {
            padding = rect.getWidth();
        }
        return new Rectangle2D.Double(rect.getMinX(), rect.getMinY(), rect.getMaxX() - rect.getMinX() - padding, rect.getMaxY() - rect.getMinY());
    }

    public static Rectangle2D paddingTop(Rectangle2D rect, double padding) {
        if (rect == null) {
            throw new IllegalArgumentException("rect == null");
        }
        if (padding == 0.0) {
            return rect;
        }
        if (padding > 0.0 && padding > rect.getHeight()) {
            padding = rect.getHeight();
        }
        return new Rectangle2D.Double(rect.getMinX(), rect.getMinY() + padding, rect.getWidth(), rect.getHeight() - padding);
    }

    public static Rectangle2D paddingBottom(Rectangle2D rect, double padding) {
        if (rect == null) {
            throw new IllegalArgumentException("rect == null");
        }
        if (padding == 0.0) {
            return rect;
        }
        if (padding > 0.0 && padding > rect.getHeight()) {
            padding = rect.getHeight();
        }
        return new Rectangle2D.Double(rect.getMinX(), rect.getMinY(), rect.getWidth(), rect.getHeight() - padding);
    }

    public static Rectangle2D move(Rectangle2D rect, double x, double y) {
        if (rect == null) {
            throw new IllegalArgumentException("rect == null");
        }
        if (x == 0.0 && y == 0.0) {
            return rect;
        }
        return new Rectangle2D.Double(rect.getMinX() + x, rect.getMinY() + y, rect.getMaxX() - rect.getMinX(), rect.getMaxY() - rect.getMinY());
    }

    public static Rectangle2D size(Rectangle2D rect, double width, double height) {
        if (rect == null) {
            throw new IllegalArgumentException("rect == null");
        }
        return new Rectangle2D.Double(rect.getMinX(), rect.getMinY(), width + rect.getMinX(), height + rect.getMinY());
    }

    public static Rectangle2D union(Rectangle2D ... rects) {
        if (rects == null || rects.length == 0) {
            return null;
        }
        Double xmin = null;
        Double xmax = null;
        Double ymin = null;
        Double ymax = null;
        for (Rectangle2D r : rects) {
            if (r == null || r.getWidth() <= 0.0 || r.getHeight() <= 0.0) continue;
            xmin = xmin == null ? r.getMinX() : Math.min(xmin, r.getMinX());
            xmax = xmax == null ? r.getMaxX() : Math.max(xmax, r.getMaxX());
            ymin = ymin == null ? r.getMinY() : Math.min(ymin, r.getMinY());
            ymax = ymax == null ? r.getMaxY() : Math.max(ymax, r.getMaxY());
        }
        if (xmin == null) {
            return null;
        }
        if (ymin == null) {
            return null;
        }
        if (xmax == null) {
            return null;
        }
        if (ymax == null) {
            return null;
        }
        return new Rectangle2D.Double(Math.min(xmin, xmax), Math.min(ymin, ymax), Math.max(xmin, xmax) - Math.min(xmin, xmax), Math.max(ymin, ymax) - Math.min(ymin, ymax));
    }
}

