/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.time;

import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.BasicTriple;
import xyz.cofe.collection.Triple;

public class Day
implements Comparable<Day> {
    private static final Logger logger = Logger.getLogger(Day.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected int date;
    protected int month;
    protected int year;
    protected volatile transient Integer dayOfWeek;
    protected volatile transient GregorianCalendar gregorianCalendar;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(Day.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(Day.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(Day.class.getName(), method, result);
    }

    public Day(int year, int month, int date) {
        Day.validate(year, month, date, true);
        this.year = year;
        this.month = month;
        this.date = date;
    }

    public Day(Day sample) {
        if (sample == null) {
            throw new IllegalArgumentException("sample == null");
        }
        this.year = sample.year;
        this.month = sample.month;
        this.date = sample.date;
    }

    public Day() {
        GregorianCalendar gcal = new GregorianCalendar();
        this.year = gcal.get(1);
        this.month = gcal.get(2) + 1;
        this.date = gcal.get(5);
    }

    public static String validate(int year, int month, int date, boolean throwException) {
        if (month < 1) {
            if (throwException) {
                throw new IllegalArgumentException("month(" + month + ")<1");
            }
            return "month(" + month + ")<1";
        }
        if (month > 12) {
            if (throwException) {
                throw new IllegalArgumentException("month(" + month + ")>12");
            }
            return "month(" + month + ")>12";
        }
        if (date < 1) {
            if (throwException) {
                throw new IllegalArgumentException("date(" + date + ")<1");
            }
            return "date(" + date + ")<1";
        }
        if (date > 31) {
            if (throwException) {
                throw new IllegalArgumentException("date(" + date + ")>31");
            }
            return "date(" + date + ")>31";
        }
        int ml = Day.getMonthLength(year, month);
        if (date > ml) {
            if (throwException) {
                throw new IllegalArgumentException("date(" + date + ")>" + ml);
            }
            return "date(" + date + ")>" + ml;
        }
        return null;
    }

    public int getDate() {
        return this.date;
    }

    public int getMonth() {
        return this.month;
    }

    public int getYear() {
        return this.year;
    }

    public boolean match(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("date == null");
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return this.match(cal);
    }

    public boolean match(Calendar cal) {
        if (cal == null) {
            throw new IllegalArgumentException("cal == null");
        }
        int cy = cal.get(1);
        if (this.year != cy) {
            return false;
        }
        int cm = cal.get(2) + 1;
        if (this.month != cm) {
            return false;
        }
        int cd = cal.get(5);
        return this.date == cd;
    }

    public static boolean isLeapYear(int year) {
        if (year > 1582) {
            int mod4 = year % 4;
            int mod100 = year % 100;
            int mod400 = year % 400;
            return mod4 == 0 && mod100 != 0 || mod400 == 0;
        }
        int mod4 = year % 4;
        return mod4 == 0;
    }

    public static int getDaysOfYear(int year) {
        if (Day.isLeapYear(year)) {
            return 366;
        }
        return 365;
    }

    public static int getMonthLength(int year, int month) {
        boolean ly = Day.isLeapYear(year);
        switch (month) {
            case 1: {
                return 31;
            }
            case 2: {
                if (ly) {
                    return 29;
                }
                return 28;
            }
            case 3: {
                return 31;
            }
            case 4: {
                return 30;
            }
            case 5: {
                return 31;
            }
            case 6: {
                return 30;
            }
            case 7: {
                return 31;
            }
            case 8: {
                return 31;
            }
            case 9: {
                return 30;
            }
            case 10: {
                return 31;
            }
            case 11: {
                return 30;
            }
            case 12: {
                return 31;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDayOfWeek() {
        if (this.dayOfWeek != null) {
            return this.dayOfWeek;
        }
        Day day = this;
        synchronized (day) {
            if (this.dayOfWeek != null) {
                return this.dayOfWeek;
            }
            this.dayOfWeek = Day.getDayOfWeek(this.year, this.month, this.date);
            return this.dayOfWeek;
        }
    }

    public static int getDayOfWeek(int year, int month, int date) {
        if (year > 1582) {
            int a = (14 - month) / 12;
            int y = year - a;
            int m = month + 12 * a - 2;
            int d1 = (7000 + (date + y + y / 4 - y / 100 + y / 400 + 31 * m / 12)) % 7;
            int d2 = 0;
            switch (d1) {
                case 0: {
                    d2 = 6;
                    break;
                }
                case 1: {
                    d2 = 0;
                    break;
                }
                case 2: {
                    d2 = 1;
                    break;
                }
                case 3: {
                    d2 = 2;
                    break;
                }
                case 4: {
                    d2 = 3;
                    break;
                }
                case 5: {
                    d2 = 4;
                    break;
                }
                case 6: {
                    d2 = 5;
                }
            }
            return d2;
        }
        int a = (14 - month) / 12;
        int y = year - a;
        int m = month + 12 * a - 2;
        int d1 = (7000 + (date + y + y / 4 + 31 * m / 12) - 2) % 7;
        int d2 = 0;
        switch (d1) {
            case 0: {
                d2 = 6;
                break;
            }
            case 1: {
                d2 = 0;
                break;
            }
            case 2: {
                d2 = 1;
                break;
            }
            case 3: {
                d2 = 2;
                break;
            }
            case 4: {
                d2 = 3;
                break;
            }
            case 5: {
                d2 = 4;
                break;
            }
            case 6: {
                d2 = 5;
            }
        }
        return d2;
    }

    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + this.date;
        hash = 41 * hash + this.month;
        hash = 41 * hash + this.year;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Day other = (Day)obj;
        if (this.date != other.date) {
            return false;
        }
        if (this.month != other.month) {
            return false;
        }
        return this.year == other.year;
    }

    @Override
    public int compareTo(Day d) {
        if (d == null) {
            return -1;
        }
        if (this.year < d.getYear()) {
            return -1;
        }
        if (this.year > d.getYear()) {
            return 1;
        }
        if (this.month < d.getMonth()) {
            return -1;
        }
        if (this.month > d.getMonth()) {
            return 1;
        }
        if (this.date < d.getDate()) {
            return -1;
        }
        if (this.date > d.getDate()) {
            return 1;
        }
        return 0;
    }

    public Date getBeginDate() {
        GregorianCalendar gcal = new GregorianCalendar(this.year, this.month - 1, this.date);
        return gcal.getTime();
    }

    public static Triple<Integer, Integer, Integer> nextDay(int year, int month, int date) {
        Day.validate(year, month, date, true);
        int mlen = Day.getMonthLength(year, month);
        if (date < mlen) {
            return new BasicTriple((Object)year, (Object)month, (Object)(date + 1));
        }
        if (month < 12) {
            return new BasicTriple((Object)year, (Object)(month + 1), (Object)1);
        }
        return new BasicTriple((Object)(year + 1), (Object)1, (Object)1);
    }

    public static Triple<Integer, Integer, Integer> nextDay(Triple<Integer, Integer, Integer> yearMonDate) {
        if (yearMonDate == null) {
            throw new IllegalArgumentException("yearMonDate == null");
        }
        if (yearMonDate.A() == null) {
            throw new IllegalArgumentException("yearMonDate.A() == null");
        }
        if (yearMonDate.B() == null) {
            throw new IllegalArgumentException("yearMonDate.B() == null");
        }
        if (yearMonDate.C() == null) {
            throw new IllegalArgumentException("yearMonDate.C() == null");
        }
        return Day.nextDay((Integer)yearMonDate.A(), (Integer)yearMonDate.B(), (Integer)yearMonDate.C());
    }

    public Day getNextDay() {
        Triple<Integer, Integer, Integer> t = Day.nextDay(this.year, this.month, this.date);
        return new Day((Integer)t.A(), (Integer)t.B(), (Integer)t.C());
    }

    public static Triple<Integer, Integer, Integer> prevDay(int year, int month, int date) {
        Day.validate(year, month, date, true);
        if (date > 1) {
            return new BasicTriple((Object)year, (Object)month, (Object)(date - 1));
        }
        if (month > 1) {
            return new BasicTriple((Object)year, (Object)(month - 1), (Object)Day.getMonthLength(year, month - 1));
        }
        return new BasicTriple((Object)(year - 1), (Object)12, (Object)Day.getMonthLength(year - 1, 12));
    }

    public static Triple<Integer, Integer, Integer> prevDay(Triple<Integer, Integer, Integer> yearMonDate) {
        if (yearMonDate == null) {
            throw new IllegalArgumentException("yearMonDate == null");
        }
        if (yearMonDate.A() == null) {
            throw new IllegalArgumentException("yearMonDate.A() == null");
        }
        if (yearMonDate.B() == null) {
            throw new IllegalArgumentException("yearMonDate.B() == null");
        }
        if (yearMonDate.C() == null) {
            throw new IllegalArgumentException("yearMonDate.C() == null");
        }
        return Day.prevDay((Integer)yearMonDate.A(), (Integer)yearMonDate.B(), (Integer)yearMonDate.C());
    }

    public Day getPrevDay() {
        Triple<Integer, Integer, Integer> t = Day.prevDay(this.year, this.month, this.date);
        return new Day((Integer)t.A(), (Integer)t.B(), (Integer)t.C());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GregorianCalendar getCalendar() {
        if (this.gregorianCalendar != null) {
            return this.gregorianCalendar;
        }
        Day day = this;
        synchronized (day) {
            if (this.gregorianCalendar != null) {
                return this.gregorianCalendar;
            }
            this.gregorianCalendar = new GregorianCalendar(this.year, this.month - 1, this.date);
            return this.gregorianCalendar;
        }
    }

    public int getWeekOfYear() {
        return this.getCalendar().get(3);
    }

    public int getWeekOfMonth() {
        return this.getCalendar().get(4);
    }

    public Day getFirstDayOfMonth() {
        return new Day(this.year, this.month, 1);
    }

    public boolean isFirstDayOfWeek() {
        int weekDay = this.getDayOfWeek();
        return weekDay == 0;
    }

    public boolean isLastDayOfWeek() {
        int weekDay = this.getDayOfWeek();
        return weekDay == 6;
    }

    public boolean isFirstDayOfMonth() {
        return this.date == 1;
    }

    public boolean isLastDayOfMonth() {
        return this.date == this.getMonthLength();
    }

    public Day getFirstDayOfWeek() {
        int weekDay = this.getDayOfWeek();
        if (weekDay == 0) {
            return this;
        }
        if (weekDay > 0) {
            Day d = this;
            for (int i = 0; i < weekDay; ++i) {
                d = d.getPrevDay();
            }
            return d;
        }
        return this;
    }

    public static String[] getDayNames() {
        return Day.getDayNames(false, null);
    }

    public static String[] getDayNames(boolean shortNames) {
        return Day.getDayNames(shortNames, null);
    }

    public static String[] getDayNames(boolean shortNames, Locale loc) {
        DateFormatSymbols dfs = loc != null ? DateFormatSymbols.getInstance(loc) : DateFormatSymbols.getInstance();
        String[] names = shortNames ? dfs.getShortWeekdays() : dfs.getWeekdays();
        return new String[]{names[2], names[3], names[4], names[5], names[6], names[7], names[1]};
    }

    public String getMonthName() {
        return this.getMonthName(false);
    }

    public String getMonthName(boolean shortName) {
        return this.getMonthName(shortName, null);
    }

    public String getMonthName(boolean shortName, Locale loc) {
        DateFormatSymbols dfs = loc != null ? DateFormatSymbols.getInstance(loc) : DateFormatSymbols.getInstance();
        String[] mons = shortName ? dfs.getShortMonths() : dfs.getMonths();
        return mons[this.month - 1];
    }

    public String getDayName() {
        return this.getDayName(false);
    }

    public String getDayName(boolean shortName) {
        return this.getDayName(shortName, null);
    }

    public String getDayName(boolean shortName, Locale loc) {
        int dw = this.getDayOfWeek();
        return Day.getDayNames(shortName, loc)[dw];
    }

    public String toString() {
        return "" + this.year + "-" + this.getMonthName(true, null) + "-" + this.getDate() + " " + this.getDayName(true, null) + "";
    }

    public int getMonthLength() {
        return Day.getMonthLength(this.year, this.month);
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

