/*
 * The MIT License
 *
 * Copyright 2015 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"),
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ,
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ,
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */

package xyz.cofe.common;

import java.io.Closeable;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.Func2;
import xyz.cofe.xml.XmlCoder;


/**
 * Фрагмент данных
 * @author Kamnev Georgiy (nt.gocha@gmail.com)
 */
public class Fragment extends ImmutableFragment
{
    //<editor-fold defaultstate="collapsed" desc="log Функции">
    private static void logFine(String message,Object ... args){
        Logger.getLogger(Fragment.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message,Object ... args){
        Logger.getLogger(Fragment.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message,Object ... args){
        Logger.getLogger(Fragment.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message,Object ... args){
        Logger.getLogger(Fragment.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message,Object ... args){
        Logger.getLogger(Fragment.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message,Object ... args){
        Logger.getLogger(Fragment.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex){
        Logger.getLogger(Fragment.class.getName()).log(Level.SEVERE, null, ex);
    }
    //</editor-fold>

    public class Event {
        protected Fragment source = null;
        public Event(Fragment source){
            this.source = source;
        }

        public Fragment getSource() {
            return source;
        }
    }

    //<editor-fold defaultstate="collapsed" desc="PropertyInsertedEvent">
//    public class PropertyInsertedEvent extends Event {
//        protected Object property = null;
//        protected Object value = null;
//
//        public PropertyInsertedEvent(Fragment source, Object property, Object value) {
//            super(source);
//            this.property = property;
//            this.value = value;
//        }
//
//        public Object getProperty() {
//            return property;
//        }
//
//        public Object getValue() {
//            return value;
//        }
//    }
//</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="PropertyDeletedEvent">
//    public class PropertyDeletedEvent extends Event {
//        protected Object property = null;
//        protected Object value = null;
//
//        public PropertyDeletedEvent(Fragment source, Object property, Object value) {
//            super(source);
//            this.property = property;
//            this.value = value;
//        }
//
//        public Object getProperty() {
//            return property;
//        }
//
//        public Object getValue() {
//            return value;
//        }
//    }
//</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="PropertyUpdatedEvent">
//    public class PropertyUpdatedEvent extends Event {
//        protected Object property = null;
//        protected Object oldValue = null;
//        protected Object newValue = null;
//
//        public PropertyUpdatedEvent(Fragment source, Object property, Object oldvalue, Object newvalue) {
//            super(source);
//            this.property = property;
//            this.oldValue = oldvalue;
//            this.newValue = newvalue;
//        }
//
//        public Object getProperty() {
//            return property;
//        }
//
//        public Object getOldValue() {
//            return oldValue;
//        }
//
//        public Object getNewValue() {
//            return newValue;
//        }
//    }
//</editor-fold>


    //<editor-fold defaultstate="collapsed" desc="listeners">
    public interface Listener {
        public void fragmentEvent( Event event );
    }

    protected ListenersHelper<Listener,Event> listeners = null;
    protected ListenersHelper<Listener,Event> listeners(){
        if( listeners!=null )return listeners;
        listeners =
        new ListenersHelper<Listener, Event>(new Func2<Object, Listener, Event>() {
                @Override
                public Object apply(Listener lst, Event e) {
                    lst.fragmentEvent(e);
                    return null;
                }
            },
            listenerLock
        );
        return listeners;
    }

    public Set<Listener> getListeners() {
        return listeners().getListeners();
    }

    public Closeable addListener(Listener listener) {
        return listeners().addListener(listener);
    }

    public Closeable addListener(Listener listener, boolean weakLink) {
        return listeners().addListener(listener, weakLink);
    }

    public void removeListener(Listener listener) {
        listeners().removeListener(listener);
    }

    public void fireEvent(Event event) {
        listeners().fireEvent(event);
    }
    //</editor-fold>

    protected Lock lock = null;
    protected Lock listenerLock = null;

    /**
     * Конструктор
     * @param begin начало фрагмента
     * @param end конец фрагмента (искл)
     * @param lock блокировка для синхронизации
     */
    public Fragment(long begin, long end, Lock lock){
        super();

        this.lock = lock;
        this.listenerLock = lock;

        init(begin,end);

//        if( properties instanceof EventMap ){
//            EventMap emap = (EventMap)properties;
//            emap.addEventMapListener(propertiesListener);
//        }
    }

    /**
     * Конструктор
     * @param begin начало фрагмента
     * @param end конец фрагмента (искл)
     */
    public Fragment(long begin, long end){
        super();

        this.lock = createLock();
        this.listenerLock = this.lock;

        init(begin, end);

//        if( properties instanceof EventMap ){
//            EventMap emap = (EventMap)properties;
//            emap.addEventMapListener(propertiesListener);
//        }
    }

    /**
     * Конструктор копирования
     * @param source образец
     */
    public Fragment(Fragment source){
        super();

        this.lock = createLock();
        this.listenerLock = this.lock;

        init(source);

//        if( properties instanceof EventMap ){
//            EventMap emap = (EventMap)properties;
//            emap.addEventMapListener(propertiesListener);
//        }
    }

    protected Lock createLock(){
        return new ReentrantLock();
    }

//    @Override
//    protected Map createProperties() {
//        return new xyz.cofe.collection.map.BasicEventMap(
//            new LinkedHashMap(),
//            lock
//        );
//    }

    /**
     * Создание клона
     * @return клон
     */
    @Override
    public Fragment clone(){
        return new Fragment(this);
    }

    protected Queue<Event> eventQu = new LinkedBlockingQueue<Event>();
    protected void fireEventQu(){
        while( true ){
            Event e = eventQu.poll();
            if( e==null )break;
            fireEvent(e);
        }
    }

    //<editor-fold defaultstate="collapsed" desc="properties listener">
//    protected EventMapAdapter propertiesListener = new EventMapAdapter(){
//        @Override
//        protected void updated(EventMap map, Object old, Object key, Object value) {
//            eventQu.add(new PropertyUpdatedEvent(Fragment.this, key, old, value));
//            if( syncFirePropertyListeners.get() )fireEventQu();
//        }
//
//        @Override
//        protected void deleted(EventMap map, Object key, Object value) {
//            eventQu.add(new PropertyDeletedEvent(Fragment.this, key, value));
//            if( syncFirePropertyListeners.get() )fireEventQu();
//        }
//
//        @Override
//        protected void inserted(EventMap map, Object key, Object value) {
//            eventQu.add(new PropertyInsertedEvent(Fragment.this, key, value));
//            if( syncFirePropertyListeners.get() )fireEventQu();
//        }
//    };
//</editor-fold>

    protected final AtomicBoolean syncFirePropertyListeners = new AtomicBoolean(true);

    /**
     * Обновление свойств с учетом блокировок и много поточности.
     * Нужно, чтоб listeners вызывались после снятия блокировки.
     * @param code Код обновления свойств
     */
    protected void syncUpdateProperties( Runnable code ){
        if( code==null )throw new IllegalArgumentException( "code==null" );
        try{
            syncFirePropertyListeners.set(false);
            code.run();
        }finally{
            syncFirePropertyListeners.set(true);
        }
        fireEventQu();
    }

    /**
     * Установка начала фрагмента
     * @param begin начала фрагмента
     */
    public void setBegin( final long begin ){
        Runnable r = new Runnable() {
            @Override
            public void run() {
//                Fragment.this.put(BEGIN, begin);
                Fragment.this.begin = begin;
            }
        };
        syncUpdateProperties(r);
    }

    /**
     * Установка конца фрагмента
     * @param end конец фрагмента (искл)
     */
    public void setEnd( final long end ){
        Runnable r = new Runnable() {
            @Override
            public void run() {
//                Fragment.this.put(END, end);
                Fragment.this.end = end;
            }
        };
        syncUpdateProperties(r);
    }

    /**
     * Устанавливает границы текущего фрагмента
     * @param begin начало, от нуля
     * @param end конец, от нуля исключительно. end должен быть больше или равен begin.
     */
    public void setRange( final long begin, final long end ){
        Runnable r = new Runnable() {
            @Override
            public void run() {
                long b = begin;
                long e = end;
                if( e<b ){
                    long t = b; b = e; e = t;
                }
//                Fragment.this.put(BEGIN, b);
                Fragment.this.begin = b;
//                Fragment.this.put(END, e);
                Fragment.this.end = e;
            }
        };
        syncUpdateProperties(r);
    }

    /**
     * Указание нового размера для текущего фрагмента
     * @param newSize размер &gt;= 0
     */
    @XmlCoder.Ignore
    public void setSize( final long newSize ){
        if( newSize<0 )throw new IllegalArgumentException("newsize<0");
        Runnable r = new Runnable() {
            @Override
            public void run() {
                long b = Fragment.this.getBegin();
                long e = b + newSize;
//                Fragment.this.put(END, e);
                Fragment.this.end = e;
            }
        };
        syncUpdateProperties(r);
    }

    @Override
    public Fragment union(ImmutableFragment fragment) {
        ImmutableFragment f = super.union(fragment);
        if( f instanceof Fragment )return (Fragment)f;
        return new Fragment(f.getBegin(), f.getEnd());
    }

//    @Override
//    public void put(String key, Object value) {
//        super.put(key, value);
//    }
//
//    @Override
//    public void putAll(Map<String, Object> map) {
//        super.putAll(map); //To change body of generated methods, choose Tools | Templates.
//    }
//
//    @Override
//    public void clear() {
//        super.clear(); //To change body of generated methods, choose Tools | Templates.
//    }
//
//    @Override
//    public void remove(Object key) {
//        super.remove(key); //To change body of generated methods, choose Tools | Templates.
//    }
}
