/*
 * The MIT License
 *
 * Copyright 2015 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"),
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ,
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ,
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */

package xyz.cofe.common;


import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import org.xml.sax.SAXException;
import xyz.cofe.typeconv.BaseCastGraph;
import xyz.cofe.typeconv.TypeCastGraph;
import xyz.cofe.xml.FormatXMLWriter;
import xyz.cofe.xml.XMLUtil;

/**
 * Сохранение / восстановление xml
 * @author Kamnev Georgiy (nt.gocha@gmail.com)
 */
public class FragmentsXmlDom {
    //<editor-fold defaultstate="collapsed" desc="log Функции">
    private static void logFine(String message,Object ... args){
        Logger.getLogger(FragmentsXmlDom.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message,Object ... args){
        Logger.getLogger(FragmentsXmlDom.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message,Object ... args){
        Logger.getLogger(FragmentsXmlDom.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message,Object ... args){
        Logger.getLogger(FragmentsXmlDom.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message,Object ... args){
        Logger.getLogger(FragmentsXmlDom.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message,Object ... args){
        Logger.getLogger(FragmentsXmlDom.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex){
        Logger.getLogger(FragmentsXmlDom.class.getName()).log(Level.SEVERE, null, ex);
    }
    //</editor-fold>

    /**
     * Сохранение в XML
     */
    public static class Store {
        protected org.w3c.dom.Document xdoc = null;
        protected TypeCastGraph typeCast = new BaseCastGraph();

        public Store( TypeCastGraph typeCast, org.w3c.dom.Document xdoc ){
            if( xdoc==null )throw new IllegalArgumentException( "xdoc==null" );
            if( typeCast==null )throw new IllegalArgumentException( "typeCast==null" );
            this.xdoc = xdoc;
            this.typeCast = typeCast;
        }

        public Store( org.w3c.dom.Document xdoc ){
            if( xdoc==null )throw new IllegalArgumentException( "xdoc==null" );
            this.xdoc = xdoc;
        }

        public org.w3c.dom.Element createElementOf( Fragments fragments ){
            if( fragments==null )throw new IllegalArgumentException( "fragments==null" );
            if( xdoc==null )throw new IllegalArgumentException( "xdoc==null" );

            Lock lock = fragments.getLock();
            if( lock!=null ){
                lock.lock();
                try{
                    return createElementOf0(fragments);
                }finally{
                    return createElementOf0(fragments);
                }
            }else{
                return createElementOf0(fragments);
            }
        }

        private org.w3c.dom.Element createElementOf0( Fragments fragments ){
            org.w3c.dom.Element fragmentsEl = xdoc.createElement("fragments");
            fragmentsEl.setAttribute("javaType", fragments.getClass().getName());

            for( Fragment f : fragments ){
                if( f==null )continue;
                org.w3c.dom.Element el = createElementOf(f);
                if( el!=null ){
                    fragmentsEl.appendChild(el);
                }
            }
            return fragmentsEl;
        }

        public org.w3c.dom.Element createElementOf( Fragment fragment ){
            if( fragment==null )throw new IllegalArgumentException( "fragment==null" );
            if( xdoc==null )throw new IllegalArgumentException( "xdoc==null" );

            org.w3c.dom.Element fragmentEl = xdoc.createElement("fragment");
            fragmentEl.setAttribute("javaType", fragment.getClass().getName());

            fragmentEl.setAttribute("begin", typeCast.cast(fragment.getBegin(), String.class));
            fragmentEl.setAttribute("end", typeCast.cast(fragment.getEnd(), String.class));

            org.w3c.dom.Element propertiesEl = xdoc.createElement("properties");
            fragmentEl.appendChild(propertiesEl);

//            for( String propKey : fragment.getKeys() ){
//                if( propKey==null )continue;
//
//                Object propVal = fragment.get(propKey);
//                if( propVal==null ){
//                    org.w3c.dom.Element propertyEl = xdoc.createElement("property");
//                    propertiesEl.appendChild(propertyEl);
//                    propertyEl.setAttribute("name", propKey);
//                }else{
//                    org.w3c.dom.Element propertyEl = xdoc.createElement("property");
//                    propertiesEl.appendChild(propertyEl);
//                    propertyEl.setAttribute("name", propKey);
//
//                    String strval = typeCast.cast(propVal, String.class);
//                    propertyEl.setAttribute("value", strval);
//
//                    String typename = propVal.getClass().getName();
//                    propertyEl.setAttribute("valueType", typename);
//                }
//            }

            return fragmentEl;
        }
    }

    /**
     * Восстановление из XML
     */
    public static class Restore {
        protected TypeCastGraph typeCast = new BaseCastGraph();

        public Restore(){
        }

        public Restore(TypeCastGraph typeCast){
            if( typeCast==null )throw new IllegalArgumentException( "typeCast==null" );
            this.typeCast = typeCast;
        }

        public Fragments createFragmentsFrom( org.w3c.dom.Element fragmentsElement ){
            if( fragmentsElement==null )throw new IllegalArgumentException( "fragmentsElement==null" );

            String javaType = fragmentsElement.getAttribute("javaType");
            Fragments fragments = createFragments(javaType);
            for( org.w3c.dom.Element fragmentEl :
                XMLUtil.elements(
                    fragmentsElement,
                    XMLUtil.Predicates.nodeName("fragment", true)) ){
                if( fragmentEl!=null ){
                    Fragment f = createFragmentFrom(fragmentEl);
                    if( f!=null ){
                        fragments.add(f);
                    }
                }
            }
            return fragments;
        }

        protected Fragments createFragments(String javaType){
            return new Fragments();
        }

        public Fragment createFragmentFrom( org.w3c.dom.Element fragmentElement ){
            if( fragmentElement==null )throw new IllegalArgumentException( "fragmentElement==null" );

            String javaType = fragmentElement.getAttribute("javaType");

            String beginStr = fragmentElement.getAttribute("begin");
            if( beginStr==null || beginStr.length()==0 )return null;

            String endStr = fragmentElement.getAttribute("end");
            if( endStr==null || endStr.length()==0 )return null;

            Fragment fragment = createFragment(
                javaType,
                typeCast.cast(beginStr, Long.class),
                typeCast.cast(endStr, Long.class)
                );
            if( fragment==null )return null;

            for( org.w3c.dom.Element propertiesEl :
                XMLUtil.elements(
                    fragmentElement,
                    XMLUtil.Predicates.nodeName("properties", true)) ){

                if( propertiesEl!=null ){
                    for( org.w3c.dom.Element propertyEl :
                        XMLUtil.elements(
                            propertiesEl,
                            XMLUtil.Predicates.nodeName("property", true)) ){
                        if( propertyEl==null )continue;

                        String propName = propertyEl.getAttribute("name");
                        String valueStr = propertyEl.getAttribute("value");
                        String valueType = propertyEl.getAttribute("valueType");

                        if( propName!=null && valueStr==null && valueType==null && propName.length()>0 ){
//                            fragment.put(propName, null);
                        }else if(
                            propName!=null &&
                            valueStr!=null &&
                            valueType!=null &&
                            valueStr.length()>0 &&
                            valueType.length()>0 && propName.length()>0
                            ){
//                            try {
//                                fragment.put(propName, typeCast.cast(valueStr, Class.forName(valueType)));
//                            } catch (ClassNotFoundException ex) {
//                                Logger.getLogger(FragmentsXmlDom.class.getName()).log(Level.SEVERE, null, ex);
//                            }
                        }
                    }
                }
            }

            return fragment;
        }

        protected Fragment createFragment(String javaType, long begin, long end){
            return new Fragment(begin, end);
        }
    }

    protected Store createStore(org.w3c.dom.Document doc){
        if( doc==null )throw new IllegalArgumentException( "doc==null" );
        return new Store(doc);
    }

    protected Restore createRestore(){
        return new Restore();
    }

    public void write( Writer writer, Fragments fragments ) throws IOException {
        try {
            if( writer==null )throw new IllegalArgumentException( "writer==null" );
            if( fragments==null )throw new IllegalArgumentException( "fragments==null" );

            org.w3c.dom.Document doc = XMLUtil.createDocument();
            Store store = createStore(doc);

            org.w3c.dom.Element el = store.createElementOf(fragments);
            doc.appendChild(el);

            FormatXMLWriter fxmlwr = new FormatXMLWriter(writer);
            fxmlwr.setWriteOutline(true);

            XMLUtil.write(fxmlwr, doc);
            fxmlwr.flush();
        } catch (XMLStreamException ex) {
            Logger.getLogger(FragmentsXmlDom.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public org.w3c.dom.Element xmlElementOf( Fragments fragments ) throws IOException {
        if( fragments==null )throw new IllegalArgumentException( "fragments==null" );
        return xmlElementOf( fragments, null );
    }

    public org.w3c.dom.Element xmlElementOf( Fragments fragments, org.w3c.dom.Document doc ) throws IOException {
        if( fragments==null )throw new IllegalArgumentException( "fragments==null" );
        doc = doc==null ? XMLUtil.createDocument() : doc;
        Store store = createStore(doc);

        org.w3c.dom.Element el = store.createElementOf(fragments);
        return el;
    }

    public Fragments readFragments( Reader reader ) throws IOException {
        if( reader==null )throw new IllegalArgumentException( "reader==null" );

        try {
            org.w3c.dom.Document doc = XMLUtil.parseXML(reader);
            org.w3c.dom.NodeList nl = doc.getElementsByTagName("fragments");

            if( nl==null || nl.getLength()==0 )return null;

            org.w3c.dom.Node n =  nl.item(0);
            if( !(n instanceof org.w3c.dom.Element) ){
                return null;
            }

            org.w3c.dom.Element el = (org.w3c.dom.Element)n;

            Restore restore = createRestore();
            return restore.createFragmentsFrom(el);
        } catch (SAXException ex) {
            Logger.getLogger(FragmentsXmlDom.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public Fragments readFragments( org.w3c.dom.Node n ) throws IOException {
//        if( n==null )throw new IllegalArgumentException( "n==null" );

//        try {
//            org.w3c.dom.Document doc = XMLUtil.parseXML(reader);
//            org.w3c.dom.NodeList nl = doc.getElementsByTagName("fragments");
//
//            if( nl==null || nl.getLength()==0 )return null;
//
//            org.w3c.dom.Node n =  nl.item(0);
            if( !(n instanceof org.w3c.dom.Element) ){
                return null;
            }

            org.w3c.dom.Element el = (org.w3c.dom.Element)n;

            Restore restore = createRestore();
            return restore.createFragmentsFrom(el);
//        } catch (SAXException ex) {
//            Logger.getLogger(FragmentsXmlDom.class.getName()).log(Level.SEVERE, null, ex);
//            return null;
//        }
    }

    public Fragments readFragments( org.w3c.dom.Element el ) throws IOException {
        if( el==null )throw new IllegalArgumentException( "el==null" );

        Restore restore = createRestore();
        return restore.createFragmentsFrom(el);
    }
}
