/*
 * The MIT License
 *
 * Copyright 2015 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"),
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ,
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ,
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */

package xyz.cofe.http;


import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.common.Fragment;

/**
 * Фрагмент контента. <br>
 * Ключи которые используется в этом классе: <br>
 * begin : long <br>
 * end : long <br>
 * downloadedSize : long
 * @author Kamnev Georgiy (nt.gocha@gmail.com)
 */
public class ContentFragment extends Fragment {
    //<editor-fold defaultstate="collapsed" desc="log Функции">
    private static void logFine(String message,Object ... args){
        Logger.getLogger(ContentFragment.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message,Object ... args){
        Logger.getLogger(ContentFragment.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message,Object ... args){
        Logger.getLogger(ContentFragment.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message,Object ... args){
        Logger.getLogger(ContentFragment.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message,Object ... args){
        Logger.getLogger(ContentFragment.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message,Object ... args){
        Logger.getLogger(ContentFragment.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex){
        Logger.getLogger(ContentFragment.class.getName()).log(Level.SEVERE, null, ex);
    }
    //</editor-fold>

    public ContentFragment() {
        super(0,0);
    }

    public ContentFragment(long begin, long end, Lock lock) {
        super(begin, end, lock);
    }

    public ContentFragment(long begin, long end) {
        super(begin, end);
    }

    public ContentFragment(Fragment source) {
        super(source);
    }

    public ContentFragment(ContentFragment source) {
        super(source);
        this.downloadedSize = source.downloadedSize;
        this.md5 = source.md5;
    }

    @Override
    public ContentFragment clone() {
        return new ContentFragment(this);
    }
    
    //<editor-fold defaultstate="collapsed" desc="md5 : String">
    protected String md5;
    
    public String getMd5() {
        return md5;
    }
    
    public void setMd5(final String newmd5) {
        syncUpdateProperties(new Runnable() {
            @Override
            public void run() {
                md5 = newmd5;
            }
        });
    }
//</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="downloadedSize : long">
    protected long downloadedSize;
    
    /**
     * Указывает кол-во загружен байт
     * @return кол-во загруженых байтов
     */
    public long getDownloadedSize(){
//        Object v = get("downloadedSize");
//        if( v instanceof Long ){
//            return ((Long)v);
//        }
//        return 0;
        return downloadedSize;
    }
    
    /**
     * Указывает кол-во загружен байт
     * @param size кол-во загруженых байтов
     */
    public void setDownloadedSize(final long size){
//        put("downloadedSize", size);
        syncUpdateProperties(new Runnable() {
            @Override
            public void run() {
                downloadedSize = size;
            }
        });
    }
//</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="fullDownloaded : boolean">
    /**
     * Возвращает признак что указанный фрагмент полностью загружен
     * @return true - полностью загружен
     */
    public boolean isFullDownloaded(){
        try{
            if( lock!=null )lock.lock();
            long downloaded = getDownloadedSize();
            long fragmentSize = getSize();
            return downloaded>=fragmentSize;
        }finally{
            if( lock!=null )lock.unlock();
        }
    }
//</editor-fold>

    /**
     * Текстовое представление
     * @return текст
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        long b = getBegin();
        long e = getEnd();
        long s = getSize();

        sb.append("[").
            append(b).
            //append(" \u2192 ").
            append(" -> ").
            append(e).
            append("/").
            append(s);
        sb.append(", ").append("downloadedSize=").append(downloadedSize);
        sb.append(", ").append("md5=").append(md5);
        sb.append("]");
        return sb.toString();
    }
}
