/*
 * The MIT License
 *
 * Copyright 2015 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"),
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ,
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ,
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */

package xyz.cofe.http;


import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.Func1;
import xyz.cofe.collection.Func2;
import xyz.cofe.common.Fragment;
import xyz.cofe.common.Fragments;
import xyz.cofe.common.Hash;
import xyz.cofe.fs.File;

// TODO проверка на md5

/**
 * Фраменты контента
 * @author Kamnev Georgiy (nt.gocha@gmail.com)
 */
public class ContentFragments  extends Fragments {
    //<editor-fold defaultstate="collapsed" desc="log Функции">
    private static void logFine(String message,Object ... args){
        Logger.getLogger(ContentFragments.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message,Object ... args){
        Logger.getLogger(ContentFragments.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message,Object ... args){
        Logger.getLogger(ContentFragments.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message,Object ... args){
        Logger.getLogger(ContentFragments.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message,Object ... args){
        Logger.getLogger(ContentFragments.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message,Object ... args){
        Logger.getLogger(ContentFragments.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex){
        Logger.getLogger(ContentFragments.class.getName()).log(Level.SEVERE, null, ex);
    }
    //</editor-fold>

    public ContentFragments() {
    }

    public ContentFragments(Lock lock) {
        super(lock, lock);
    }

    public ContentFragments(Iterable<Fragment> source) {
        super(source);
    }

    public ContentFragments(Iterable<Fragment> source,Lock lock) {
        super(source,lock, lock);
    }

    public ContentFragments(ContentFragments source, Lock lock) {
        super(source,lock, lock);
    }

    @Override
    public ContentFragments clone() {
        return new ContentFragments(this, null);
    }

    //<editor-fold defaultstate="collapsed" desc="createFagment( begin, end )">
    @Override
    protected Fragment createFagment(long begin, long end) {
        return new ContentFragment(begin, end, getLock());
    }
//</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="getTotalDownloadedSize()">
    /**
     * Возвращает сумарный объем скаченых данных
     * @return сумарный объем скаченых данных
     */
    public long getTotalDownloadedSize(){
        try{
            if( lock!=null )lock.lock();
            long tot = 0;
            for( Fragment f : this ){
                if( f instanceof ContentFragment ){
                    ContentFragment cf = (ContentFragment)f;
                    tot += cf.getDownloadedSize();
                }
            }
            return tot;
        }finally{
            if( lock!=null )lock.unlock();
        }
    }
//</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="getTotalSize()">
    /**
     * Возвращает сумарный объем фрагментов
     * @return сумарный объем фрагментов
     */
    public long getTotalSize(){
        try{
            if( lock!=null )lock.lock();
            long tot = 0;
            for( Fragment f : this ){
                if( f!=null ){
                    tot += f.getSize();
                }
            }
            return tot;
        }finally{
            if( lock!=null )lock.unlock();
        }
    }
//</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="getNotDownloaded()">
    /**
     * Возвращает список не закаченых фрагментов
     * @return фрагменты
     */
    public List<ContentFragment> getNotDownloaded(){
        try{
            if( lock!=null )lock.lock();
            List<ContentFragment> l = new ArrayList<ContentFragment>();
            for( Fragment f : this ){
                if( f instanceof ContentFragment ){
                    ContentFragment cf = (ContentFragment)f;
                    if( !cf.isFullDownloaded() ){
                        l.add(cf);
                    }
                }
            }
            return l;
        }finally{
            if( lock!=null )lock.unlock();
        }
    }
//</editor-fold>
    
    private static ContentFragment getMD5( byte[] buff, int buffBegin, int buffEndExc, long fileoffset ){
        if( buff==null )return null;
        if( buff.length<1 )return null;
        if( buffBegin > buffEndExc )return null;
        if( (buffEndExc - buffBegin)<=0 )return null;

        Hash h = new Hash();
        byte[] hash = h.md5(buff, buffBegin, buffEndExc);

        String dataMd5str = h.toString(hash);
        int dataLen = (buffEndExc - buffBegin);

        ContentFragment cf = new ContentFragment(fileoffset,fileoffset+dataLen);
        cf.setMd5(dataMd5str);

        return cf;
    }

    public static ContentFragments createMd5( 
        final File sourceFile, 
        int fragmentSize,
        final Func2<Object,Long,Long> progress
    )
    {
        if( fragmentSize<1 )throw new IllegalArgumentException( "fragmentSize<1" );
        if( sourceFile==null )throw new IllegalArgumentException( "sourceFile==null" );

        try {
            final long fileSize = sourceFile.getLength();
            InputStream fin = sourceFile.openRead();
            
            ContentFragments cfs =
                createMd5(fin, fragmentSize, new Func1<Object, Long>() {

                @Override
                public Object apply(Long offset) {
                    if( progress!=null ){
                        try{
                            long fsize = sourceFile.getLength();
                            progress.apply(offset, fsize);
                        }catch( Throwable err ){
                            logException(err);
                        }
                    }
                    return null;
                }
            });
            
            fin.close();
            
            return cfs;
        } catch (IOException ex) {
            throw new IOError(ex);
        }
    }
    
    public static ContentFragments createMd5( 
        InputStream data, 
        int fragmentSize,
        Func1<Object,Long> progress
    ) throws IOException
    {
        if( fragmentSize<1 )throw new IllegalArgumentException( "fragmentSize<1" );
        if( data==null )throw new IllegalArgumentException( "data==null" );
        
        ContentFragments cfs = new ContentFragments();
        if( fragmentSize<1 )return null;

        byte[] buff = new byte[fragmentSize];
        int bptr = 0;
        long fileoffset = 0;
        int zeroreaded = 0;
        while( true ){
            if( Thread.currentThread().isInterrupted() )break;
            
            if( bptr>=buff.length ){
                // get hash of buff
                ContentFragment cf = getMD5(buff, 0, bptr, fileoffset);
                if( cf!=null )cfs.add(cf);
                // move to next block
                fileoffset += bptr;
                bptr = 0;

                if( progress!=null ){
                    progress.apply(fileoffset);
                }
            }
            int readed = data.read(buff,bptr,buff.length - bptr);
            if( readed<0 )break;
            if( readed==0 ){
                zeroreaded++;
                if( zeroreaded<10 ){
                    continue;
                }else{
                    break;
                }
            }
            zeroreaded = 0;
            bptr += readed;
        }

        if( bptr>0 ){
            ContentFragment cf = getMD5(buff, 0, bptr, fileoffset);
            if( cf!=null )cfs.add(cf);

            if( progress!=null ){
                progress.apply(cf.getEnd());
            }
        }

        return cfs;
    }
}
