/*
 * The MIT License
 *
 * Copyright 2015 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"),
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ,
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ,
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */

package xyz.cofe.http;


import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.cbuffer.ContentBuffer;
import xyz.cofe.collection.set.EventSet;
import xyz.cofe.http.download.FragmentValidator;
import xyz.cofe.http.download.GetPart;

/**
 * Адаптер Listener
 * @author Kamnev Georgiy (nt.gocha@gmail.com)
 */
public class HttpListenerAdapter implements HttpListener
{
    //<editor-fold defaultstate="collapsed" desc="log Функции">
    private static void logFine(String message,Object ... args){
        Logger.getLogger(HttpListenerAdapter.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message,Object ... args){
        Logger.getLogger(HttpListenerAdapter.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message,Object ... args){
        Logger.getLogger(HttpListenerAdapter.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message,Object ... args){
        Logger.getLogger(HttpListenerAdapter.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message,Object ... args){
        Logger.getLogger(HttpListenerAdapter.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message,Object ... args){
        Logger.getLogger(HttpListenerAdapter.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex){
        Logger.getLogger(HttpListenerAdapter.class.getName()).log(Level.SEVERE, null, ex);
    }
    //</editor-fold>

    /**
     * Определяет что за событие и вызывает соответ protected method
     * @param event событие
     */
    @Override
    public void httpEvent(HttpEvent event) {
        // HttpResponse
        if( event instanceof HttpResponse.StateChangedEvent ){
            HttpResponse.StateChangedEvent e = (HttpResponse.StateChangedEvent)event;
            responseStateChanged(e, e.getHttpResponse(), e.getOldState(), e.getNewState());

            if( HttpResponse.State.Finished.equals( e.getNewState() ) ){
                responseFinished(e, e.getHttpResponse());
            }
        }

        if( event instanceof HttpResponse.ProgressEvent ){
            HttpResponse.ProgressEvent e = (HttpResponse.ProgressEvent)event;
            responseProgress(e, e.getHttpResponse());
        }

        if( event instanceof HttpResponse.RedirectEvent ){
            HttpResponse.RedirectEvent e = (HttpResponse.RedirectEvent)event;
            responseRedirect(e, e.getHttpResponse(), e.getFrom(), e.getTo());
        }

        // HttpDownloader
        if( event instanceof HttpDownloader.StateChangedEvent ){
            HttpDownloader.StateChangedEvent e = (HttpDownloader.StateChangedEvent)event;
            downloaderStateChanged(e, e.getHttpDownloader(), e.getOldState(), e.getNewState());

            if( HttpDownloader.State.Finished.equals( e.getNewState() ) ){
                downloaderFinished(e, e.getHttpDownloader());
            }
            if( HttpDownloader.State.DownloadingPartial.equals( e.getNewState() ) ){
                downloaderPartialMode(e, e.getHttpDownloader());
            }
            if( HttpDownloader.State.DownloadingStream.equals( e.getNewState() ) ){
                downloaderStreamMode(e, e.getHttpDownloader());
            }
        }

        if( event instanceof HttpDownloader.ProgressEvent ){
            HttpDownloader.ProgressEvent e = (HttpDownloader.ProgressEvent)event;
            downloaderProgress(e, e.getHttpDownloader());
        }

        if( event instanceof HttpDownloader.RedirectEvent ){
            HttpDownloader.RedirectEvent e = (HttpDownloader.RedirectEvent)event;
            downloaderRedirect(e, e.getHttpDownloader(), e.getFrom(), e.getTo());
        }

        if( event instanceof HttpDownloader.ResponseEvent ){
            HttpDownloader.ResponseEvent e = (HttpDownloader.ResponseEvent)event;
            downloaderResponse(e, e.getHttpDownloader(), e.getRequest(), e.getResponse());
        }

        if( event instanceof HttpDownloader.GetPartEvent ){
            HttpDownloader.GetPartEvent e = (HttpDownloader.GetPartEvent)event;
            downloaderGetPart(e, e.getHttpDownloader(), e.getGetPart(), e.getFragment());
        }

        if( event instanceof HttpDownloader.GetPartStartedEvent ){
            HttpDownloader.GetPartStartedEvent e = (HttpDownloader.GetPartStartedEvent)event;
            downloaderGetPartStarted(e, e.getHttpDownloader(), e.getGetPart(), e.getFragment());
        }

        if( event instanceof HttpDownloader.GetPartFinishedEvent ){
            HttpDownloader.GetPartFinishedEvent e = (HttpDownloader.GetPartFinishedEvent)event;
            downloaderGetPartFinished(e, e.getHttpDownloader(), e.getGetPart(), e.getFragment());
        }

        if( event instanceof HttpDownloader.CountersResetedEvent ){
            HttpDownloader.CountersResetedEvent e = (HttpDownloader.CountersResetedEvent)event;
            downloaderCountersReseted(e, e.getHttpDownloader());
        }

        if( event instanceof HttpDownloader.RepeatOverflowEvent ){
            HttpDownloader.RepeatOverflowEvent e = (HttpDownloader.RepeatOverflowEvent)event;
            downloaderRepeatOverflow(e, e.getHttpDownloader(), e.getCurrentRepeatCount(), e.getMaxRepeatCount());
        }

        if( event instanceof HttpDownloader.RepeatFragmentEvent ){
            HttpDownloader.RepeatFragmentEvent e = (HttpDownloader.RepeatFragmentEvent)event;
            downloaderRepeatFragment(e, e.getHttpDownloader(), e.getContentFragment());
        }

        if( event instanceof HttpDownloader.DownloadedFragmentEvent ){
            HttpDownloader.DownloadedFragmentEvent e = (HttpDownloader.DownloadedFragmentEvent)event;
            downloaderDownloadedFragment(e, e.getHttpDownloader(), e.getContentFragment());
        }

        if( event instanceof HttpDownloader.SkippedFragmentEvent ){
            HttpDownloader.SkippedFragmentEvent e = (HttpDownloader.SkippedFragmentEvent)event;
            downloaderSkippedFragment(e, e.getHttpDownloader(), e.getContentFragment());
        }

        if( event instanceof HttpDownloader.FragmentErrorEvent ){
            HttpDownloader.FragmentErrorEvent e = (HttpDownloader.FragmentErrorEvent)event;
            downloaderFragmentError(
                e,
                e.getHttpDownloader(),
                e.getFragmentValidator(),
                e.getGetPart(),
                e.getContentFragment(),
                e.getError()
            );
        }

        if( event instanceof HttpDownloader.AddedValidFragmentEvent ){
            HttpDownloader.AddedValidFragmentEvent e = (HttpDownloader.AddedValidFragmentEvent)event;
            downloaderAddedValidFragment(
                e,
                e.getHttpDownloader(),
                e.getFragments(),
                e.getValidated(),
                e.getContentFragment()
            );
        }

        if( event instanceof HttpDownloader.RemovedInvalidFragmentEvent ){
            HttpDownloader.RemovedInvalidFragmentEvent e = (HttpDownloader.RemovedInvalidFragmentEvent)event;
            downloaderRemovedInvalidFragment(
                e,
                e.getHttpDownloader(),
                e.getFragments(),
                e.getValidated(),
                e.getContentFragment()
            );
        }

        if( event instanceof HttpDownloader.ContentValidateProgressEvent ){
            HttpDownloader.ContentValidateProgressEvent e = (HttpDownloader.ContentValidateProgressEvent)event;
            downloaderContentValidateProgress(
                e,
                e.getHttpDownloader(),
                e.getContentBuffer(),
                e.getSampleFragments(),
                e.getSample(),
                e.getSampleNum(),
                e.getSampleTotal(),
                e.isHashMatched()
            );
        }

        if( event instanceof HttpDownloader.FinishWithErrorEvent ){
            HttpDownloader.FinishWithErrorEvent e = (HttpDownloader.FinishWithErrorEvent)event;
            downloaderFinishWithError(
                e,
                e.getHttpDownloader(),
                e.getMessage()
            );
        }

        if( event instanceof HttpDownloader.RetryEvent ){
            HttpDownloader.RetryEvent e = (HttpDownloader.RetryEvent)event;
            downloaderRetry(
                e,
                e.getHttpDownloader(),
                e.getMessage()
            );
        }
    }

    protected void responseStateChanged(
        HttpResponse.StateChangedEvent event,
        HttpResponse response,
        HttpResponse.State oldState,
        HttpResponse.State newState
    ){
    }

    protected void responseFinished(
        HttpResponse.StateChangedEvent event,
        HttpResponse response
    ){
    }

    protected void responseProgress(
        HttpResponse.ProgressEvent event,
        HttpResponse response
    ){
    }

    protected void responseRedirect(
        HttpResponse.RedirectEvent event,
        HttpResponse response,
        URL from,
        URL to
    ){
    }

    protected void downloaderStateChanged(
        HttpDownloader.StateChangedEvent event,
        HttpDownloader downloader,
        HttpDownloader.State oldState,
        HttpDownloader.State newState
    ){
    }

    protected void downloaderFinished(
        HttpDownloader.StateChangedEvent event,
        HttpDownloader downloader
    ){
    }

    protected void downloaderStreamMode(
        HttpDownloader.StateChangedEvent event,
        HttpDownloader downloader
    ){
    }

    protected void downloaderPartialMode(
        HttpDownloader.StateChangedEvent event,
        HttpDownloader downloader
    ){
    }

    protected void downloaderResponse(
        HttpDownloader.ResponseEvent event,
        HttpDownloader downloader,
        HttpRequest request,
        HttpResponse response
    ){
    }

    protected void downloaderProgress(
        HttpDownloader.ProgressEvent event,
        HttpDownloader downloader
    ){
    }

    protected void downloaderRedirect(
        HttpDownloader.RedirectEvent event,
        HttpDownloader downloader,
        URL from,
        URL to
    ){
    }

    protected void downloaderGetPart(
        HttpDownloader.GetPartEvent event,
        HttpDownloader downloader,
        GetPart getPart,
        ContentFragment contentFragment
    ){
    }

    protected void downloaderGetPartStarted(
        HttpDownloader.GetPartStartedEvent event,
        HttpDownloader downloader,
        GetPart getPart,
        ContentFragment contentFragment
    ){
    }

    protected void downloaderGetPartFinished(
        HttpDownloader.GetPartFinishedEvent event,
        HttpDownloader downloader,
        GetPart getPart,
        ContentFragment contentFragment
    ){
    }

    protected void downloaderCountersReseted(
        HttpDownloader.CountersResetedEvent event,
        HttpDownloader downloader
    ){
    }

    protected void downloaderRepeatOverflow(
        HttpDownloader.RepeatOverflowEvent event,
        HttpDownloader downloader,
        int curRepeatCount,
        int maxRepeatCount
    ){
    }

    protected void downloaderRepeatFragment(
        HttpDownloader.RepeatFragmentEvent event,
        HttpDownloader downloader,
        ContentFragment cf
    ){
    }

    protected void downloaderDownloadedFragment(
        HttpDownloader.DownloadedFragmentEvent event,
        HttpDownloader downloader,
        ContentFragment cf
    ){
    }

    protected void downloaderSkippedFragment(
        HttpDownloader.SkippedFragmentEvent event,
        HttpDownloader downloader,
        ContentFragment cf
    ){
    }

    protected void downloaderFragmentError(
        HttpDownloader.FragmentErrorEvent event,
        HttpDownloader downloader,
        FragmentValidator fv,
        GetPart gp,
        ContentFragment cf,
        Throwable err
    ){
    }

    protected void downloaderAddedValidFragment(
        HttpDownloader.AddedValidFragmentEvent event,
        HttpDownloader downloader,
        ContentFragments cfs,
        EventSet<ContentFragment> valid,
        ContentFragment cf
    ){
    }

    protected void downloaderRemovedInvalidFragment(
        HttpDownloader.RemovedInvalidFragmentEvent event,
        HttpDownloader downloader,
        ContentFragments cfs,
        EventSet<ContentFragment> valid,
        ContentFragment cf
    ){
    }

    protected void downloaderContentValidateProgress(
        HttpDownloader.ContentValidateProgressEvent event,
        HttpDownloader downloader,
        ContentBuffer contentBuffer,
        ContentFragments sampleFragments,
        ContentFragment sample,
        int sampleNum,
        int sampleTotal,
        boolean hashMatched
    ){
    }

    protected void downloaderFinishWithError(
        HttpDownloader.FinishWithErrorEvent event,
        HttpDownloader downloader,
        String message
    ){
    }

    protected void downloaderRetry(
        HttpDownloader.RetryEvent event,
        HttpDownloader downloader,
        String message
    ){
    }
}
