/*
 * The MIT License
 *
 * Copyright 2015 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного 
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"), 
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на 
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование 
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется 
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии 
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ, 
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ, 
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ 
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ 
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ 
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ 
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */

package xyz.cofe.http;


import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * Декодирование HTTP status code
 * @author Kamnev Georgiy (nt.gocha@gmail.com)
 */
public class HttpStatusHelper {
    //<editor-fold defaultstate="collapsed" desc="log Функции">
    private static void logFine(String message,Object ... args){
        Logger.getLogger(HttpStatusHelper.class.getName()).log(Level.FINE, message, args);
    }
    
    private static void logFiner(String message,Object ... args){
        Logger.getLogger(HttpStatusHelper.class.getName()).log(Level.FINER, message, args);
    }
    
    private static void logFinest(String message,Object ... args){
        Logger.getLogger(HttpStatusHelper.class.getName()).log(Level.FINEST, message, args);
    }
    
    private static void logInfo(String message,Object ... args){
        Logger.getLogger(HttpStatusHelper.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message,Object ... args){
        Logger.getLogger(HttpStatusHelper.class.getName()).log(Level.WARNING, message, args);
    }
    
    private static void logSevere(String message,Object ... args){
        Logger.getLogger(HttpStatusHelper.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex){
        Logger.getLogger(HttpStatusHelper.class.getName()).log(Level.SEVERE, null, ex);
    }
    //</editor-fold>
    
    public boolean isInfoStatus( int code ){
        return code >= 100 && code < 200;
    }
    
    public boolean isSuccess( int code ){
        return code >= 200 && code < 300;
    }
    
    public boolean isRedirect( int code ){
        return code >= 300 && code < 400;
    }
    
    public boolean isClientError( int code ){
        return code >= 400 && code < 500;
    }
    
    public boolean isServerError( int code ){
        return code >= 500;
    }
    
    /** 
     * сервер удовлетворён начальными сведениями о запросе, клиент может продолжать пересылать заголовки. 
     * Появился в HTTP/1.1.
     */
    public static final int CONTINUE = 100;
    
    /** 
     * сервер предлагает перейти на более подходящий для указанного ресурса протокол; 
     * список предлагаемых протоколов сервер обязательно указывает в поле заголовка Update. 
     * Если клиента это заинтересует, то он посылает новый запрос с указанием другого протокола. 
     * Появился в HTTP/1.1.
     */
    public static final int SWITCH_PROTOCOLS = 101;
    
    /**
     * запрос принят, но на его обработку понадобится длительное время. 
     * Используется сервером, чтобы клиент не разорвал соединение из-за превышения времени ожидания. 
     * Клиент при получении такого ответа должен сбросить таймер и 
     * дожидаться следующей команды в обычном режиме. Появился в WebDAV.
     */
    public static final int PROCESSING = 102;
    
    /**
     * при разрешении доменного имени возникла ошибка в связи с неверным или отсутствующем IP-адресом DNS-сервера.
     */
    public static final int NAME_NOT_RESOLVED = 105;
    
    /**
     * успешный запрос. 
     * Если клиентом были запрошены какие-либо данные, 
     * то они находятся в заголовке и/или теле сообщения. Появился в HTTP/1.0.
     */
    public static final int OK = 200;
    
    /**
     * в результате успешного выполнения запроса был создан новый ресурс. 
     * Сервер должен указать его местоположение в заголовке Location. 
     * Серверу рекомендуется[источник не указан 1159 дней] ещё указывать в заголовке 
     * характеристики созданного ресурса (например, в поле Content-Type). 
     * Если сервер не уверен, что ресурс действительно будет существовать к моменту 
     * получения данного сообщения клиентом, то лучше использовать ответ с кодом 202. 
     * Появился в HTTP/1.0.
     */
    public static final int CREATED = 201;
    
    /** 
     * запрос был принят на обработку, но она не завершена. 
     * Клиенту не обязательно дожидаться окончательной передачи сообщения, 
     * так как может быть начат очень долгий процесс. Появился в HTTP/1.0.
     */
    public static final int ACCEPTED = 202;
    
    /**
    * аналогично ответу 200, 
    * но в этом случае передаваемая информация была взята 
    * не из первичного источника (резервной копии, другого сервера и т. д.) 
    * и поэтому может быть неактуальной. Появился в HTTP/1.1.
    */
    public static final int NON_AUTHORITATIVE_INFORMATION = 203;

    /** сервер успешно обработал запрос, но в ответе были переданы только 
    * заголовки без тела сообщения. Клиент не должен обновлять содержимое документа, но может применить к нему полученные метаданные. Появился в HTTP/1.0.
    */
    public static final int NO_CONTENT =204;
    
    /** 
     * сервер обязывает клиента сбросить введённые пользователем данные. 
     * Тела сообщения сервер при этом не передаёт и документ обновлять 
     * не обязательно. Появился в HTTP/1.1.
    */
    public static final int RESET_CONTENT=205;
    
    /** сервер удачно выполнил частичный GET-запрос, 
     * возвратив только часть сообщения. В заголовке Content-Range сервер 
     * указывает байтовые диапазоны содержимого. Особое внимание при 
     * работе с подобными ответами следует уделить кэшированию. Появился в HTTP/1.1. (подробнее...)
    */
    public static final int PARTIAL_CONTENT=206;
    
    /** сервер передаёт результаты выполнения сразу нескольких независимых операций. 
     * Они помещаются в само тело сообщения в 
     * виде XML-документа с объектом multistatus. 
     * Не рекомендуется размещать в этом объекте статусы из серии 1xx из-за 
     * бессмысленности и избыточности. Появился в WebDAV.
    */
    public static final int MULTI_STATUS =207;
    
    /** заголовок A-IM от клиента был 
     * успешно принят и сервер возвращает содержимое с учётом указанных параметров. 
     * Введено в RFC 3229 для дополнения протокола HTTP поддержкой дельта-кодирования.
    */
    public static final int IM_USED =226;

    /** по указанному URI существует несколько вариантов предоставления 
     * ресурса по типу MIME, по языку или по другим характеристикам. 
     * Сервер передаёт с сообщением список альтернатив, давая возможность сделать 
     * выбор клиенту автоматически или пользователю. Появился в HTTP/1.0.
    */
    public static final int MULTIPLE_CHOICES=300;
    
    /** запрошенный документ был окончательно перенесен на новый 
     * URI, указанный в поле Location заголовка. Некоторые клиенты 
     * некорректно ведут себя при обработке данного кода. Появился в HTTP/1.0.
    */
    public static final int MOVED_PERMANENTLY=301;
    
    /** запрошенный документ временно доступен по другому URI, 
     * указанному в заголовке в поле Location. Этот код может быть использован, 
     * например, при управляемом сервером согласовании содержимого. 
     * Некоторые клиенты некорректно ведут себя при обработке данного кода. Введено в HTTP/1.0.
    */
    public static final int MOVED_TEMPORARILY=302;
    
    /** документ по запрошенному URI нужно запросить по адресу в поле 
     * Location заголовка с использованием метода GET несмотря даже на то, 
     * что первый запрашивался иным методом. Этот код был введён вместе с 307-ым для 
     * избежания неоднозначности, чтобы сервер был уверен, что следующий ресурс будет 
     * запрошен методом GET. Например, на веб-странице есть поле ввода текста 
     * для быстрого перехода и поиска. После ввода данных браузер делает запрос 
     * методом POST, включая в тело сообщения введённый текст. 
     * Если обнаружен документ с введённым названием, то сервер отвечает кодом 303, 
     * указав в заголовке Location его постоянный адрес. Тогда браузер гарантировано 
     * его запросит методом GET для получения содержимого. 
     * В противном случае сервер просто вернёт клиенту страницу с результатами поиска. Введено в HTTP/1.1.
    */
    public static final int SEE_OTHER=303;
    
    /** сервер возвращает такой код, если клиент запросил документ методом GET, 
     * использовал заголовок If-Modified-Since или If-None-Match и документ не 
     * изменился с указанного момента. При этом сообщение сервера не должно 
     * содержать тела. Появился в HTTP/1.0.
    */
    public static final int NOT_MODIFIED=304;
    
    /** запрос к запрашиваемому ресурсу должен осуществляться через 
     * прокси-сервер, URI которого указан в поле Location заголовка. 
     * Данный код ответа могут использовать только исходные HTTP-сервера 
     * (не прокси). Введено в HTTP/1.1.
    */
    public static final int USE_PROXY =305;
    
    /**  запрашиваемый ресурс на короткое время доступен по другому 
     * URI, указанный в поле Location заголовка. 
     * Этот код был введён вместе с 303 вместо 302-го для избежания неоднозначности. 
     * Введено в RFC 2616 (обновление HTTP/1.1).
    */
    public static final int TEMPORARY_REDIRECT=307;
    
    /**сервер обнаружил в запросе клиента синтаксическую ошибку. 
     * Появился в HTTP/1.0.
    */
    public static final int BAD_REQUEST =400;

    /**для доступа к запрашиваемому ресурсу требуется аутентификация. 
     * В заголовке ответ должен содержать поле WWW-Authenticate с 
     * перечнем условий аутентификации. Клиент может повторить запрос, 
     * включив в заголовок сообщения поле Authorization с требуемыми 
     * для аутентификации данными.
    */
    public static final int UNAUTHORIZED =401;

    /**предполагается использовать в будущем. В настоящий момент не 
     * используется. Этот код предусмотрен для платных пользовательских сервисов, 
     * а не для хостинговых компаний. Имеется в виду, что эта ошибка не будет 
     * выдана хостинговым провайдером в случае просроченной оплаты его услуг. 
     * Зарезервирован, начиная с HTTP/1.1.
    */
    public static final int PAYMENT_REQUIRED =402;

    /**сервер понял запрос, но он отказывается его выполнять из-за 
     * ограничений в доступе для клиента к указанному ресурсу. 
     * Если для доступа к ресурсу требуется аутентификация средствами HTTP, 
     * то сервер вернёт ответ 401 или 407 при использовании прокси. 
     * В противном случае ограничения были заданы администратором сервера 
     * или разработчиком веб-приложения и могут быть любыми в зависимости 
     * от возможностей используемого программного обеспечения. 
     * В любом случае клиенту следует сообщить причины отказа в обработке запроса.
     * Наиболее вероятными причинами ограничения может послужить попытка доступа к
     * системным ресурсам веб-сервера (например, файлам .htaccess или .htpasswd) 
     * или к файлам, доступ к которым был закрыт с помощью конфигурационных файлов, 
     * требование аутентификации не средствами HTTP, например, для доступа к системе 
     * управления содержимым или разделу для зарегистрированных пользователей либо сервер 
     * не удовлетворён IP-адресом клиента, например, при блокировках. Появился в HTTP/1.0.
    */
    public static final int FORBIDDEN =403;

    /**самая распространенная ошибка при пользовании Интернетом, 
     * основная причина — ошибка в написании адреса Web-страницы. 
     * Сервер понял запрос, но не нашёл соответствующего ресурса по указанному URI. 
     * Если серверу известно, что по этому адресу был документ, то ему желательно 
     * использовать код 410. Ответ 404 может использоваться вместо 403, если 
     * требуется тщательно скрыть от посторонних глаз определённые ресурсы. 
     * Появился в HTTP/1.0.
    */
    public static final int NOT_FOUND =404;

    /**указанный клиентом метод нельзя применить к текущему ресурсу. 
     * В ответе сервер должен указать доступные методы в заголовке Allow, 
     * разделив их запятой. Эту ошибку сервер должен возвращать, если 
     * метод ему известен, но он не применим именно к указанному в запросе 
     * ресурсу, если же указанный метод не применим на всём сервере, то клиенту 
     * нужно вернуть код 501 (Not Implemented). Появился в HTTP/1.1.
    */
    public static final int METHOD_NOT_ALLOWED =405;

    /**запрошенный URI не может удовлетворить переданным в заголовке характеристикам. 
     * Если метод был не HEAD, то сервер должен вернуть список допустимых 
     * характеристик для данного ресурса. Появился в HTTP/1.1.
    */
    public static final int NOT_ACCEPTABLE =406;

    /**ответ аналогичен коду 401 за исключением того, что аутентификация 
     * производится для прокси-сервера. Механизм аналогичен идентификации на 
     * исходном сервере. Появился в HTTP/1.1.
    */
    public static final int PROXY_AUTHENTICATION_REQUIRED =407;

    /**время ожидания сервером передачи от клиента истекло. Клиент 
     * может повторить аналогичный предыдущему запрос в любое время. 
     * Например, такая ситуация может возникнуть при загрузке на сервер 
     * объёмного файла методом POST или PUT. В какой-то момент передачи 
     * источник данных перестал отвечать, например, из-за повреждения 
     * компакт-диска или потери связи с другим компьютером в локальной сети. 
     * Пока клиент ничего не передаёт, ожидая от него ответа, соединение с 
     * сервером держится. Через некоторое время сервер может закрыть соединение 
     * со своей стороны, чтобы дать возможность другим клиентам сделать запрос. 
     * Этот ответ не возвращается, когда клиент принудительно остановил передачу 
     * по команде пользователя или соединение прервалось по каким-то иным 
     * причинам, так как ответ уже послать невозможно. Появился в HTTP/1.1.
    */
    public static final int REQUEST_TIMEOUT =408;

    /**запрос не может быть выполнен из-за конфликтного обращения к ресурсу. 
     * Такое возможно, например, когда два клиента пытаются изменить ресурс 
     * с помощью метода PUT.Появился в HTTP/1.1.
    */
    public static final int CONFLICT =409;

    /**такой ответ сервер посылает, если ресурс раньше был по указанному 
     * URL, но был удалён и теперь недоступен. Серверу в этом случае неизвестно 
     * и местоположение альтернативного документа, например, копии). 
     * Если у сервера есть подозрение, что документ в ближайшее время может
     * быть восстановлен, то лучше клиенту передать код 404. Появился в HTTP/1.1.
    */
    public static final int GONE =410;

    /**для указанного ресурса клиент должен указать Content-Length в 
     * заголовке запроса. Без указания этого поля не стоит делать повторную 
     * попытку запроса к серверу по данному URI. Такой ответ естественен 
     * для запросов типа POST и PUT. Например, если по указанному URI 
     * производится загрузка файлов, а на сервере стоит ограничение на их объём.
     * Тогда разумней будет проверить в самом начале заголовок Content-Length 
     * и сразу отказать в загрузке, чем провоцировать бессмысленную нагрузку, 
     * разрывая соединение, когда клиент действительно пришлёт слишком объёмное сообщение. 
     * Появился в HTTP/1.1.
    */
    public static final int LENGTH_REQUIRED =411;

    /**возвращается, если ни одно из условных полей заголовка[неизвестный термин] 
     * запроса не было выполнено. Появился в HTTP/1.1.
    */
    public static final int PRECONDITION_FAILED =412;

    /**возвращается в случае, если сервер отказывается обработать 
     * запрос по причине слишком большого размера тела запроса. 
     * Сервер может закрыть соединение, чтобы прекратить дальнейшую 
     * передачу запроса. Если проблема временная, то рекомендуется в 
     * ответ сервера включить заголовок Retry-After с указанием времени, 
     * по истечении которого можно повторить аналогичный запрос. 
     * Появился в HTTP/1.1.
    */
    public static final int REQUEST_ENTITY_TOO_LARGE =413;

    /** сервер не может обработать запрос из-за слишком 
     * длинного указанного URL. Такую ошибку можно спровоцировать, 
     * например, когда клиент пытается передать длинные параметры 
     * через метод GET, а не POST. Появился в HTTP/1.1.
    */
    public static final int REQUEST_URL_TOO_LONG = 414;

    /**по каким-то причинам сервер отказывается работать с 
     * указанным типом данных при данном методе. Появился в HTTP/1.1.
    */
    public static final int UNSUPPORTED_MEDIA_TYPE =415;

    /**в поле Range заголовка запроса был указан диапазон за пределами ресурса и отсутствует 
    * поле If-Range. Если клиент передал байтовый диапазон, 
    * то сервер может вернуть реальный размер в поле Content-Range заголовка. 
    * Данный ответ не следует использовать при передаче 
    * типа multipart/byteranges[источник не указан 1159 дней]. Введено в RFC 2616 (обновление HTTP/1.1).
    */
    public static final int REQUESTED_RANGE_NOT_SATISFIABLE =416;

    /**по каким-то причинам сервер не может удовлетворить значению поля Expect заголовка запроса. 
     * Введено в RFC 2616 (обновление HTTP/1.1).
    */
    public static final int EXPECTATION_FAILED =417;

    //418 I'm a teapot — Этот код был введен в 1998 году как 
    //одна из традиционных первоапрельских шуток IETF в RFC 2324, 
    //Hyper Text Coffee Pot Control Protocol. 
    //Не ожидается, что данный код будет поддерживаться реальными серверами.[8]

    /**
     * сервер успешно принял запрос, может работать с указанным видом данных, 
     * в теле запроса XML-документ имеет верный синтаксис, но имеется какая-то 
     * логическая ошибка, из-за которой невозможно произвести операцию над ресурсом. 
     * Введено в WebDAV.
    */
    public static final int UNPROCESSABLE_ENTITY =422;

    /**целевой ресурс из запроса заблокирован от применения к нему указанного метода. 
     * Введено в WebDAV.
    */
    public static final int LOCKED =423;

    /**реализация текущего запроса может зависеть от успешности выполнения другой операции. 
    Если она не выполнена и из-за этого нельзя выполнить текущий запрос, 
    то сервер вернёт этот код. Введено в WebDAV.
    */
    public static final int FAILED_DEPENDENCY =424;

    /**используется в расширении WebDAV Advanced Collections Protocol[18].
     * Посылается, если клиент указал номер элемента в неупорядоченном списке, 
     * или запросил несколько элементов в порядке, отличающемся от серверного.
    */
    public static final int UNORDERED_COLLECTION =425;

    /**сервер указывает клиенту на необходимость обновить протокол. 
    Заголовок ответа должен содержать правильно сформированные поля Upgrade и
    Connection. Введено в RFC 2817 для возможности перехода к TLS посредством HTTP.
    */
    public static final int UPGRADE_REQUIRED =426;

    /**сервер указывает клиенту на необходимость использования в запросе заголовков 
    условий, наподобие If-Match. Введено в черновике стандарта RFC 6585.
    */
    public static final int PRECONDITION_REQUIRED =428;

    /**клиент попытался отправить слишком много запросов 
    за короткое время, что может указывать, например, 
    на попытку DoS-атаки. Может сопровождаться заголовком Retry-After, 
    указывающим, через какое время можно повторить запрос. В
    ведено в черновике стандарта RFC 6585.
    */
    public static final int TOO_MANY_REQUESTS =429;

    /**Превышена допустимая длина заголовков. 
    Сервер не обязан отвечать этим кодом, 
    вместо этого он может просто сбросить соединение. 
    Введено в черновике стандарта RFC 6585.
    */
    public static final int REQUEST_HEADER_FIELDS_TOO_LARGE =431;

    /**Запрашиваемый адрес недоступен[источник не указан 596 дней].
    */
    public static final int REQUESTED_HOST_UNAVAILABLE = 434;
    
    /**
    возвращается сервером, если для обработки запроса от 
    клиента поступило недостаточно информации. 
    При этом в заголовок ответа помещается поле Ms-Echo-Request. 
    Введено корпорацией Microsoft для WebDAV. 
    В настоящий момент как минимум используется программой Microsoft Money.
    */
    public static final int RETRY_WITH =449;

    /**доступ к ресурсу закрыт по юридическим причинам, например, 
    по требованию органов государственной власти или по требованию 
    правообладателя в случае нарушения авторских прав. 
    Введено в черновике IETF за авторством Google[11], при этом 
    код ошибки является отсылкой к роману Рэя Брэдбери «451 градус по Фаренгейту».
    */
    public static final int UNAVAILABLE_FOR_LEGAL_REASONS =451;

    /**возвращается сервером, если обработка запроса вызывает некорректируемые сбои в 
    таблицах баз данных[источник не указан 1159 дней]. 
    Введено корпорацией Microsoft для WebDAV.
    */
    public static final int UNRECOVERABLE_ERROR =456;

    /** любая внутренняя ошибка сервера, которая не 
     * входит в рамки остальных ошибок класса. 
     * Появился в HTTP/1.0. 
     */
    public static final int INTERNAL_SERVER_ERROR = 500;

    /** сервер не поддерживает возможностей, необходимых для обработки запроса. 
     * Типичный ответ для случаев, когда сервер не понимает 
     * указанный в запросе метод. Если же метод серверу известен, 
     * но он не применим к данному ресурсу, то нужно вернуть ответ 405. 
     * Появился в HTTP/1.0. 
     */
    public static final int NOT_IMPLEMENTED = 501 ;

    /** сервер, выступая в роли шлюза или прокси-сервера, 
     * получил недействительное ответное сообщение от вышестоящего сервера. 
     * Появился в HTTP/1.0. 
     */
    public static final int BAD_GATEWAY = 502 ;

    /** сервер временно не имеет возможности обрабатывать запросы 
     * по техническим причинам (обслуживание, перегрузка и прочее). 
     * В поле Retry-After заголовка сервер может указать время, 
     * через которое клиенту рекомендуется повторить запрос. 
     * Хотя во время перегрузки очевидным кажется сразу разрывать соединение, 
     * эффективней может оказаться установка большого значения 
     * поля Retry-After для уменьшения частоты избыточных запросов. 
     * Появился в HTTP/1.0. 
     */
    public static final int SERVICE_UNAVAILABLE = 503 ;
    
    /** сервер в роли шлюза или прокси-сервера не дождался ответа 
     * от вышестоящего сервера для завершения текущего запроса. 
     * Появился в HTTP/1.1. 
     */
    public static final int GATEWAY_TIMEOUT = 504 ;
    
    /** сервер не поддерживает или отказывается поддерживать указанную 
     * в запросе версию протокола HTTP. Появился в HTTP/1.1. 
     */
    public static final int HTTP_VERSION_NOT_SUPPORTED = 505 ;
    
    /** в результате ошибочной конфигурации выбранный вариант 
     * указывает сам на себя, из-за чего процесс связывания прерывается. 
     * Экспериментальное. Введено в RFC 2295 для дополнения протокола HTTP 
     * технологией Transparent Content Negotiation. 
     */
    public static final int VARIANT_ALSO_NEGOTIATES = 506 ;
    
    /** не хватает места для выполнения текущего запроса. 
     * Проблема может быть временной. 
     * Введено в WebDAV. 
     */
    public static final int INSUFFICIENT_STORAGE = 507 ;
    
    /** используется при превышении веб-площадкой отведённого ей ограничения 
     * на потребление трафика. В данном случае владельцу площадки следует 
     * обратиться к своему хостинг-провайдеру. В настоящий момент данный 
     * код не описан ни в одном RFC и используется только модулем «bw/limited», 
     * входящим в панель управления хостингом cPanel, где и был введён.
     */
    public static final int BANDWIDTH_LIMIT_EXCEEDED = 509 ;

    /** на сервере отсутствует расширение, которое желает использовать клиент. 
     * Сервер может дополнительно передать информацию о доступных ему расширениях. 
     * Введено в RFC 2774 для дополнения протокола HTTP поддержкой расширений.
     */
    public static final int NOT_EXTENDED = 510 ;
    
    /** этот ответ посылается не сервером, которому был предназначен запрос, 
     * а сервером-посредником — например, сервером провайдера — в случае, 
     * если клиент должен сначала авторизоваться в сети, например, ввести 
     * пароль для платной точки доступа к Интернету. Предполагается, что 
     * в теле ответа будет возвращена Web-форма авторизации или перенаправление 
     * на неё. Введено в черновике стандарта RFC 6585. 
     */
    public static final int NETWORK_AUTHENTICATION_REQUIRED = 511 ;
}
