/*
 * The MIT License
 *
 * Copyright 2016 user.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package xyz.cofe.http;

import java.io.IOException;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * Несколько прокси для запросов
 * @author Kamnev Georgiy (nt.gocha@gmail.com)
 */
public class MultiProxy extends ProxySelector
{
    //<editor-fold defaultstate="collapsed" desc="log Функции">
    private static final Logger logger = Logger.getLogger(MultiProxy.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere =
        logLevel==null
        ? true
        : logLevel.intValue() <= Level.SEVERE.intValue();

    private static final boolean isLogWarning =
        logLevel==null
        ? true
        : logLevel.intValue() <= Level.WARNING.intValue();

    private static final boolean isLogInfo =
        logLevel==null
        ? true
        : logLevel.intValue() <= Level.INFO.intValue();

    private static final boolean isLogFine =
        logLevel==null
        ? true
        : logLevel.intValue() <= Level.FINE.intValue();

    private static final boolean isLogFiner =
        logLevel==null
        ? true
        : logLevel.intValue() <= Level.FINER.intValue();

    private static final boolean isLogFinest =
        logLevel==null
        ? true
        : logLevel.intValue() <= Level.FINEST.intValue();

    private static void logFine(String message,Object ... args){
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message,Object ... args){
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message,Object ... args){
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message,Object ... args){
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message,Object ... args){
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message,Object ... args){
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex){
        logger.log(Level.SEVERE, null, ex);
    }
    //</editor-fold>

    public MultiProxy(){
    }

    public MultiProxy(MultiProxy src){
        if( src!=null ){
            synchronized(src){
//                this.getExcepts().addAll(src.getExcepts());
                this.getUrlMap().putAll(src.getUrlMap());
                this.defaultProxy = src.getDefaultProxy().clone();
            }
        }
    }

    @Override
    public MultiProxy clone(){
        return new MultiProxy(this);
    }

    //<editor-fold defaultstate="collapsed" desc="defaultProxy">
    private Proxy defaultProxy;

    public Proxy getDefaultProxy() {
        synchronized(this){
            if( defaultProxy==null ){
                defaultProxy = new Proxy(Proxy.Type.direct, new InetAddress("localhost", 0));
            }
            return defaultProxy;
        }
    }

    public void setDefaultProxy(Proxy proxy) {
        synchronized(this){
            this.defaultProxy = proxy;
        }
    }
//</editor-fold>

    private Map<UrlPattern,Proxy> urlMap;

    public Map<UrlPattern,Proxy> getUrlMap(){
        synchronized(this){
            if( urlMap==null )urlMap = new LinkedHashMap<UrlPattern, Proxy>();
            return urlMap;
        }
    }

    public void setUrlMap(Map<UrlPattern,Proxy> urlMap){
        synchronized(this){
            this.urlMap = urlMap;
        }
    }

    @Override
    public List<java.net.Proxy> select(URI uri) {
        List<java.net.Proxy> lp = new ArrayList<java.net.Proxy>();

        java.net.Proxy defprx = null;
        Map<UrlPattern,Proxy> umap = null;

        synchronized(this){
            defprx = getDefaultProxy().clone();
            umap = getUrlMap();
        }

        if( uri==null ){
            lp.add(defprx);
            return lp;
        }

        for( Map.Entry<UrlPattern,Proxy> me : umap.entrySet().toArray(new Map.Entry[]{}) ){
            UrlPattern uptr = me.getKey();
            Proxy prx = me.getValue();
            if( uptr==null || prx==null )continue;

            uptr = uptr.clone();
            prx = prx.clone();

            if( uptr.matched(uri) ){
                lp.add(prx);
            }
        }

        if( lp.isEmpty() )lp.add(defprx);
        return lp;
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
    }

//    @Override
//    public String toString() {
//        return "OneProxy{" +
//            "proxy=" + proxy +
//            ", excepts=" + excepts +
//            "}";
//    }
}
