/*
 * The MIT License
 *
 * Copyright 2015 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного 
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"), 
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на 
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование 
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется 
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии 
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ, 
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ, 
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ 
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ 
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ 
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ 
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */

package xyz.cofe.http;


import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * Пул обжидания запросов
 * @author Kamnev Georgiy (nt.gocha@gmail.com)
 */
public class WaitPool 
{
    //<editor-fold defaultstate="collapsed" desc="log Функции">
    private static void logFine(String message,Object ... args){
        Logger.getLogger(WaitPool.class.getName()).log(Level.FINE, message, args);
    }
    
    private static void logFiner(String message,Object ... args){
        Logger.getLogger(WaitPool.class.getName()).log(Level.FINER, message, args);
    }
    
    private static void logFinest(String message,Object ... args){
        Logger.getLogger(WaitPool.class.getName()).log(Level.FINEST, message, args);
    }
    
    private static void logInfo(String message,Object ... args){
        Logger.getLogger(WaitPool.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message,Object ... args){
        Logger.getLogger(WaitPool.class.getName()).log(Level.WARNING, message, args);
    }
    
    private static void logSevere(String message,Object ... args){
        Logger.getLogger(WaitPool.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex){
        Logger.getLogger(WaitPool.class.getName()).log(Level.SEVERE, null, ex);
    }
    //</editor-fold>
    
    protected final Set waitObjects;
    
    public WaitPool(){
        Set s = new HashSet();
        waitObjects = Collections.synchronizedSet(s);
    }
    
    public void add( IsFinished response ){
        if( response==null )throw new IllegalArgumentException( "response==null" );
        synchronized( waitObjects ){
            waitObjects.add(response);
        }
    }

//    public void add( HttpDownloader downloader ){
//        if( downloader==null )throw new IllegalArgumentException( "downloader==null" );
//        waitObjects.add(downloader);
//    }
    
    public void remove( Object o ){
        synchronized( waitObjects ){
            waitObjects.remove(o);
        }
    }
    
    public boolean contains( Object o ){
        synchronized( waitObjects ){
            return waitObjects.contains(o);
        }
    }
    
    public Object[] items(){
        synchronized( waitObjects ){
            return waitObjects.toArray();
        }
    }
    
    public int count(){
        synchronized( waitObjects ){
            return waitObjects.size();
        }
    }
    
    public void waitAll(boolean removeAll){
        ArrayList<IsFinished> waits = new ArrayList<IsFinished>();
        synchronized( waitObjects ){
            for( Object o : waitObjects ){
                if( o instanceof IsFinished ){
                    waits.add((IsFinished)o);
                }
            }
        }
            
        while( true ){
            ArrayList removeList = new ArrayList();
            int wc = 0;
            for( IsFinished finishObj : waits ){
                if( !finishObj.isFinished() ){
                    wc++;
                }else{
                    removeList.add(finishObj);
                }
            }
            if( !removeList.isEmpty() ){
                waits.removeAll(removeList);
            }
            if( wc<1 )break;
            Thread.yield();
        }

        synchronized( waitObjects ){
            if( removeAll ){
                waitObjects.clear();
            }
        }
    }
}
