/*
 * The MIT License
 *
 * Copyright 2016 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного 
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"), 
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на 
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование 
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется 
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии 
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ, 
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ, 
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ 
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ 
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ 
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ 
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */

package xyz.cofe.http.download;


import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.http.ContentFragment;
import xyz.cofe.http.ContentFragments;
import xyz.cofe.http.HttpDownloader;
import xyz.cofe.http.HttpResponse;

/**
 * Разбиение на равные фрагменты, первый фрагмент соответ скаченному.
 * @author Kamnev Georgiy (nt.gocha@gmail.com)
 */
public class EqualsFragments 
implements InitFragments
{
    //<editor-fold defaultstate="collapsed" desc="log Функции">
    private static final Logger logger = Logger.getLogger(EqualsFragments.class.getName());
    private static final Level logLevel = logger.getLevel();
    
    private static final boolean isLogSevere = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.SEVERE.intValue();
    
    private static final boolean isLogWarning = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.WARNING.intValue();
    
    private static final boolean isLogInfo = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.INFO.intValue();
    
    private static final boolean isLogFine = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.FINE.intValue();
    
    private static final boolean isLogFiner = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.FINER.intValue();
    
    private static final boolean isLogFinest = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.FINEST.intValue();

    private static void logFine(String message,Object ... args){
        logger.log(Level.FINE, message, args);
    }
    
    private static void logFiner(String message,Object ... args){
        logger.log(Level.FINER, message, args);
    }
    
    private static void logFinest(String message,Object ... args){
        logger.log(Level.FINEST, message, args);
    }
    
    private static void logInfo(String message,Object ... args){
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message,Object ... args){
        logger.log(Level.WARNING, message, args);
    }
    
    private static void logSevere(String message,Object ... args){
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex){
        logger.log(Level.SEVERE, null, ex);
    }
    //</editor-fold>
    
    protected final ReentrantLock lock = new ReentrantLock();

    //<editor-fold defaultstate="collapsed" desc="fragmentSize">
    /**
     * размер фрагмента по умолчанию (64К)
     */
    protected int fragmentSize = 1024 * 64;
    
    /**
     * Возвращает размер фрагмента по умолчанию (64К)
     * @return размер фрагмента по умолчанию
     */
    public int getFragmentSize() {
        try{
            lock.lock();
            return fragmentSize;
        }finally{
            lock.unlock();
        }
    }
    
    /**
     * Указывает размер фрагмента по умолчанию
     * @param defFragmentSize размер фрагмента по умолчанию, 1 и больше
     */
    public void setFragmentSize(int defFragmentSize) {
        if( defFragmentSize<1 )throw new IllegalArgumentException("defFragmentSize<1");
        try{
            lock.lock();
            this.fragmentSize = defFragmentSize;
        }finally{
            lock.unlock();
        }
    }
//</editor-fold>
    
    public EqualsFragments(){
    }
    
    public EqualsFragments(int fragmentSize){
        if( fragmentSize<1 )throw new IllegalArgumentException("fragmentSize<1");
        this.fragmentSize = fragmentSize;
    }

    public EqualsFragments(HttpDownloader downloader){
        if( downloader==null )throw new IllegalArgumentException( "downloader==null" );
        this.fragmentSize = downloader.getDefaultFragmentSize();
    }
    
    /**
     * Создание фрагмента
     * @param cfragments массив фрагментов
     * @param begin начало
     * @param end конец исключительно
     * @return фрагмент
     */
    protected ContentFragment createFragment( ContentFragments cfragments, long begin, long end ){
        Lock lock = cfragments.getLock();
        if( lock!=null ) {
            return new ContentFragment(begin, end, lock);
        }else{
            return new ContentFragment(begin, end);
        }
    }
    
    @Override
    public void initFragments( ContentFragments cfragments, HttpResponse firstRes, long contentLength ){
        if( firstRes==null )throw new IllegalArgumentException( "firstRes==null" );
        
        cfragments.clear();
        if( contentLength<=0 )return;
        
        int partSize = getFragmentSize();

        logFine("build fragments, def fragment size = {0}",partSize);
        
//        long firstDownSize = firstRes.getDownloadedSize();
//
//        ContentFragment cfFirst = createFragment( cfragments, 0, firstDownSize);
//        cfFirst.setDownloadedSize( firstDownSize );
//        cfragments.add(cfFirst);

        // Создание фрагментов
        long initPosF = 0;
        while( true ){
            long diff = contentLength - initPosF;
            if( diff <= 0 )break;

            long end = -1;
            if( diff >= partSize ){
                end = initPosF + partSize;
            }else{
                end = initPosF + (int)diff;
            }

            ContentFragment cf = createFragment(cfragments, initPosF, end);
            cf.setDownloadedSize(0);
            cfragments.add(cf);

            initPosF = end;
        }
    }
}
