/*
 * The MIT License
 *
 * Copyright 2016 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного 
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"), 
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на 
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование 
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется 
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии 
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ, 
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ, 
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ 
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ 
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ 
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ 
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */

package xyz.cofe.http.download;


import java.net.URL;
import java.security.SecureRandom;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.cbuffer.ContentBuffer;
import xyz.cofe.common.ImmutableFragment;
import xyz.cofe.http.ContentFragment;
import xyz.cofe.http.HttpDownloader;
import xyz.cofe.http.HttpListener;
import xyz.cofe.http.HttpListenerAdapter;
import xyz.cofe.http.HttpRequest;
import xyz.cofe.http.HttpResponse;

/**
 * Создание асинхронных запрос на получени фрагментов
 * @author Kamnev Georgiy (nt.gocha@gmail.com)
 */
public class GetPartBuilder {
    //<editor-fold defaultstate="collapsed" desc="log Функции">
    private static final Logger logger = Logger.getLogger(GetPartBuilder.class.getName());
    private static final Level logLevel = logger.getLevel();
    
    private static final boolean isLogSevere = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.SEVERE.intValue();
    
    private static final boolean isLogWarning = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.WARNING.intValue();
    
    private static final boolean isLogInfo = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.INFO.intValue();
    
    private static final boolean isLogFine = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.FINE.intValue();
    
    private static final boolean isLogFiner = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.FINER.intValue();
    
    private static final boolean isLogFinest = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.FINEST.intValue();

    private static void logFine(String message,Object ... args){
        logger.log(Level.FINE, message, args);
    }
    
    private static void logFiner(String message,Object ... args){
        logger.log(Level.FINER, message, args);
    }
    
    private static void logFinest(String message,Object ... args){
        logger.log(Level.FINEST, message, args);
    }
    
    private static void logInfo(String message,Object ... args){
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message,Object ... args){
        logger.log(Level.WARNING, message, args);
    }
    
    private static void logSevere(String message,Object ... args){
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex){
        logger.log(Level.SEVERE, null, ex);
    }
    //</editor-fold>

    protected HttpDownloader downloader = null;
    protected Mirrors mirrors = null;
    protected HttpRequest request = null;
    protected ContentBuffer buffer = null;
    
    /**
     * Конструктор
     * @param downloader загрузчик
     * @param mirrors зеркала
     * @param request текущий запрос
     * @param contentBuffer буфер данных
     */
    public GetPartBuilder(
        HttpDownloader downloader,
        Mirrors mirrors,
        HttpRequest request,
        ContentBuffer contentBuffer
    ){
        if( request==null )throw new IllegalArgumentException( "request==null" );
        if( contentBuffer==null )throw new IllegalArgumentException( "contentBuffer==null" );
        
        this.mirrors = mirrors;
        this.request = request;
        this.buffer = contentBuffer;
        this.downloader = downloader;
    }
    
//    private int callGetPartNum = 0;
    
    /**
     * Создает асинхронный запрос на получение фрагмента.
     * @param fragment Фрагмент который необходимо получить
     * @return Докачка части
     */
    public GetPart getPart( ContentFragment fragment ){
//        if( sourceFrom<0 )throw new IllegalArgumentException( "sourceFrom<0" );
//        if( size<1 )throw new IllegalArgumentException( "size<1" );
        if( fragment==null )throw new IllegalArgumentException( "fragment==null" );
        
//        callGetPartNum++;
        
        HttpRequest req = null;
        boolean createGetPartMirror = false;
        final Mirrors.NRequest nreq;
        
        if( mirrors!=null ){
            nreq = mirrors.getNRequest();
            req = nreq.getRequest();
            if( req==null ){
                req = request.clone();
            }else{
                createGetPartMirror = true;
            }
        }else{
            req = request.clone();
            nreq = null;
        }

        req.setAsync(true);
        req.setContentBuffer(buffer);
//        req.setContentOffsetStart(sourceFrom);
        req.setContentOffsetStart(fragment.getBegin());
//        req.getHttpHeaders().setRange(sourceFrom, sourceFrom+size-1);
        req.getHttpHeaders().setRange(fragment.getBegin(), fragment.getBegin()+fragment.getSize()-1);

        HttpResponse response = req.createResponse();
        
        response.setFollowRedirect( downloader!=null ? downloader.isFollowRedirect() : true );
        response.setThreadName(
                (downloader!=null ? "Downloader("+downloader.id+") " : "")+
                "GetPart "+
                        Long.toString(fragment.getBegin())+
                        "-"+Long.toString(fragment.getEnd())+
                        "/"+Long.toString(fragment.getSize()));
        
        final Mirrors mmrs = mirrors;
        
        HttpListener redirectListener = new HttpListenerAdapter(){
            @Override
            protected void responseRedirect(HttpResponse.RedirectEvent event, HttpResponse response, URL from, URL to) {
                HttpDownloader downl = downloader;
                if( downl!=null ){
                    HttpDownloader.RedirectEvent re = new HttpDownloader.RedirectEvent(downloader, from, to);
                    downl.fireEvent(re);
                    
                    if( mmrs!=null && nreq!=null ){
                        mmrs.redirect(nreq.getMirrorId(), from, to);
                    }
                }
            }
        };
        
        response.addListener(redirectListener);
        
        GetPart gp =
            createGetPartMirror 
            ? new GetPartMirror(fragment, req, response)
            : new GetPart(fragment, req, response);
        
        if( gp instanceof GetPartMirror ){
            GetPartMirror gpm = (GetPartMirror)gp;
            gpm.setMirrors(mirrors);
            gpm.setNRequest(nreq);
        }
        
        return gp;
    }
}
