/*
 * The MIT License
 *
 * Copyright 2016 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного 
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"), 
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на 
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование 
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется 
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии 
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ, 
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ, 
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ 
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ 
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ 
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ 
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */

package xyz.cofe.http.download;


import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
//import java.util.Spliterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
//import java.util.function.Consumer;
//import java.util.function.Predicate;
//import java.util.function.UnaryOperator;
import java.util.logging.Level;
import java.util.logging.Logger;
//import java.util.stream.Stream;
import xyz.cofe.collection.Func3;
import xyz.cofe.collection.list.BasicEventList;
import xyz.cofe.collection.list.EventList;
import xyz.cofe.collection.list.EventListListener;
import xyz.cofe.collection.list.IndexEventList;
import xyz.cofe.collection.list.LockList;
import xyz.cofe.common.CloseHandler;
import xyz.cofe.common.Reciver;

/**
 * Список паралельный запросов
 * @author Kamnev Georgiy (nt.gocha@gmail.com)
 */
public class GetPartList 
implements EventList<GetPart> 
{
    //<editor-fold defaultstate="collapsed" desc="log Функции">
    private static final Logger logger = Logger.getLogger(GetPartList.class.getName());
    private static final Level logLevel = logger.getLevel();
    
    private static final boolean isLogSevere = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.SEVERE.intValue();
    
    private static final boolean isLogWarning = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.WARNING.intValue();
    
    private static final boolean isLogInfo = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.INFO.intValue();
    
    private static final boolean isLogFine = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.FINE.intValue();
    
    private static final boolean isLogFiner = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.FINER.intValue();
    
    private static final boolean isLogFinest = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.FINEST.intValue();

    private static void logFine(String message,Object ... args){
        logger.log(Level.FINE, message, args);
    }
    
    private static void logFiner(String message,Object ... args){
        logger.log(Level.FINER, message, args);
    }
    
    private static void logFinest(String message,Object ... args){
        logger.log(Level.FINEST, message, args);
    }
    
    private static void logInfo(String message,Object ... args){
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message,Object ... args){
        logger.log(Level.WARNING, message, args);
    }
    
    private static void logSevere(String message,Object ... args){
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex){
        logger.log(Level.SEVERE, null, ex);
    }
    //</editor-fold>
    
    protected final EventList<GetPart> list;
    protected final Lock lock;
    
    public GetPartList() {
        lock = new ReentrantLock();
        
        List<GetPart> list = new ArrayList<GetPart>();
        LockList<GetPart> llist = new LockList<GetPart>(list, lock);
        this.list = new IndexEventList<GetPart>(llist);
    }

    public GetPartList(Lock lock) {
        this.lock = lock==null ? new ReentrantLock() : lock;
        
        List<GetPart> list = new ArrayList<GetPart>();
        LockList<GetPart> llist = new LockList<GetPart>(list, lock);
        this.list = new IndexEventList<GetPart>(llist);
    }

    @Override
    public int size() {
        return list.size();
    }

    @Override
    public boolean isEmpty() {
        return list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return list.contains(o);
    }

    @Override
    public Iterator<GetPart> iterator() {
        return list.iterator();
    }

    @Override
    public Object[] toArray() {
        return list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return list.toArray(a);
    }

    @Override
    public boolean add(GetPart e) {
        return list.add(e);
    }

    @Override
    public boolean remove(Object o) {
        return list.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return list.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends GetPart> c) {
        return list.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends GetPart> c) {
        return list.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return list.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return list.retainAll(c);
    }

//    @Override
//    public void replaceAll(UnaryOperator<GetPart> operator) {
//        list.replaceAll(operator);
//    }

//    @Override
//    public void sort(Comparator<? super GetPart> c) {
//        list.sort(c);
//    }

    @Override
    public void clear() {
        list.clear();
    }

    @Override
    public GetPart get(int index) {
        return list.get(index);
    }

    @Override
    public GetPart set(int index, GetPart element) {
        return list.set(index, element);
    }

    @Override
    public void add(int index, GetPart element) {
        list.add(index, element);
    }

    @Override
    public GetPart remove(int index) {
        return list.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return list.lastIndexOf(o);
    }

    @Override
    public ListIterator<GetPart> listIterator() {
        return list.listIterator();
    }

    @Override
    public ListIterator<GetPart> listIterator(int index) {
        return list.listIterator(index);
    }

    @Override
    public List<GetPart> subList(int fromIndex, int toIndex) {
        return list.subList(fromIndex, toIndex);
    }

//    @Override
//    public Spliterator<GetPart> spliterator() {
//        return list.spliterator();
//    }

    @Override
    public Closeable addEventListListener(EventListListener<GetPart> listener) {
        return list.addEventListListener(listener);
    }

    @Override
    public Closeable addEventListListener(EventListListener<GetPart> listener, boolean weakListener) {
        return list.addEventListListener(listener, weakListener);
    }

    @Override
    public void removeEventListListener(EventListListener<GetPart> listener) {
        list.removeEventListListener(listener);
    }

    @Override
    public Closeable onAdded(Reciver<GetPart> listener) {
        return list.onAdded(listener);
    }

    @Override
    public Closeable onRemoved(Reciver<GetPart> listener) {
        return list.onRemoved(listener);
    }

    @Override
    public boolean containsEventListListener(EventListListener<GetPart> listener) {
        return list.containsEventListListener(listener);
    }

    @Override
    public Closeable onChanged(Func3<Object, Integer, GetPart, GetPart> fn, boolean weak) {
        return list.onChanged(fn, weak);
    }

    @Override
    public Closeable onChanged(Func3<Object, Integer, GetPart, GetPart> fn) {
        return list.onChanged(fn);
    }

//    @Override
//    public boolean removeIf(Predicate<? super GetPart> filter)
//    {
//        return list.removeIf(filter);
//    }
//
//    @Override
//    public Stream<GetPart> stream()
//    {
//        return list.stream();
//    }
//
//    @Override
//    public Stream<GetPart> parallelStream()
//    {
//        return list.parallelStream();
//    }
//
//    @Override
//    public void forEach(Consumer<? super GetPart> action)
//    {
//        list.forEach(action);
//    }

    @Override
    public Closeable onUpdated(Func3<Object, Integer, GetPart, GetPart> fn, boolean weak)
    {
        return list.onUpdated(fn, weak);
    }

    @Override
    public Closeable onUpdated(Func3<Object, Integer, GetPart, GetPart> fn)
    {
        return list.onUpdated(fn);
    }

    @Override
    public Closeable onInserted(Func3<Object, Integer, GetPart, GetPart> fn, boolean weak)
    {
        return list.onInserted(fn, weak);
    }

    @Override
    public Closeable onInserted(Func3<Object, Integer, GetPart, GetPart> fn)
    {
        return list.onInserted(fn);
    }

    @Override
    public Closeable onDeleted(Func3<Object, Integer, GetPart, GetPart> fn, boolean weak)
    {
        return list.onDeleted(fn, weak);
    }

    @Override
    public Closeable onDeleted(Func3<Object, Integer, GetPart, GetPart> fn)
    {
        return list.onDeleted(fn);
    }

    @Override
    public Closeable onAdding(Reciver<GetPart> listener) {
        return list.onAdding(listener);
    }

    @Override
    public Closeable onRemoving(Reciver<GetPart> listener) {
        return list.onRemoving(listener);
    }

    @Override
    public Closeable onChanging(Func3<Object, Integer, GetPart, GetPart> fn, boolean weak) {
        return list.onChanging(fn, weak);
    }

    @Override
    public Closeable onChanging(Func3<Object, Integer, GetPart, GetPart> fn) {
        return list.onChanging(fn);
    }

    @Override
    public Closeable onUpdating(Func3<Object, Integer, GetPart, GetPart> fn, boolean weak) {
        return list.onUpdating(fn, weak);
    }

    @Override
    public Closeable onUpdating(Func3<Object, Integer, GetPart, GetPart> fn) {
        return list.onUpdating(fn);
    }

    @Override
    public Closeable onInserting(Func3<Object, Integer, GetPart, GetPart> fn, boolean weak) {
        return list.onInserting(fn, weak);
    }

    @Override
    public Closeable onInserting(Func3<Object, Integer, GetPart, GetPart> fn) {
        return list.onInserting(fn);
    }

    @Override
    public Closeable onDeleting(Func3<Object, Integer, GetPart, GetPart> fn, boolean weak) {
        return list.onDeleting(fn, weak);
    }

    @Override
    public Closeable onDeleting(Func3<Object, Integer, GetPart, GetPart> fn) {
        return list.onDeleting(fn);
    }
    
    
    
    public void stopAll(){
        logFine("stop all (0)",this.size());
        for( GetPart gp : this.toArray(new GetPart[]{}) ){
            if( gp!=null )gp.stop();
        }
    }

    public void pauseAll(){
        logFine("pause all (0)",this.size());
        for( GetPart gp : this.toArray(new GetPart[]{}) ){
            if( gp!=null )gp.pause();
        }
    }

    public void resumeAll(){
        logFine("resume all (0)",this.size());
        for( GetPart gp : this.toArray(new GetPart[]{}) ){
            if( gp!=null )gp.resume();
        }
    }
}
